/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMDynamicGroup;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class GroupCreateSubGroupReq
extends AdminReq {
    protected Map values;
    protected String groupDN;
    protected String groupType;

    GroupCreateSubGroupReq(String string) {
        super(string);
    }

    void addSubGroupReq(String string, String string2, Map map) {
        this.groupType = string2;
        this.groupDN = string;
        this.values = map;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription20") + " " + this.targetDN);
        HashMap<String, Map> hashMap = new HashMap<String, Map>();
        hashMap.put(this.groupDN, this.values);
        AdminUtils.printAttributeNameValuesMap(printWriter, printUtils, hashMap);
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(AdminReq.bundle.getString("group") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("creategroups"));
        }
        AdminReq.writer.println(AdminReq.bundle.getString("group") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("creategroups"));
        Set set = this.createGroups(aMStoreConnection);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AMObject aMObject = (AMObject)iterator.next();
            AdminReq.writer.println(aMObject.getDN());
        }
        this.doLog(set, "create-group");
    }

    protected Set createGroups(AMStoreConnection aMStoreConnection) throws AdminException {
        try {
            AMStaticGroup aMStaticGroup = aMStoreConnection.getStaticGroup(this.targetDN);
            return this.createGroup(aMStaticGroup);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }

    protected Set createGroup(AMStaticGroup aMStaticGroup) throws AdminException {
        Set set = null;
        try {
            HashMap<String, Map> hashMap = new HashMap<String, Map>();
            if (this.groupType.equals("assignableDynamic")) {
                hashMap.put(this.groupDN, this.values);
                set = aMStaticGroup.createAssignableDynamicGroups(hashMap);
            } else if (this.groupType.equals("dynamic")) {
                Object object;
                String string = null;
                if (this.values != null && this.values.get("filterinfo") != null && (object = (Set)this.values.remove("filterinfo")) != null && !object.isEmpty()) {
                    string = (String)object.iterator().next();
                }
                hashMap.put(this.groupDN, this.values);
                set = aMStaticGroup.createDynamicGroups(hashMap);
                if (string != null) {
                    object = (AMDynamicGroup)set.iterator().next();
                    object.setFilter(string);
                }
            } else {
                hashMap.put(this.groupDN, this.values);
                set = aMStaticGroup.createStaticGroups(hashMap);
            }
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
        return set;
    }
}

