/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class ContCreateServiceTemplateReq
extends AdminReq {
    private Set serviceNames = new HashSet();

    ContCreateServiceTemplateReq() {
    }

    ContCreateServiceTemplateReq(String string) {
        super(string);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription63") + " " + this.targetDN);
        printWriter.flush();
        return stringWriter.toString();
    }

    void addContServiceTmplReq(String string) {
        this.serviceNames.add(string);
    }

    void process(AMStoreConnection aMStoreConnection, SSOToken sSOToken) throws AdminException {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(AdminReq.bundle.getString("container") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("createservicetemplates"));
        }
        AdminReq.writer.println(AdminReq.bundle.getString("container") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("createservicetemplates"));
        try {
            AMOrganizationalUnit aMOrganizationalUnit = aMStoreConnection.getOrganizationalUnit(this.targetDN);
            Iterator iterator = this.serviceNames.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.createServiceTemplate(aMOrganizationalUnit, string, sSOToken);
                AdminReq.writer.println(string);
            }
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }

    private void createServiceTemplate(AMOrganizationalUnit aMOrganizationalUnit, String string, SSOToken sSOToken) throws AdminException {
        try {
            ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager(sSOToken, string);
            Set set = serviceSchemaManager.getSchemaTypes();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                SchemaType schemaType = (SchemaType)iterator.next();
                if (schemaType.equals(SchemaType.ORGANIZATION)) {
                    String string2;
                    AMTemplate aMTemplate = aMOrganizationalUnit.createTemplate(302, string, null);
                    if (string.equals("iPlanetAMAuthService") && (string2 = AdminUtils.getPeopleContainerDN(aMOrganizationalUnit)) != null) {
                        HashSet<String> hashSet = new HashSet<String>();
                        hashSet.add(string2);
                        HashMap<String, HashSet<String>> hashMap = new HashMap<String, HashSet<String>>();
                        hashMap.put("iplanet-am-auth-user-container", hashSet);
                        aMTemplate.setAttributes(hashMap);
                        aMTemplate.store();
                    }
                    this.doLog(string, aMOrganizationalUnit, "create-servtemplate");
                    continue;
                }
                if (!schemaType.equals(SchemaType.DYNAMIC)) continue;
                aMOrganizationalUnit.createTemplate(301, string, null, 0);
                this.doLog(string, aMOrganizationalUnit, "create-servtemplate");
            }
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SMSException sMSException) {
            throw new AdminException(sMSException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

