/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common.admin;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;

public class AdminInterfaceUtils {
    public static final String DEFAULT_PEOPLE_CONTAINER_NAME = "People";
    public static final String DEFAULT_GROUP_CONTAINER_NAME = "Groups";

    public static AMObject getAMObject(Debug debug, String string, AMStoreConnection aMStoreConnection) throws AMException, SSOException {
        AMOrganization aMOrganization = null;
        int n = aMStoreConnection.getAMObjectType(string);
        switch (n) {
            case 2: {
                aMOrganization = aMStoreConnection.getOrganization(string);
                break;
            }
            case 3: {
                aMOrganization = aMStoreConnection.getOrganizationalUnit(string);
                break;
            }
            case 9: 
            case 10: {
                aMOrganization = aMStoreConnection.getStaticGroup(string);
                break;
            }
            case 11: {
                aMOrganization = aMStoreConnection.getDynamicGroup(string);
                break;
            }
            case 12: {
                aMOrganization = aMStoreConnection.getAssignableDynamicGroup(string);
                break;
            }
            case 6: {
                aMOrganization = aMStoreConnection.getRole(string);
                break;
            }
            case 8: {
                aMOrganization = aMStoreConnection.getFilteredRole(string);
                break;
            }
            case 1: {
                aMOrganization = aMStoreConnection.getUser(string);
                break;
            }
            case 5: {
                aMOrganization = aMStoreConnection.getPeopleContainer(string);
                break;
            }
            case 4: {
                aMOrganization = aMStoreConnection.getGroupContainer(string);
                break;
            }
            case 300: {
                aMOrganization = aMStoreConnection.getPolicyTemplate(string);
                break;
            }
            default: {
                if (!debug.warningEnabled()) break;
                debug.warning("AdminInterfaceUtils.getAMObject: Cannot create AMObject for:" + string);
            }
        }
        return aMOrganization;
    }

    public static boolean inOrganizationalUnit(Debug debug, AMStoreConnection aMStoreConnection, AMObject aMObject) {
        boolean bl = false;
        String string = aMObject.getParentDN();
        try {
            while (string != null && !bl) {
                if (aMStoreConnection.getAMObjectType(string) == 3) {
                    bl = true;
                    continue;
                }
                AMObject aMObject2 = AdminInterfaceUtils.getAMObject(debug, string, aMStoreConnection);
                String string2 = string = aMObject2 != null ? aMObject2.getParentDN() : null;
            }
        }
        catch (SSOException sSOException) {
            debug.warning("AdminInterfaceUtils.inOrganizationalUnit", sSOException);
        }
        catch (AMException aMException) {
            debug.warning("AdminInterfaceUtils.inOrganizationalUnit", aMException);
        }
        return bl;
    }

    public static String getNamingAttribute(int n, Debug debug) {
        String string = "";
        try {
            string = AMStoreConnection.getNamingAttribute((int)n);
        }
        catch (AMException aMException) {
            debug.warning("couldn't get naming attribute");
        }
        return string;
    }
}

