/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.iplanet.am.util.AMResourceBundleCache;
import com.sun.identity.common.L10NMessage;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class L10NMessageImpl
extends Exception
implements L10NMessage {
    AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
    private String message;
    private String bundleName;
    private String errorCode;
    private Object[] args;
    private ResourceBundle bundle;

    public L10NMessageImpl(String string) {
        super(string);
    }

    public L10NMessageImpl(String string, String string2, Object[] objectArray) {
        this.bundleName = string;
        this.errorCode = string2;
        this.args = objectArray;
        this.message = this.getL10NMessage(Locale.ENGLISH);
    }

    public L10NMessageImpl(Throwable throwable) {
        this.message = throwable.getMessage();
        if (throwable instanceof L10NMessage) {
            L10NMessage l10NMessage = (L10NMessage)((Object)throwable);
            this.bundleName = l10NMessage.getResourceBundleName();
            this.errorCode = l10NMessage.getErrorCode();
            this.args = l10NMessage.getMessageArgs();
        }
    }

    public String getL10NMessage(Locale locale) {
        if (this.errorCode == null) {
            return this.getMessage();
        }
        String string = this.message;
        if (this.bundleName != null && locale != null) {
            this.bundle = this.amCache.getResBundle(this.bundleName, locale);
            String string2 = this.bundle.getString(this.errorCode);
            string = this.args == null || this.args.length == 0 ? string2 : MessageFormat.format(string2, this.args);
        }
        return string;
    }

    public String getResourceBundleName() {
        return this.bundleName;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public Object[] getMessageArgs() {
        return this.args;
    }

    public String getMessage() {
        if (this.message != null) {
            return this.message;
        }
        return super.getMessage();
    }
}

