/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.util;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.util.AMEncryption;
import com.iplanet.services.util.Base64;
import com.iplanet.services.util.ConfigurableKey;
import com.iplanet.services.util.JSSEncryption;
import com.sun.identity.security.ISSecurityPermission;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.security.Permission;

public class Crypt {
    private static final String ENCRYPTOR_CLASS_PROPERTY = "com.iplanet.security.encryptor";
    private static final String CHECK_CALLER_PROPERTY = "com.sun.identity.security.checkcaller";
    private static final String DEFAULT_ENCRYPTOR_CLASS = "com.iplanet.services.util.JSSEncryption";
    private static final String PROPERTY_PWD = "am.encryption.pwd";
    private static final String DEFAULT_PWD = "KmhUnWR1MYWDYW4xuqdF5nbm+CXIyOVt";
    private static Debug debug = Debug.getInstance("amSDK");
    private static boolean checkCaller;
    public static SecurityManager securityManager;
    private static AMEncryption encryptor;
    private static AMEncryption hardcodedKeyEncryptor;
    private static final String[] VALID_PACKAGES;
    private static final String[] VALID_CLASSES;
    private static final String CLASSNAME = "com.iplanet.services.util.Crypt";
    private static final String AT_NAME = "at ";

    private static AMEncryption createInstance(String string) {
        AMEncryption aMEncryption;
        block5: {
            String string2 = SystemProperties.get(ENCRYPTOR_CLASS_PROPERTY, DEFAULT_ENCRYPTOR_CLASS);
            if (debug.messageEnabled()) {
                debug.message("Crypt.static{}: Encryptor class= " + string2);
            }
            try {
                aMEncryption = (AMEncryption)Class.forName(string2).newInstance();
            }
            catch (Exception exception) {
                debug.error("Crypt:: Unable to get class instance: " + string2, exception);
                aMEncryption = new JSSEncryption();
            }
            try {
                ((ConfigurableKey)((Object)aMEncryption)).setPassword(string);
            }
            catch (Exception exception) {
                if (debug == null) break block5;
                debug.error("Crypt: failed to set password-based key", exception);
            }
        }
        return aMEncryption;
    }

    public static boolean checkCaller() {
        return checkCaller;
    }

    public static AMEncryption getHardcodedKeyEncryptor() {
        return hardcodedKeyEncryptor;
    }

    public static String encrypt(String string) {
        return Crypt.encode(string);
    }

    public static String decrypt(String string) {
        return Crypt.decode(string);
    }

    public static String encode(String string, AMEncryption aMEncryption) {
        Object object;
        if (Crypt.checkCaller()) {
            try {
                object = new ISSecurityPermission("access", "adminpassword");
                if (securityManager != null) {
                    securityManager.checkPermission((Permission)object);
                }
            }
            catch (SecurityException securityException) {
                debug.error("Security Alert: Unauthorized access to Encoding/Decoding password utility: Returning NULL", securityException);
                return null;
            }
        }
        if (string == null || string.equals("")) {
            return null;
        }
        object = null;
        try {
            object = aMEncryption.encrypt(string.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            debug.error("Crypt:: utf-8 encoding is not supported");
            object = encryptor.encrypt(string.getBytes());
        }
        String string2 = null;
        string2 = Base64.encode((byte[])object).trim();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string2));
        StringBuffer stringBuffer = new StringBuffer(string2.length());
        String string3 = null;
        try {
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string3);
            }
        }
        catch (IOException iOException) {
            debug.error("Crypt:: Error while base64 encoding", iOException);
        }
        return stringBuffer.toString();
    }

    public static String encode(String string) {
        return Crypt.encode(string, encryptor);
    }

    public static String decode(String string, AMEncryption aMEncryption) {
        Object object;
        if (Crypt.checkCaller()) {
            try {
                object = new ISSecurityPermission("access", "adminpassword");
                if (securityManager != null) {
                    securityManager.checkPermission((Permission)object);
                }
            }
            catch (SecurityException securityException) {
                debug.error("Security Alert: Unauthorized access to Encoding/Decoding password utility: Returning NULL", securityException);
                return null;
            }
        }
        if (string == null || string.equals("")) {
            return null;
        }
        object = null;
        object = Base64.decode(string.trim());
        byte[] byArray = aMEncryption.decrypt((byte[])object);
        if (byArray == null) {
            return null;
        }
        String string2 = null;
        try {
            string2 = new String(byArray, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            debug.error("Crypt:: Unsupported encoding UTF-8", unsupportedEncodingException);
            string2 = new String(byArray);
        }
        return string2;
    }

    public static String decode(String string) {
        return Crypt.decode(string, encryptor);
    }

    protected static boolean isCallerValid() {
        if (!checkCaller) {
            return true;
        }
        return Crypt.isCallerValid(CLASSNAME);
    }

    public static boolean isCallerValid(Object object) {
        if (!checkCaller) {
            return true;
        }
        if (object == null) {
            return Crypt.isCallerValid(CLASSNAME);
        }
        return Crypt.isCallerValid(object.getClass().getName());
    }

    public static boolean isCallerValid(String string) {
        if (!checkCaller) {
            return true;
        }
        String string2 = Crypt.getParentClass(string);
        int n = 0;
        while (n < VALID_PACKAGES.length) {
            if (string2.startsWith(VALID_PACKAGES[n])) {
                return true;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < VALID_CLASSES.length) {
            if (string2.equals(VALID_CLASSES[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static String getParentClass(String string) {
        String string2 = null;
        try {
            throw new Exception();
        }
        catch (Exception exception) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            exception.printStackTrace(printStream);
            String string3 = byteArrayOutputStream.toString();
            String string4 = string3.substring(string3.lastIndexOf(string) + string.length());
            string3 = string4.substring(string4.lastIndexOf(AT_NAME) + AT_NAME.length());
            string2 = string3.substring(0, string3.indexOf("("));
            string2 = string3.substring(0, string2.lastIndexOf("."));
            return string2;
        }
    }

    static {
        encryptor = Crypt.createInstance(SystemProperties.get(PROPERTY_PWD, DEFAULT_PWD));
        hardcodedKeyEncryptor = Crypt.createInstance(DEFAULT_PWD);
        String string = SystemProperties.get(CHECK_CALLER_PROPERTY);
        if (string != null && string.equalsIgnoreCase("true")) {
            checkCaller = true;
            securityManager = System.getSecurityManager();
            if (debug.messageEnabled()) {
                debug.message("Crypt:: Callers will be checked for access");
            }
        }
        VALID_PACKAGES = new String[]{"com.iplanet.services", "com.iplanet.am", "com.sun.identity.policy"};
        VALID_CLASSES = new String[]{CLASSNAME, "TestCrypt"};
    }
}

