/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.comm.share;

import com.iplanet.am.util.XMLUtils;
import com.iplanet.services.comm.share.Notification;
import com.iplanet.services.comm.share.NotificationSet;
import com.iplanet.services.comm.share.RequestSetParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class NotificationSetParser {
    Document document;

    public NotificationSetParser(Document document) {
        this.document = document;
    }

    public NotificationSetParser(String string) {
        this.document = XMLUtils.toDOMDocument(string, RequestSetParser.debug);
    }

    public NotificationSet parseXML() {
        if (this.document == null) {
            return null;
        }
        Element element = this.document.getDocumentElement();
        NotificationSet notificationSet = new NotificationSet();
        this.setNotificationSetAttributes(element, notificationSet);
        NodeList nodeList = element.getElementsByTagName("Notification");
        if (nodeList == null) {
            return notificationSet;
        }
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            notificationSet.addNotification(this.parseNotificationElement((Element)nodeList.item(n2)));
            ++n2;
        }
        return notificationSet;
    }

    public void setNotificationSetAttributes(Element element, NotificationSet notificationSet) {
        String string = element.getAttribute("vers");
        if (string != null) {
            notificationSet.setNotificationSetVersion(string);
        }
        if ((string = element.getAttribute("svcid")) != null) {
            notificationSet.setServiceID(string);
        }
        if ((string = element.getAttribute("notid")) != null) {
            notificationSet.setNotificationSetID(string);
        }
    }

    private Notification parseNotificationElement(Element element) {
        Notification notification = new Notification();
        String string = element.getAttribute("dtdid");
        if (string != null) {
            notification.setDtdID(string);
        }
        Node node = null;
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node2 = nodeList.item(n2);
            if (node2.getNodeType() == 4) {
                node = node2;
                break;
            }
            ++n2;
        }
        if (node != null) {
            notification.setContent(node.getNodeValue());
        }
        return notification;
    }
}

