/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.comm.client;

import com.iplanet.services.comm.client.NotificationHandler;
import com.iplanet.services.comm.client.PLLClient;
import com.iplanet.services.comm.share.NotificationSet;
import com.iplanet.services.comm.share.PLLBundle;
import com.sun.identity.common.ISLocaleContext;
import com.sun.identity.common.L10NMessageImpl;
import com.sun.identity.common.RequestUtils;
import java.io.IOException;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PLLNotificationServlet
extends HttpServlet {
    private static final String sccsID = "$Id: PLLNotificationServlet.java,v 1.16 2003/08/09 03:40:38 laseu Exp $ $Date: 2003/08/09 03:40:38 $  Sun Microsystems, Inc.";

    public void init() throws ServletException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            RequestUtils.checkContentLength(httpServletRequest);
        }
        catch (L10NMessageImpl l10NMessageImpl) {
            ISLocaleContext iSLocaleContext = new ISLocaleContext();
            iSLocaleContext.setLocale(httpServletRequest);
            Locale locale = iSLocaleContext.getLocale();
            throw new ServletException(l10NMessageImpl.getL10NMessage(locale));
        }
        int n = httpServletRequest.getContentLength();
        if (n == -1) {
            throw new ServletException(PLLBundle.getString("unknownLength"));
        }
        byte[] byArray = new byte[n];
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        int n2 = 0;
        int n3 = 0;
        while (n2 != n) {
            int n4 = servletInputStream.read(byArray, n3, n - n3);
            if (n4 == -1) {
                throw new ServletException(PLLBundle.getString("readRequestError"));
            }
            n2 += n4;
            n3 += n4;
        }
        String string = new String(byArray, 0, n, "UTF-8");
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        try {
            try {
                this.handleNotification(string);
                servletOutputStream.print("OK");
            }
            catch (ServletException servletException) {
                servletOutputStream.print("NOT OK");
            }
            servletOutputStream.flush();
            Object var12_15 = null;
            if (servletOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (servletOutputStream == null) throw throwable;
            servletOutputStream.close();
            throw throwable;
        }
        servletOutputStream.close();
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        servletOutputStream.print("Webtop 2.5 Platform Low Level notification servlet");
        servletOutputStream.flush();
    }

    private void handleNotification(String string) throws ServletException {
        NotificationSet notificationSet = NotificationSet.parseXML(string);
        Vector vector = notificationSet.getNotifications();
        if (vector.size() != 0) {
            String string2 = notificationSet.getServiceID();
            NotificationHandler notificationHandler = PLLClient.getNotificationHandler(string2);
            if (notificationHandler == null) {
                throw new ServletException(PLLBundle.getString("noNotificationHandler") + string2);
            }
            notificationHandler.process(vector);
        }
    }
}

