/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session;

import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.SessionListener;
import com.iplanet.dpro.session.SessionNotificationHandler;
import com.iplanet.dpro.session.SessionPoller;
import com.iplanet.dpro.session.SessionTimedOutException;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.dpro.session.share.SessionBundle;
import com.iplanet.dpro.session.share.SessionEncodeURL;
import com.iplanet.dpro.session.share.SessionInfo;
import com.iplanet.dpro.session.share.SessionRequest;
import com.iplanet.dpro.session.share.SessionResponse;
import com.iplanet.services.comm.client.PLLClient;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.RequestSet;
import com.iplanet.services.comm.share.Response;
import com.iplanet.services.naming.URLNotFoundException;
import com.iplanet.services.naming.WebtopNaming;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletResponse;

public class Session {
    private static final String sccsID = "@(#)Session.java      1.18  00/03/29 03/29/00  Sun Microsystems, Inc.";
    private SessionID sessionID;
    private int sessionType;
    private String clientID;
    private String clientDomain;
    private long maxSessionTime;
    private long maxIdleTime;
    private long maxCachingTime;
    private long sessionIdleTime;
    private long sessionTimeLeft;
    private long timedOutAt = 0L;
    private int sessionState;
    private Hashtable sessionProperties = new Hashtable();
    private URL sessionServiceURL;
    private int eventType = -1;
    private long latestRefreshTime;
    boolean needToReset = false;
    private boolean isSessionServiceLocal = false;
    private SessionService sessionService = null;
    public static final int INVALID = 0;
    public static final int VALID = 1;
    public static final int INACTIVE = 2;
    public static final int DESTROYED = 3;
    public static final int USER_SESSION = 0;
    public static final int APPLICATION_SESSION = 1;
    public static final String SESSION_HANDLE_PROP = "SessionHandle";
    public static final String SESSION_SERVICE = "session";
    private static String cookieName = SystemProperties.get("com.iplanet.am.cookie.name");
    private String cookieStr;
    Boolean cookieMode = null;
    private static long purgeDelay;
    private static boolean pollingEnabled;
    private static Thread sp;
    private static Hashtable sessionTable;
    private static Hashtable destroyedSessionTable;
    private static Hashtable sessionServiceURLTable;
    private Vector sessionEventListeners = new Vector();
    private static Vector allSessionEventListeners;
    private static int maxSessionTableSize;

    Session(SessionID sessionID, URL uRL) {
        this.sessionID = sessionID;
        this.sessionServiceURL = uRL;
        if (SessionService.isInitialized()) {
            this.sessionService = SessionService.getSessionService();
            this.isSessionServiceLocal = this.sessionService.isSessionFailoverEnabled() ? this.sessionService.isLocalSession(sessionID) : this.sessionService.isLocalSessionService(uRL);
        }
        this.latestRefreshTime = System.currentTimeMillis() / 1000L;
    }

    public static String getCookieName() {
        return cookieName;
    }

    public SessionID getID() {
        return this.sessionID;
    }

    public int getType() {
        return this.sessionType;
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getClientDomain() {
        return this.clientDomain;
    }

    public long getMaxSessionTime() {
        return this.maxSessionTime;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public boolean isTimedOut() throws SessionException {
        if (this.timedOutAt > 0L) {
            return true;
        }
        if (this.maxCachingTimeReached()) {
            try {
                this.refresh(false);
            }
            catch (SessionTimedOutException sessionTimedOutException) {
                this.timedOutAt = this.latestRefreshTime = System.currentTimeMillis() / 1000L;
            }
        }
        return this.timedOutAt > 0L;
    }

    public long getTimeLeftBeforePurge() throws SessionException {
        if (!this.isTimedOut()) {
            return -1L;
        }
        long l = System.currentTimeMillis() / 1000L;
        long l2 = this.timedOutAt + purgeDelay * 60L - l;
        return l2 > 0L ? l2 : 0L;
    }

    public long getMaxCachingTime() {
        return this.maxCachingTime;
    }

    public long getIdleTime() throws SessionException {
        if (this.maxCachingTimeReached()) {
            this.refresh(false);
        }
        return this.sessionIdleTime;
    }

    public long getTimeLeft() throws SessionException {
        if (this.maxCachingTimeReached()) {
            this.refresh(false);
        }
        return this.sessionTimeLeft;
    }

    public int getState(boolean bl) throws SessionException {
        if (this.maxCachingTimeReached()) {
            this.refresh(bl);
        } else if (bl) {
            this.needToReset = true;
        }
        return this.sessionState;
    }

    public int getEventType() {
        return this.eventType;
    }

    public String getProperty(String string) throws SessionException {
        if (this.maxCachingTimeReached()) {
            this.refresh(false);
        }
        return (String)this.sessionProperties.get(string);
    }

    public void setProperty(String string, String string2) throws SessionException {
        try {
            if (this.isSessionServiceLocal) {
                this.sessionService.setProperty(this.sessionID, string, string2);
            } else {
                SessionRequest sessionRequest = new SessionRequest(6, this.sessionID.toString(), false);
                sessionRequest.setPropertyName(string);
                sessionRequest.setPropertyValue(string2);
                SessionResponse sessionResponse = this.getSessionResponse(this.sessionServiceURL, sessionRequest);
            }
            this.sessionProperties.put(string, string2);
        }
        catch (Exception exception) {
            throw new SessionException(exception);
        }
    }

    URL getSessionServiceURL() {
        return this.sessionServiceURL;
    }

    public void destroySession(Session session) throws SessionException {
        try {
            Object object;
            if (session.isSessionServiceLocal) {
                this.sessionService.destroySession(this, session.getID());
            } else {
                object = new SessionRequest(2, this.sessionID.toString(), false);
                ((SessionRequest)object).setDestroySessionID(session.getID().toString());
                SessionResponse sessionResponse = this.getSessionResponse(session.getSessionServiceURL(), (SessionRequest)object);
            }
            object = sessionTable;
            synchronized (object) {
                if (sessionTable.contains(session.getID())) {
                    destroyedSessionTable.put(session.getID(), sessionTable.remove(session.getID()));
                }
            }
        }
        catch (Exception exception) {
            throw new SessionException(exception);
        }
    }

    public void logout() throws SessionException {
        try {
            Object object;
            if (this.isSessionServiceLocal) {
                this.sessionService.logout(this.sessionID);
            } else {
                object = new SessionRequest(3, this.sessionID.toString(), false);
                SessionResponse sessionResponse = this.getSessionResponse(this.sessionServiceURL, (SessionRequest)object);
            }
            object = sessionTable;
            synchronized (object) {
                if (sessionTable.contains(this.sessionID)) {
                    destroyedSessionTable.put(this.sessionID, sessionTable.remove(this.sessionID));
                }
            }
        }
        catch (Exception exception) {
            throw new SessionException(exception);
        }
    }

    public void addSessionListener(SessionListener sessionListener) throws SessionException {
        if (this.sessionState != 1) {
            throw new SessionException(SessionBundle.rbName, "invalidSessionState", null);
        }
        this.sessionEventListeners.addElement(sessionListener);
    }

    public static Session getSession(SessionID sessionID) throws SessionException {
        Session session = (Session)sessionTable.get(sessionID);
        if (session != null) {
            if (session.maxCachingTimeReached()) {
                session.refresh(false);
            }
            return session;
        }
        URL uRL = Session.getSessionServiceURL(sessionID);
        session = new Session(sessionID, uRL);
        session.refresh(true);
        sessionTable.put(sessionID, session);
        if (!pollingEnabled) {
            session.addInternalSessionListener();
        } else if (sp == null) {
            sp = new SessionPoller(sessionTable, destroyedSessionTable, uRL, session.isSessionServiceLocal);
            sp.start();
        }
        return session;
    }

    public AMSearchResults getValidSessions() throws SessionException {
        return this.getValidSessions(this.sessionServiceURL, null);
    }

    public AMSearchResults getValidSessions(String string, String string2) throws SessionException {
        String string3 = this.sessionID.getSessionServerProtocol();
        String string4 = string;
        String string5 = this.sessionID.getSessionServerPort();
        int n = string4.indexOf("://");
        if (n != -1) {
            string3 = string4.substring(0, n);
            string4 = string4.substring(n + 3);
        }
        if ((n = string4.indexOf(":")) != -1) {
            string5 = string4.substring(n + 1);
            string4 = string4.substring(0, n);
        }
        URL uRL = Session.getSessionServiceURL(string3, string4, string5);
        return this.getValidSessions(uRL, string2);
    }

    public void addSessionListenerOnAllSessions(SessionListener sessionListener) throws SessionException {
        this.addSessionListenerOnAllSessions(this.sessionServiceURL, sessionListener);
    }

    public void addSessionListenerOnAllSessions(String string, SessionListener sessionListener) throws SessionException {
        String string2 = this.sessionID.getSessionServerProtocol();
        String string3 = string;
        String string4 = this.sessionID.getSessionServerPort();
        int n = string3.indexOf("://");
        if (n != -1) {
            string2 = string3.substring(0, n);
            string3 = string3.substring(n + 3);
        }
        if ((n = string3.indexOf(":")) != -1) {
            string4 = string3.substring(n + 1);
            string3 = string3.substring(0, n);
        }
        this.addSessionListenerOnAllSessions(Session.getSessionServiceURL(string2, string3, string4), sessionListener);
    }

    Vector getSessionEventListeners() {
        return this.sessionEventListeners;
    }

    static Vector getAllSessionEventListeners() {
        return allSessionEventListeners;
    }

    public static URL getSessionServiceURL(SessionID sessionID) throws SessionException {
        return Session.getSessionServiceURL(sessionID.getSessionServerProtocol(), sessionID.getSessionServer(), sessionID.getSessionServerPort());
    }

    public static URL getSessionServiceURL(String string, String string2, String string3) throws SessionException {
        URL uRL = null;
        String string4 = string + "://" + string2 + ":" + string3;
        uRL = (URL)sessionServiceURLTable.get(string4);
        if (uRL == null) {
            try {
                uRL = WebtopNaming.getServiceURL(SESSION_SERVICE, string, string2, string3);
                sessionServiceURLTable.put(string4, uRL);
                return uRL;
            }
            catch (URLNotFoundException uRLNotFoundException) {
                throw new SessionException(uRLNotFoundException);
            }
        }
        return uRL;
    }

    private boolean maxCachingTimeReached() {
        long l = System.currentTimeMillis() / 1000L - this.latestRefreshTime;
        return l > this.maxCachingTime * 60L;
    }

    private AMSearchResults getValidSessions(URL uRL, String string) throws SessionException {
        try {
            Object object;
            int[] nArray = new int[]{0};
            Vector vector = null;
            if (this.sessionService != null && this.sessionService.isLocalSessionService(uRL)) {
                vector = this.sessionService.getValidSessions(this, string, nArray);
            } else {
                object = new SessionRequest(1, this.sessionID.toString(), false);
                if (string != null) {
                    ((SessionRequest)object).setPattern(string);
                }
                SessionResponse sessionResponse = this.getSessionResponse(uRL, (SessionRequest)object);
                vector = sessionResponse.getSessionInfoVector();
                nArray[0] = sessionResponse.getStatus();
            }
            object = new Hashtable();
            int n = vector.size();
            Session session = null;
            int n2 = 0;
            while (n2 < n) {
                SessionInfo sessionInfo = (SessionInfo)vector.elementAt(n2);
                SessionID sessionID = new SessionID(sessionInfo.sid);
                session = new Session(sessionID, uRL);
                session.update(sessionInfo);
                ((Hashtable)object).put(sessionInfo.sid, session);
                ++n2;
            }
            return new AMSearchResults(((Hashtable)object).size(), ((Hashtable)object).keySet(), nArray[0], (Map)object);
        }
        catch (Exception exception) {
            SessionService.sessionDebug.error("Session:getValidSession : ", exception);
            throw new SessionException(exception);
        }
    }

    private void addSessionListenerOnAllSessions(URL uRL, SessionListener sessionListener) throws SessionException {
        if (!pollingEnabled) {
            try {
                String string = WebtopNaming.getNotificationURL().toString();
                if (this.sessionService != null && this.sessionService.isLocalSessionService(uRL)) {
                    this.sessionService.addSessionListenerOnAllSessions(this, string);
                } else {
                    SessionRequest sessionRequest = new SessionRequest(5, this.sessionID.toString(), false);
                    sessionRequest.setNotificationURL(string);
                    SessionResponse sessionResponse = this.getSessionResponse(uRL, sessionRequest);
                }
            }
            catch (Exception exception) {
                throw new SessionException(exception);
            }
        }
        allSessionEventListeners.addElement(sessionListener);
    }

    public void refresh(boolean bl) throws SessionException {
        SessionInfo sessionInfo = null;
        boolean bl2 = bl || this.needToReset;
        this.needToReset = false;
        if (this.isSessionServiceLocal) {
            InternalSession internalSession = this.sessionService.getSession(this.sessionID, bl2);
            sessionInfo = internalSession.toSessionInfo();
        } else {
            SessionRequest sessionRequest = new SessionRequest(0, this.sessionID.toString(), bl2);
            SessionResponse sessionResponse = this.getSessionResponse(this.sessionServiceURL, sessionRequest);
            Vector vector = sessionResponse.getSessionInfoVector();
            if (vector.size() != 1) {
                throw new SessionException(SessionBundle.rbName, "unexpectedSession", null);
            }
            sessionInfo = (SessionInfo)vector.elementAt(0);
        }
        this.update(sessionInfo);
        this.latestRefreshTime = System.currentTimeMillis() / 1000L;
    }

    void update(SessionInfo sessionInfo) {
        Session session = this;
        synchronized (session) {
            String string;
            if (sessionInfo.stype.equals("user")) {
                this.sessionType = 0;
            } else if (sessionInfo.stype.equals("application")) {
                this.sessionType = 1;
            }
            this.clientID = sessionInfo.cid;
            this.clientDomain = sessionInfo.cdomain;
            this.maxSessionTime = Long.parseLong(sessionInfo.maxtime);
            this.maxIdleTime = Long.parseLong(sessionInfo.maxidle);
            this.maxCachingTime = Long.parseLong(sessionInfo.maxcaching);
            this.sessionIdleTime = Long.parseLong(sessionInfo.timeidle);
            this.sessionTimeLeft = Long.parseLong(sessionInfo.timeleft);
            if (sessionInfo.state.equals("invalid")) {
                this.sessionState = 0;
            } else if (sessionInfo.state.equals("valid")) {
                this.sessionState = 1;
            } else if (sessionInfo.state.equals("inactive")) {
                this.sessionState = 2;
            } else if (sessionInfo.state.equals("destroyed")) {
                this.sessionState = 3;
            }
            this.sessionProperties = sessionInfo.properties;
            if (this.timedOutAt <= 0L && (string = (String)this.sessionProperties.get("SessionTimedOut")) != null) {
                try {
                    this.timedOutAt = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    SessionService.sessionDebug.error("Invalid timeout value " + string, numberFormatException);
                }
            }
        }
    }

    private SessionResponse getSessionResponse(URL uRL, SessionRequest sessionRequest) throws SessionException {
        try {
            Request request = new Request(sessionRequest.toXMLString());
            RequestSet requestSet = new RequestSet(SESSION_SERVICE);
            requestSet.addRequest(request);
            String string = cookieName + "=" + this.sessionID;
            Vector vector = PLLClient.send(uRL, string, requestSet);
            if (vector != null && vector.size() != 1) {
                throw new SessionException(SessionBundle.rbName, "unexpectedResponse", null);
            }
            Response response = (Response)vector.elementAt(0);
            SessionResponse sessionResponse = SessionResponse.parseXML(response.getContent());
            if (sessionResponse == null) {
                throw new SessionException(SessionBundle.rbName, "unexpectedResponse", null);
            }
            if (sessionResponse.getException() != null) {
                String string2;
                if (this.timedOutAt <= 0L && (string2 = sessionResponse.getException()).indexOf("SessionTimedOutException") != -1) {
                    this.timedOutAt = System.currentTimeMillis() / 1000L;
                }
                throw new SessionException(sessionResponse.getException());
            }
            return sessionResponse;
        }
        catch (Exception exception) {
            throw new SessionException(exception);
        }
    }

    private void addInternalSessionListener() {
        try {
            if (SessionNotificationHandler.handler == null) {
                SessionNotificationHandler.handler = new SessionNotificationHandler(sessionTable, destroyedSessionTable);
                PLLClient.addNotificationHandler(SESSION_SERVICE, SessionNotificationHandler.handler);
            }
            String string = WebtopNaming.getNotificationURL().toString();
            if (this.isSessionServiceLocal) {
                this.sessionService.addSessionListener(this.sessionID, string);
            } else {
                SessionRequest sessionRequest = new SessionRequest(4, this.sessionID.toString(), false);
                sessionRequest.setNotificationURL(string);
                SessionResponse sessionResponse = this.getSessionResponse(this.sessionServiceURL, sessionRequest);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String encodeURL(HttpServletResponse httpServletResponse, String string) {
        String string2 = httpServletResponse.encodeURL(string);
        return this.encodeURL(string2, (short)0, true);
    }

    public String encodeURL(String string, boolean bl) {
        return this.encodeURL(string, (short)0, bl);
    }

    public String encodeURL(String string) {
        return this.encodeURL(string, (short)0, true);
    }

    public String encodeURL(String string, short s, boolean bl) {
        String string2 = string;
        if (string != null && string.length() > 0 && !this.getCookieSupport()) {
            if (this.cookieStr != null && this.cookieStr.length() > 0) {
                string2 = SessionEncodeURL.buildCookieString(string, this.cookieStr, s, bl);
            } else if (this.sessionID != null) {
                this.cookieStr = SessionEncodeURL.createCookieString(this.sessionID.toString());
                string2 = SessionEncodeURL.encodeURL(this.cookieStr, string, s, bl);
            }
        }
        return string2;
    }

    private String getClientType() {
        String string = null;
        try {
            string = this.getProperty("clientType");
        }
        catch (SessionException sessionException) {
            // empty catch block
        }
        return string;
    }

    private boolean getCookieSupport() {
        boolean bl = false;
        try {
            Boolean bl2 = this.sessionID.getCookieMode();
            if (bl2 != null) {
                bl = bl2;
            } else if (this.cookieMode != null) {
                bl = this.cookieMode;
            } else {
                String string = this.getProperty("cookieSupport");
                if (string != null) {
                    bl = string.equals("true");
                }
            }
        }
        catch (Exception exception) {
            SessionService.sessionDebug.error("Error getting cookieSupport value: ", exception);
            bl = true;
        }
        if (SessionService.sessionDebug.messageEnabled()) {
            SessionService.sessionDebug.message("Session: getCookieSupport: " + bl);
        }
        return bl;
    }

    public void setCookieMode(Boolean bl) {
        if (SessionService.sessionDebug.messageEnabled()) {
            SessionService.sessionDebug.message("CookieMode is:" + bl);
        }
        if (bl != null) {
            this.cookieMode = bl;
        }
    }

    static {
        String string = SystemProperties.get("com.iplanet.am.session.purgedelay", "120");
        try {
            purgeDelay = Long.parseLong(string);
        }
        catch (Exception exception) {
            purgeDelay = 120L;
        }
        pollingEnabled = Boolean.valueOf(SystemProperties.get("com.iplanet.am.session.client.polling.enable"));
        sessionTable = new Hashtable();
        destroyedSessionTable = new Hashtable();
        sessionServiceURLTable = new Hashtable();
        allSessionEventListeners = new Vector();
        maxSessionTableSize = 1000;
    }
}

