/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.util;

import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import java.security.Principal;
import java.util.HashMap;
import java.util.Set;

public class UpdateDNSAlias {
    static Debug debug = Debug.getInstance("amMultiInstall");

    public static void main(String[] stringArray) {
        if (stringArray.length != 5) {
            System.out.println(" Usage: UpdateDNSAlias <add | delete> <orgdn> <dnsalias> <userdn> <passwd>");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        if (string == null || string2 == null || string3 == null) {
            debug.error("One or more parameters are null");
            System.exit(1);
        }
        try {
            String string4 = stringArray[3];
            String string5 = stringArray[4];
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            SSOToken sSOToken = sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(string4), string5);
            AMStoreConnection aMStoreConnection = new AMStoreConnection(sSOToken);
            AMOrganization aMOrganization = aMStoreConnection.getOrganization(string2);
            Set set = aMOrganization.getAttribute("sunOrganizationAlias");
            HashMap<String, Set> hashMap = new HashMap<String, Set>();
            if (string.equalsIgnoreCase("add")) {
                if (!set.contains(string3)) {
                    set.add(string3);
                }
                hashMap.put("sunOrganizationAlias", set);
                aMOrganization.setAttributes(hashMap);
                aMOrganization.store();
            } else if (string.equalsIgnoreCase("delete")) {
                set.remove(string3);
                hashMap.put("sunOrganizationAlias", set);
                aMOrganization.setAttributes(hashMap);
                aMOrganization.store();
            } else {
                debug.error("Unknown option in AMGenerateServerID");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            debug.error("Exception occured:", exception);
        }
        System.exit(0);
    }
}

