/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.util;

import com.iplanet.am.util.AMResourceBundleCache;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.Session;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class Locale {
    static BitSet dontEncode;
    static final int caseDiff = 32;
    private static final int LOCALE_STRING_MAX_LEN = 5;
    static java.util.Locale defaultLocale;
    static Debug debug;
    protected static final String USER_PROPERTIES = "amUser";
    protected static final String DATE_SYNTAX = "dateSyntax";
    private static final String normalizedDateString = "yyyy/MM/dd HH:mm:ss";
    private static final SimpleDateFormat normalizedDateFormat;

    public static void main(String[] stringArray) {
        System.out.println(":" + Locale.getLocale(stringArray[0]) + ":");
        System.out.println(":" + Locale.getLocale(stringArray[0]).getCountry() + ":");
    }

    public static java.util.Locale getLocale(String string) {
        if (string == null) {
            return java.util.Locale.getDefault();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
        }
        return new java.util.Locale(string2, string3, string4);
    }

    public static String getLocaleStringFromAcceptLangHeader(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        try {
            while (Character.isWhitespace(cArray[n])) {
                ++n;
            }
            int n2 = cArray.length;
            if (n2 > n + 5) {
                n2 = n + 5;
            }
            boolean bl = false;
            int n3 = n;
            while (n3 < n2) {
                char c = cArray[n3];
                if (c == '*') {
                    return null;
                }
                if (c == '-') {
                    cArray[n3] = 95;
                    bl = true;
                } else {
                    if (c == ';' || c == ',') {
                        return new String(cArray, n, n3 - n);
                    }
                    if (bl) {
                        cArray[n3] = Character.toUpperCase(c);
                    }
                }
                ++n3;
            }
            return new String(cArray, 0, n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public static java.util.Locale getLocaleObjFromAcceptLangHeader(String string) {
        String string2 = Locale.getLocaleStringFromAcceptLangHeader(string);
        if (string2 == null) {
            return null;
        }
        String string3 = string2.substring(0, 2);
        String string4 = "";
        if (string2.length() == 5) {
            string4 = string2.substring(3, 5);
        }
        return new java.util.Locale(string3, string4);
    }

    public static ResourceBundle getResourceBundle(String string, String string2) {
        return ResourceBundle.getBundle(string, Locale.getLocale(string2));
    }

    protected static ResourceBundle getResourceBundle(Session session, String string) {
        return Locale.getInstallResourceBundle(string);
    }

    public static ResourceBundle getInstallResourceBundle(String string) {
        String string2 = null;
        string2 = SystemProperties.get("com.iplanet.am.locale", "en_US");
        return ResourceBundle.getBundle(string, Locale.getLocale(string2));
    }

    public static java.util.Locale getDefaultLocale() {
        return defaultLocale;
    }

    public static String formatMessage(String string, Object object) {
        Object[] objectArray = new Object[]{object};
        return MessageFormat.format(string, objectArray);
    }

    public static String formatMessage(String string, Object[] objectArray) {
        return MessageFormat.format(string, objectArray);
    }

    public static Date parseNormalizedDateString(String string) {
        if (string == null) {
            return null;
        }
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = normalizedDateFormat.parse(string, parsePosition);
        if (date == null) {
            debug.error("Locale.parseDateString: Unable to parse date string");
        }
        if (debug.messageEnabled()) {
            debug.message("Locale.parseNormalizedDateString(" + string + ")=" + date);
        }
        return date;
    }

    public static Date parseDateString(String string, java.util.Locale locale) {
        if (string == null) {
            return null;
        }
        ResourceBundle resourceBundle = AMResourceBundleCache.getInstance().getResBundle(USER_PROPERTIES, locale);
        if (resourceBundle == null) {
            debug.error("Locale.parseDateString: Unable to get resource bundle. Locale = " + locale);
            return null;
        }
        String string2 = null;
        try {
            string2 = resourceBundle.getString(DATE_SYNTAX);
        }
        catch (Exception exception) {
            debug.error("Locale.parseDateString: Unable to get dateSyntax. Locale " + locale);
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message("Locale.parseDateString: dateSyntax = " + string2);
        }
        if (string.length() != string2.length()) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        simpleDateFormat.setLenient(false);
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = simpleDateFormat.parse(string, parsePosition);
        if (date == null) {
            debug.error("Locale.parseDateString: Unable to parse date string");
        }
        return date;
    }

    public static String getNormalizedDateString(Date date) {
        if (date == null) {
            return null;
        }
        return normalizedDateFormat.format(date);
    }

    public static String getDateString(Date date, java.util.Locale locale) {
        if (date == null) {
            return null;
        }
        ResourceBundle resourceBundle = AMResourceBundleCache.getInstance().getResBundle(USER_PROPERTIES, locale);
        if (resourceBundle == null) {
            debug.error("Locale.getDateString: Unable to get resource bundle. Locale = " + locale);
            return null;
        }
        String string = null;
        try {
            string = resourceBundle.getString(DATE_SYNTAX);
        }
        catch (Exception exception) {
            debug.error("Locale.getDateString: Unable to get dateSyntax. Locale " + locale);
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message("Locale.getDateString: dateSyntax = " + string);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat.format(date);
    }

    public static String convertDateString(String string, java.util.Locale locale, java.util.Locale locale2) {
        Date date = Locale.parseDateString(string, locale);
        return Locale.getDateString(date, locale2);
    }

    public static String getString(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        try {
            return MessageFormat.format(resourceBundle.getString(string), objectArray);
        }
        catch (Exception exception) {
            if (debug.messageEnabled()) {
                debug.message("missing resource: " + string);
            }
            return string;
        }
    }

    public static String getString(ResourceBundle resourceBundle, String string, ResourceBundle resourceBundle2, Object[] objectArray) {
        try {
            return MessageFormat.format(resourceBundle.getString(string), objectArray);
        }
        catch (Exception exception) {
            try {
                if (debug.messageEnabled()) {
                    debug.message("missing resource: " + string);
                    debug.message("fall back to default resource bundle");
                }
                return MessageFormat.format(resourceBundle2.getString(string), objectArray);
            }
            catch (Exception exception2) {
                if (debug.messageEnabled()) {
                    debug.message("missing resource in default resource bundle:" + string);
                }
                return string;
            }
        }
    }

    public static String getString(ResourceBundle resourceBundle, String string, Debug debug) {
        try {
            return resourceBundle.getString(string);
        }
        catch (Exception exception) {
            if (debug.messageEnabled()) {
                debug.message("missing resource: " + string);
            }
            return string;
        }
    }

    public static String getString(ResourceBundle resourceBundle, String string, Debug debug, ResourceBundle resourceBundle2) {
        try {
            return resourceBundle.getString(string);
        }
        catch (Exception exception) {
            try {
                if (debug.messageEnabled()) {
                    debug.message("missing resource: " + string);
                    debug.message("fall back to default resource bundle");
                }
                return resourceBundle2.getString(string);
            }
            catch (Exception exception2) {
                if (debug.messageEnabled()) {
                    debug.message("missing resource in default resource bundle:" + string);
                }
                return string;
            }
        }
    }

    public static String getString(ResourceBundle resourceBundle, String string) {
        try {
            return resourceBundle.getString(string);
        }
        catch (Exception exception) {
            if (debug.messageEnabled()) {
                debug.message("missing resource: " + string);
            }
            return string;
        }
    }

    public static String getString(ResourceBundle resourceBundle, String string, ResourceBundle resourceBundle2) {
        try {
            return resourceBundle.getString(string);
        }
        catch (Exception exception) {
            try {
                if (debug.messageEnabled()) {
                    debug.message("missing resource: " + string);
                    debug.message("fall back to default resource bundle");
                }
                return resourceBundle2.getString(string);
            }
            catch (Exception exception2) {
                if (debug.messageEnabled()) {
                    debug.message("missing resource in default resource bundle:" + string);
                }
                return string;
            }
        }
    }

    public static String URLEncodeField(String string, String string2) throws UnsupportedEncodingException {
        int n = string.length();
        byte[] byArray = string.getBytes(string2);
        StringBuffer stringBuffer = new StringBuffer(n * 4);
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = byArray[n2] & 0xFF;
            if (dontEncode.get(n3)) {
                if (n3 == 32) {
                    n3 = 43;
                }
                stringBuffer.append((char)n3);
            } else {
                stringBuffer.append('%');
                char c = Character.forDigit(n3 >> 4 & 0xF, 16);
                if ('a' <= c && c <= 'f') {
                    c = (char)(c - 32);
                }
                stringBuffer.append(c);
                c = Character.forDigit(n3 & 0xF, 16);
                if ('a' <= c && c <= 'f') {
                    c = (char)(c - 32);
                }
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String URLEncodeField(String string, String string2, Debug debug) {
        byte[] byArray;
        int n = string.length();
        try {
            byArray = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (debug != null) {
                debug.error("Locale.URLEncodeField: Unsupported Encoding " + string2, unsupportedEncodingException);
            }
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n * 4);
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = byArray[n2] & 0xFF;
            if (dontEncode.get(n3)) {
                if (n3 == 32) {
                    n3 = 43;
                }
                stringBuffer.append((char)n3);
            } else {
                stringBuffer.append('%');
                char c = Character.forDigit(n3 >> 4 & 0xF, 16);
                if ('a' <= c && c <= 'f') {
                    c = (char)(c - 32);
                }
                stringBuffer.append(c);
                c = Character.forDigit(n3 & 0xF, 16);
                if ('a' <= c && c <= 'f') {
                    c = (char)(c - 32);
                }
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String URLDecodeField(String string, Debug debug) {
        return Locale.URLDecodeField(string, "UTF-8", debug);
    }

    public static String URLDecodeField(String string, String string2, Debug debug) {
        if (string == null) {
            return string;
        }
        String string3 = null;
        try {
            int n = string.length();
            byte[] byArray = new byte[n];
            int n2 = 0;
            int n3 = 0;
            char[] cArray = string.toCharArray();
            block6: while (n2 < n) {
                byte by = (byte)cArray[n2];
                switch (by) {
                    case 43: {
                        byArray[n3++] = 32;
                        ++n2;
                        break;
                    }
                    case 37: {
                        int n4 = 0;
                        if (n2 + 2 >= n) continue block6;
                        if (97 <= (by = (byte)cArray[++n2]) && by <= 102) {
                            by = (byte)(by - 32);
                        }
                        if (65 <= by && by <= 70) {
                            n4 = 10 + by - 65;
                            n4 <<= 4;
                        } else if (48 <= by && by <= 57) {
                            n4 = by - 48 << 4;
                        } else {
                            throw new IllegalArgumentException("invalid hex char");
                        }
                        by = (byte)cArray[++n2];
                        if (97 <= by && by <= 102) {
                            by = (byte)(by - 32);
                        }
                        if (65 <= by && by <= 70) {
                            n4 += 10 + by - 65;
                        } else if (48 <= by && by <= 57) {
                            n4 += by - 48;
                        } else {
                            throw new IllegalArgumentException("invalid hex char");
                        }
                        byArray[n3++] = (byte)n4;
                        ++n2;
                        break;
                    }
                    default: {
                        byArray[n3++] = (byte)cArray[n2++];
                    }
                }
            }
            string3 = string2 == null || string2.length() == 0 ? new String(byArray, 0, n3, "UTF-8") : new String(byArray, 0, n3, string2);
        }
        catch (Exception exception) {
            debug.error("Locale::decodeField", exception);
            string3 = string;
        }
        return string3;
    }

    static {
        debug = Debug.getInstance("amUtil");
        dontEncode = new BitSet(256);
        int n = 97;
        while (n <= 122) {
            dontEncode.set(n);
            ++n;
        }
        n = 65;
        while (n <= 90) {
            dontEncode.set(n);
            ++n;
        }
        n = 48;
        while (n <= 57) {
            dontEncode.set(n);
            ++n;
        }
        dontEncode.set(32);
        dontEncode.set(45);
        dontEncode.set(95);
        dontEncode.set(46);
        dontEncode.set(42);
        String string = SystemProperties.get("com.iplanet.am.locale", "en_US");
        defaultLocale = Locale.getLocale(string);
        normalizedDateFormat = new SimpleDateFormat(normalizedDateString);
    }
}

