/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.homedir;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.usermgr.common.AdminCommonTools;
import com.sun.wbem.solarisprovider.usermgr.common.SolServerException;
import com.sun.wbem.solarisprovider.usermgr.common.UserException;
import com.sun.wbem.solarisprovider.usermgr.homedir.HomeDirObj;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.text.StringCharacterIterator;

public class UMgrWrapper {
    ProviderUtility provUtil = null;
    private String mvCommand = "/usr/bin/mv";
    private String chownCommand = "/usr/bin/chown";
    private String chmodCommand = "/usr/bin/chmod";
    private String chgrpCommand = "/usr/bin/chgrp";
    private String cpCommand = "/usr/bin/cp";
    private String mkdirCommand = "/usr/bin/mkdir";
    private String rmdirCommand = "/usr/bin/rm -rM ";
    private String DEFAULT_SOURCE_DIRECTORY = "/etc/skel";
    private String ROOT = "/";
    private String ETC = "/etc";
    private String USR = "/usr";
    private String HOM = "/home";
    private String VAR = "/var";
    private String OPT = "/opt";
    private String TMP = "/tmp";
    private String PRC = "/proc";
    private String setlabelCommand = "/bin/setlabel";
    private String adornfcCommand = "/bin/adornfc";
    private String getsldnameCommand = "/bin/getsldname";

    static {
        System.loadLibrary("tsolprov");
    }

    public UMgrWrapper(ProviderUtility providerUtility) throws UserException {
        this.provUtil = providerUtility;
    }

    public synchronized void createHomeDir(HomeDirObj homeDirObj) throws UserException {
        String string = "";
        String string2 = homeDirObj.getUserName();
        if (homeDirObj != null) {
            string = homeDirObj.getPathname();
        }
        String string3 = null;
        File file = null;
        try {
            file = new File(string);
        }
        catch (Exception exception) {
            string3 = this.provUtil.writeLog(2, "LM_2043", "LM_2220", exception.getLocalizedMessage(), null, null, null);
            throw new UserException(string3);
        }
        if (file.exists()) {
            string3 = this.provUtil.writeLog(2, "LM_2043", "LM_2064", string, string2, homeDirObj.getServer(), null);
            throw new UserException(string3);
        }
        try {
            this.performCreateHomeDir(homeDirObj);
        }
        catch (Exception exception) {
            string3 = this.provUtil.writeLog(2, "LM_2043", "LM_2308", string, null, null, null);
            throw new UserException(string3);
        }
        this.provUtil.writeLog(0, "LM_2045", "LM_2076", string2, string, null, null);
    }

    public synchronized void deleteHomeDir(String string) throws UserException {
        String string2 = null;
        String string3 = null;
        string3 = string.trim();
        boolean bl = this.isStringOK(string3);
        if (!bl) {
            string2 = this.provUtil.writeLog(2, "LM_2047", "LM_2307", string3, null, null, null);
            throw new UserException(string2);
        }
        if (string3.equals(this.ROOT) || string3.equals(this.ETC) || string3.equals(this.USR) || string3.equals(this.HOM) || string3.equals(this.VAR) || string3.equals(this.OPT) || string3.equals(this.TMP) || string3.equals(this.PRC)) {
            string2 = this.provUtil.writeLog(2, "LM_2047", "LM_2232", string3, null, null, null);
            throw new UserException(string2);
        }
        String string4 = new String(String.valueOf(this.rmdirCommand) + string3);
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(string4);
            process.getInputStream().close();
            process.getErrorStream().close();
            process.waitFor();
            if (process.exitValue() != 0) {
                throw new SolServerException("?????");
            }
        }
        catch (Exception exception) {
            string2 = this.provUtil.writeLog(2, "LM_2047", "LM_2307", string3, null, null, null);
            throw new UserException(string2);
        }
        this.provUtil.writeLog(0, "LM_2044", "LM_2304", string3, null, null, null);
    }

    private String execCmd(String string) throws SolServerException {
        String string2 = new String("");
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(string);
            InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                string2 = String.valueOf(string2) + string3;
                string3 = bufferedReader.readLine();
            }
            bufferedReader.close();
            inputStreamReader.close();
            process.getInputStream().close();
            process.getErrorStream().close();
            process.waitFor();
            if (process.exitValue() != 0) {
                throw new SolServerException("?????");
            }
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("exec'ing " + string + " failed");
            throw new SolServerException("?????");
        }
        return string2;
    }

    public synchronized HomeDirObj getPermissions(HomeDirObj homeDirObj) throws UserException {
        String string = homeDirObj.getPathname();
        int n = 7;
        int n2 = 5;
        int n3 = 0;
        homeDirObj.setOwnerPerms(n);
        homeDirObj.setGroupPerms(n2);
        homeDirObj.setWorldPerms(n3);
        File file = new File(string);
        try {
            if (!file.exists()) {
                homeDirObj.setModifyServer(true);
                homeDirObj.setForceModify(true);
                return homeDirObj;
            }
        }
        catch (Exception exception) {
            return homeDirObj;
        }
        String[] stringArray = new String[]{"LC_ALL=C", "LC_MESSAGES=C", "LANG=C"};
        String string2 = "/bin/ls -ld ";
        string2 = string2.concat(string);
        String[] stringArray2 = AdminCommonTools.CMN_exec(string2, stringArray);
        if (stringArray2 == null) {
            AdminCommonTools.CMN_HandleOutput("ls command failed!");
            return homeDirObj;
        }
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(stringArray2[0]);
        n = 0;
        char c = stringCharacterIterator.first();
        c = stringCharacterIterator.next();
        if (c == 'r') {
            n = 5;
        }
        if ((c = stringCharacterIterator.next()) == 'w') {
            n = 7;
        }
        n2 = 0;
        c = stringCharacterIterator.next();
        c = stringCharacterIterator.next();
        if (c == 'r') {
            n2 = 5;
        }
        if ((c = stringCharacterIterator.next()) == 'w') {
            n2 = 7;
        }
        n3 = 0;
        c = stringCharacterIterator.next();
        c = stringCharacterIterator.next();
        if (c == 'r') {
            n3 = 5;
        }
        if ((c = stringCharacterIterator.next()) == 'w') {
            n3 = 7;
        }
        homeDirObj.setOwnerPerms(n);
        homeDirObj.setGroupPerms(n2);
        homeDirObj.setWorldPerms(n3);
        return homeDirObj;
    }

    private static native String getUserMinLabel(String var0);

    private boolean isStringOK(String string) {
        boolean bl = true;
        int n = string.length();
        if (n < 1) {
            bl = false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) == ' ' || string.charAt(n2) == '.' || string.charAt(n2) == '*') {
                bl = false;
                break;
            }
            ++n2;
        }
        return bl;
    }

    public void modifyHomeDir(HomeDirObj homeDirObj, String string) throws UserException {
        Object object;
        Object object2;
        Object object3;
        String string2 = null;
        if (homeDirObj == null) {
            string2 = this.provUtil.writeLog(2, "LM_2005", "LM_2221", null, null, null, null);
            throw new UserException(string2);
        }
        String string3 = homeDirObj.getUserName();
        String string4 = string;
        String string5 = homeDirObj.getPathname();
        if (string4 == null) {
            string4 = "";
        }
        if (string4.trim().length() == 0) {
            string4 = string5;
        }
        if (string4.equals(string5)) {
            object3 = new File(string5);
            if (!((File)object3).exists()) {
                try {
                    this.performCreateHomeDir(homeDirObj);
                    string2 = this.provUtil.writeLog(0, "LM_2004", "LM_2076", string3, string4, null, null);
                    return;
                }
                catch (Exception exception) {
                    string2 = this.provUtil.writeLog(2, "LM_2005", "LM_2221", null, null, null, null);
                    throw new UserException(string2);
                }
            }
        } else {
            Process process;
            Runtime runtime;
            String string6;
            object3 = new File(string4);
            if (((File)object3).exists()) {
                string2 = this.provUtil.writeLog(2, "LM_2005", "LM_2065", string4, string3, homeDirObj.getServer(), null);
                throw new UserException(string2);
            }
            int n = string4.lastIndexOf("/");
            object2 = null;
            if (n == -1) {
                string2 = this.provUtil.writeLog(2, "LM_2005", "LM_2313", string4, null, null, null);
                throw new UserException(string2);
            }
            object2 = string4.substring(0, n);
            object = new File((String)object2);
            if (!((File)object).exists()) {
                string6 = new String(String.valueOf(this.mkdirCommand) + " -m 750 -p " + (String)object2);
                runtime = Runtime.getRuntime();
                try {
                    process = runtime.exec(string6);
                    process.getInputStream().close();
                    process.getErrorStream().close();
                    process.waitFor();
                    if (process.exitValue() != 0) {
                        throw new SolServerException("?????");
                    }
                }
                catch (Exception exception) {
                    string2 = this.provUtil.writeLog(2, "LM_2005", "LM_2221", null, null, null, null);
                    throw new UserException(string2);
                }
            }
            string6 = new String(String.valueOf(this.mvCommand) + " " + string5 + " " + string4);
            runtime = Runtime.getRuntime();
            try {
                process = runtime.exec(string6);
                process.getInputStream().close();
                process.getErrorStream().close();
                process.waitFor();
                if (process.exitValue() != 0) {
                    throw new SolServerException("?????");
                }
            }
            catch (Exception exception) {
                string2 = this.provUtil.writeLog(2, "LM_2005", "LM_2221", null, null, null, null);
                throw new UserException(string2);
            }
        }
        object3 = String.valueOf(homeDirObj.getOwnerPerms()) + homeDirObj.getGroupPerms() + homeDirObj.getWorldPerms();
        String string7 = new String(String.valueOf(this.chmodCommand) + " " + (String)object3 + " " + string4);
        object2 = Runtime.getRuntime();
        try {
            object = ((Runtime)object2).exec(string7);
            ((Process)object).getInputStream().close();
            ((Process)object).getErrorStream().close();
            ((Process)object).waitFor();
            if (((Process)object).exitValue() != 0) {
                throw new SolServerException("?????");
            }
        }
        catch (Exception exception) {
            string2 = this.provUtil.writeLog(2, "LM_2005", "LM_2309", string4, null, null, null);
            throw new UserException(string2);
        }
        this.provUtil.writeLog(0, "LM_2004", "LM_2080", string3, string4, null, null);
    }

    private void performCreateHomeDir(HomeDirObj homeDirObj) throws SolServerException, UserException {
        Object object;
        if (homeDirObj == null) {
            throw new SolServerException("?????");
        }
        String string = homeDirObj.getUID();
        String string2 = homeDirObj.getPathname();
        String string3 = String.valueOf(homeDirObj.getOwnerPerms()) + homeDirObj.getGroupPerms() + homeDirObj.getWorldPerms();
        String string4 = homeDirObj.getPrimaryGroup();
        String string5 = new String(String.valueOf(this.mkdirCommand) + " -m 750 -p " + string2);
        Runtime runtime = Runtime.getRuntime();
        try {
            object = runtime.exec(string5);
            ((Process)object).getInputStream().close();
            ((Process)object).getErrorStream().close();
            ((Process)object).waitFor();
            if (((Process)object).exitValue() != 0) {
                throw new SolServerException("?????");
            }
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("Exec'ing mkdir failed");
            exception.printStackTrace();
            throw new SolServerException("?????");
        }
        string5 = new String(String.valueOf(this.chmodCommand) + " " + string3 + " " + string2);
        try {
            object = runtime.exec(string5);
            ((Process)object).getInputStream().close();
            ((Process)object).getErrorStream().close();
            ((Process)object).waitFor();
            if (((Process)object).exitValue() != 0) {
                throw new SolServerException("?????");
            }
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("exec'ing chmod failed");
            throw new SolServerException("?????");
        }
        string5 = new String(String.valueOf(this.chownCommand) + " -fR " + string + " " + string2);
        try {
            object = runtime.exec(string5);
            ((Process)object).getInputStream().close();
            ((Process)object).getErrorStream().close();
            ((Process)object).waitFor();
            if (((Process)object).exitValue() != 0) {
                throw new SolServerException("?????");
            }
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("exec'ing chown failed");
            throw new SolServerException("?????");
        }
        string5 = new String(String.valueOf(this.chgrpCommand) + " -fR " + string4 + " " + string2);
        try {
            object = runtime.exec(string5);
            ((Process)object).getInputStream().close();
            ((Process)object).getErrorStream().close();
            ((Process)object).waitFor();
            if (((Process)object).exitValue() != 0) {
                throw new SolServerException("?????");
            }
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("exec'ing chown failed");
            throw new SolServerException("?????");
        }
        string5 = new String("/bin/setfattrflag -m " + string2);
        this.execCmd(string5);
        object = null;
        object = homeDirObj.getInitFilePath() != null && homeDirObj.getInitFilePath().trim().length() != 0 ? new String(homeDirObj.getInitFilePath()) : new String(this.DEFAULT_SOURCE_DIRECTORY);
        String string6 = UMgrWrapper.getUserMinLabel(string);
        string5 = new String(String.valueOf(this.adornfcCommand) + " " + string2);
        String string7 = this.execCmd(string5);
        string5 = new String(String.valueOf(this.getsldnameCommand) + " -s " + string6 + " " + string2);
        String string8 = this.execCmd(string5);
        String string9 = String.valueOf(string7) + "/" + string8;
        if (string9.equals(this.ROOT)) {
            AdminCommonTools.CMN_Trace1("Can't get user min label's SLD");
            throw new SolServerException("?????");
        }
        if (((String)object).startsWith("/etc/skel/tsol")) {
            string5 = new String(String.valueOf(this.cpCommand) + " " + (String)object + "/role.link_files " + string9 + "/.link_files");
            this.execCmd(string5);
            string5 = new String(String.valueOf(this.cpCommand) + " " + (String)object + "/role.profile " + string9 + "/.profile");
            this.execCmd(string5);
            string5 = new String(String.valueOf(this.setlabelCommand) + " -s " + string6 + " " + string9 + "/.link_files");
            this.execCmd(string5);
            string5 = new String(String.valueOf(this.setlabelCommand) + " -s " + string6 + " " + string9 + "/.profile");
            this.execCmd(string5);
        } else {
            string5 = new String(String.valueOf(this.cpCommand) + " " + (String)object + "/local.login " + string9 + "/.login");
            this.execCmd(string5);
            string5 = new String(String.valueOf(this.cpCommand) + " " + (String)object + "/local.cshrc " + string9 + "/.cshrc");
            this.execCmd(string5);
            string5 = new String(String.valueOf(this.cpCommand) + " " + (String)object + "/local.profile " + string9 + "/.profile");
            this.execCmd(string5);
            string5 = new String(String.valueOf(this.cpCommand) + " " + (String)object + "/.copy_files " + string9 + "/.copy_files");
            this.execCmd(string5);
            string5 = new String(String.valueOf(this.cpCommand) + " " + (String)object + "/.link_files " + string9 + "/.link_files");
            this.execCmd(string5);
            string5 = new String(String.valueOf(this.setlabelCommand) + " -s " + string6 + " " + string9 + "/.login");
            this.execCmd(string5);
            string5 = new String(String.valueOf(this.setlabelCommand) + " -s " + string6 + " " + string9 + "/.cshrc");
            this.execCmd(string5);
            string5 = new String(String.valueOf(this.setlabelCommand) + " -s " + string6 + " " + string9 + "/.profile");
            this.execCmd(string5);
            string5 = new String(String.valueOf(this.setlabelCommand) + " -s " + string6 + " " + string9 + "/.copy_files");
            this.execCmd(string5);
            string5 = new String(String.valueOf(this.setlabelCommand) + " -s " + string6 + " " + string9 + "/.link_files");
            this.execCmd(string5);
        }
        string5 = new String(String.valueOf(this.chownCommand) + " -R -f " + string + ":" + string4 + " " + string9);
        this.execCmd(string5);
    }
}

