/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.logsvc;

import com.sun.wbem.solarisprovider.logsvc.AdminLogException;
import com.sun.wbem.solarisprovider.logsvc.CorruptDataException;
import com.sun.wbem.solarisprovider.logsvc.DataRecord;
import com.sun.wbem.solarisprovider.logsvc.InvalidRecordException;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.util.Vector;

public class DataStore
implements Cloneable {
    private static String VERSION_STR = "logsvc.wbem.version.1";
    private static final long SIZE_OF_LOG_HEADER = 65L;
    private static final long SIZE_OF_RECORD_HEADER = 20L;
    String logFileName;
    RandomAccessFile fileDescriptor;
    long totalNumRecords = 0L;
    long currentEndOffset = 0L;
    long lastRecordOffset = 0L;
    long startDate = 0L;
    long firstOffset = 0L;
    int marker;
    String version = "";
    long timeOfLastChange = 0L;

    public DataStore(String string) throws IOException, EOFException {
        this.logFileName = string;
        this.fileDescriptor = new RandomAccessFile(string, "rw");
        if (this.fileDescriptor.length() > 0L) {
            this.fileDescriptor.seek(0L);
            this.currentEndOffset = this.fileDescriptor.readLong();
            this.lastRecordOffset = this.fileDescriptor.readLong();
            this.totalNumRecords = this.fileDescriptor.readLong();
            this.timeOfLastChange = this.fileDescriptor.readLong();
            this.marker = this.fileDescriptor.readInt();
            this.startDate = this.fileDescriptor.readLong();
            this.version = this.fileDescriptor.readUTF();
            this.firstOffset = this.fileDescriptor.getFilePointer();
        } else {
            this.marker = this.hashCode();
            this.timeOfLastChange = this.startDate = System.currentTimeMillis();
            this.fileDescriptor.seek(0L);
            this.fileDescriptor.writeLong(this.currentEndOffset);
            this.fileDescriptor.writeLong(this.lastRecordOffset);
            this.fileDescriptor.writeLong(this.totalNumRecords);
            this.fileDescriptor.writeLong(this.timeOfLastChange);
            this.fileDescriptor.writeInt(this.marker);
            this.fileDescriptor.writeLong(this.startDate);
            this.fileDescriptor.writeUTF(VERSION_STR);
            this.firstOffset = this.currentEndOffset = this.fileDescriptor.getFilePointer();
            this.fileDescriptor.seek(0L);
            this.fileDescriptor.writeLong(this.currentEndOffset);
            this.lastRecordOffset = this.currentEndOffset;
            this.fileDescriptor.writeLong(this.lastRecordOffset);
        }
    }

    private void autoCheck() throws CorruptDataException {
        boolean bl = false;
        try {
            if (this.currentEndOffset != this.fileDescriptor.length()) {
                bl = true;
            }
        }
        catch (Exception exception) {
            throw new CorruptDataException("EXLOG_OFF");
        }
        if (bl) {
            throw new CorruptDataException("EXLOG_OFF");
        }
    }

    private void checkMark() throws IOException, EOFException, CorruptDataException {
        int n = this.fileDescriptor.readInt();
        if (n != this.marker) {
            throw new CorruptDataException("EXLOG_MRK");
        }
    }

    private long checkOffset(long l) {
        if (l < 0L || l >= this.currentEndOffset) {
            return -1L;
        }
        if (l == 0L) {
            l = this.firstOffset;
        }
        return l;
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
    }

    protected void close() throws AdminLogException {
        try {
            this.fileDescriptor.close();
        }
        catch (IOException iOException) {
            throw new AdminLogException("EXLOG_IO", this.logFileName);
        }
    }

    private Object convertToObject(byte[] byArray) throws IOException, ClassNotFoundException {
        if (byArray.length <= 0) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Object object = objectInputStream.readObject();
        return object;
    }

    protected void finalize() throws IOException {
        this.fileDescriptor.close();
    }

    long getCurrentEndOffset() {
        return this.currentEndOffset;
    }

    protected long getFileDate() {
        return this.startDate;
    }

    protected String getFileName() {
        return this.logFileName;
    }

    protected long getFileSize() throws IOException {
        return this.fileDescriptor.length();
    }

    protected String getLogHeaderFormat() {
        String string = "The format of the log header is as follows:\n\tCurrent end offset     - 8 bytes\tLast record offset     - 8 bytes\tNumber of records      - 8 bytes\tTime of last change    - 8 bytes\tRecord marker          - 4 bytes\tLog creation date      - 8 bytes\tVersion String         - 21 bytes";
        return string;
    }

    protected long getLogHeaderSize() {
        return 65L;
    }

    protected long getNumRecords() {
        return this.totalNumRecords;
    }

    protected String getRecordHeaderFormat() {
        String string = "The format of the record header is as follows:\n\tPrevious record offset - 8 bytes\tRecordMarker           - 4 bytes\tRecordHash             - 4 bytes\tRecord Length          - 4 bytes";
        return string;
    }

    protected long getRecordHeaderSize() {
        return 20L;
    }

    protected long getTimeOfLastChange() {
        return this.timeOfLastChange;
    }

    protected String getVersion() {
        return this.version;
    }

    protected synchronized Vector readNumRecordsAsStr(long l, int n, int n2) throws IOException, EOFException, InvalidRecordException, CorruptDataException {
        Vector<DataRecord> vector = new Vector<DataRecord>();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        long l2 = 0L;
        if (l > this.currentEndOffset) {
            throw new InvalidRecordException("EXLOG_OFF");
        }
        if (this.totalNumRecords == 0L) {
            return null;
        }
        if (n2 == 0) {
            if (l == 0L) {
                l = this.lastRecordOffset;
            } else {
                if (l == this.firstOffset) {
                    return null;
                }
                long l3 = l;
                this.fileDescriptor.seek(l += 8L);
                l = this.fileDescriptor.readLong();
                if (l3 == l) {
                    return null;
                }
            }
        } else if (n2 == 1 && l != 0L) {
            if (l == this.lastRecordOffset) {
                return null;
            }
            this.autoCheck();
            l = this.checkOffset(l);
            this.fileDescriptor.seek(l += 16L);
            n4 = this.fileDescriptor.readInt();
            String string = this.fileDescriptor.readUTF();
            l = this.fileDescriptor.getFilePointer();
        }
        l = this.checkOffset(l);
        if (l < 0L) {
            this.autoCheck();
            throw new InvalidRecordException("EXLOG_OFF");
        }
        this.fileDescriptor.seek(l);
        while (n5 < n) {
            long l4;
            try {
                this.checkMark();
                n3 = this.fileDescriptor.readInt();
                l4 = this.fileDescriptor.readLong();
                n4 = this.fileDescriptor.readInt();
                if (n4 < 0) {
                    throw new CorruptDataException("EXLOG_LEN");
                }
                String string = this.fileDescriptor.readUTF();
                if (string == null) {
                    throw new CorruptDataException("EXLOG_DAT");
                }
                vector.addElement(new DataRecord(l, n3, string, string.length(), this.version));
                l2 = l;
            }
            catch (EOFException eOFException) {
                if (n5 > 0) {
                    return vector;
                }
                throw eOFException;
            }
            ++n5;
            l = this.fileDescriptor.getFilePointer();
            if (n2 != 0) continue;
            if (l4 > l) {
                throw new CorruptDataException("EXLOG_DAT");
            }
            if (l4 == l2) {
                return vector;
            }
            this.fileDescriptor.seek(l4);
            l = l4;
        }
        return vector;
    }

    protected synchronized DataRecord readSpecificRecordAsStr(long l, int n) throws InvalidRecordException, IOException, EOFException, CorruptDataException {
        if (l > this.currentEndOffset) {
            throw new InvalidRecordException("EXLOG_OFF");
        }
        if (this.totalNumRecords == 0L) {
            return null;
        }
        if ((l = this.checkOffset(l)) < 0L) {
            this.autoCheck();
            throw new InvalidRecordException("EXLOG_OFF");
        }
        this.fileDescriptor.seek(l);
        this.checkMark();
        int n2 = this.fileDescriptor.readInt();
        if (n2 != n) {
            throw new InvalidRecordException("EXLOG_HSH");
        }
        this.fileDescriptor.readLong();
        int n3 = this.fileDescriptor.readInt();
        if (n3 < 0) {
            throw new CorruptDataException("EXLOG_LEN");
        }
        String string = this.fileDescriptor.readUTF();
        if (string == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        return new DataRecord(l, n2, string, string.length(), this.version);
    }

    protected synchronized long writeRecord(String string, long l) throws IOException, InvalidRecordException, CorruptDataException {
        int n = 0;
        long l2 = this.lastRecordOffset;
        if (string == null) {
            throw new InvalidRecordException("EXLOG_NUL");
        }
        this.autoCheck();
        this.fileDescriptor.seek(this.currentEndOffset);
        n = string.length();
        if (n <= 0) {
            throw new InvalidRecordException("EXLOG_NUL");
        }
        long l3 = this.fileDescriptor.length();
        if ((l3 += (long)(12 + n + 8)) > l) {
            return -1L;
        }
        this.lastRecordOffset = this.currentEndOffset;
        this.fileDescriptor.writeInt(this.marker);
        this.fileDescriptor.writeInt(string.hashCode());
        this.fileDescriptor.writeLong(l2);
        this.fileDescriptor.writeInt(n);
        this.fileDescriptor.writeUTF(string);
        this.currentEndOffset = this.fileDescriptor.getFilePointer();
        ++this.totalNumRecords;
        this.timeOfLastChange = System.currentTimeMillis();
        this.fileDescriptor.seek(0L);
        this.fileDescriptor.writeLong(this.currentEndOffset);
        this.fileDescriptor.writeLong(this.lastRecordOffset);
        this.fileDescriptor.writeLong(this.totalNumRecords);
        this.fileDescriptor.writeLong(this.timeOfLastChange);
        return this.fileDescriptor.length();
    }
}

