/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.fsmgr.mount;

import com.sun.wbem.solarisprovider.fsmgr.common.FsMgrBooleanOption;
import com.sun.wbem.solarisprovider.fsmgr.common.FsMgrIntegerOption;
import com.sun.wbem.solarisprovider.fsmgr.common.FsMgrStringOption;
import com.sun.wbem.solarisprovider.fsmgr.mount.FsMgrMount;

public class FsMgrMountData
implements Cloneable {
    private static final String EMPTY_STRING = new String("");
    private static final String COMMA = new String(",");
    public static final String YES = new String("yes");
    public static final String NO = new String("no");
    public static final String DASH = new String("-");
    public static final String UFS = new String("ufs");
    public static final String NFS = new String("nfs");
    public static final String HSFS = new String("hsfs");
    public static final String SWAP = new String("swap");
    public static final String TMPFS = new String("tmpfs");
    public static final String PROC = new String("proc");
    public static final String FD = new String("fd");
    public static final String DH = new String("dh");
    public static final String KRB5 = new String("krb5");
    public static final String ROOT = new String("/");
    public static final String USR = new String("/usr");
    public static final String VAR = new String("/var");
    public static final String MOUNTTAB = new String("mounttab");
    public static final String VFSTAB = new String("vfstab");
    public static final String[] MOUNTTAB_ARRAY = new String[]{MOUNTTAB};
    public static final String[] VFSTAB_ARRAY = new String[]{VFSTAB};
    public static final String[] MOUNTBOTH_ARRAY = new String[]{MOUNTTAB, VFSTAB};
    private String rawString = EMPTY_STRING;
    private String resource = EMPTY_STRING;
    private String fsckDevice = EMPTY_STRING;
    private String mountPoint = EMPTY_STRING;
    private String fsType = EMPTY_STRING;
    private String fsckPass = EMPTY_STRING;
    private String bootMount = EMPTY_STRING;
    private FsMgrBooleanOption rw = null;
    private FsMgrBooleanOption ro = null;
    private FsMgrBooleanOption intr = null;
    private FsMgrBooleanOption nointr = null;
    private FsMgrBooleanOption nosuid = null;
    private FsMgrBooleanOption suid = null;
    private FsMgrBooleanOption quota = null;
    private FsMgrBooleanOption noquota = null;
    private FsMgrIntegerOption acdirmax = null;
    private FsMgrIntegerOption acdirmin = null;
    private FsMgrIntegerOption acregmax = null;
    private FsMgrIntegerOption acregmin = null;
    private FsMgrIntegerOption actimeo = null;
    private FsMgrBooleanOption bg = null;
    private FsMgrBooleanOption fg = null;
    private FsMgrBooleanOption grpid = null;
    private FsMgrBooleanOption hard = null;
    private FsMgrBooleanOption soft = null;
    private FsMgrBooleanOption kerberos = null;
    private FsMgrBooleanOption noac = null;
    private FsMgrIntegerOption port = null;
    private FsMgrBooleanOption posix = null;
    private FsMgrStringOption proto = null;
    private FsMgrBooleanOption webnfs = null;
    private FsMgrIntegerOption retrans = null;
    private FsMgrIntegerOption retry = null;
    private FsMgrIntegerOption rsize = null;
    private FsMgrStringOption sec = null;
    private FsMgrBooleanOption secure = null;
    private FsMgrIntegerOption timeo = null;
    private FsMgrIntegerOption vers = null;
    private FsMgrIntegerOption wsize = null;
    private FsMgrBooleanOption largefiles = null;
    private FsMgrBooleanOption nolargefiles = null;
    private FsMgrBooleanOption noatime = null;
    private FsMgrBooleanOption forcedirectio = null;
    private FsMgrBooleanOption noforcedirectio = null;
    private FsMgrBooleanOption logging = null;
    private FsMgrBooleanOption nologging = null;
    private FsMgrBooleanOption rq = null;
    private FsMgrStringOption onerror = null;
    private FsMgrStringOption toosoon = null;
    private FsMgrBooleanOption global = null;
    private FsMgrBooleanOption noglobal = null;
    private FsMgrBooleanOption rr = null;
    private FsMgrBooleanOption nrr = null;
    private FsMgrBooleanOption traildot = null;
    private FsMgrBooleanOption notraildot = null;
    private FsMgrBooleanOption maplcase = null;
    private FsMgrBooleanOption nomaplcase = null;
    public static final String DEV = new String("dev");
    public static final String ACDIRMAX = new String("acdirmax");
    public static final String ACDIRMIN = new String("acdirmin");
    public static final String ACREGMAX = new String("acregmax");
    public static final String ACREGMIN = new String("acregmin");
    public static final String ACTIMEO = new String("actimeo");
    public static final String BG = new String("bg");
    public static final String FG = new String("fg");
    public static final String GRPID = new String("grpid");
    public static final String HARD = new String("hard");
    public static final String SOFT = new String("soft");
    public static final String INTR = new String("intr");
    public static final String NOINTR = new String("nointr");
    public static final String KERBEROS = new String("kerberos");
    public static final String NOAC = new String("noac");
    public static final String PORT = new String("port");
    public static final String POSIX = new String("posix");
    public static final String PROTO = new String("proto");
    public static final String PUBLIC = new String("public");
    public static final String QUOTA = new String("quota");
    public static final String NOQUOTA = new String("noquota");
    public static final String RETRANS = new String("retrans");
    public static final String RETRY = new String("retry");
    public static final String RO = new String("ro");
    public static final String RW = new String("rw");
    public static final String RSIZE = new String("rsize");
    public static final String SEC = new String("sec");
    public static final String SECURE = new String("secure");
    public static final String SUID = new String("suid");
    public static final String NOSUID = new String("nosuid");
    public static final String TIMEO = new String("timeo");
    public static final String VERS = new String("vers");
    public static final String WSIZE = new String("wsize");
    public static final String LARGEFILES = new String("largefiles");
    public static final String NOLARGEFILES = new String("nolargefiles");
    public static final String NOATIME = new String("noatime");
    public static final String FORCEDIRECTIO = new String("forcedirectio");
    public static final String NOFORCEDIRECTIO = new String("noforcedirectio");
    public static final String LOGGING = new String("logging");
    public static final String NOLOGGING = new String("nologging");
    public static final String RQ = new String("rq");
    public static final String ONERROR = new String("onerror");
    public static final String TOOSOON = new String("toosoon");
    public static final String GLOBAL = new String("global");
    public static final String NOGLOBAL = new String("noglobal");
    public static final String RR = new String("rr");
    public static final String NRR = new String("nrr");
    public static final String TRAILDOT = new String("traildot");
    public static final String NOTRAILDOT = new String("notraildot");
    public static final String MAPLCASE = new String("maplcase");
    public static final String NOMAPLCASE = new String("nomaplcase");
    public static final int ACDIRMAX_DEFAULT = 60;
    public static final int ACDIRMIN_DEFAULT = 30;
    public static final int ACREGMAX_DEFAULT = 60;
    public static final int ACREGMIN_DEFAULT = 3;
    public static final boolean BG_DEFAULT = false;
    public static final boolean FG_DEFAULT = true;
    public static final boolean GRPID_DEFAULT = false;
    public static final boolean HARD_DEFAULT = true;
    public static final boolean SOFT_DEFAULT = false;
    public static final boolean INTR_DEFAULT = true;
    public static final boolean NOINTR_DEFAULT = false;
    public static final boolean KERBEROS_DEFAULT = false;
    public static final boolean NOAC_DEFAULT = false;
    public static final int PORT_DEFAULT = 2049;
    public static final boolean POSIX_DEFAULT = false;
    public static final String PROTO_DEFAULT = new String("tcp");
    public static final boolean PUBLIC_DEFAULT = false;
    public static final boolean QUOTA_DEFAULT = false;
    public static final boolean NOQUOTA_DEFAULT = true;
    public static final int RETRANS_DEFAULT = 5;
    public static final int RETRY_DEFAULT = 10000;
    public static final boolean RO_DEFAULT = false;
    public static final boolean RW_DEFAULT = true;
    public static final int RSIZE_DEFAULT = 32768;
    public static final boolean SECURE_DEFAULT = false;
    public static final boolean SUID_DEFAULT = true;
    public static final boolean NOSUID_DEFAULT = false;
    public static final int TIMEO_DEFAULT = 11;
    public static final int VERS_DEFAULT = 3;
    public static final int WSIZE_DEFAULT = 32768;
    public static final boolean LARGEFILES_DEFAULT = true;
    public static final boolean NOLARGEFILES_DEFAULT = false;
    public static final boolean NOATIME_DEFAULT = false;
    public static final boolean FORCEDIRECTIO_DEFAULT = false;
    public static final boolean NOFORCEDIRECTIO_DEFAULT = true;
    public static final boolean LOGGING_DEFAULT = false;
    public static final boolean NOLOGGING_DEFAULT = true;
    public static final boolean RQ_DEFAULT = false;
    public static final String ONERROR_DEFAULT = new String("panic");
    public static final String TOOSOON_DEFAULT = new String("1w");
    public static final boolean GLOBAL_DEFAULT = false;
    public static final boolean NOGLOBAL_DEFAULT = true;
    public static final boolean RR_DEFAULT = true;
    public static final boolean NRR_DEFAULT = false;
    public static final boolean TRAILDOT_DEFAULT = true;
    public static final boolean NOTRAILDOT_DEFAULT = false;
    public static final boolean MAPLCASE_DEFAULT = true;
    public static final boolean NOMAPLCASE_DEFAULT = false;

    public FsMgrMountData(FsMgrMount fsMgrMount) {
        if (fsMgrMount == null) {
            return;
        }
        this.resource = fsMgrMount.getResource();
        this.fsckDevice = fsMgrMount.getFsckDevice();
        this.mountPoint = fsMgrMount.getMountPoint();
        this.fsType = fsMgrMount.getFsType();
        this.fsckPass = fsMgrMount.getFsckPass();
        this.bootMount = fsMgrMount.getBootMount();
        String string = fsMgrMount.getOptions();
        if (string == null || string.length() == 0 || string.trim().equals(DASH)) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 44;
        boolean bl = true;
        while (bl) {
            String string2;
            n2 = string.indexOf(n3, n);
            if (n2 == -1) {
                if (n == string.length() - 1) {
                    bl = false;
                }
                string2 = string.substring(n).trim();
                bl = false;
            } else {
                string2 = string.substring(n, n2).trim();
                n = n2 + 1;
            }
            this.setOption(string2);
        }
        this.convertAccess();
    }

    public Object clone() {
        try {
            FsMgrMountData fsMgrMountData = (FsMgrMountData)super.clone();
            if (this.acdirmax != null) {
                fsMgrMountData.acdirmax = (FsMgrIntegerOption)this.acdirmax.clone();
            }
            if (this.acdirmin != null) {
                fsMgrMountData.acdirmin = (FsMgrIntegerOption)this.acdirmin.clone();
            }
            if (this.acregmax != null) {
                fsMgrMountData.acregmax = (FsMgrIntegerOption)this.acregmax.clone();
            }
            if (this.acregmin != null) {
                fsMgrMountData.acregmin = (FsMgrIntegerOption)this.acregmin.clone();
            }
            if (this.actimeo != null) {
                fsMgrMountData.actimeo = (FsMgrIntegerOption)this.actimeo.clone();
            }
            if (this.bg != null) {
                fsMgrMountData.bg = (FsMgrBooleanOption)this.bg.clone();
            }
            if (this.fg != null) {
                fsMgrMountData.fg = (FsMgrBooleanOption)this.fg.clone();
            }
            if (this.grpid != null) {
                fsMgrMountData.grpid = (FsMgrBooleanOption)this.grpid.clone();
            }
            if (this.hard != null) {
                fsMgrMountData.hard = (FsMgrBooleanOption)this.hard.clone();
            }
            if (this.soft != null) {
                fsMgrMountData.soft = (FsMgrBooleanOption)this.soft.clone();
            }
            if (this.intr != null) {
                fsMgrMountData.intr = (FsMgrBooleanOption)this.intr.clone();
            }
            if (this.nointr != null) {
                fsMgrMountData.nointr = (FsMgrBooleanOption)this.nointr.clone();
            }
            if (this.kerberos != null) {
                fsMgrMountData.kerberos = (FsMgrBooleanOption)this.kerberos.clone();
            }
            if (this.noac != null) {
                fsMgrMountData.noac = (FsMgrBooleanOption)this.noac.clone();
            }
            if (this.port != null) {
                fsMgrMountData.port = (FsMgrIntegerOption)this.port.clone();
            }
            if (this.posix != null) {
                fsMgrMountData.posix = (FsMgrBooleanOption)this.posix.clone();
            }
            if (this.proto != null) {
                fsMgrMountData.proto = (FsMgrStringOption)this.proto.clone();
            }
            if (this.webnfs != null) {
                fsMgrMountData.webnfs = (FsMgrBooleanOption)this.webnfs.clone();
            }
            if (this.quota != null) {
                fsMgrMountData.quota = (FsMgrBooleanOption)this.quota.clone();
            }
            if (this.noquota != null) {
                fsMgrMountData.noquota = (FsMgrBooleanOption)this.noquota.clone();
            }
            if (this.retrans != null) {
                fsMgrMountData.retrans = (FsMgrIntegerOption)this.retrans.clone();
            }
            if (this.retry != null) {
                fsMgrMountData.retry = (FsMgrIntegerOption)this.retry.clone();
            }
            if (this.ro != null) {
                fsMgrMountData.ro = (FsMgrBooleanOption)this.ro.clone();
            }
            if (this.rw != null) {
                fsMgrMountData.rw = (FsMgrBooleanOption)this.rw.clone();
            }
            if (this.rsize != null) {
                fsMgrMountData.rsize = (FsMgrIntegerOption)this.rsize.clone();
            }
            if (this.sec != null) {
                fsMgrMountData.sec = (FsMgrStringOption)this.sec.clone();
            }
            if (this.secure != null) {
                fsMgrMountData.secure = (FsMgrBooleanOption)this.secure.clone();
            }
            if (this.suid != null) {
                fsMgrMountData.suid = (FsMgrBooleanOption)this.suid.clone();
            }
            if (this.nosuid != null) {
                fsMgrMountData.nosuid = (FsMgrBooleanOption)this.nosuid.clone();
            }
            if (this.timeo != null) {
                fsMgrMountData.timeo = (FsMgrIntegerOption)this.timeo.clone();
            }
            if (this.vers != null) {
                fsMgrMountData.vers = (FsMgrIntegerOption)this.vers.clone();
            }
            if (this.wsize != null) {
                fsMgrMountData.wsize = (FsMgrIntegerOption)this.wsize.clone();
            }
            if (this.largefiles != null) {
                fsMgrMountData.largefiles = (FsMgrBooleanOption)this.largefiles.clone();
            }
            if (this.nolargefiles != null) {
                fsMgrMountData.nolargefiles = (FsMgrBooleanOption)this.nolargefiles.clone();
            }
            if (this.noatime != null) {
                fsMgrMountData.noatime = (FsMgrBooleanOption)this.noatime.clone();
            }
            if (this.forcedirectio != null) {
                fsMgrMountData.forcedirectio = (FsMgrBooleanOption)this.forcedirectio.clone();
            }
            if (this.noforcedirectio != null) {
                fsMgrMountData.noforcedirectio = (FsMgrBooleanOption)this.noforcedirectio.clone();
            }
            if (this.logging != null) {
                fsMgrMountData.logging = (FsMgrBooleanOption)this.logging.clone();
            }
            if (this.nologging != null) {
                fsMgrMountData.nologging = (FsMgrBooleanOption)this.nologging.clone();
            }
            if (this.rq != null) {
                fsMgrMountData.rq = (FsMgrBooleanOption)this.rq.clone();
            }
            if (this.onerror != null) {
                fsMgrMountData.onerror = (FsMgrStringOption)this.onerror.clone();
            }
            if (this.toosoon != null) {
                fsMgrMountData.toosoon = (FsMgrStringOption)this.toosoon.clone();
            }
            if (this.global != null) {
                fsMgrMountData.global = (FsMgrBooleanOption)this.global.clone();
            }
            if (this.noglobal != null) {
                fsMgrMountData.noglobal = (FsMgrBooleanOption)this.noglobal.clone();
            }
            if (this.rr != null) {
                fsMgrMountData.rr = (FsMgrBooleanOption)this.rr.clone();
            }
            if (this.nrr != null) {
                fsMgrMountData.nrr = (FsMgrBooleanOption)this.nrr.clone();
            }
            if (this.traildot != null) {
                fsMgrMountData.traildot = (FsMgrBooleanOption)this.traildot.clone();
            }
            if (this.notraildot != null) {
                fsMgrMountData.notraildot = (FsMgrBooleanOption)this.notraildot.clone();
            }
            if (this.maplcase != null) {
                fsMgrMountData.maplcase = (FsMgrBooleanOption)this.maplcase.clone();
            }
            if (this.nomaplcase != null) {
                fsMgrMountData.nomaplcase = (FsMgrBooleanOption)this.nomaplcase.clone();
            }
            return fsMgrMountData;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void convertAccess() {
        if (this.kerberos != null && this.kerberos.getValue()) {
            this.setOption(SEC, KRB5);
            this.kerberos = null;
        } else if (this.secure != null && this.secure.getValue()) {
            this.setOption(SEC, DH);
            this.secure = null;
        }
        if (this.rq != null && this.rq.getValue()) {
            this.setOption(QUOTA, true);
            this.quota = null;
            this.setOption(RW, true);
            this.rw = null;
        }
        if (this.actimeo != null) {
            this.setOption(ACDIRMAX, this.actimeo.getValue());
            this.setOption(ACDIRMIN, this.actimeo.getValue());
            this.setOption(ACREGMAX, this.actimeo.getValue());
            this.setOption(ACREGMIN, this.actimeo.getValue());
        }
    }

    private FsMgrBooleanOption createOption(String string, FsMgrBooleanOption fsMgrBooleanOption, boolean bl) {
        return new FsMgrBooleanOption(string, bl);
    }

    private FsMgrIntegerOption createOption(String string, FsMgrIntegerOption fsMgrIntegerOption, String string2) {
        return new FsMgrIntegerOption(string, string2);
    }

    private FsMgrStringOption createOption(String string, FsMgrStringOption fsMgrStringOption, String string2) {
        return new FsMgrStringOption(string, string2);
    }

    public boolean equalAccess(Object object) {
        FsMgrBooleanOption fsMgrBooleanOption;
        if (object == null) {
            return false;
        }
        if (!(object instanceof FsMgrMountData)) {
            return false;
        }
        FsMgrMountData fsMgrMountData = (FsMgrMountData)object;
        FsMgrBooleanOption fsMgrBooleanOption2 = (FsMgrBooleanOption)fsMgrMountData.getOption(RW);
        if (!this.equalAttributes(fsMgrBooleanOption2, this.rw, true)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption3 = (FsMgrBooleanOption)fsMgrMountData.getOption(RO);
        if (!this.equalAttributes(fsMgrBooleanOption3, this.ro, false)) {
            return false;
        }
        return this.fsType != UFS || this.equalAttributes(fsMgrBooleanOption = (FsMgrBooleanOption)fsMgrMountData.getOption(RQ), this.rq, false);
    }

    public boolean equalAttributes(FsMgrBooleanOption fsMgrBooleanOption, FsMgrBooleanOption fsMgrBooleanOption2, boolean bl) {
        if (fsMgrBooleanOption == null && fsMgrBooleanOption2 == null) {
            return true;
        }
        if (fsMgrBooleanOption == null || fsMgrBooleanOption2 == null) {
            if (fsMgrBooleanOption == null) {
                fsMgrBooleanOption = new FsMgrBooleanOption(fsMgrBooleanOption2.getOptionName(), bl);
            } else {
                fsMgrBooleanOption2 = new FsMgrBooleanOption(fsMgrBooleanOption.getOptionName(), bl);
            }
        }
        return this.equalAttributes(fsMgrBooleanOption, fsMgrBooleanOption2);
    }

    public boolean equalAttributes(FsMgrStringOption fsMgrStringOption, FsMgrStringOption fsMgrStringOption2, String string) {
        if (fsMgrStringOption == null && fsMgrStringOption2 == null) {
            return true;
        }
        if (fsMgrStringOption == null || fsMgrStringOption2 == null) {
            if (fsMgrStringOption == null) {
                fsMgrStringOption = new FsMgrStringOption(fsMgrStringOption2.getOptionName(), string);
            } else {
                fsMgrStringOption2 = new FsMgrStringOption(fsMgrStringOption.getOptionName(), string);
            }
        }
        return this.equalAttributes(fsMgrStringOption, fsMgrStringOption2);
    }

    public boolean equalAttributes(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object instanceof String) {
            if (object2 instanceof String) {
                String string = (String)object;
                String string2 = (String)object2;
                return string.equals(string2);
            }
            return false;
        }
        if (object instanceof FsMgrBooleanOption) {
            if (object instanceof FsMgrBooleanOption) {
                FsMgrBooleanOption fsMgrBooleanOption = (FsMgrBooleanOption)object;
                FsMgrBooleanOption fsMgrBooleanOption2 = (FsMgrBooleanOption)object2;
                return fsMgrBooleanOption.equals(fsMgrBooleanOption2);
            }
            return false;
        }
        if (object instanceof FsMgrStringOption) {
            if (object instanceof FsMgrStringOption) {
                FsMgrStringOption fsMgrStringOption = (FsMgrStringOption)object;
                FsMgrStringOption fsMgrStringOption2 = (FsMgrStringOption)object2;
                return fsMgrStringOption.equals(fsMgrStringOption2);
            }
            return false;
        }
        if (object instanceof FsMgrIntegerOption) {
            if (object instanceof FsMgrIntegerOption) {
                FsMgrIntegerOption fsMgrIntegerOption = (FsMgrIntegerOption)object;
                FsMgrIntegerOption fsMgrIntegerOption2 = (FsMgrIntegerOption)object2;
                return fsMgrIntegerOption.equals(fsMgrIntegerOption2);
            }
            return false;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof FsMgrMountData)) {
            return false;
        }
        FsMgrMountData fsMgrMountData = (FsMgrMountData)object;
        String string = fsMgrMountData.getResource();
        if (!this.equalAttributes(string, this.resource)) {
            return false;
        }
        String string2 = fsMgrMountData.getFsckDevice();
        if (!(this.equalAttributes(string2, this.fsckDevice) || string2.equals(DASH) || this.fsckDevice.equals(DASH))) {
            return false;
        }
        String string3 = fsMgrMountData.getMountPoint();
        if (!this.equalAttributes(string3, this.mountPoint)) {
            return false;
        }
        String string4 = fsMgrMountData.getFsType();
        if (!this.equalAttributes(string4, this.fsType)) {
            return false;
        }
        String string5 = fsMgrMountData.getFsckPass();
        if (!(this.equalAttributes(string5, this.fsckPass) || string5.equals(DASH) || this.fsckPass.equals(DASH))) {
            return false;
        }
        FsMgrIntegerOption fsMgrIntegerOption = (FsMgrIntegerOption)fsMgrMountData.getOption(ACDIRMAX);
        if (!this.equalAttributes(fsMgrIntegerOption, this.acdirmax)) {
            return false;
        }
        FsMgrIntegerOption fsMgrIntegerOption2 = (FsMgrIntegerOption)fsMgrMountData.getOption(ACDIRMIN);
        if (!this.equalAttributes(fsMgrIntegerOption2, this.acdirmin)) {
            return false;
        }
        FsMgrIntegerOption fsMgrIntegerOption3 = (FsMgrIntegerOption)fsMgrMountData.getOption(ACREGMAX);
        if (!this.equalAttributes(fsMgrIntegerOption3, this.acregmax)) {
            return false;
        }
        FsMgrIntegerOption fsMgrIntegerOption4 = (FsMgrIntegerOption)fsMgrMountData.getOption(ACREGMIN);
        if (!this.equalAttributes(fsMgrIntegerOption4, this.acregmin)) {
            return false;
        }
        FsMgrIntegerOption fsMgrIntegerOption5 = (FsMgrIntegerOption)fsMgrMountData.getOption(ACTIMEO);
        if (!this.equalAttributes(fsMgrIntegerOption5, this.actimeo)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption = (FsMgrBooleanOption)fsMgrMountData.getOption(GRPID);
        if (!this.equalAttributes(fsMgrBooleanOption, this.grpid, false)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption2 = (FsMgrBooleanOption)fsMgrMountData.getOption(HARD);
        if (!this.equalAttributes(fsMgrBooleanOption2, this.hard, true)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption3 = (FsMgrBooleanOption)fsMgrMountData.getOption(SOFT);
        if (!this.equalAttributes(fsMgrBooleanOption3, this.soft, false)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption4 = (FsMgrBooleanOption)fsMgrMountData.getOption(INTR);
        if (!this.equalAttributes(fsMgrBooleanOption4, this.intr, true)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption5 = (FsMgrBooleanOption)fsMgrMountData.getOption(NOINTR);
        if (!this.equalAttributes(fsMgrBooleanOption5, this.nointr, false)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption6 = (FsMgrBooleanOption)fsMgrMountData.getOption(KERBEROS);
        if (!this.equalAttributes(fsMgrBooleanOption6, this.kerberos, false)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption7 = (FsMgrBooleanOption)fsMgrMountData.getOption(NOAC);
        if (!this.equalAttributes(fsMgrBooleanOption7, this.noac, false)) {
            return false;
        }
        FsMgrIntegerOption fsMgrIntegerOption6 = (FsMgrIntegerOption)fsMgrMountData.getOption(PORT);
        if (!this.equalAttributes(fsMgrIntegerOption6, this.port)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption8 = (FsMgrBooleanOption)fsMgrMountData.getOption(POSIX);
        if (!this.equalAttributes(fsMgrBooleanOption8, this.posix, false)) {
            return false;
        }
        FsMgrStringOption fsMgrStringOption = (FsMgrStringOption)fsMgrMountData.getOption(PROTO);
        if (!this.equalAttributes(fsMgrStringOption, this.proto)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption9 = (FsMgrBooleanOption)fsMgrMountData.getOption(PUBLIC);
        if (!this.equalAttributes(fsMgrBooleanOption9, this.webnfs, false)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption10 = (FsMgrBooleanOption)fsMgrMountData.getOption(QUOTA);
        if (!this.equalAttributes(fsMgrBooleanOption10, this.quota, false)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption11 = (FsMgrBooleanOption)fsMgrMountData.getOption(NOQUOTA);
        if (!this.equalAttributes(fsMgrBooleanOption11, this.noquota, true)) {
            return false;
        }
        FsMgrIntegerOption fsMgrIntegerOption7 = (FsMgrIntegerOption)fsMgrMountData.getOption(RETRANS);
        if (!this.equalAttributes(fsMgrIntegerOption7, this.retrans)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption12 = (FsMgrBooleanOption)fsMgrMountData.getOption(RO);
        if (!this.equalAttributes(fsMgrBooleanOption12, this.ro, false)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption13 = (FsMgrBooleanOption)fsMgrMountData.getOption(RW);
        if (!this.equalAttributes(fsMgrBooleanOption13, this.rw, true)) {
            return false;
        }
        FsMgrIntegerOption fsMgrIntegerOption8 = (FsMgrIntegerOption)fsMgrMountData.getOption(RSIZE);
        if (!this.equalAttributes(fsMgrIntegerOption8, this.rsize)) {
            return false;
        }
        FsMgrStringOption fsMgrStringOption2 = (FsMgrStringOption)fsMgrMountData.getOption(SEC);
        if (!this.equalAttributes(fsMgrStringOption2, this.sec)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption14 = (FsMgrBooleanOption)fsMgrMountData.getOption(SECURE);
        if (!this.equalAttributes(fsMgrBooleanOption14, this.secure, false)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption15 = (FsMgrBooleanOption)fsMgrMountData.getOption(SUID);
        if (!this.equalAttributes(fsMgrBooleanOption15, this.suid, true)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption16 = (FsMgrBooleanOption)fsMgrMountData.getOption(NOSUID);
        if (!this.equalAttributes(fsMgrBooleanOption16, this.nosuid, false)) {
            return false;
        }
        FsMgrIntegerOption fsMgrIntegerOption9 = (FsMgrIntegerOption)fsMgrMountData.getOption(TIMEO);
        if (!this.equalAttributes(fsMgrIntegerOption9, this.timeo)) {
            return false;
        }
        FsMgrIntegerOption fsMgrIntegerOption10 = (FsMgrIntegerOption)fsMgrMountData.getOption(VERS);
        if (!this.equalAttributes(fsMgrIntegerOption10, this.vers)) {
            return false;
        }
        FsMgrIntegerOption fsMgrIntegerOption11 = (FsMgrIntegerOption)fsMgrMountData.getOption(WSIZE);
        if (!this.equalAttributes(fsMgrIntegerOption11, this.wsize)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption17 = (FsMgrBooleanOption)fsMgrMountData.getOption(LARGEFILES);
        if (!this.equalAttributes(fsMgrBooleanOption17, this.largefiles, true)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption18 = (FsMgrBooleanOption)fsMgrMountData.getOption(NOLARGEFILES);
        if (!this.equalAttributes(fsMgrBooleanOption18, this.nolargefiles, false)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption19 = (FsMgrBooleanOption)fsMgrMountData.getOption(NOATIME);
        if (!this.equalAttributes(fsMgrBooleanOption19, this.noatime, false)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption20 = (FsMgrBooleanOption)fsMgrMountData.getOption(FORCEDIRECTIO);
        if (!this.equalAttributes(fsMgrBooleanOption20, this.forcedirectio, false)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption21 = (FsMgrBooleanOption)fsMgrMountData.getOption(NOFORCEDIRECTIO);
        if (!this.equalAttributes(fsMgrBooleanOption21, this.noforcedirectio, true)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption22 = (FsMgrBooleanOption)fsMgrMountData.getOption(LOGGING);
        if (!this.equalAttributes(fsMgrBooleanOption22, this.logging, false)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption23 = (FsMgrBooleanOption)fsMgrMountData.getOption(NOLOGGING);
        if (!this.equalAttributes(fsMgrBooleanOption23, this.nologging, true)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption24 = (FsMgrBooleanOption)fsMgrMountData.getOption(RQ);
        if (!this.equalAttributes(fsMgrBooleanOption24, this.rq, false)) {
            return false;
        }
        FsMgrStringOption fsMgrStringOption3 = (FsMgrStringOption)fsMgrMountData.getOption(ONERROR);
        if (!this.equalAttributes(fsMgrStringOption3, this.onerror, ONERROR_DEFAULT)) {
            return false;
        }
        FsMgrStringOption fsMgrStringOption4 = (FsMgrStringOption)fsMgrMountData.getOption(TOOSOON);
        if (!this.equalAttributes(fsMgrStringOption4, this.toosoon, TOOSOON_DEFAULT)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption25 = (FsMgrBooleanOption)fsMgrMountData.getOption(GLOBAL);
        if (!this.equalAttributes(fsMgrBooleanOption25, this.global, false)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption26 = (FsMgrBooleanOption)fsMgrMountData.getOption(NOGLOBAL);
        if (!this.equalAttributes(fsMgrBooleanOption26, this.noglobal, true)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption27 = (FsMgrBooleanOption)fsMgrMountData.getOption(RR);
        if (!this.equalAttributes(fsMgrBooleanOption27, this.rr, true)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption28 = (FsMgrBooleanOption)fsMgrMountData.getOption(NRR);
        if (!this.equalAttributes(fsMgrBooleanOption28, this.nrr, false)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption29 = (FsMgrBooleanOption)fsMgrMountData.getOption(TRAILDOT);
        if (!this.equalAttributes(fsMgrBooleanOption29, this.traildot, true)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption30 = (FsMgrBooleanOption)fsMgrMountData.getOption(NOTRAILDOT);
        if (!this.equalAttributes(fsMgrBooleanOption30, this.notraildot, false)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption31 = (FsMgrBooleanOption)fsMgrMountData.getOption(MAPLCASE);
        if (!this.equalAttributes(fsMgrBooleanOption31, this.maplcase, true)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption32 = (FsMgrBooleanOption)fsMgrMountData.getOption(NOMAPLCASE);
        return this.equalAttributes(fsMgrBooleanOption32, this.nomaplcase, false);
    }

    public String getBootMount() {
        return this.bootMount;
    }

    public String getFsType() {
        return this.fsType;
    }

    public String getFsckDevice() {
        return this.fsckDevice;
    }

    public String getFsckPass() {
        return this.fsckPass;
    }

    public String getMountPoint() {
        return this.mountPoint;
    }

    public Object getOption(String string) {
        Cloneable cloneable = null;
        if (string == ACDIRMAX) {
            cloneable = this.acdirmax;
        } else if (string == ACDIRMIN) {
            cloneable = this.acdirmin;
        } else if (string == ACREGMAX) {
            cloneable = this.acregmax;
        } else if (string == ACREGMIN) {
            cloneable = this.acregmin;
        } else if (string == ACTIMEO) {
            cloneable = this.actimeo;
        } else if (string == BG) {
            cloneable = this.bg;
        } else if (string == FG) {
            cloneable = this.fg;
        } else if (string == GRPID) {
            cloneable = this.grpid;
        } else if (string == HARD) {
            cloneable = this.hard;
        } else if (string == SOFT) {
            cloneable = this.soft;
        } else if (string == INTR) {
            cloneable = this.intr;
        } else if (string == NOINTR) {
            cloneable = this.nointr;
        } else if (string == KERBEROS) {
            cloneable = this.kerberos;
        } else if (string == NOAC) {
            cloneable = this.noac;
        } else if (string == PORT) {
            cloneable = this.port;
        } else if (string == POSIX) {
            cloneable = this.posix;
        } else if (string == PROTO) {
            cloneable = this.proto;
        } else if (string == PUBLIC) {
            cloneable = this.webnfs;
        } else if (string == QUOTA) {
            cloneable = this.quota;
        } else if (string == NOQUOTA) {
            cloneable = this.noquota;
        } else if (string == RETRANS) {
            cloneable = this.retrans;
        } else if (string == RETRY) {
            cloneable = this.retry;
        } else if (string == RO) {
            cloneable = this.ro;
        } else if (string == RW) {
            cloneable = this.rw;
        } else if (string == RSIZE) {
            cloneable = this.rsize;
        } else if (string == SEC) {
            cloneable = this.sec;
        } else if (string == SECURE) {
            cloneable = this.secure;
        } else if (string == SUID) {
            cloneable = this.suid;
        } else if (string == NOSUID) {
            cloneable = this.nosuid;
        } else if (string == TIMEO) {
            cloneable = this.timeo;
        } else if (string == VERS) {
            cloneable = this.vers;
        } else if (string == WSIZE) {
            cloneable = this.wsize;
        } else if (string == LARGEFILES) {
            cloneable = this.largefiles;
        } else if (string == NOLARGEFILES) {
            cloneable = this.nolargefiles;
        } else if (string == NOATIME) {
            cloneable = this.noatime;
        } else if (string == FORCEDIRECTIO) {
            cloneable = this.forcedirectio;
        } else if (string == NOFORCEDIRECTIO) {
            cloneable = this.noforcedirectio;
        } else if (string == LOGGING) {
            cloneable = this.logging;
        } else if (string == NOLOGGING) {
            cloneable = this.nologging;
        } else if (string == RQ) {
            cloneable = this.rq;
        } else if (string == ONERROR) {
            cloneable = this.onerror;
        } else if (string == TOOSOON) {
            cloneable = this.toosoon;
        } else if (string == GLOBAL) {
            cloneable = this.global;
        } else if (string == NOGLOBAL) {
            cloneable = this.noglobal;
        } else if (string == RR) {
            cloneable = this.rr;
        } else if (string == NRR) {
            cloneable = this.nrr;
        } else if (string == TRAILDOT) {
            cloneable = this.traildot;
        } else if (string == NOTRAILDOT) {
            cloneable = this.notraildot;
        } else if (string == MAPLCASE) {
            cloneable = this.maplcase;
        } else if (string == NOMAPLCASE) {
            cloneable = this.nomaplcase;
        }
        return cloneable;
    }

    public String getResource() {
        return this.resource;
    }

    public boolean isRo() {
        boolean bl = false;
        if (this.ro != null && this.ro.getValue()) {
            bl = true;
        }
        return bl;
    }

    public boolean isRw() {
        boolean bl = false;
        if (this.rw != null && this.rw.getValue() || this.fsType.equals(UFS) && this.rq != null && this.rq.getValue() || this.ro == null || !this.ro.getValue()) {
            bl = true;
        }
        return bl;
    }

    public boolean isSpecial() {
        return this.mountPoint.equals(ROOT) || this.mountPoint.equals(USR) || this.mountPoint.equals(VAR) || !this.isSupportedFsType();
    }

    public boolean isSupportedFsType() {
        return this.fsType.equals(UFS) || this.fsType.equals(NFS) || this.fsType.equals(HSFS);
    }

    public void removeOption(String string) {
        if (string == ACDIRMAX) {
            this.acdirmax = null;
        } else if (string == ACDIRMIN) {
            this.acdirmin = null;
        } else if (string == ACREGMAX) {
            this.acregmax = null;
        } else if (string == ACREGMIN) {
            this.acregmin = null;
        } else if (string == ACTIMEO) {
            this.actimeo = null;
        } else if (string == BG) {
            this.bg = null;
        } else if (string == FG) {
            this.fg = null;
        } else if (string == GRPID) {
            this.grpid = null;
        } else if (string == HARD) {
            this.hard = null;
        } else if (string == SOFT) {
            this.soft = null;
        } else if (string == INTR) {
            this.intr = null;
        } else if (string == NOINTR) {
            this.nointr = null;
        } else if (string == KERBEROS) {
            this.kerberos = null;
        } else if (string == NOAC) {
            this.noac = null;
        } else if (string == PORT) {
            this.port = null;
        } else if (string == POSIX) {
            this.posix = null;
        } else if (string == PROTO) {
            this.proto = null;
        } else if (string == PUBLIC) {
            this.webnfs = null;
        } else if (string == QUOTA) {
            this.quota = null;
        } else if (string == NOQUOTA) {
            this.noquota = null;
        } else if (string == RETRANS) {
            this.retrans = null;
        } else if (string == RETRY) {
            this.retry = null;
        } else if (string == RO) {
            this.ro = null;
        } else if (string == RW) {
            this.rw = null;
        } else if (string == RSIZE) {
            this.rsize = null;
        } else if (string == SEC) {
            this.sec = null;
        } else if (string == SECURE) {
            this.secure = null;
        } else if (string == SUID) {
            this.suid = null;
        } else if (string == NOSUID) {
            this.nosuid = null;
        } else if (string == TIMEO) {
            this.timeo = null;
        } else if (string == VERS) {
            this.vers = null;
        } else if (string == WSIZE) {
            this.wsize = null;
        } else if (string == LARGEFILES) {
            this.largefiles = null;
        } else if (string == NOLARGEFILES) {
            this.nolargefiles = null;
        } else if (string == NOATIME) {
            this.noatime = null;
        } else if (string == FORCEDIRECTIO) {
            this.forcedirectio = null;
        } else if (string == NOFORCEDIRECTIO) {
            this.noforcedirectio = null;
        } else if (string == LOGGING) {
            this.logging = null;
        } else if (string == NOLOGGING) {
            this.nologging = null;
        } else if (string == RQ) {
            this.rq = null;
        } else if (string == ONERROR) {
            this.onerror = null;
        } else if (string == TOOSOON) {
            this.toosoon = null;
        } else if (string == GLOBAL) {
            this.global = null;
        } else if (string == NOGLOBAL) {
            this.noglobal = null;
        } else if (string == RR) {
            this.rr = null;
        } else if (string == NRR) {
            this.nrr = null;
        } else if (string == TRAILDOT) {
            this.traildot = null;
        } else if (string == NOTRAILDOT) {
            this.notraildot = null;
        } else if (string == MAPLCASE) {
            this.maplcase = null;
        } else if (string == NOMAPLCASE) {
            this.nomaplcase = null;
        }
    }

    public void setBootMount(String string) {
        this.bootMount = string;
    }

    public void setFsType(String string) {
        this.fsType = string;
    }

    public void setFsckDevice(String string) {
        this.fsckDevice = string;
    }

    public void setFsckPass(String string) {
        this.fsckPass = string;
    }

    public void setMountPoint(String string) {
        this.mountPoint = string;
    }

    private void setOption(String string) {
        int n = 61;
        int n2 = string.indexOf(n);
        if (n2 != -1) {
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1);
            this.setOption(string2, string3);
        } else {
            String string4 = string;
            this.setOption(string4, true);
        }
    }

    public void setOption(String string, int n) {
        this.setOption(string, Integer.toString(n));
    }

    public void setOption(String string, String string2) {
        if (string.equals(ACDIRMAX)) {
            if (this.acdirmax == null) {
                this.acdirmax = this.createOption(ACDIRMAX, this.acdirmax, string2);
            } else {
                this.acdirmax.setValue(string2);
            }
        } else if (string.equals(ACDIRMIN)) {
            if (this.acdirmin == null) {
                this.acdirmin = this.createOption(ACDIRMIN, this.acdirmin, string2);
            } else {
                this.acdirmin.setValue(string2);
            }
        } else if (string.equals(ACREGMAX)) {
            if (this.acregmax == null) {
                this.acregmax = this.createOption(ACREGMAX, this.acregmax, string2);
            } else {
                this.acregmax.setValue(string2);
            }
        } else if (string.equals(ACREGMIN)) {
            if (this.acregmin == null) {
                this.acregmin = this.createOption(ACREGMIN, this.acregmin, string2);
            } else {
                this.acregmin.setValue(string2);
            }
        } else if (string.equals(ACTIMEO)) {
            if (this.actimeo == null) {
                this.actimeo = this.createOption(ACTIMEO, this.actimeo, string2);
            } else {
                this.actimeo.setValue(string2);
            }
        } else if (string.equals(PORT)) {
            if (this.port == null) {
                this.port = this.createOption(PORT, this.port, string2);
            } else {
                this.port.setValue(string2);
            }
        } else if (string.equals(PROTO)) {
            if (this.proto == null) {
                this.proto = this.createOption(PROTO, this.proto, string2);
            } else {
                this.proto.setValue(string2);
            }
        } else if (string.equals(RETRANS)) {
            if (this.retrans == null) {
                this.retrans = this.createOption(RETRANS, this.retrans, string2);
            } else {
                this.retrans.setValue(string2);
            }
        } else if (string.equals(RETRY)) {
            if (this.retry == null) {
                this.retry = this.createOption(RETRY, this.retry, string2);
            } else {
                this.retry.setValue(string2);
            }
        } else if (string.equals(RSIZE)) {
            if (this.rsize == null) {
                this.rsize = this.createOption(RSIZE, this.rsize, string2);
            } else {
                this.rsize.setValue(string2);
            }
        } else if (string.equals(SEC)) {
            if (this.sec == null) {
                this.sec = this.createOption(SEC, this.sec, string2);
            } else {
                this.sec.setValue(string2);
            }
        } else if (string.equals(TIMEO)) {
            if (this.timeo == null) {
                this.timeo = this.createOption(TIMEO, this.timeo, string2);
            } else {
                this.timeo.setValue(string2);
            }
        } else if (string.equals(VERS)) {
            if (this.vers == null) {
                this.vers = this.createOption(VERS, this.vers, string2);
            } else {
                this.vers.setValue(string2);
            }
        } else if (string.equals(WSIZE)) {
            if (this.wsize == null) {
                this.wsize = this.createOption(WSIZE, this.wsize, string2);
            } else {
                this.wsize.setValue(string2);
            }
        } else if (string.equals(ONERROR)) {
            if (this.onerror == null) {
                this.onerror = this.createOption(ONERROR, this.onerror, string2);
            } else {
                this.onerror.setValue(string2);
            }
        } else if (string.equals(TOOSOON)) {
            if (this.toosoon == null) {
                this.toosoon = this.createOption(TOOSOON, this.toosoon, string2);
            } else {
                this.toosoon.setValue(string2);
            }
        } else if (!string.equals(DEV)) {
            this.isSupportedFsType();
        }
    }

    public void setOption(String string, boolean bl) {
        if (string.equals(BG)) {
            if (this.bg == null) {
                this.bg = this.createOption(BG, this.bg, bl);
            } else {
                this.bg.setValue(bl);
            }
            if (this.fg != null) {
                this.fg.setValue(bl ^ true);
            }
        } else if (string.equals(FG)) {
            if (this.fg == null) {
                this.fg = this.createOption(FG, this.fg, bl);
            } else {
                this.fg.setValue(bl);
            }
            if (this.bg != null) {
                this.bg.setValue(bl ^ true);
            }
        } else if (string.equals(GRPID)) {
            if (this.grpid == null) {
                this.grpid = this.createOption(GRPID, this.grpid, bl);
            } else {
                this.grpid.setValue(bl);
            }
        } else if (string.equals(HARD)) {
            if (this.hard == null) {
                this.hard = this.createOption(HARD, this.hard, bl);
            } else {
                this.hard.setValue(bl);
            }
            if (this.soft != null) {
                this.soft.setValue(bl ^ true);
            }
        } else if (string.equals(SOFT)) {
            if (this.soft == null) {
                this.soft = this.createOption(SOFT, this.soft, bl);
            } else {
                this.soft.setValue(bl);
            }
            if (this.hard != null) {
                this.hard.setValue(bl ^ true);
            }
        } else if (string.equals(INTR)) {
            if (this.intr == null) {
                this.intr = this.createOption(INTR, this.intr, bl);
            } else {
                this.intr.setValue(bl);
            }
            if (this.nointr != null) {
                this.nointr.setValue(bl ^ true);
            }
        } else if (string.equals(NOINTR)) {
            if (this.nointr == null) {
                this.nointr = this.createOption(NOINTR, this.nointr, bl);
            } else {
                this.nointr.setValue(bl);
            }
            if (this.intr != null) {
                this.intr.setValue(bl ^ true);
            }
        } else if (string.equals(KERBEROS)) {
            if (this.kerberos == null) {
                this.kerberos = this.createOption(KERBEROS, this.kerberos, bl);
            } else {
                this.kerberos.setValue(bl);
            }
        } else if (string.equals(NOAC)) {
            if (this.noac == null) {
                this.noac = this.createOption(NOAC, this.noac, bl);
            } else {
                this.noac.setValue(bl);
            }
        } else if (string.equals(POSIX)) {
            if (this.posix == null) {
                this.posix = this.createOption(POSIX, this.posix, bl);
            } else {
                this.posix.setValue(bl);
            }
        } else if (string.equals(PUBLIC)) {
            if (this.webnfs == null) {
                this.webnfs = this.createOption(PUBLIC, this.webnfs, bl);
            } else {
                this.webnfs.setValue(bl);
            }
        } else if (string.equals(QUOTA)) {
            if (this.quota == null) {
                this.quota = this.createOption(QUOTA, this.quota, bl);
            } else {
                this.quota.setValue(bl);
            }
            if (this.noquota != null) {
                this.noquota.setValue(bl ^ true);
            }
        } else if (string.equals(NOQUOTA)) {
            if (this.noquota == null) {
                this.noquota = this.createOption(NOQUOTA, this.noquota, bl);
            } else {
                this.noquota.setValue(bl);
            }
            if (this.quota != null) {
                this.quota.setValue(bl ^ true);
            }
        } else if (string.equals(RO)) {
            if (this.ro == null) {
                this.ro = this.createOption(RO, this.ro, bl);
            } else {
                this.ro.setValue(bl);
            }
            if (this.rw != null) {
                this.rw.setValue(bl ^ true);
            }
        } else if (string.equals(RW)) {
            if (this.rw == null) {
                this.rw = this.createOption(RW, this.rw, bl);
            } else {
                this.rw.setValue(bl);
            }
            if (this.ro != null) {
                this.ro.setValue(bl ^ true);
            }
        } else if (string.equals(SECURE)) {
            if (this.secure == null) {
                this.secure = this.createOption(SECURE, this.secure, bl);
            } else {
                this.secure.setValue(bl);
            }
        } else if (string.equals(SUID)) {
            if (this.suid == null) {
                this.suid = this.createOption(SUID, this.suid, bl);
            } else {
                this.suid.setValue(bl);
            }
            if (this.nosuid != null) {
                this.nosuid.setValue(bl ^ true);
            }
        } else if (string.equals(NOSUID)) {
            if (this.nosuid == null) {
                this.nosuid = this.createOption(NOSUID, this.nosuid, bl);
            } else {
                this.nosuid.setValue(bl);
            }
            if (this.suid != null) {
                this.suid.setValue(bl ^ true);
            }
        } else if (string.equals(LARGEFILES)) {
            if (this.largefiles == null) {
                this.largefiles = this.createOption(LARGEFILES, this.largefiles, bl);
            } else {
                this.largefiles.setValue(bl);
            }
            if (this.nolargefiles != null) {
                this.nolargefiles.setValue(bl ^ true);
            }
        } else if (string.equals(NOLARGEFILES)) {
            if (this.nolargefiles == null) {
                this.nolargefiles = this.createOption(NOLARGEFILES, this.nolargefiles, bl);
            } else {
                this.nolargefiles.setValue(bl);
            }
            if (this.largefiles != null) {
                this.largefiles.setValue(bl ^ true);
            }
        } else if (string.equals(NOATIME)) {
            if (this.noatime == null) {
                this.noatime = this.createOption(NOATIME, this.noatime, bl);
            } else {
                this.noatime.setValue(bl);
            }
        } else if (string.equals(FORCEDIRECTIO)) {
            if (this.forcedirectio == null) {
                this.forcedirectio = this.createOption(FORCEDIRECTIO, this.forcedirectio, bl);
            } else {
                this.forcedirectio.setValue(bl);
            }
            if (this.noforcedirectio != null) {
                this.noforcedirectio.setValue(bl ^ true);
            }
        } else if (string.equals(NOFORCEDIRECTIO)) {
            if (this.noforcedirectio == null) {
                this.noforcedirectio = this.createOption(NOFORCEDIRECTIO, this.noforcedirectio, bl);
            } else {
                this.noforcedirectio.setValue(bl);
            }
            if (this.forcedirectio != null) {
                this.forcedirectio.setValue(bl ^ true);
            }
        } else if (string.equals(LOGGING)) {
            if (this.logging == null) {
                this.logging = this.createOption(LOGGING, this.logging, bl);
            } else {
                this.logging.setValue(bl);
            }
            if (this.nologging != null) {
                this.nologging.setValue(bl ^ true);
            }
        } else if (string.equals(NOLOGGING)) {
            if (this.nologging == null) {
                this.nologging = this.createOption(NOLOGGING, this.nologging, bl);
            } else {
                this.nologging.setValue(bl);
            }
            if (this.logging != null) {
                this.logging.setValue(bl ^ true);
            }
        } else if (string.equals(RQ)) {
            if (this.rq == null) {
                this.rq = this.createOption(RQ, this.rq, bl);
            } else {
                this.rq.setValue(bl);
            }
        } else if (string.equals(GLOBAL)) {
            if (this.global == null) {
                this.global = this.createOption(GLOBAL, this.global, bl);
            } else {
                this.global.setValue(bl);
            }
            if (this.noglobal != null) {
                this.noglobal.setValue(bl ^ true);
            }
        } else if (string.equals(NOGLOBAL)) {
            if (this.noglobal == null) {
                this.noglobal = this.createOption(NOGLOBAL, this.noglobal, bl);
            } else {
                this.noglobal.setValue(bl);
            }
            if (this.global != null) {
                this.global.setValue(bl ^ true);
            }
        } else if (string.equals(RR)) {
            if (this.rr == null) {
                this.rr = this.createOption(RR, this.rr, bl);
            } else {
                this.rr.setValue(bl);
            }
            if (this.nrr != null) {
                this.nrr.setValue(bl ^ true);
            }
        } else if (string.equals(NRR)) {
            if (this.nrr == null) {
                this.nrr = this.createOption(NRR, this.nrr, bl);
            } else {
                this.nrr.setValue(bl);
            }
            if (this.rr != null) {
                this.rr.setValue(bl ^ true);
            }
        } else if (string.equals(TRAILDOT)) {
            if (this.traildot == null) {
                this.traildot = this.createOption(TRAILDOT, this.traildot, bl);
            } else {
                this.traildot.setValue(bl);
            }
            if (this.notraildot != null) {
                this.notraildot.setValue(bl ^ true);
            }
        } else if (string.equals(NOTRAILDOT)) {
            if (this.notraildot == null) {
                this.notraildot = this.createOption(NOTRAILDOT, this.notraildot, bl);
            } else {
                this.notraildot.setValue(bl);
            }
            if (this.traildot != null) {
                this.traildot.setValue(bl ^ true);
            }
        } else if (string.equals(MAPLCASE)) {
            if (this.maplcase == null) {
                this.maplcase = this.createOption(MAPLCASE, this.maplcase, bl);
            } else {
                this.maplcase.setValue(bl);
            }
            if (this.nomaplcase != null) {
                this.nomaplcase.setValue(bl ^ true);
            }
        } else if (string.equals(NOMAPLCASE)) {
            if (this.nomaplcase == null) {
                this.nomaplcase = this.createOption(NOMAPLCASE, this.nomaplcase, bl);
            } else {
                this.nomaplcase.setValue(bl);
            }
            if (this.maplcase != null) {
                this.maplcase.setValue(bl ^ true);
            }
        } else {
            this.isSupportedFsType();
        }
    }

    public void setResource(String string) {
        this.resource = string;
    }

    public FsMgrMount toFsMgrMount() {
        StringBuffer stringBuffer = new StringBuffer(128);
        if (this.acdirmax != null) {
            stringBuffer.append(this.acdirmax.toString());
            stringBuffer.append(COMMA);
        }
        if (this.acdirmin != null) {
            stringBuffer.append(this.acdirmin.toString());
            stringBuffer.append(COMMA);
        }
        if (this.acregmax != null) {
            stringBuffer.append(this.acregmax.toString());
            stringBuffer.append(COMMA);
        }
        if (this.acregmin != null) {
            stringBuffer.append(this.acregmin.toString());
            stringBuffer.append(COMMA);
        }
        if (this.actimeo != null) {
            stringBuffer.append(this.actimeo.toString());
            stringBuffer.append(COMMA);
        }
        if (this.bg != null && this.bg.getValue()) {
            stringBuffer.append(this.bg.toString());
            stringBuffer.append(COMMA);
        }
        if (this.fg != null && this.fg.getValue()) {
            stringBuffer.append(this.fg.toString());
            stringBuffer.append(COMMA);
        }
        if (this.grpid != null && this.grpid.getValue()) {
            stringBuffer.append(this.grpid.toString());
            stringBuffer.append(COMMA);
        }
        if (this.hard != null && this.hard.getValue()) {
            stringBuffer.append(this.hard.toString());
            stringBuffer.append(COMMA);
        }
        if (this.soft != null && this.soft.getValue()) {
            stringBuffer.append(this.soft.toString());
            stringBuffer.append(COMMA);
        }
        if (this.intr != null && this.intr.getValue()) {
            stringBuffer.append(this.intr.toString());
            stringBuffer.append(COMMA);
        }
        if (this.nointr != null && this.nointr.getValue()) {
            stringBuffer.append(this.nointr.toString());
            stringBuffer.append(COMMA);
        }
        if (this.kerberos != null && this.kerberos.getValue()) {
            stringBuffer.append(this.kerberos.toString());
            stringBuffer.append(COMMA);
        }
        if (this.noac != null && this.noac.getValue()) {
            stringBuffer.append(this.noac.toString());
            stringBuffer.append(COMMA);
        }
        if (this.port != null) {
            stringBuffer.append(this.port.toString());
            stringBuffer.append(COMMA);
        }
        if (this.posix != null && this.posix.getValue()) {
            stringBuffer.append(this.posix.toString());
            stringBuffer.append(COMMA);
        }
        if (this.proto != null) {
            stringBuffer.append(this.proto.toString());
            stringBuffer.append(COMMA);
        }
        if (this.webnfs != null && this.webnfs.getValue()) {
            stringBuffer.append(this.webnfs.toString());
            stringBuffer.append(COMMA);
        }
        if (this.quota != null && this.quota.getValue()) {
            stringBuffer.append(this.quota.toString());
            stringBuffer.append(COMMA);
        }
        if (this.noquota != null && this.noquota.getValue()) {
            stringBuffer.append(this.noquota.toString());
            stringBuffer.append(COMMA);
        }
        if (this.retrans != null) {
            stringBuffer.append(this.retrans.toString());
            stringBuffer.append(COMMA);
        }
        if (this.retry != null) {
            stringBuffer.append(this.retry.toString());
            stringBuffer.append(COMMA);
        }
        if (this.ro != null && this.ro.getValue()) {
            stringBuffer.append(this.ro.toString());
            stringBuffer.append(COMMA);
        }
        if (this.rw != null && this.rw.getValue()) {
            stringBuffer.append(this.rw.toString());
            stringBuffer.append(COMMA);
        }
        if (this.rsize != null) {
            stringBuffer.append(this.rsize.toString());
            stringBuffer.append(COMMA);
        }
        if (this.sec != null) {
            stringBuffer.append(this.sec.toString());
            stringBuffer.append(COMMA);
        }
        if (this.secure != null && this.secure.getValue()) {
            stringBuffer.append(this.secure.toString());
            stringBuffer.append(COMMA);
        }
        if (this.suid != null && this.suid.getValue()) {
            stringBuffer.append(this.suid.toString());
            stringBuffer.append(COMMA);
        }
        if (this.nosuid != null && this.nosuid.getValue()) {
            stringBuffer.append(this.nosuid.toString());
            stringBuffer.append(COMMA);
        }
        if (this.timeo != null) {
            stringBuffer.append(this.timeo.toString());
            stringBuffer.append(COMMA);
        }
        if (this.vers != null) {
            stringBuffer.append(this.vers.toString());
            stringBuffer.append(COMMA);
        }
        if (this.wsize != null) {
            stringBuffer.append(this.wsize.toString());
            stringBuffer.append(COMMA);
        }
        if (this.largefiles != null && this.largefiles.getValue()) {
            stringBuffer.append(this.largefiles.toString());
            stringBuffer.append(COMMA);
        }
        if (this.nolargefiles != null && this.nolargefiles.getValue()) {
            stringBuffer.append(this.nolargefiles.toString());
            stringBuffer.append(COMMA);
        }
        if (this.noatime != null && this.noatime.getValue()) {
            stringBuffer.append(this.noatime.toString());
            stringBuffer.append(COMMA);
        }
        if (this.forcedirectio != null && this.forcedirectio.getValue()) {
            stringBuffer.append(this.forcedirectio.toString());
            stringBuffer.append(COMMA);
        }
        if (this.noforcedirectio != null && this.noforcedirectio.getValue()) {
            stringBuffer.append(this.noforcedirectio.toString());
            stringBuffer.append(COMMA);
        }
        if (this.logging != null && this.logging.getValue()) {
            stringBuffer.append(this.logging.toString());
            stringBuffer.append(COMMA);
        }
        if (this.nologging != null && this.nologging.getValue()) {
            stringBuffer.append(this.nologging.toString());
            stringBuffer.append(COMMA);
        }
        if (this.rq != null && this.rq.getValue()) {
            stringBuffer.append(this.rq.toString());
            stringBuffer.append(COMMA);
        }
        if (this.onerror != null) {
            stringBuffer.append(this.onerror.toString());
            stringBuffer.append(COMMA);
        }
        if (this.toosoon != null) {
            stringBuffer.append(this.toosoon.toString());
            stringBuffer.append(COMMA);
        }
        if (this.global != null && this.global.getValue()) {
            stringBuffer.append(this.global.toString());
            stringBuffer.append(COMMA);
        }
        if (this.noglobal != null && this.noglobal.getValue()) {
            stringBuffer.append(this.noglobal.toString());
            stringBuffer.append(COMMA);
        }
        if (this.rr != null && this.rr.getValue()) {
            stringBuffer.append(this.rr.toString());
            stringBuffer.append(COMMA);
        }
        if (this.nrr != null && this.nrr.getValue()) {
            stringBuffer.append(this.nrr.toString());
            stringBuffer.append(COMMA);
        }
        if (this.traildot != null && this.traildot.getValue()) {
            stringBuffer.append(this.traildot.toString());
            stringBuffer.append(COMMA);
        }
        if (this.notraildot != null && this.notraildot.getValue()) {
            stringBuffer.append(this.notraildot.toString());
            stringBuffer.append(COMMA);
        }
        if (this.maplcase != null && this.maplcase.getValue()) {
            stringBuffer.append(this.maplcase.toString());
            stringBuffer.append(COMMA);
        }
        if (this.nomaplcase != null && this.nomaplcase.getValue()) {
            stringBuffer.append(this.nomaplcase.toString());
            stringBuffer.append(COMMA);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        FsMgrMount fsMgrMount = new FsMgrMount(this.resource, this.fsckDevice, this.mountPoint, this.fsType, this.fsckPass, this.bootMount, stringBuffer.toString());
        fsMgrMount.setRawString(this.rawString);
        return fsMgrMount;
    }
}

