/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.computersystem;

import com.sun.wbem.cim.CIMProviderException;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.computersystem.Solaris_ComputerSystem;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;
import java.util.Vector;

public class SystemPowerMgtData {
    private static final String powerconf_file = "/etc/power.conf";
    private static final String autoshutdown = "autoshutdown";
    private int idletime;
    private int starttimehour;
    private int starttimemin;
    private int stoptimehour;
    private int stoptimemin;
    private int behavior;
    private String idleTime = "";
    private String startTime = "";
    private String stopTime = "";
    private String behaviorStr = "";
    private static ProviderUtility provUtil = null;

    SystemPowerMgtData(int n, int n2, int n3, int n4, int n5, int n6, ProviderUtility providerUtility) {
        this.idletime = n;
        this.starttimehour = n2;
        this.starttimemin = n3;
        this.stoptimehour = n4;
        this.stoptimemin = n5;
        this.behavior = n6;
        provUtil = providerUtility;
    }

    public void getBehavior() {
        this.behaviorStr = this.behavior == 1 ? "shutdown" : (this.behavior == 2 ? "noshutdown" : (this.behavior == 3 ? "autowakeup" : (this.behavior == 4 ? "default" : (this.behavior == 5 ? "unconfigured" : "noshutdown"))));
    }

    public static Vector getSystemPowerMgtData() throws Exception {
        Vector vector = new Vector();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(powerconf_file));
            while ((string = bufferedReader.readLine()) != null) {
                if (!string.startsWith(autoshutdown)) continue;
                vector = SystemPowerMgtData.parseLine(string);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (Exception exception) {
            Solaris_ComputerSystem.provUtil.writeLog(2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)exception.getMessage());
        }
        return vector;
    }

    public String newLine() {
        Integer n;
        String string = new String();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (this.starttimehour < 10) {
            string2 = "0" + this.starttimehour;
        } else {
            n = new Integer(this.starttimehour);
            string2 = n.toString();
        }
        if (this.starttimemin < 10) {
            string3 = "0" + this.starttimemin;
        } else {
            n = new Integer(this.starttimemin);
            string3 = n.toString();
        }
        if (this.stoptimehour < 10) {
            string4 = "0" + this.stoptimehour;
        } else {
            n = new Integer(this.stoptimehour);
            string4 = n.toString();
        }
        if (this.stoptimemin < 10) {
            string5 = "0" + this.stoptimemin;
        } else {
            n = new Integer(this.stoptimemin);
            string5 = n.toString();
        }
        n = new Integer(this.idletime);
        this.idleTime = n.toString();
        this.startTime = String.valueOf(string2) + ":" + string3;
        this.stopTime = String.valueOf(string4) + ":" + string5;
        this.getBehavior();
        string = "autoshutdown\t" + this.idletime + "\t\t" + this.startTime + " " + this.stopTime + "\t\t" + this.behaviorStr;
        return string;
    }

    public static Vector parseLine(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t \n");
        stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        return vector;
    }

    public int sanityCheck() {
        if (this.idletime < 0 || this.idletime > 1440 || this.starttimehour < 0 || this.starttimehour > 23 || this.starttimemin < 0 || this.starttimemin > 59 || this.stoptimehour < 0 || this.stoptimehour > 23 || this.stoptimemin < 0 || this.stoptimemin > 59) {
            return -1;
        }
        return 0;
    }

    public int setSysPowerProperties() throws Exception {
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        String string = "/usr/sbin/pmconfig";
        try {
            process = runtime.exec("/usr/sbin/pmconfig");
            process.waitFor();
        }
        catch (Exception exception) {
            provUtil.writeLog(2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)exception.getMessage());
        }
        return 0;
    }

    public int setSystemPowerMgtData() throws Exception {
        try {
            String string;
            Vector vector = new Vector();
            Vector<String> vector2 = new Vector<String>();
            if (this.sanityCheck() < 0) {
                provUtil.writeLog(2, "LM_9000", "LM_9002", null, null, null, null);
                throw new CIMProviderException("GENERAL_EXCEPTION");
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(powerconf_file));
            while ((string = bufferedReader.readLine()) != null) {
                vector2.addElement(string);
            }
            bufferedReader.close();
            if (this.writeSysPowerMgtData(vector2) == 0) {
                this.setSysPowerProperties();
            }
            provUtil.writeLog(0, "LM_9000", "LM_9003", this.idleTime, this.startTime, this.stopTime, this.behaviorStr);
            return 0;
        }
        catch (Exception exception) {
            provUtil.writeLog(2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)exception.getMessage());
        }
    }

    public int writeSysPowerMgtData(Vector vector) throws Exception {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(powerconf_file)));
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                String string = (String)vector.elementAt(n2);
                if (string.startsWith(autoshutdown)) {
                    bufferedWriter.write(this.newLine());
                    bufferedWriter.newLine();
                } else {
                    bufferedWriter.write(string);
                    bufferedWriter.newLine();
                }
                ++n2;
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            provUtil.writeLog(2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)exception.getMessage());
        }
        return 0;
    }
}

