/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.fsmgr.files;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMDateTime;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMProviderException;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.cim.UnsignedInt64;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.provider20.InstanceProvider;
import com.sun.wbem.solarisprovider.common.PropertyUtil;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.fsmgr.files.NativeStorage;
import com.sun.wbem.utility.log.LogUtil;
import java.io.File;
import java.math.BigInteger;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class Solaris_DataFile
implements InstanceProvider {
    public static final String CSCCN = "CSCreationClassName";
    public static final String CSNAME = "CSName";
    public static final String FSCCN = "FSCreationClassName";
    public static final String FSNAME = "FSName";
    public static final String CCN = "CreationClassName";
    public static final String NAME = "Name";
    public static final String SIZE = "FileSize";
    public static final String CDATE = "CreationDate";
    public static final String MODDATE = "LastModified";
    public static final String ACCDATE = "LastAccessed";
    public static final String READ = "Readable";
    public static final String WRITE = "Writeable";
    public static final String COMPRESS = "CompressionMethod";
    public static final String ENCRYPT = "EncryptionMethod";
    public static final String INUSE = "InUseCount";
    public static final String NATIVE_FILE_IMPL = "datafile.nativeimplementation";
    public static final String PROVIDER_NAME = "Datafile provider";
    private CIMOMHandle cimomhandle = null;
    private String nativeClass = null;
    private ProviderUtility provUtil = null;
    private PropertyUtil props = null;
    private NativeStorage storageImpl = null;
    private LogUtil logUtil = null;

    public void cleanup() throws CIMException {
    }

    private UnsignedInt32 convertIntToCIMUnsignedInt(int n) {
        try {
            return new UnsignedInt32(Integer.toString(n));
        }
        catch (Exception exception) {
            return new UnsignedInt32("0");
        }
    }

    private UnsignedInt64 convertLongToCIMUnsignedLong(long l) {
        try {
            return new UnsignedInt64(new BigInteger(Long.toString(l)));
        }
        catch (Exception exception) {
            return new UnsignedInt64(new BigInteger("0"));
        }
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    private CIMInstance createNewInstance(CIMClass cIMClass, String string) throws Exception {
        CIMInstance cIMInstance = cIMClass.newInstance();
        File file = new File(string);
        cIMInstance.setProperty(CSCCN, new CIMValue((Object)this.storageImpl.getComputerSystemCCN(string)));
        cIMInstance.setProperty(CSNAME, new CIMValue((Object)this.storageImpl.getComputerSystemName(string)));
        cIMInstance.setProperty(FSCCN, new CIMValue((Object)this.storageImpl.getFileSystemCCN(string)));
        cIMInstance.setProperty(FSNAME, new CIMValue((Object)this.storageImpl.getFileSystemName(string)));
        cIMInstance.setProperty(CCN, new CIMValue((Object)this.storageImpl.getFileSystemCCN(string)));
        cIMInstance.setProperty(NAME, new CIMValue((Object)string));
        long l = file.length();
        cIMInstance.setProperty(SIZE, new CIMValue((Object)this.convertLongToCIMUnsignedLong(l)));
        cIMInstance.setProperty(CDATE, new CIMValue((Object)new CIMDateTime()));
        Date date = new Date(file.lastModified());
        cIMInstance.setProperty(MODDATE, new CIMValue((Object)new CIMDateTime(date)));
        Date date2 = this.storageImpl.getLastAccessDate(string);
        cIMInstance.setProperty(ACCDATE, new CIMValue((Object)new CIMDateTime(date2)));
        cIMInstance.setProperty(READ, new CIMValue((Object)new Boolean(file.canRead())));
        cIMInstance.setProperty(WRITE, new CIMValue((Object)new Boolean(file.canWrite())));
        cIMInstance.setProperty(COMPRESS, new CIMValue((Object)this.storageImpl.getCompressionMethod(string)));
        cIMInstance.setProperty(ENCRYPT, new CIMValue((Object)this.storageImpl.getEncryptionMethod(string)));
        long l2 = this.storageImpl.getInUseCount(string);
        cIMInstance.setProperty(INUSE, new CIMValue((Object)this.convertLongToCIMUnsignedLong(l2)));
        return cIMInstance;
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass, boolean bl2) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public Vector execQuery(CIMObjectPath cIMObjectPath, String string, int n, CIMClass cIMClass) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, CIMClass cIMClass, boolean bl) throws CIMException {
        Object object;
        String string = null;
        this.provUtil.checkAuthenticated();
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            object = (CIMProperty)enumeration.nextElement();
            if (!object.getName().equalsIgnoreCase(NAME)) continue;
            string = (String)object.getValue().getValue();
        }
        if (string == null) {
            object = this.logUtil.writeLog(PROVIDER_NAME, "LM_4074", "LM_4075", null, cIMObjectPath.toString(), true, 0, 2);
            throw new CIMProviderException("CIM_ERR_FAILED", object);
        }
        object = null;
        try {
            object = this.createNewInstance(cIMClass, string);
        }
        catch (Exception exception) {
            String string2 = this.provUtil.writeLog(2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        return object;
    }

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        this.provUtil = new ProviderUtility(cIMOMHandle, PROVIDER_NAME);
        this.logUtil = LogUtil.getInstance((CIMOMHandle)cIMOMHandle);
        try {
            this.props = new PropertyUtil("propdir", "WbemServices.properties", 1);
            this.nativeClass = this.props.getProp(NATIVE_FILE_IMPL);
            if (this.nativeClass != null) {
                Class<?> clazz = Class.forName(this.nativeClass);
                this.storageImpl = (NativeStorage)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            String string = this.provUtil.writeLog(2, exception);
        }
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }
}

