/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.scheduledjob;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProviderException;
import com.sun.wbem.cim.CIMSecurityException;
import com.sun.wbem.cim.UnsignedInt16;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.client.ProviderCIMOMHandle;
import com.sun.wbem.provider20.InstanceProvider;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.scheduledjob.CronUtility;
import com.sun.wbem.utility.authorization.AuthorizationUtility;
import com.sun.wbem.utility.log.LogUtil;
import java.util.Vector;

public abstract class ScheduledJobProvider
implements InstanceProvider {
    private static final String MGMT_DOMAIN = "mgmtDomain";
    private static final String DFLT_DOMAIN_TYPE = "file";
    private static final String ROLE_TYPE = "role";
    public static final String SCHEDULED_JOBS_ADMIN_RIGHT = "solaris.jobs.admin";
    public static final String SCHEDULED_JOBS_USER_RIGHT = "solaris.jobs.user";
    private static final int AUTH_NONE = 0;
    private static final int AUTH_READ_SELF = 1;
    private static final int AUTH_READ_OTHER = 2;
    private static final int AUTH_READ_ANY = 3;
    private static final int AUTH_WRITE_SELF = 4;
    private static final int AUTH_WRITE_OTHER = 8;
    private static final int AUTH_WRITE_ANY = 12;
    private static final int AUTH_ALL = 15;
    protected ProviderCIMOMHandle cimomhandle = null;
    protected LogUtil logUtil = null;
    protected ProviderUtility provUtil = null;
    protected String providerName = "ScheduledJobProvider";

    protected void checkAdminModifyRights(CIMObjectPath cIMObjectPath) throws CIMException {
        this.provUtil.checkRights(SCHEDULED_JOBS_ADMIN_RIGHT, cIMObjectPath);
    }

    protected void checkAdminViewRights(CIMObjectPath cIMObjectPath) throws CIMException {
        try {
            this.provUtil.checkRights(SCHEDULED_JOBS_ADMIN_RIGHT, cIMObjectPath);
            return;
        }
        catch (CIMSecurityException cIMSecurityException) {
            this.provUtil.checkRights(SCHEDULED_JOBS_USER_RIGHT, cIMObjectPath);
            return;
        }
    }

    protected String checkJobModifyRights(String string, CIMObjectPath cIMObjectPath) throws CIMException {
        String string2 = null;
        int n = -1;
        String string3 = "";
        string2 = this.provUtil.getClientUserName();
        if (string2 == null) {
            throw new CIMSecurityException("CIM_ERR_ACCESS_DENIED");
        }
        if (string.compareTo(string2) != 0) {
            this.provUtil.checkRights(SCHEDULED_JOBS_ADMIN_RIGHT, cIMObjectPath);
            string3 = SCHEDULED_JOBS_ADMIN_RIGHT;
        }
        if ((n = CronUtility.withinFile(this, string, CronUtility.ALLOW_FILENAME)) == CronUtility.UNKNOWN_ERROR) {
            throw new CIMException("CIM_ERR_FAILED");
        }
        if (n != CronUtility.FILE_DOES_NOT_EXIST) {
            if (n == CronUtility.USER_NOT_IN_FILE) {
                this.checkUserRights(string, SCHEDULED_JOBS_USER_RIGHT, cIMObjectPath);
                if (string3.equals("")) {
                    string3 = SCHEDULED_JOBS_USER_RIGHT;
                } else {
                    string3 = string3.concat(";");
                    string3 = string3.concat(SCHEDULED_JOBS_USER_RIGHT);
                }
            }
        } else {
            n = CronUtility.withinFile(this, string, CronUtility.DENY_FILENAME);
            if (n == CronUtility.UNKNOWN_ERROR) {
                throw new CIMException("CIM_ERR_FAILED");
            }
            if (n != CronUtility.FILE_DOES_NOT_EXIST) {
                if (n == CronUtility.USER_IN_FILE) {
                    this.checkUserRights(string, SCHEDULED_JOBS_USER_RIGHT, cIMObjectPath);
                    if (string3.equals("")) {
                        string3 = SCHEDULED_JOBS_USER_RIGHT;
                    } else {
                        string3 = string3.concat(";");
                        string3 = string3.concat(SCHEDULED_JOBS_USER_RIGHT);
                    }
                }
            } else {
                this.checkUserRights(string, SCHEDULED_JOBS_USER_RIGHT, cIMObjectPath);
                if (string3.equals("")) {
                    string3 = SCHEDULED_JOBS_USER_RIGHT;
                } else {
                    string3 = string3.concat(";");
                    string3 = string3.concat(SCHEDULED_JOBS_USER_RIGHT);
                }
            }
        }
        return string3;
    }

    protected String checkJobViewRights(CIMObjectPath cIMObjectPath) throws CIMException {
        String string = null;
        int n = -1;
        string = this.provUtil.getClientUserName();
        try {
            this.provUtil.checkRights(SCHEDULED_JOBS_ADMIN_RIGHT, cIMObjectPath);
            return null;
        }
        catch (CIMSecurityException cIMSecurityException) {
            n = CronUtility.withinFile(this, string, CronUtility.ALLOW_FILENAME);
            if (n == CronUtility.UNKNOWN_ERROR) {
                throw new CIMException("CIM_ERR_FAILED");
            }
            if (n != CronUtility.FILE_DOES_NOT_EXIST) {
                if (n == CronUtility.USER_NOT_IN_FILE) {
                    this.provUtil.checkRights(SCHEDULED_JOBS_USER_RIGHT, cIMObjectPath);
                }
            } else {
                n = CronUtility.withinFile(this, string, CronUtility.DENY_FILENAME);
                if (n == CronUtility.UNKNOWN_ERROR) {
                    throw new CIMException("CIM_ERR_FAILED");
                }
                if (n != CronUtility.FILE_DOES_NOT_EXIST) {
                    if (n == CronUtility.USER_IN_FILE) {
                        this.provUtil.checkRights(SCHEDULED_JOBS_USER_RIGHT, cIMObjectPath);
                    }
                } else {
                    this.provUtil.checkRights(SCHEDULED_JOBS_USER_RIGHT, cIMObjectPath);
                }
            }
            return string;
        }
    }

    protected void checkUserRights(String string, String string2, CIMObjectPath cIMObjectPath) throws CIMException {
        if (!AuthorizationUtility.checkAuthName((String)string, (String)string2)) {
            String[] stringArray = new String[]{string};
            this.logUtil.writeLog(this.providerName, "LM_1001", "LM_1012", stringArray, "", false, 1, 1);
            this.provUtil.unAuthorizedAudit(cIMObjectPath, string2);
            throw new CIMSecurityException("CIM_ERR_ACCESS_DENIED");
        }
    }

    public void cleanup() throws CIMException {
    }

    protected UnsignedInt32 convertIntToCIMUnsignedInt(int n) {
        try {
            return new UnsignedInt32(Integer.toString(n));
        }
        catch (Exception exception) {
            return new UnsignedInt32("0");
        }
    }

    protected UnsignedInt16 convertShortToCIMUnsignedInt16(short s) {
        try {
            return new UnsignedInt16(Short.toString(s));
        }
        catch (Exception exception) {
            return new UnsignedInt16("0");
        }
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass, boolean bl2) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public Vector execQuery(CIMObjectPath cIMObjectPath, String string, int n, CIMClass cIMClass) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public String getClientSensitivityLabel() throws CIMException {
        return this.provUtil.getClientSensitivityLabel();
    }

    protected String getDefaultScope() {
        return this.provUtil.getDefaultScope();
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, CIMClass cIMClass, boolean bl) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    protected String getMessage(String string) {
        return this.logUtil.getMessage(string);
    }

    protected String getMgmtScope(CIMObjectPath cIMObjectPath) throws CIMException {
        return this.provUtil.getMgmtScope(cIMObjectPath);
    }

    public int getScheduledJobsAuthorization(CIMObjectPath cIMObjectPath) throws CIMException {
        String string = null;
        int n = -1;
        string = this.provUtil.getClientUserName();
        try {
            this.provUtil.checkRights(SCHEDULED_JOBS_ADMIN_RIGHT, cIMObjectPath);
            return 15;
        }
        catch (CIMSecurityException cIMSecurityException) {
            n = CronUtility.withinFile(this, string, CronUtility.ALLOW_FILENAME);
            if (n == CronUtility.UNKNOWN_ERROR) {
                return 0;
            }
            if (n != CronUtility.FILE_DOES_NOT_EXIST) {
                if (n == CronUtility.USER_NOT_IN_FILE) {
                    try {
                        this.provUtil.checkRights(SCHEDULED_JOBS_USER_RIGHT, cIMObjectPath);
                    }
                    catch (CIMSecurityException cIMSecurityException2) {
                        return 0;
                    }
                }
            } else {
                n = CronUtility.withinFile(this, string, CronUtility.DENY_FILENAME);
                if (n == CronUtility.UNKNOWN_ERROR) {
                    return 0;
                }
                if (n != CronUtility.FILE_DOES_NOT_EXIST) {
                    if (n == CronUtility.USER_IN_FILE) {
                        try {
                            this.provUtil.checkRights(SCHEDULED_JOBS_USER_RIGHT, cIMObjectPath);
                        }
                        catch (CIMSecurityException cIMSecurityException3) {
                            return 0;
                        }
                    }
                } else {
                    try {
                        this.provUtil.checkRights(SCHEDULED_JOBS_USER_RIGHT, cIMObjectPath);
                    }
                    catch (CIMSecurityException cIMSecurityException4) {
                        return 0;
                    }
                }
            }
            return 5;
        }
    }

    protected String getScopeType(String string) {
        if (string == null || string.trim().length() == 0) {
            return DFLT_DOMAIN_TYPE;
        }
        int n = string.indexOf(58);
        if (n < 1) {
            return DFLT_DOMAIN_TYPE;
        }
        return string.substring(0, n);
    }

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = (ProviderCIMOMHandle)cIMOMHandle;
        this.logUtil = LogUtil.getInstance((CIMOMHandle)cIMOMHandle);
        this.provUtil = new ProviderUtility(cIMOMHandle, this.providerName);
    }

    protected String logError(String string, String string2) {
        return this.provUtil.writeLog(2, string, string2, null, null, null, null);
    }

    protected String logError(String string, String string2, String string3) {
        return this.provUtil.writeLog(2, string, string2, string3, null, null, null);
    }

    protected String logError(String string, String string2, String string3, String string4) {
        return this.provUtil.writeLog(2, string, string2, string3, string4, null, null);
    }

    protected String logError(String string, String string2, String string3, String string4, String string5) {
        return this.provUtil.writeLog(2, string, string2, string3, string4, string5, null);
    }

    protected void logErrorAndThrow(String string, String string2) throws CIMException {
        throw new CIMProviderException("GENERAL_EXCEPTION", (Object)this.provUtil.writeLog(2, string, string2, null, null, null, null));
    }

    protected void logErrorAndThrow(String string, String string2, String string3) throws CIMException {
        throw new CIMProviderException("GENERAL_EXCEPTION", (Object)this.provUtil.writeLog(2, string, string2, string3, null, null, null));
    }

    protected void logErrorAndThrow(String string, String string2, String string3, String string4) throws CIMException {
        throw new CIMProviderException("GENERAL_EXCEPTION", (Object)this.provUtil.writeLog(2, string, string2, string3, string4, null, null));
    }

    protected void logErrorAndThrow(String string, String string2, String string3, String string4, String string5) throws CIMException {
        throw new CIMProviderException("GENERAL_EXCEPTION", (Object)this.provUtil.writeLog(2, string, string2, string3, string4, string5, null));
    }

    protected String logSuccess(String string) {
        return this.provUtil.writeLog(0, string, string, null, null, null, null);
    }

    protected String logSuccess(String string, String string2) {
        return this.provUtil.writeLog(0, string, string2, null, null, null, null);
    }

    protected String logSuccess(String string, String string2, String string3) {
        return this.provUtil.writeLog(0, string, string2, string3, null, null, null);
    }

    protected String logSuccess(String string, String string2, String string3, String string4) {
        return this.provUtil.writeLog(0, string, string2, string3, string4, null, null);
    }

    protected String logWarning(String string) {
        return this.provUtil.writeLog(1, string, string, null, null, null, null);
    }

    protected String logWarning(String string, String string2) {
        return this.provUtil.writeLog(1, string, string2, null, null, null, null);
    }

    protected String logWarning(String string, String string2, String string3) {
        return this.provUtil.writeLog(1, string, string2, string3, null, null, null);
    }

    protected String logWarning(String string, String string2, String string3, String string4) {
        return this.provUtil.writeLog(1, string, string2, string3, string4, null, null);
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    protected void writeLog(int n, Exception exception) {
        this.provUtil.writeLog(n, exception);
    }

    protected String writeLog(int n, String string, String string2, String string3, String string4, String string5, String string6) {
        return this.provUtil.writeLog(n, string, string2, string3, string4, string4, string6);
    }
}

