/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.network;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMElement;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMProviderException;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.provider20.InstanceProvider;
import com.sun.wbem.query.NonJoinExp;
import com.sun.wbem.query.QueryExp;
import com.sun.wbem.query.SelectExp;
import com.sun.wbem.query.SelectList;
import com.sun.wbem.query.WQLParser;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.network.NetworkConfigData;
import com.sun.wbem.solarisprovider.network.NetworkConfigInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Solaris_IPProtocolEndpoint
implements InstanceProvider {
    private static final String SOLARIS_IPPE = "Solaris_IPProtocolEndpoint";
    private static final String SOLARIS_CS = "Solaris_ComputerSystem";
    private static final String IP_ADDRESS = "Address";
    private static final String NETMASK = "SubnetMask";
    private static final String ADDRESS_TYPE = "AddressType";
    private static final String IPVERSION_SUPPORT = "IPVersionSupport";
    private static final String DESCRIPTION = "Description";
    private static final String STATUS = "Status";
    private static final String MAX_DATA_SIZE = "MaxDataSize";
    private static final String INDEX = "Index";
    private static final String BROADCAST = "Broadcast";
    private static final String OPTIONS = "OptionsEnabled";
    private static final String NAME = "Name";
    private static final String SYSTEM_CREATION_CLASS_NAME = "SystemCreationClassName";
    private static final String SYSTEM_NAME = "SystemName";
    private static final String CREATION_CLASS_NAME = "CreationClassName";
    private Hashtable hash = null;
    private CIMOMHandle cimomhandle = null;
    private ProviderUtility provUtil = null;
    private static final String providerName = "Solaris_IPProtocolEndpoint";

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    private CIMInstance createNewInstance(CIMClass cIMClass, NetworkConfigData networkConfigData) {
        CIMInstance cIMInstance = cIMClass.newInstance();
        cIMInstance.setProperty(NAME, new CIMValue((Object)networkConfigData.getInterfaceName()));
        cIMInstance.setProperty(IP_ADDRESS, new CIMValue((Object)networkConfigData.getIPAddress()));
        int n = 0;
        String string = networkConfigData.getAddressType();
        if (string.equalsIgnoreCase("IPv4")) {
            n = 1;
        }
        cIMInstance.setProperty(ADDRESS_TYPE, new CIMValue((Object)new Integer(n)));
        cIMInstance.setProperty(IPVERSION_SUPPORT, new CIMValue((Object)new Integer(n)));
        cIMInstance.setProperty(NETMASK, new CIMValue((Object)networkConfigData.getNetmask()));
        cIMInstance.setProperty(MAX_DATA_SIZE, new CIMValue((Object)networkConfigData.getMtu()));
        cIMInstance.setProperty(INDEX, new CIMValue((Object)networkConfigData.getIndex()));
        cIMInstance.setProperty(OPTIONS, new CIMValue((Object)networkConfigData.getOptionsEnabled()));
        cIMInstance.setProperty(DESCRIPTION, new CIMValue((Object)networkConfigData.getDescription()));
        cIMInstance.setProperty(BROADCAST, new CIMValue((Object)networkConfigData.getBroadcast()));
        cIMInstance.setProperty(STATUS, new CIMValue((Object)"Running"));
        cIMInstance.setProperty(CREATION_CLASS_NAME, new CIMValue((Object)"Solaris_IPProtocolEndpoint"));
        cIMInstance.setProperty(SYSTEM_CREATION_CLASS_NAME, new CIMValue((Object)SOLARIS_CS));
        try {
            cIMInstance.setProperty(SYSTEM_NAME, new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
        }
        catch (Exception exception) {}
        return cIMInstance;
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass) throws CIMException {
        Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
        try {
            this.hash = this.getData();
            if (this.hash == null) return null;
            Enumeration enumeration = this.hash.elements();
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    return vector;
                }
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                NetworkConfigData networkConfigData = (NetworkConfigData)enumeration.nextElement();
                cIMObjectPath2.addKey(NAME, new CIMValue((Object)networkConfigData.getInterfaceName()));
                cIMObjectPath2.addKey(CREATION_CLASS_NAME, new CIMValue((Object)"Solaris_IPProtocolEndpoint"));
                cIMObjectPath2.addKey(SYSTEM_CREATION_CLASS_NAME, new CIMValue((Object)SOLARIS_CS));
                try {
                    cIMObjectPath2.addKey(SYSTEM_NAME, new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                }
                catch (Exception exception) {}
                vector.addElement(cIMObjectPath2);
            }
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)exception.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass, boolean bl2) throws CIMException {
        Vector<CIMInstance> vector = new Vector<CIMInstance>();
        try {
            this.hash = this.getData();
            if (this.hash == null) return null;
            Enumeration enumeration = this.hash.elements();
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    return vector;
                }
                NetworkConfigData networkConfigData = (NetworkConfigData)enumeration.nextElement();
                vector.addElement(this.createNewInstance(cIMClass, networkConfigData));
            }
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)exception.toString());
        }
    }

    public Vector execQuery(CIMObjectPath cIMObjectPath, String string, int n, CIMClass cIMClass) throws CIMException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        WQLParser wQLParser = new WQLParser((InputStream)byteArrayInputStream);
        Vector<CIMElement> vector = new Vector<CIMElement>();
        try {
            SelectExp selectExp = (SelectExp)wQLParser.querySpecification();
            SelectList selectList = selectExp.getSelectList();
            NonJoinExp nonJoinExp = (NonJoinExp)selectExp.getFromClause();
            QueryExp queryExp = selectExp.getWhereClause();
            Vector vector2 = new Vector();
            vector2 = this.enumInstances(cIMObjectPath, false, cIMClass, true);
            int n2 = 0;
            while (n2 < vector2.size()) {
                if (queryExp == null || queryExp.apply((CIMElement)((CIMInstance)vector2.elementAt(n2)))) {
                    vector.addElement(selectList.apply((CIMElement)((CIMInstance)vector2.elementAt(n2))));
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
        return vector;
    }

    private Hashtable getData() throws Exception {
        try {
            NetworkConfigInfo networkConfigInfo = new NetworkConfigInfo(this.provUtil);
            Hashtable hashtable = networkConfigInfo.initData();
            if (hashtable != null) {
                return hashtable;
            }
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)exception.toString());
        }
        return null;
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, CIMClass cIMClass, boolean bl) throws CIMException {
        try {
            String string = null;
            NetworkConfigData networkConfigData = null;
            Enumeration enumeration = cIMObjectPath.getKeys().elements();
            while (enumeration.hasMoreElements()) {
                CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
                if (!cIMProperty.getName().equalsIgnoreCase(NAME)) continue;
                string = (String)cIMProperty.getValue().getValue();
            }
            if (string == null) {
                return null;
            }
            networkConfigData = this.getNetworkConfigData(string);
            return this.createNewInstance(cIMClass, networkConfigData);
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)exception.toString());
        }
    }

    private NetworkConfigData getNetworkConfigData(String string) throws Exception {
        Hashtable hashtable = null;
        NetworkConfigData networkConfigData = null;
        try {
            hashtable = this.getData();
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)exception.toString());
        }
        if (hashtable == null) {
            return null;
        }
        networkConfigData = (NetworkConfigData)hashtable.get(string);
        if (networkConfigData == null) {
            return null;
        }
        return networkConfigData;
    }

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        try {
            this.cimomhandle = cIMOMHandle;
            this.provUtil = new ProviderUtility(cIMOMHandle, "Solaris_IPProtocolEndpoint");
        }
        catch (CIMException cIMException) {
            this.provUtil.writeLog(2, (Exception)((Object)cIMException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)cIMException.toString());
        }
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }
}

