
--  
--  Copyright (c) 03/22/05 Sun Microsystems, Inc. All Rights Reserved. 
--  

-- A new procedure for seahaven 1.1 requirement to get top "n" containers
-- based on their cumulative performance avg for the given timerange.

-- The procedure should be called exactly the same way get_perf_data is
-- called by the reporting APIs. 
-- The report request may have been made for all the properties.
-- The purpose is to regenerate the properties vector only for top "n" 
-- out of the all properties for this report request.

CREATE OR REPLACE PROCEDURE sp_get_sorted_perf_properties(
                            p_sorted_rows IN NUMBER,
                            p_prop_id_cursor OUT pkg_perf_data.cursortype)

IS

BEGIN

    OPEN p_prop_id_cursor FOR 
    SELECT pts.property_id,module,property,pts.module_instance,
           pts.property_instance,units 
    FROM report_property rp, perf_temp_sorted pts 
    WHERE pts.property_id = rp.property_id
        AND rownum <= p_sorted_rows ;


    EXCEPTION
        WHEN NO_DATA_FOUND THEN
             RAISE_APPLICATION_ERROR( -20001, 'ROW_NOT_FOUND' );
        WHEN OTHERS THEN
             RAISE_APPLICATION_ERROR( -20002, 'OTHERS : '  || SQLCODE);

END sp_get_sorted_perf_properties;
/
SHOW ERRORS;
