--  @(#)sp_get_sorted_perf_data.sql	1.2 05/03/22 
--  
--  Copyright (c) 03/22/05 Sun Microsystems, Inc. All Rights Reserved. 
--  

-- A new procedure for seahaven 1.1 requirement to get top "n" containers
-- based on their cumulative performance avg for the given timerange.

-- The procedure should be called exactly the same way get_perf_data is 
-- called by the reporting APIs. The basic logical flow is the same
-- as get_perf_data procedure. 

-- The procedure gets the AVG of all trend_values for the give time range
-- for each instance of each property in the report_trend table.
-- Then it sorts the output basedon it in requested sort order.

CREATE OR REPLACE PROCEDURE sp_get_sorted_perf_data(
                        p_request_id IN report_request.request_id%TYPE,
                        p_id_array IN NUM_ARRAY,
                        p_function_name IN report_filter.function_name%TYPE,
                        p_start_date IN report_filter.start_date%TYPE,
                        p_end_date IN report_filter.end_date%TYPE,
                        p_table_name IN report_property.table_name%TYPE,
                        p_sort_order IN NUMBER,
                        p_sorted_rows IN NUMBER,
                        p_pdata_cursor OUT pkg_perf_data.cursorType)
IS

l_query                 varchar2(4000);
l_mod_inst_join         varchar2(100);
l_prop_inst_join        varchar2(200);

BEGIN


    --- 4823002 : Takes 6-7 minutes to generate performance reports for one property 
    --- Ran the exaplin plan without including report_request_property table in the join
    --- condition. Noticed that the REPORT_DATA_TREND_HOUR_FK1 index on report_data_trend_hour
    --- table is not used. No index in used for the trend table thereby resulting in a full
    --- access of the trend table. The inclusion of the report_request_property table results
    --- in the use of the REPORT_DATA_TREND_HOUR_FK1 index. This along with the and condition
    --- on the request_id equal to p_request_id clause reduces the cost of the query significantly.  

    --- Still include the p_start_date and p_end_date in the where clause to ensure
    --- that the optimizer will do partition elimination.

    --- For uptime statistics reports, return the value stored in the column trend_value

   -- start procedure code here.

    --- Insert the record id list first in a global temporary table
    --- Java code will issue a commit after calling this stored proc.

    FOR i in 1 .. p_id_array.count LOOP

       INSERT INTO perf_temp_id (rec_id) VALUES (p_id_array(i));

    END LOOP;


    -- generate the query

    l_query := 'INSERT INTO perf_temp_sorted ' ||
               'SELECT rdt.property_id, rdt.module_instance,' ||
               'rdt.property_instance,' ||
               'AVG( DECODE(:p_function_name,' || '''AVG''' || ',trend_avg_value,' || 
                       '''MIN''' || ',trend_min_value,' || 
                      '''MAX''' || ',trend_max_value,trend_value) ) avg_trend_value';

    l_query := l_query || ' FROM report_host rh, report_property rp, ';

    --- Generate AND NVL(rdt.module_instance,'x') = NVL(rrp.module_instance,'x');

    l_mod_inst_join := 'AND NVL(rdt.module_instance,' || '''' || 'x' || '''' || ') ' ||
                       '= NVL(rrp.module_instance,' || '''' || 'x' || '''' || ') ';

    --- User can specify a particular property instance (say CPU instance
    --- number 3) while adding a property to a report request or can even
    --- specify the property instance as '_ALL_' (in this example indicating
    --- that the data be retrieved for all the CPUs of the machine).

    --- Modified query to support "_ALL_" as property instance name
    --- Generate : AND NVL(rdt.property_instance,'x') = 
    ---    DECODE(rrp.property_instance,NULL,'x','_ALL_',rdt.property_instance,rrp.property_instance);

    l_prop_inst_join := 'AND NVL(rdt.property_instance,' || '''' || 'x' || '''' || ') ' ||
                        '= DECODE(rrp.property_instance,NULL,' || '''' || 'x' || '''' || ',' || 
                        '''' || '_ALL_' || '''' || ',' || 'rdt.property_instance,rrp.property_instance' || ') ';


    IF (p_table_name = 'report_data_trend_hour') THEN

        l_query := l_query || 'report_data_trend_hour rdt, report_request_property rrp ' ||
                   'WHERE rdt.host_id = rh.host_id AND rdt.property_id = rp.property_id ' ||
                   'AND rdt.property_id = rrp.property_id ';

        l_query := l_query || l_mod_inst_join || l_prop_inst_join;

        l_query := l_query || 'AND trend_date >= :p_start_date AND trend_date <= :p_end_date ' ||
                              'AND rrp.request_id = :p_request_id';

        l_query := l_query || ' AND rdt.rec_id IN ' || '(SELECT rec_id FROM perf_temp_id)';

        --- group by property_id, module_instance, property_instance
        --- as these things constitute a container.

        l_query := l_query || ' GROUP BY rdt.property_id, rdt.module_instance, rdt.property_instance';

        --- Order by the AVG calculated for each on of the above group

        l_query := l_query || ' ORDER BY avg_trend_value' ;

        if (p_sort_order = 2) THEN
            l_query := l_query || ' DESC';
        END IF;
  
        sp_print(l_query);

        EXECUTE IMMEDIATE l_query USING p_function_name, p_start_date, p_end_date, p_request_id;

    ELSIF (p_table_name = 'report_data_trend_day') THEN
        
        l_query := l_query || 'report_data_trend_day rdt, report_request_property rrp ' ||
                   'WHERE rdt.host_id = rh.host_id AND rdt.property_id = rp.property_id ' ||
                   'AND rdt.property_id = rrp.property_id ';

        l_query := l_query || l_mod_inst_join || l_prop_inst_join;

        l_query := l_query || 'AND trend_date >= :p_start_date AND trend_date <= :p_end_date ' ||
                              'AND rrp.request_id = :p_request_id';

        l_query := l_query || ' AND rdt.rec_id IN ' || '(SELECT rec_id FROM perf_temp_id)';

        l_query := l_query || ' GROUP BY rdt.property_id, rdt.module_instance, rdt.property_instance';

        l_query := l_query || ' ORDER BY avg_trend_value' ;

        if (p_sort_order = 2) THEN
            l_query := l_query || ' DESC';
        END IF;

        sp_print(l_query);

         EXECUTE IMMEDIATE l_query USING p_function_name, p_start_date, p_end_date, p_request_id;

    ELSIF (p_table_name = 'report_data_trend_week') THEN

        l_query := l_query || 'report_data_trend_week rdt, report_request_property rrp ' ||
                   'WHERE rdt.host_id = rh.host_id AND rdt.property_id = rp.property_id ' ||
                   'AND rdt.property_id = rrp.property_id ';

        l_query := l_query || l_mod_inst_join || l_prop_inst_join;

        l_query := l_query || 'AND trend_date >= :p_start_date AND trend_date <= :p_end_date ' ||
                              'AND rrp.request_id = :p_request_id';


        l_query := l_query || ' AND rdt.rec_id IN ' || '(SELECT rec_id FROM perf_temp_id)';

        l_query := l_query || ' GROUP BY rdt.property_id, rdt.module_instance, rdt.property_instance';

        l_query := l_query || ' ORDER BY avg_trend_value' ;

        if (p_sort_order = 2) THEN
            l_query := l_query || ' DESC';
        END IF;

        sp_print(l_query);

         EXECUTE IMMEDIATE l_query USING p_function_name, p_start_date, p_end_date, p_request_id;

     ELSE

        l_query := l_query || 'report_data_trend_month rdt, report_request_property rrp ' ||
                   'WHERE rdt.host_id = rh.host_id AND rdt.property_id = rp.property_id ' ||
                   'AND rdt.property_id = rrp.property_id ';

        l_query := l_query || l_mod_inst_join || l_prop_inst_join;

        l_query := l_query || 'AND trend_date >= :p_start_date AND trend_date <= :p_end_date ' ||
                              'AND rrp.request_id = :p_request_id';


        l_query := l_query || ' AND rdt.rec_id IN ' || '(SELECT rec_id FROM perf_temp_id)';

        l_query := l_query || ' GROUP BY rdt.property_id, rdt.module_instance, rdt.property_instance';

        l_query := l_query || ' ORDER BY avg_trend_value' ;

        if (p_sort_order = 2) THEN
            l_query := l_query || ' DESC';
        END IF;

        sp_print(l_query);

        EXECUTE IMMEDIATE l_query USING p_function_name, p_start_date, p_end_date, p_request_id;

     END IF;

    -- Now we have module instance, property id and property instance
    -- in the perf_temp_sorted table.
 
    -- Get the actual data.
    
    -- Reset the l_query

    l_query := 'SELECT rh.host_port,rp.module,rp.property,rdt.module_instance,' ||
               'rdt.property_instance,trend_date,' ||
               'DECODE(:p_function_name,' || '''AVG''' || ',trend_avg_value,' ||
                       '''MIN''' || ',trend_min_value,' ||
                      '''MAX''' || ',trend_max_value,trend_value) trend_value';

    l_query := l_query || ' FROM report_host rh, report_property rp, ';

    -- l_mod_inst_join and l_prop_inst_join are already set.
    -- rec_ids are already inserted in the perf_temp_id table.


    IF (p_table_name = 'report_data_trend_hour') THEN

        l_query := l_query || 'report_data_trend_hour rdt, report_request_property rrp ' ||
                   'WHERE rdt.host_id = rh.host_id AND rdt.property_id = rp.property_id ' ||
                   'AND rdt.property_id = rrp.property_id ';

        l_query := l_query || l_mod_inst_join || l_prop_inst_join;

        l_query := l_query || 'AND trend_date >= :p_start_date AND trend_date <= :p_end_date ' ||
                              'AND rrp.request_id = :p_request_id';

        l_query := l_query || ' AND rdt.rec_id IN ' || '(SELECT rec_id FROM perf_temp_id)';

        --- Now match the rows in the perf_temp_sorted table.

        l_query := l_query || ' AND rdt.property_id IN ' || '(SELECT property_id FROM perf_temp_sorted WHERE rownum <= :p_sorted_rows)';
       --  l_query := l_query || ' AND rdt.module_instance IN ' || '(SELECT module_instance FROM perf_temp_sorted WHERE rownum <= :p_sorted_rows)';
        l_query := l_query || ' AND rdt.property_instance IN ' || '(SELECT property_instance FROM perf_temp_sorted WHERE rownum <= :p_sorted_rows)';

        --- Order by host_port, trend_date, property as the data will include host_port as the
        --- first column in the resultset.

        l_query := l_query || ' ORDER BY rh.host_port, trend_date, rp.property' ;

        sp_print(l_query);

        OPEN p_pdata_cursor FOR l_query USING p_function_name, p_start_date, p_end_date, p_request_id, p_sorted_rows, p_sorted_rows;

    ELSIF (p_table_name = 'report_data_trend_day') THEN
        
        l_query := l_query || 'report_data_trend_day rdt, report_request_property rrp ' ||
                   'WHERE rdt.host_id = rh.host_id AND rdt.property_id = rp.property_id ' ||
                   'AND rdt.property_id = rrp.property_id ';

        l_query := l_query || l_mod_inst_join || l_prop_inst_join;

        l_query := l_query || 'AND trend_date >= :p_start_date AND trend_date <= :p_end_date ' ||
                              'AND rrp.request_id = :p_request_id';

        l_query := l_query || ' AND rdt.rec_id IN ' || '(SELECT rec_id FROM perf_temp_id)';

        l_query := l_query || ' AND rdt.property_id IN ' || '(SELECT property_id FROM perf_temp_sorted WHERE rownum <= :p_sorted_rows)';
        -- l_query := l_query || ' AND rdt.module_instance IN ' || '(SELECT module_instance FROM perf_temp_sorted WHERE rownum <= :p_sorted_rows)';
        l_query := l_query || ' AND rdt.property_instance IN ' || '(SELECT property_instance FROM perf_temp_sorted WHERE rownum <= :p_sorted_rows)';

        l_query := l_query || ' ORDER BY rh.host_port, trend_date, rp.property' ;

        sp_print(l_query);

        OPEN p_pdata_cursor FOR l_query USING p_function_name, p_start_date, p_end_date, p_request_id, p_sorted_rows, p_sorted_rows;

    ELSIF (p_table_name = 'report_data_trend_week') THEN

        l_query := l_query || 'report_data_trend_week rdt, report_request_property rrp ' ||
                   'WHERE rdt.host_id = rh.host_id AND rdt.property_id = rp.property_id ' ||
                   'AND rdt.property_id = rrp.property_id ';

        l_query := l_query || l_mod_inst_join || l_prop_inst_join;

        l_query := l_query || 'AND trend_date >= :p_start_date AND trend_date <= :p_end_date ' ||
                              'AND rrp.request_id = :p_request_id';


        l_query := l_query || ' AND rdt.rec_id IN ' || '(SELECT rec_id FROM perf_temp_id)';

        l_query := l_query || ' AND rdt.property_id IN ' || '(SELECT property_id FROM perf_temp_sorted WHERE rownum <= :p_sorted_rows)';
        -- l_query := l_query || ' AND rdt.module_instance IN ' || '(SELECT module_instance FROM perf_temp_sorted WHERE rownum <= :p_sorted_rows)';
        l_query := l_query || ' AND rdt.property_instance IN ' || '(SELECT property_instance FROM perf_temp_sorted WHERE rownum <= :p_sorted_rows)';

        l_query := l_query || ' ORDER BY rh.host_port, trend_date, rp.property' ;

        sp_print(l_query);

        OPEN p_pdata_cursor FOR l_query USING p_function_name, p_start_date, p_end_date, p_request_id, p_sorted_rows, p_sorted_rows;

     ELSE

        l_query := l_query || 'report_data_trend_month rdt, report_request_property rrp ' ||
                   'WHERE rdt.host_id = rh.host_id AND rdt.property_id = rp.property_id ' ||
                   'AND rdt.property_id = rrp.property_id ';

        l_query := l_query || l_mod_inst_join || l_prop_inst_join;

        l_query := l_query || 'AND trend_date >= :p_start_date AND trend_date <= :p_end_date ' ||
                              'AND rrp.request_id = :p_request_id';


        l_query := l_query || ' AND rdt.rec_id IN ' || '(SELECT rec_id FROM perf_temp_id)';

        l_query := l_query || ' AND rdt.property_id IN ' || '(SELECT property_id FROM perf_temp_sorted WHERE rownum <= :p_sorted_rows)';
        -- l_query := l_query || ' AND rdt.module_instance IN ' || '(SELECT module_instance FROM perf_temp_sorted WHERE rownum <= :p_sorted_rows)';
        l_query := l_query || ' AND rdt.property_instance IN ' || '(SELECT property_instance FROM perf_temp_sorted WHERE rownum <= :p_sorted_rows)';

        l_query := l_query || ' ORDER BY rh.host_port, trend_date, rp.property' ;

        sp_print(l_query);

        OPEN p_pdata_cursor FOR l_query USING p_function_name, p_start_date, p_end_date, p_request_id, p_sorted_rows, p_sorted_rows;

     END IF;


     EXCEPTION
         WHEN NO_DATA_FOUND THEN
              RAISE_APPLICATION_ERROR( -20001, 'ROW_NOT_FOUND' );
         WHEN OTHERS THEN
             RAISE_APPLICATION_ERROR( -20002, 'OTHERS : '  || SQLCODE);

END sp_get_sorted_perf_data;
/
SHOW ERRORS;

