--
--  @(#)create_report_tables.sql	1.24 05/03/22
--
--  Copyright (c) 03/22/05 Sun Microsystems, Inc. All Rights Reserved.
--
--
CREATE TABLE report_category
(   cat_id             NUMBER NOT NULL,
    cat_name           VARCHAR2(96) NOT NULL,
    cat_desc           VARCHAR2(768),
    system_defined     VARCHAR2(1),
    updated_by         VARCHAR2(32),
    timestamp          DATE,
    created_date       DATE
)
TABLESPACE report_data_s;

CREATE TABLE report_filter
(   filter_id          NUMBER NOT NULL,
    filter_name        VARCHAR2(96) NOT NULL,
    filter_desc        VARCHAR2(768),
    function_name      VARCHAR2(10),
    time_interval      NUMBER(3),
    start_date         DATE,
    end_date           DATE,
    updated_by         VARCHAR2(32),
    timestamp          DATE,
    created_date       DATE
)
TABLESPACE report_data_s;

CREATE TABLE report_host
(   host_id            NUMBER(5) NOT NULL,
    hostname           VARCHAR2(60),
    port               VARCHAR2(6),
    host_port          VARCHAR2(70),
    os                 VARCHAR2(20),
    ip_address         VARCHAR2(31),
    stop_collect       DATE,
    last_trend_date    DATE,
    collect_fail_date  DATE
)
TABLESPACE report_data_s;


CREATE TABLE report_lookup
(   attribute_name     VARCHAR2(30) NOT NULL,
    code               VARCHAR2(30) NOT NULL,
    seq_num            NUMBER(2) NOT NULL,
    value              VARCHAR2(200) NOT NULL
)
TABLESPACE report_data_s;

CREATE TABLE report_package
(   package_id         NUMBER NOT NULL,
    pkginst            VARCHAR2(60),
    pkgname            VARCHAR2(256),
    category           VARCHAR2(60),
    arch               VARCHAR2(30),
    version            VARCHAR2(80),
    vendor             VARCHAR2(80),
    pkg_desc           VARCHAR2(256)
)
TABLESPACE report_data_s;

CREATE TABLE report_patch
(   patch_id           VARCHAR2(60) NOT NULL,
    obsoletes          VARCHAR2(1024),
    requires           VARCHAR2(1024),
    incompatibles      VARCHAR2(1024)
)
TABLESPACE report_data_s;

CREATE TABLE report_table_admin
(   table_name         VARCHAR2(30) NOT NULL,
    table_alias        VARCHAR2(6),
    partition_size     NUMBER,
    age_limit          NUMBER,
    last_rollup_date   DATE
)
TABLESPACE report_data_s;

CREATE TABLE stage_hardware
(   hostname           VARCHAR2(60),
    port               VARCHAR2(6),
    hw_status          VARCHAR2(1),
    timestamp          DATE,
    hw_tab_name        VARCHAR2(30),
    row_index          VARCHAR2(128),
    row_value          VARCHAR2(4000)
)
TABLESPACE report_data_m;

CREATE TABLE stage_package
(   hostname           VARCHAR2(60),
    port               VARCHAR2(6),
    pkg_status         VARCHAR2(1),
    timestamp          DATE,
    pkginst            VARCHAR2(60),
    pkgname            VARCHAR2(256),
    category           VARCHAR2(60),
    arch               VARCHAR2(30),
    version            VARCHAR2(80),
    basedir            VARCHAR2(256),
    vendor             VARCHAR2(80),
    pkg_desc           VARCHAR2(256),
    instdate           VARCHAR2(60),
    status             VARCHAR2(60),
    num_blocks         VARCHAR2(512)
)
TABLESPACE report_data_m;

CREATE TABLE stage_patch
(   hostname           VARCHAR2(60),
    port               VARCHAR2(6),
    patch_status       VARCHAR2(1),
    timestamp          DATE,
    patch_id           VARCHAR2(60),
    obsoletes          VARCHAR2(1024),
    requires           VARCHAR2(1024),
    incompatibles      VARCHAR2(1024),
    packages           VARCHAR2(1024)
)
TABLESPACE report_data_m;

CREATE TABLE stage_uptime
(   hostname           VARCHAR2(60),
    port               VARCHAR2(6),
    trend_date         DATE,
    property           VARCHAR2(512),
    trend_value        NUMBER(38, 4),
    units              VARCHAR2(64),
    tz_offset          NUMBER(4)
)
TABLESPACE report_data_m;

CREATE TABLE stage_report_data_log_hour
(   hostname           VARCHAR2(60),
    port               VARCHAR2(6),
    module             VARCHAR2(256),
    module_instance    VARCHAR2(256),
    property           VARCHAR2(512),
    property_instance  VARCHAR2(256),
    units              VARCHAR2(30),
    date_created       DATE,
    trend_max_value    NUMBER(38, 4),
    trend_min_value    NUMBER(38, 4),
    trend_avg_value    NUMBER(38, 4),
    tz_offset          NUMBER(4)
)
TABLESPACE report_data_l;

CREATE TABLE report_direct_table_relation
(   relation_id        NUMBER(3) NOT NULL,
    first_table        VARCHAR2(30) NOT NULL,
    second_table       VARCHAR2(30) NOT NULL,
    join_flag          VARCHAR2(1),
    join_condition     VARCHAR2(200)
)
TABLESPACE report_data_s;

CREATE TABLE report_format
(   format_id          NUMBER NOT NULL,
    format_name        VARCHAR2(96) NOT NULL,
    format_desc        VARCHAR2(768),
    output_mode        VARCHAR2(30),
    data_focus         NUMBER(2),
    presentation_info  VARCHAR2(4000),
    updated_by         VARCHAR2(32),
    timestamp          DATE,
    created_date       DATE
)
TABLESPACE report_data_s;

CREATE TABLE report_hardware_title
(   hw_title_id        NUMBER(2) NOT NULL,
    hw_tab_name        VARCHAR2(30),
    hw_tab_title       VARCHAR2(200)
)
TABLESPACE report_data_s;

CREATE TABLE report_hardware
(   rec_id             NUMBER NOT NULL,
    host_id            NUMBER(5) NOT NULL,
    hw_title_id        NUMBER(2) NOT NULL,
    row_index          VARCHAR2(128) NOT NULL,
    start_date         DATE NOT NULL,
    row_value          VARCHAR2(4000),
    rec_status         VARCHAR2(1),
    end_date           DATE
)
TABLESPACE report_data_s;

CREATE TABLE report_system
(   rec_id             NUMBER NOT NULL,
    host_id            NUMBER(5) NOT NULL,
    start_date         DATE NOT NULL,
    os                 VARCHAR2(20),
    os_version         VARCHAR2(60),
    system_clock_frequency VARCHAR2(20),
    architecture       VARCHAR2(20),
    machine_type       VARCHAR2(30),
    platform           VARCHAR2(512),
    serial_number      VARCHAR2(30),
    total_disks        NUMBER,
    total_memory       VARCHAR2(30),
    total_processors   NUMBER,
    total_tape_devices NUMBER,
    end_date           DATE
)
TABLESPACE report_data_s;

CREATE TABLE report_host_package
(   rec_id             NUMBER NOT NULL,
    host_id            NUMBER(5) NOT NULL,
    package_id         NUMBER NOT NULL,
    instdate           VARCHAR2(60) NOT NULL,
    start_date         DATE,
    basedir            VARCHAR2(256),
    status             VARCHAR2(60),
    rec_status         VARCHAR2(1),
    num_blocks         VARCHAR2(512),
    end_date           DATE
)
TABLESPACE report_data_s;

CREATE TABLE report_host_patch
(   rec_id             NUMBER NOT NULL,
    host_id            NUMBER(5) NOT NULL,
    patch_id           VARCHAR2(60) NOT NULL,
    start_date         DATE NOT NULL,
    packages           VARCHAR2(1024),
    rec_status         VARCHAR2(1),
    end_date           DATE
)
TABLESPACE report_data_s;

CREATE TABLE report_ind_table_relation
(   relation_id        NUMBER(3) NOT NULL,
    seq_num            NUMBER(2) NOT NULL,
    linkage_table      VARCHAR2(30)
)
TABLESPACE report_data_s;

CREATE TABLE report_property
(   property_id        NUMBER(5) NOT NULL,
    property           VARCHAR2(512) NOT NULL,
    module             VARCHAR2(256),
    units              VARCHAR2(64),
    property_type      NUMBER(2),
    data_type          VARCHAR2(4),
    table_name         VARCHAR2(30),
    column_name        VARCHAR2(30),
    lov_available      VARCHAR2(1),
    filter_allowed     VARCHAR2(1),
    i18n_key           VARCHAR2(512),
    rollup_type        NUMBER(3)
)
TABLESPACE report_data_s;

CREATE TABLE report_subcategory
(   subcat_id          NUMBER NOT NULL,
    cat_id             NUMBER NOT NULL,
    subcat_name        VARCHAR2(96) NOT NULL,
    subcat_desc        VARCHAR2(768),
    system_defined     VARCHAR2(1),
    updated_by         VARCHAR2(32),
    timestamp          DATE,
    created_date       DATE
)
TABLESPACE report_data_s;

CREATE TABLE report_data_trend_day
(   rec_id             NUMBER NOT NULL,
    host_id            NUMBER(5) NOT NULL,
    property_id        NUMBER(5) NOT NULL,
    trend_date         DATE NOT NULL,
    trend_avg_value    NUMBER(38, 4),
    trend_max_value    NUMBER(38, 4),
    trend_min_value    NUMBER(38, 4),
    summarized         VARCHAR2(1) NOT NULL,
    property_instance  VARCHAR2(256),
    module_instance    VARCHAR2(256),
    tz_offset          NUMBER(4),
    avg_recs           NUMBER(38),
    trend_value        NUMBER(38,4)
)PARTITION BY RANGE(trend_date) (PARTITION p_max VALUES LESS THAN (MAXVALUE))
TABLESPACE report_data_m;

CREATE TABLE report_data_trend_hour
(   rec_id             NUMBER NOT NULL,
    host_id            NUMBER(5) NOT NULL,
    property_id        NUMBER(5) NOT NULL,
    trend_date         DATE NOT NULL,
    trend_avg_value    NUMBER(38, 4),
    trend_max_value    NUMBER(38, 4),
    trend_min_value    NUMBER(38, 4),
    summarized         VARCHAR2(1) NOT NULL,
    property_instance  VARCHAR2(256),
    module_instance    VARCHAR2(256),
    tz_offset          NUMBER(4),
    trend_value        NUMBER(38,4)
)PARTITION BY RANGE(trend_date) (PARTITION p_max VALUES LESS THAN (MAXVALUE))
TABLESPACE report_data_l;

CREATE TABLE report_data_trend_month
(   rec_id             NUMBER NOT NULL,
    host_id            NUMBER(5) NOT NULL,
    property_id        NUMBER(5) NOT NULL,
    trend_date         DATE NOT NULL,
    trend_avg_value    NUMBER(38, 4),
    trend_max_value    NUMBER(38, 4),
    trend_min_value    NUMBER(38, 4),
    summarized         VARCHAR2(1) NOT NULL,
    property_instance  VARCHAR2(256),
    module_instance    VARCHAR2(256),
    tz_offset          NUMBER(4),
    avg_recs           NUMBER(38),
    trend_value        NUMBER(38,4)
)PARTITION BY RANGE(trend_date) (PARTITION p_max VALUES LESS THAN (MAXVALUE))
TABLESPACE report_data_m;

CREATE TABLE report_data_trend_week
(   rec_id             NUMBER NOT NULL,
    host_id            NUMBER(5) NOT NULL,
    property_id        NUMBER(5) NOT NULL,
    trend_date         DATE NOT NULL,
    trend_avg_value    NUMBER(38, 4),
    trend_max_value    NUMBER(38, 4),
    trend_min_value    NUMBER(38, 4),
    summarized         VARCHAR2(1) NOT NULL,
    property_instance  VARCHAR2(256),
    module_instance    VARCHAR2(256),
    tz_offset          NUMBER(4),
    avg_recs           NUMBER(38),
    trend_value        NUMBER(38,4)
)PARTITION BY RANGE(trend_date) (PARTITION p_max VALUES LESS THAN (MAXVALUE))
TABLESPACE report_data_m;

CREATE TABLE report_filter_criteria
(   filter_id          NUMBER NOT NULL,
    seq_num            NUMBER(2) NOT NULL,
    property_id        NUMBER(5) NOT NULL,
    operator           VARCHAR2(10) NOT NULL,
    value              VARCHAR2(1024) NOT NULL,
    concat_oper        VARCHAR2(10)
)
TABLESPACE report_data_s;

CREATE TABLE report_request
(   request_id         NUMBER NOT NULL,
    request_name       VARCHAR2(96) NOT NULL,
    request_type       NUMBER(2) NOT NULL,
    cat_id             NUMBER NOT NULL,
    subcat_id          NUMBER,
    request_desc       VARCHAR2(768),
    system_defined     VARCHAR2(1) NOT NULL,
    request_level      NUMBER(1),
    request_window     NUMBER(1),
    scheduled          NUMBER(1) DEFAULT 0,
    ref_count          NUMBER(3),
    object_group_name  VARCHAR2(96),
    hostname_list      VARCHAR2(1000),
    filter_id          NUMBER,
    format_id          NUMBER,
    select_clause      VARCHAR2(2000),
    from_where_clause  VARCHAR2(2000),
    updated_by         VARCHAR2(32),
    timestamp          DATE,
    created_date       DATE
)
TABLESPACE report_data_s;

CREATE TABLE report_request_lnk
(   request_id         NUMBER NOT NULL,
    seq_num            NUMBER(5) NOT NULL,
    child_request_id   NUMBER NOT NULL
)
TABLESPACE report_data_s;

CREATE TABLE report_request_property
(   request_id         NUMBER NOT NULL,
    seq_num            NUMBER(5) NOT NULL,
    property_id        NUMBER(5) NOT NULL,
    property_instance  VARCHAR2(256),
    module_instance    VARCHAR2(256)
)
TABLESPACE report_data_s;

CREATE TABLE report_part_admin_log
(   log_name           VARCHAR2(30) NOT NULL,
    log_text           VARCHAR2(256) NOT NULL,
    date_created       DATE
)
TABLESPACE report_data_s;

CREATE TABLE report_rollup_admin_log
(   table_name       VARCHAR2(30)  NOT NULL,
    log_text         VARCHAR2(256) NOT NULL,
    date_created     DATE NOT NULL
)
TABLESPACE report_data_s;

CREATE GLOBAL TEMPORARY TABLE perf_temp_host 
(host_id NUMBER(5)) ON COMMIT DELETE ROWS;

CREATE GLOBAL TEMPORARY TABLE perf_temp_id 
(rec_id NUMBER) ON COMMIT DELETE ROWS;

CREATE GLOBAL TEMPORARY TABLE detail_temp_host 
(host_id NUMBER(5)) ON COMMIT DELETE ROWS;

CREATE GLOBAL TEMPORARY TABLE detail_temp_id 
(rec_id NUMBER) ON COMMIT DELETE ROWS;

CREATE GLOBAL TEMPORARY TABLE detail_temp_ip 
(ip_address VARCHAR2(31)) ON COMMIT DELETE ROWS;

CREATE GLOBAL TEMPORARY TABLE detail_temp_alarm 
(url varchar2(300)) ON COMMIT DELETE ROWS;

CREATE GLOBAL TEMPORARY TABLE summ_temp_host 
(host_id NUMBER(5)) ON COMMIT DELETE ROWS;

CREATE GLOBAL TEMPORARY TABLE summ_temp_id 
(rec_id NUMBER) ON COMMIT DELETE ROWS;

CREATE GLOBAL TEMPORARY TABLE hw_temp_host 
(host_id NUMBER(5)) ON COMMIT DELETE ROWS;

CREATE GLOBAL TEMPORARY TABLE hw_temp_id 
(rec_id NUMBER) ON COMMIT DELETE ROWS;

CREATE GLOBAL TEMPORARY TABLE summ_temp_events 
ON COMMIT DELETE ROWS
AS (SELECT * FROM EVENTS WHERE 1 = 2);

CREATE GLOBAL TEMPORARY TABLE host_temp_map
(seq_num NUMBER, host_port VARCHAR2(70)) ON COMMIT DELETE ROWS;

CREATE GLOBAL TEMPORARY TABLE perf_summ_temp_host 
(host_id NUMBER(5)) ON COMMIT DELETE ROWS;

CREATE GLOBAL TEMPORARY TABLE perf_temp_sorted
(property_id NUMBER(5), module_instance VARCHAR2(256),
 property_instance VARCHAR2(256), avg_trend_value NUMBER(38,4)) ON COMMIT DELETE ROWS;

