/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.common;

import com.sun.symon.base.server.snmp.SsDecodeException;
import com.sun.symon.base.server.snmp.SsEncodeException;
import com.sun.symon.base.server.snmp.SsMessage;
import com.sun.symon.base.server.snmp.v1.SsTrap;
import com.sun.symon.base.server.snmp.v2u.SsResponse;
import com.sun.symon.base.server.types.StSnmpOBJECT_IDENTIFIER;
import com.sun.symon.base.server.types.StSnmpOCTET_STRING;
import com.sun.symon.base.utility.UcBeanIntrospector;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcPeriodicException;
import com.sun.symon.base.utility.UcTickerTimer;
import com.sun.symon.base.utility.UcTickerTimerResponse;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public abstract class ScBaseTrapHandler {
    private static final int PACKET_SIZE = 65536;
    private static final int DEFAULT_TRAP_FREQ = 300;
    public static final int STATUS_TRAP = 0;
    public static final int REFRESH_TRAP = 1;
    public static final int WARMSTART_TRAP = 2;
    public static final int MIBRESTRUCTURE_TRAP = 3;
    public final String SERVER_CFG = "javaserver.properties";
    private static final int GENERIC = 1;
    private static final int SPECIFIC = 6;
    private static final int SPEC_STATUS = 1;
    private static final int SPEC_REFRESH = 2;
    private static final int SPEC_MIBRESTRUCTURE = 10;
    private DatagramSocket socket;
    private String trapHost = this.DEF_TRAP_HOST;
    private int trapPort = this.DEF_TRAP_PORT;
    private String trapCommunity = "public";
    private String trapEnterprise = "1.3.6.1.4.1.42.2.12.2";
    private int trapFreq = 300;
    private String DEF_TRAP_HOST = "localhost";
    private int DEF_TRAP_PORT = 162;
    private UcTickerTimer ticker;

    public ScBaseTrapHandler() {
        UcDDL.logDebugMessage((String)("ScBaseTrapHandler: " + this.trapHost + ":" + this.trapPort));
        UcBeanIntrospector ucBeanIntrospector = new UcBeanIntrospector();
        try {
            ucBeanIntrospector.readProperties("javaserver.properties");
            ucBeanIntrospector.apply((Object)this);
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)("ScBaseTrapHandler: " + exception.getMessage()));
        }
        this.init();
    }

    public String getTrapCommunity() {
        return this.trapCommunity;
    }

    public String getTrapEnterprise() {
        return this.trapEnterprise;
    }

    public int getTrapFreq() {
        return this.trapFreq;
    }

    public String getTrapHost() {
        return this.trapHost;
    }

    public int getTrapPort() {
        return this.trapPort;
    }

    public void setTrapCommunity(String string) {
        this.trapCommunity = string;
    }

    public void setTrapEnterprise(String string) {
        this.trapEnterprise = string;
    }

    public void setTrapFreq(int n) {
        if (n <= 0) {
            UcDDL.logErrorMessage((String)("Invalid trap freq: " + n));
            this.trapFreq = 300;
        } else {
            this.trapFreq = n;
        }
    }

    public void setTrapHost(String string) {
        this.trapHost = this.trapHost;
        if (this.trapPort != -1) {
            try {
                String string2 = InetAddress.getByName(this.trapHost).getHostAddress();
                UcDDL.logInfoMessage((String)("trap handler host and port = " + this.trapHost + " (" + string2 + ") port " + this.trapPort));
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    public void setTrapPort(int n) {
        this.trapPort = n;
        if (this.trapHost != null) {
            try {
                String string = InetAddress.getByName(this.trapHost).getHostAddress();
                UcDDL.logInfoMessage((String)("trap handler host and port = " + this.trapHost + " (" + string + ") port " + this.trapPort));
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    public abstract void handleTrap(int var1, String var2, String var3, String var4);

    private void handleV1Trap(SsTrap ssTrap) {
        int n = ssTrap.getGenericTrap();
        int n2 = ssTrap.getSpecificTrap();
        String string = ssTrap.getAgentAddress();
        String string2 = ssTrap.getContextName();
        int n3 = 0;
        StSnmpOBJECT_IDENTIFIER stSnmpOBJECT_IDENTIFIER = null;
        UcDDL.logDebugMessage((String)("V1: Generic=" + n + ", Specific=" + n2 + ", ip=" + string + ", context=" + string2));
        if (n == 6 && (n2 == 1 || n2 == 2 || n2 == 10)) {
            if (n2 == 1) {
                UcDDL.logDebugMessage((String)"process status trap");
                stSnmpOBJECT_IDENTIFIER = (StSnmpOBJECT_IDENTIFIER)ssTrap.getVariable(this.trapEnterprise + ".1.3.1.0");
                if (stSnmpOBJECT_IDENTIFIER == null) {
                    UcDDL.logErrorMessage((String)"can't find status oid");
                    return;
                }
            } else if (n2 == 10) {
                n3 = 3;
            } else {
                UcDDL.logDebugMessage((String)"process refresh trap");
                n3 = 1;
                stSnmpOBJECT_IDENTIFIER = (StSnmpOBJECT_IDENTIFIER)ssTrap.getVariable(this.trapEnterprise + ".1.3.2.0");
                if (stSnmpOBJECT_IDENTIFIER == null) {
                    UcDDL.logErrorMessage((String)"can't find refresh oid");
                    return;
                }
            }
        } else if (n == 1) {
            UcDDL.logDebugMessage((String)"process warm start trap");
            n3 = 2;
        } else {
            return;
        }
        String string3 = null;
        if (stSnmpOBJECT_IDENTIFIER != null) {
            string3 = stSnmpOBJECT_IDENTIFIER.toString();
        }
        UcDDL.logDebugMessage((String)("V1: trapType:" + n3 + ", " + string3));
        this.handleTrap(n3, string, string2, string3);
    }

    private void handleV2Trap(SsMessage ssMessage) {
        StSnmpOCTET_STRING stSnmpOCTET_STRING;
        String string = ssMessage.getContextName();
        StSnmpOBJECT_IDENTIFIER stSnmpOBJECT_IDENTIFIER = (StSnmpOBJECT_IDENTIFIER)ssMessage.getVariable("1.3.6.1.6.3.1.1.4.1.0");
        UcDDL.logDebugMessage((String)("V2: value=" + stSnmpOBJECT_IDENTIFIER));
        int n = 0;
        if (stSnmpOBJECT_IDENTIFIER == null) {
            UcDDL.logErrorMessage((String)"can't find trap type");
            return;
        }
        if (stSnmpOBJECT_IDENTIFIER.toString().compareTo(this.trapEnterprise + ".0.1") == 0) {
            UcDDL.logDebugMessage((String)"process status trap");
            stSnmpOBJECT_IDENTIFIER = (StSnmpOBJECT_IDENTIFIER)ssMessage.getVariable(this.trapEnterprise + ".1.3.1.0");
            if (stSnmpOBJECT_IDENTIFIER == null) {
                UcDDL.logErrorMessage((String)"can't find status oid");
                return;
            }
        } else if (stSnmpOBJECT_IDENTIFIER.toString().compareTo(this.trapEnterprise + ".0.10") == 0) {
            UcDDL.logDebugMessage((String)"process mib restructure trap");
            n = 3;
        } else if (stSnmpOBJECT_IDENTIFIER.toString().compareTo(this.trapEnterprise + ".0.2") == 0) {
            UcDDL.logDebugMessage((String)"process refresh trap");
            n = 1;
            stSnmpOBJECT_IDENTIFIER = (StSnmpOBJECT_IDENTIFIER)ssMessage.getVariable(this.trapEnterprise + ".1.3.2.0");
            if (stSnmpOBJECT_IDENTIFIER == null) {
                UcDDL.logErrorMessage((String)"can't find refresh oid");
                return;
            }
        } else if (stSnmpOBJECT_IDENTIFIER.toString().compareTo("1.3.6.1.6.3.1.1.5.2") == 0) {
            UcDDL.logDebugMessage((String)"process warm start trap");
            n = 2;
        } else {
            return;
        }
        if ((stSnmpOCTET_STRING = (StSnmpOCTET_STRING)ssMessage.getVariable("1.3.6.1.6.3.1.1.4.6.0")) == null) {
            UcDDL.logErrorMessage((String)"can't find trap address");
            return;
        }
        String string2 = stSnmpOCTET_STRING.toString();
        String string3 = "" + (0xFF & string2.charAt(0)) + "." + (0xFF & string2.charAt(1)) + "." + (0xFF & string2.charAt(2)) + "." + (0xFF & string2.charAt(3));
        String string4 = null;
        if (stSnmpOBJECT_IDENTIFIER != null) {
            string4 = stSnmpOBJECT_IDENTIFIER.toString();
        }
        this.handleTrap(n, string3, string, string4);
    }

    private void init() {
        try {
            this.ticker = new UcTickerTimer((long)this.trapFreq, new UcTickerTimerResponse(){

                public void processTick() {
                    ScBaseTrapHandler.this.sendTrap();
                }

                public void processTickEnd() {
                }
            });
        }
        catch (UcPeriodicException ucPeriodicException) {
            // empty catch block
        }
        try {
            this.socket = new DatagramSocket();
        }
        catch (SocketException socketException) {
            UcDDL.logErrorMessage((String)"socket creation failed", (Throwable)socketException);
            return;
        }
        Thread thread = new Thread("Trap UDP Reader"){

            public void run() {
                ScBaseTrapHandler.this.readTraps();
            }
        };
        thread.setPriority(10);
        thread.start();
        this.sendTrap();
        this.ticker.start();
    }

    private void readTraps() {
        byte[] byArray = new byte[65536];
        while (true) {
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            try {
                this.socket.receive(datagramPacket);
            }
            catch (IOException iOException) {
                UcDDL.logErrorMessage((String)"receive() failed", (Throwable)iOException);
                return;
            }
            this.readTrapProcess(byArray, datagramPacket.getLength(), datagramPacket.getAddress(), datagramPacket.getPort());
        }
    }

    private void readTrapProcess(byte[] byArray, int n, InetAddress inetAddress, int n2) {
        UcDDL.logDebugMessage((String)("readTrapProcess: " + n + " port=" + n2));
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        SsMessage ssMessage = null;
        try {
            ssMessage = SsMessage.toMessage((byte[])byArray2);
        }
        catch (SsDecodeException ssDecodeException) {
            UcDDL.logErrorMessage((String)"Invalid snmp packet received", (Throwable)ssDecodeException);
            return;
        }
        if (ssMessage.getVersion() == 1 && ssMessage.getType() == 4) {
            this.handleV1Trap((SsTrap)ssMessage);
        } else if (ssMessage.getVersion() == 2 && ssMessage.getType() == 3 || ssMessage.getVersion() == 3 && ssMessage.getType() == 3) {
            this.handleV2Trap(ssMessage);
        } else if (ssMessage.getVersion() == 2 && ssMessage.getType() == 4 || ssMessage.getVersion() == 3 && ssMessage.getType() == 4) {
            this.confirmInform(ssMessage, inetAddress, n2);
            this.handleV2Trap(ssMessage);
        } else {
            UcDDL.logErrorMessage((String)"wrong type of snmp packet received");
        }
    }

    private SsMessage makeConfirmation(SsMessage ssMessage) throws SsEncodeException {
        com.sun.symon.base.server.snmp.v2.SsResponse ssResponse;
        switch (ssMessage.getVersion()) {
            case 2: {
                ssResponse = new com.sun.symon.base.server.snmp.v2.SsResponse();
                break;
            }
            case 3: {
                ssResponse = new SsResponse();
                break;
            }
            default: {
                throw new SsEncodeException("Invalid request version");
            }
        }
        ssResponse.setState(ssMessage.getState());
        ssResponse.setContextName(ssMessage.getContextName());
        ssResponse.setSecurityName(ssMessage.getSecurityName());
        ssResponse.setSecurityLevel(ssMessage.getSecurityLevel());
        ssResponse.setSecurityModel(ssMessage.getSecurityModel());
        ssResponse.setSendId(ssMessage.getSendId());
        ssResponse.setRequestId(ssMessage.getRequestId());
        ssResponse.setVariableNames(ssMessage.getVariableNames());
        ssResponse.setVariableValues(ssMessage.getVariableTypes(), ssMessage.getVariableValues());
        return ssResponse;
    }

    private void confirmInform(SsMessage ssMessage, InetAddress inetAddress, int n) {
        byte[] byArray;
        try {
            byArray = this.makeConfirmation(ssMessage).toBytestream();
        }
        catch (SsEncodeException ssEncodeException) {
            UcDDL.logErrorMessage((String)"invalid packet", (Throwable)ssEncodeException);
            return;
        }
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n);
        try {
            this.socket.send(datagramPacket);
            UcDDL.logDebugMessage((String)("response sent to " + inetAddress + ":" + n));
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"send() failed", (Throwable)exception);
        }
    }

    private void sendTrap() {
        SsTrap ssTrap = new SsTrap();
        ssTrap.setSecurityName(this.trapCommunity);
        ssTrap.setEnterprise(this.trapEnterprise);
        try {
            ssTrap.setAgentAddress(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            UcDDL.logErrorMessage((String)"can't get local host address", (Throwable)unknownHostException);
            return;
        }
        ssTrap.setGenericTrap(6);
        ssTrap.setSpecificTrap(7);
        DatagramPacket datagramPacket = null;
        try {
            byte[] byArray = ssTrap.toBytestreamAndDump();
            datagramPacket = new DatagramPacket(byArray, byArray.length, InetAddress.getByName(this.trapHost), this.trapPort);
        }
        catch (UnknownHostException unknownHostException) {
            UcDDL.logErrorMessage((String)("invalid host: '" + this.trapHost + "'"), (Throwable)unknownHostException);
            return;
        }
        catch (SsEncodeException ssEncodeException) {
            UcDDL.logErrorMessage((String)"invalid packet", (Throwable)ssEncodeException);
            return;
        }
        try {
            this.socket.send(datagramPacket);
            UcDDL.logDebugMessage((String)("trap sent to " + this.trapHost + ":" + this.trapPort));
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"send() failed", (Throwable)exception);
        }
    }
}

