/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.util;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.report.SMReportCompositeRequest;
import com.sun.symon.base.client.report.SMReportData;
import com.sun.symon.base.client.report.SMReportRequest;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.client.service.SMDuplicateException;
import com.sun.symon.base.client.service.SMNoSuchObjectException;
import com.sun.symon.base.client.service.SMSecurityException;
import com.sun.symon.base.client.service.SMStaleDataException;
import com.sun.symon.base.client.util.CrReportHandle;
import com.sun.symon.base.client.util.CrReportRequestParser;
import com.sun.symon.base.client.util.CrReportUtil;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.report.MrReportServiceImpl;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Component;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Locale;

public class CrServerReportHandle
extends CrReportHandle {
    private static final String SECURITY_EXCEPTION = "Operation Not Permitted";
    private static final String DATABASE_EXCEPTION = "Database Exception";
    private static final String NOSUCHOBJECT_EXCEPTION = "Record Not Found";
    private static final String DUPLICATEDATA_EXCEPTION = "Data Duplicate In Database";
    private static final String STALEDATA_EXCEPTION = "Database Stale Error";
    private static final String SECURITY_EXCEPTION_KEY = "com.sun.symon.base.client.report.ReportMessages:securityException";
    private static final String DATABASE_EXCEPTION_KEY = "com.sun.symon.base.client.report.ReportMessages:databaseException";
    private static final String NOSUCHOBJECT_EXCEPTION_KEY = "com.sun.symon.base.client.report.ReportMessages:database.rowNotFound";
    private static final String DUPLICATEDATA_EXCEPTION_KEY = "com.sun.symon.base.client.report.ReportMessages:database.duplicateIndex";
    private static final String STALEDATA_EXCEPTION_KEY = "com.sun.symon.base.client.report.ReportMessages:database.stale";
    boolean initialized = false;
    MrReportServiceImpl reportHandle = null;
    private static CrServerReportHandle instance = new CrServerReportHandle();
    private MSLogPrintWriter logWriter;

    public void init(MrReportServiceImpl mrReportServiceImpl) {
        if (this.initialized) {
            return;
        }
        CrServerReportHandle crServerReportHandle = this;
        synchronized (crServerReportHandle) {
            this.initialized = true;
            this.reportHandle = mrReportServiceImpl;
        }
    }

    public static CrReportHandle getInstance() {
        return instance;
    }

    public SMReportRequest getReportRequest(SMDBObjectID sMDBObjectID) throws SMAPIException, SMNoSuchObjectException, SMSecurityException, SMDatabaseException {
        try {
            return this.reportHandle.getReportRequest(sMDBObjectID);
        }
        catch (Exception exception) {
            this.handleException(exception);
            return null;
        }
    }

    public SMReportCompositeRequest getCompositeRequest(SMDBObjectID sMDBObjectID) throws SMAPIException, SMNoSuchObjectException, SMSecurityException, SMDatabaseException {
        try {
            return this.reportHandle.getCompositeRequest(sMDBObjectID);
        }
        catch (Exception exception) {
            this.handleException(exception);
            return null;
        }
    }

    public SMReportData getReportData(SMDBObjectID sMDBObjectID) throws SMAPIException, IllegalArgumentException, UnknownHostException, SMSecurityException, SMDatabaseException {
        SMReportRequest sMReportRequest = this.getReportRequest(sMDBObjectID);
        CrReportRequestParser crReportRequestParser = new CrReportRequestParser(sMReportRequest);
        Date date = crReportRequestParser.getStartDate();
        Date date2 = crReportRequestParser.getEndDate();
        try {
            return this.reportHandle.runReportRequest(sMDBObjectID, 0, null, date, date2, null, null, 0);
        }
        catch (Exception exception) {
            this.handleException(exception);
            return null;
        }
    }

    public SMReportData getReportData(SMDBObjectID sMDBObjectID, String[] stringArray) throws SMAPIException, IllegalArgumentException, UnknownHostException, SMSecurityException, SMDatabaseException {
        SMReportRequest sMReportRequest = this.getReportRequest(sMDBObjectID);
        CrReportRequestParser crReportRequestParser = new CrReportRequestParser(sMReportRequest);
        Date date = crReportRequestParser.getStartDate();
        Date date2 = crReportRequestParser.getEndDate();
        try {
            return this.reportHandle.runReportRequest(sMDBObjectID, 0, stringArray, date, date2, null, null, 0);
        }
        catch (Exception exception) {
            this.handleException(exception);
            return null;
        }
    }

    public SMReportData getReportData(SMDBObjectID sMDBObjectID, String[] stringArray, int n) throws SMAPIException, IllegalArgumentException, UnknownHostException, SMSecurityException, SMDatabaseException {
        SMReportRequest sMReportRequest = this.getReportRequest(sMDBObjectID);
        CrReportRequestParser crReportRequestParser = new CrReportRequestParser(sMReportRequest);
        Date date = crReportRequestParser.getStartDate();
        Date date2 = crReportRequestParser.getEndDate();
        try {
            return this.reportHandle.runReportRequest(sMDBObjectID, 0, stringArray, date, date2, null, null, 0);
        }
        catch (Exception exception) {
            this.handleException(exception);
            return null;
        }
    }

    public SMReportData getPageData(int n, int n2, int n3, String string, int n4) throws SMAPIException, IllegalArgumentException, SMSecurityException, SMDatabaseException {
        try {
            return this.reportHandle.getPageData(n, n2, n3, string, n4);
        }
        catch (Exception exception) {
            this.handleException(exception);
            return null;
        }
    }

    public String createReportDir(String string) throws SMAPIException, SMSecurityException, IllegalArgumentException {
        try {
            return this.reportHandle.createReportDir(string);
        }
        catch (Exception exception) {
            this.handleException(exception);
            return null;
        }
    }

    public void changeReportDirOwner(String string) throws SMAPIException, SMSecurityException, IllegalArgumentException {
        try {
            this.reportHandle.changeReportDirOwner(string);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public void postFile(byte[] byArray, byte[] byArray2, byte[] byArray3) throws SMAPIException, SMSecurityException, IllegalArgumentException {
        try {
            this.reportHandle.postFile(byArray, byArray2, byArray3);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public void handleException(Exception exception) throws SMAPIException {
        String string = null;
        if (exception instanceof SMAPIException) {
            throw (SMAPIException)((Object)exception);
        }
        if (exception instanceof RemoteException) {
            throw new SMAPIException((Throwable)exception);
        }
        if (exception instanceof SMSecurityException) {
            string = this.translateKey(SECURITY_EXCEPTION_KEY, SECURITY_EXCEPTION);
            throw new SMSecurityException(string, (Throwable)exception);
        }
        if (exception instanceof SMNoSuchObjectException) {
            string = this.translateKey(NOSUCHOBJECT_EXCEPTION_KEY, NOSUCHOBJECT_EXCEPTION);
            throw new SMNoSuchObjectException(string, (Throwable)exception);
        }
        if (exception instanceof SMDuplicateException) {
            string = this.translateKey(DUPLICATEDATA_EXCEPTION_KEY, DUPLICATEDATA_EXCEPTION);
            throw new SMDuplicateException(string, (Throwable)exception);
        }
        if (exception instanceof SMStaleDataException) {
            string = this.translateKey(STALEDATA_EXCEPTION_KEY, STALEDATA_EXCEPTION);
            throw new SMStaleDataException(string, (Throwable)exception);
        }
        if (exception instanceof SMDatabaseException) {
            string = this.translateKey(DATABASE_EXCEPTION_KEY, DATABASE_EXCEPTION);
            throw new SMDatabaseException(string, (Throwable)exception);
        }
        throw new SMAPIException((Throwable)exception);
    }

    private String translateKey(String string, String string2) {
        return UcInternationalizer.translateKey((Locale)Locale.getDefault(), (String)string, (String)string2);
    }

    public void handleAPIException(Exception exception, Component component) {
        String string = "";
        string = exception instanceof SMSecurityException ? CrReportUtil.getI18nMsg((String)"standard.noRight") + "\n" + exception.getMessage() : (exception instanceof SMNoSuchObjectException ? CrReportUtil.getI18nMsg((String)"standard.noObjectErr") + "\n" + exception.getMessage() : (exception instanceof SMDatabaseException ? CrReportUtil.getI18nMsg((String)"standard.dbError") + "\n" + exception.getMessage() : (exception instanceof IllegalArgumentException ? CrReportUtil.getI18nMsg((String)"standard.arguError") + "\n" + exception.getMessage() : exception.getMessage())));
        if (this.logWriter != null) {
            this.logWriter.println(string);
        }
    }

    public void showError(String string) {
        if (this.logWriter != null) {
            this.logWriter.println(string);
        }
    }

    public void showReportPostCofirm(String string) {
        if (this.logWriter != null) {
            this.logWriter.println(string);
        }
    }

    public String getEsdir() {
        String string = System.getProperty("ESDIR", "/var/opt/SUNWsymon/");
        return string;
    }

    public void setLogWriter(MSLogPrintWriter mSLogPrintWriter) {
        this.logWriter = mSLogPrintWriter;
    }

    public boolean isServerSideGeneration() {
        return true;
    }

    public Date getCurrentServerDate() {
        return new Date();
    }
}

