/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.util;

import com.sun.symon.base.client.common.CrCSVController;
import com.sun.symon.base.client.common.CrCompositeController;
import com.sun.symon.base.client.common.CrDeployComponents;
import com.sun.symon.base.client.common.CrGraphController;
import com.sun.symon.base.client.common.CrOutputController;
import com.sun.symon.base.client.common.CrTableController;
import com.sun.symon.base.client.htmlConvertor.CrHtmlGenerator;
import com.sun.symon.base.client.report.SMReportComponent;
import com.sun.symon.base.client.report.SMReportCompositeRequest;
import com.sun.symon.base.client.report.SMReportFormat;
import com.sun.symon.base.client.report.SMReportRequest;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.util.CrReportHandle;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.report.MrReportServiceImpl;
import com.sun.symon.base.mgmtservice.util.CrServerReportHandle;
import java.util.Vector;

public class CrScheduledRequestBroker {
    CrOutputController controller = null;
    SMReportComponent request = null;
    CrReportHandle reportHandle;
    SMDBObjectID requestID;
    boolean success = false;
    MSLogPrintWriter logWriter;

    public CrScheduledRequestBroker(SMDBObjectID sMDBObjectID, MrReportServiceImpl mrReportServiceImpl, MSLogPrintWriter mSLogPrintWriter) throws Exception {
        try {
            this.requestID = sMDBObjectID;
            this.logWriter = mSLogPrintWriter;
            this.reportHandle = CrServerReportHandle.getInstance();
            ((CrServerReportHandle)this.reportHandle).init(mrReportServiceImpl);
            ((CrServerReportHandle)this.reportHandle).setLogWriter(mSLogPrintWriter);
            this.execAction();
        }
        catch (Exception exception) {
            if (mSLogPrintWriter != null) {
                mSLogPrintWriter.println(exception.getMessage());
            }
            exception.printStackTrace();
        }
        if (!this.success) {
            String string = "Report request generation failed.";
            if (this.request != null) {
                String string2 = this.request.getName();
                string = string2 + ": " + string;
            }
            throw new Exception(string);
        }
    }

    private void execAction() throws Exception {
        this.request = this.reportHandle.getReportRequest(this.requestID);
        if (((SMReportRequest)this.request).getReportType() == 6) {
            this.request = this.reportHandle.getCompositeRequest(this.requestID);
        }
        if (this.request instanceof SMReportRequest) {
            SMReportFormat sMReportFormat = ((SMReportRequest)this.request).getTemplate().getFormat();
            String string = sMReportFormat.getOutputFormat();
            if (string.equals("LINE_GRAPH") || string.equals("BAR_CHART") || string.equals("STACK_BAR_CHART") || string.equals("AREA_CHART") || string.equals("STACK_AREA_CHART") || string.equals("PIE_CHART")) {
                CrGraphController crGraphController = new CrGraphController((SMReportRequest)this.request, this.reportHandle);
                this.controller = crGraphController;
                Object[] objectArray = this.controller.getComponents();
                if (objectArray != null) {
                    new CrDeployComponents(crGraphController, CrHtmlGenerator.DEPLOY_HTML);
                    this.success = true;
                }
            } else if (string.equals("TABULAR")) {
                CrTableController crTableController = new CrTableController((SMReportRequest)this.request, this.reportHandle);
                this.controller = crTableController;
                if (this.controller.getComponents() != null) {
                    int n = this.controller.getDataModel().length;
                    int n2 = 0;
                    while (n2 < this.controller.getDataModel().length) {
                        crTableController.setNumberOfPages(1, n2);
                        ++n2;
                    }
                    new CrDeployComponents(crTableController, CrHtmlGenerator.DEPLOY_HTML);
                    this.success = true;
                }
            } else if (string.equals("TEXT_COMMA") || string.equals("TEXT_TAB")) {
                CrCSVController crCSVController = new CrCSVController((SMReportRequest)this.request, this.reportHandle);
                this.controller = crCSVController;
                if (this.controller.getComponents() != null) {
                    String[] stringArray = (String[])this.controller.getComponents();
                    new CrDeployComponents(crCSVController, CrHtmlGenerator.DEPLOY_HTML);
                    this.success = true;
                }
            }
        } else if (this.request instanceof SMReportCompositeRequest) {
            CrCompositeController crCompositeController = new CrCompositeController((SMReportCompositeRequest)this.request, this.reportHandle);
            this.controller = crCompositeController;
            Object[] objectArray = this.controller.getComponents();
            if (objectArray != null) {
                Vector vector = crCompositeController.getControllerList();
                int n = 0;
                while (n < vector.size()) {
                    if (vector.elementAt(n) instanceof CrTableController) {
                        ((CrTableController)vector.elementAt(n)).setNumberOfPages(1, 0);
                    }
                    ++n;
                }
                new CrDeployComponents(crCompositeController, CrHtmlGenerator.DEPLOY_HTML);
                this.success = true;
            }
        }
    }
}

