/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.report;

import com.sun.symon.base.client.report.SMReferenceExistsException;
import com.sun.symon.base.client.report.SMReportCategory;
import com.sun.symon.base.client.report.SMReportCompositeRequest;
import com.sun.symon.base.client.report.SMReportEvent;
import com.sun.symon.base.client.report.SMReportFilter;
import com.sun.symon.base.client.report.SMReportFormat;
import com.sun.symon.base.client.report.SMReportGraphPresentation;
import com.sun.symon.base.client.report.SMReportHost;
import com.sun.symon.base.client.report.SMReportProperty;
import com.sun.symon.base.client.report.SMReportPropertyGroup;
import com.sun.symon.base.client.report.SMReportRequest;
import com.sun.symon.base.client.report.SMReportRequestInfo;
import com.sun.symon.base.client.report.SMReportSubCategory;
import com.sun.symon.base.client.report.SMReportTemplate;
import com.sun.symon.base.client.service.SMDBChangeEvent;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.client.service.SMDuplicateException;
import com.sun.symon.base.client.service.SMLengthException;
import com.sun.symon.base.client.service.SMNoSuchObjectException;
import com.sun.symon.base.client.service.SMStaleDataException;
import com.sun.symon.base.mgmtservice.collect.McCfgData;
import com.sun.symon.base.mgmtservice.collect.McCollectService;
import com.sun.symon.base.mgmtservice.common.MSDB;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.common.MSReportHostAddrMapper;
import com.sun.symon.base.mgmtservice.report.MrReportServiceImpl;
import com.sun.symon.base.mgmtservice.report.MrReportStoredProcedures;
import com.sun.symon.base.mgmtservice.report.MrReportTools;
import com.sun.symon.base.server.common.ScSecurityCredential;
import java.net.UnknownHostException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.jdbc.driver.OracleResultSet;

public class MrReportTemplateController
implements MrReportStoredProcedures {
    private MSLogPrintWriter errorLogWriter = MSLogPrintWriter.getErrorWriter();
    private MSLogPrintWriter warningLogWriter = MSLogPrintWriter.getWarningWriter();
    private MSLogPrintWriter infoLogWriter = MSLogPrintWriter.getInfoWriter();
    private MSLogPrintWriter debugLogWriter = MSLogPrintWriter.getDebugWriter();
    private MrReportServiceImpl service = null;
    private McCfgData advHWCfgData = null;
    private static String REFERENCES_EXIST = "REFERENCES_EXIST";
    private static String i18nBase_ = "com.sun.symon.base.client.ReportServiceClientApiMessages";

    public MrReportTemplateController(MrReportServiceImpl mrReportServiceImpl) {
        this.service = mrReportServiceImpl;
    }

    public void finalize() throws Throwable {
        this.debugLogWriter.println("MrReportDataController: finalize Called for TemplateController");
        this.errorLogWriter = null;
        this.warningLogWriter = null;
        this.infoLogWriter = null;
        this.debugLogWriter = null;
        this.service = null;
        this.advHWCfgData = null;
    }

    public synchronized McCfgData getCfgData() {
        if (this.advHWCfgData == null) {
            try {
                McCollectService mcCollectService = McCollectService.getInstance();
                this.advHWCfgData = mcCollectService.getCfgData("HARDWARE");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.advHWCfgData;
    }

    public String getPropertyI18nKey(String string, String string2) {
        if (string == null) {
            this.debugLogWriter.println("MrReportTemplateController: table name is null");
            return null;
        }
        if (string2 == null) {
            this.debugLogWriter.println("MrReportTemplateController: property name is null");
            return null;
        }
        this.getCfgData();
        if (this.advHWCfgData == null) {
            this.debugLogWriter.println("MrReportTemplateController: Some problem in geting cfgdata");
            return null;
        }
        String[] stringArray = this.advHWCfgData.getProperties(string);
        String[] stringArray2 = this.advHWCfgData.getPropI18nKeys(string);
        if (stringArray == null || stringArray2 == null) {
            this.debugLogWriter.println("MrReportTemplateController: property name or property key not found in cfgdata");
            return null;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (string2.equals(stringArray[n])) {
                return stringArray2[n];
            }
            ++n;
        }
        this.debugLogWriter.println("MrReportTemplateController: property name not found in cfgdata");
        return null;
    }

    public String getTableI18nKey(String string) {
        if (string == null) {
            this.debugLogWriter.println("MrReportTemplateController: Table name is null");
            return null;
        }
        this.getCfgData();
        if (this.advHWCfgData == null) {
            this.debugLogWriter.println("MrReportTemplateController: Some problem in geting cfgdata");
            return null;
        }
        String[] stringArray = this.advHWCfgData.getTableNames();
        String[] stringArray2 = this.advHWCfgData.getTableNameI18nKeys();
        if (stringArray == null || stringArray2 == null) {
            this.debugLogWriter.println("MrReportTemplateController: table name or table key not found in cfgdata");
            return null;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return stringArray2[n];
            }
            ++n;
        }
        this.debugLogWriter.println("MrReportTemplateController: Table name not found in cfgdata");
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SMReportCategory[] getAllCategory() throws SMDatabaseException, SMNoSuchObjectException {
        Object[] objectArray;
        this.debugLogWriter.println("MrReportTemplateController: Inside method getAllCategory");
        Connection connection = MSDB.getConnection();
        Vector<SMReportCategory> vector = new Vector<SMReportCategory>();
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection.prepareCall("{call sp_get_all_categories(?)}");
                callableStatement.registerOutParameter(1, -10);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(1);
                while (true) {
                    if (!oracleResultSet.next()) {
                        Object[] objectArray2 = new SMReportCategory[vector.size()];
                        vector.copyInto(objectArray2);
                        objectArray = objectArray2;
                        Object var9_13 = null;
                        break;
                    }
                    SMReportCategory sMReportCategory = new SMReportCategory(oracleResultSet.getString("cat_name"), oracleResultSet.getString("cat_desc"), new SMDBObjectID(oracleResultSet.getLong("cat_id"), "report_category"));
                    sMReportCategory.setDefinedBy(oracleResultSet.getString("system_defined"));
                    sMReportCategory.setUpdatedBy(oracleResultSet.getString("updated_by"));
                    sMReportCategory.setUpdateTime(oracleResultSet.getTimestamp("timestamp"));
                    sMReportCategory.setCreateTime(oracleResultSet.getTimestamp("created_date"));
                    sMReportCategory.setChanged(false);
                    vector.addElement(sMReportCategory);
                }
            }
            catch (SMLengthException sMLengthException) {
                this.debugLogWriter.println("MrReportTemplateController: got SMLengthException exception");
                SMReportCategory[] sMReportCategoryArray = null;
                Object var9_14 = null;
                MrReportTools.close(callableStatement);
                MSDB.closeConnection((Connection)connection);
                return sMReportCategoryArray;
            }
            catch (SQLException sQLException) {
                this.debugLogWriter.println("MrReportTemplateController: got SQLException exception");
                if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                    throw sMNoSuchObjectException;
                }
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MrReportTools.close(callableStatement);
        MSDB.closeConnection((Connection)connection);
        return objectArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SMReportSubCategory[] getAllSubCategory(SMReportCategory sMReportCategory) throws SMDatabaseException, SMNoSuchObjectException {
        Object[] objectArray;
        this.debugLogWriter.println("MrReportTemplateController: Inside method getAllSubCategory");
        Connection connection = MSDB.getConnection();
        Vector<SMReportSubCategory> vector = new Vector<SMReportSubCategory>();
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection.prepareCall("{call sp_get_all_subcategories(?,?)}");
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMReportCategory.getObjectID());
                callableStatement.registerOutParameter(2, -10);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(2);
                while (true) {
                    if (!oracleResultSet.next()) {
                        Object[] objectArray2 = new SMReportSubCategory[vector.size()];
                        vector.copyInto(objectArray2);
                        objectArray = objectArray2;
                        Object var10_14 = null;
                        break;
                    }
                    SMReportSubCategory sMReportSubCategory = new SMReportSubCategory(oracleResultSet.getString("subcat_name"), oracleResultSet.getString("subcat_desc"), sMReportCategory.getObjectID(), new SMDBObjectID(oracleResultSet.getLong("subcat_id"), "report_subcategory"));
                    sMReportSubCategory.setDefinedBy(oracleResultSet.getString("system_defined"));
                    sMReportSubCategory.setUpdatedBy(oracleResultSet.getString("updated_by"));
                    sMReportSubCategory.setUpdateTime(oracleResultSet.getTimestamp("timestamp"));
                    sMReportSubCategory.setCreateTime(oracleResultSet.getTimestamp("created_date"));
                    sMReportSubCategory.setChanged(false);
                    vector.addElement(sMReportSubCategory);
                }
            }
            catch (SMLengthException sMLengthException) {
                this.debugLogWriter.println("MrReportTemplateController: got SMLengthException exception");
                SMReportSubCategory[] sMReportSubCategoryArray = null;
                Object var10_15 = null;
                MrReportTools.close(callableStatement);
                MSDB.closeConnection((Connection)connection);
                return sMReportSubCategoryArray;
            }
            catch (SQLException sQLException) {
                this.debugLogWriter.println("MrReportTemplateController: got SQLException exception");
                if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                    throw sMNoSuchObjectException;
                }
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MrReportTools.close(callableStatement);
        MSDB.closeConnection((Connection)connection);
        return objectArray;
    }

    public SMDBObjectID save(SMReportCategory sMReportCategory) throws SMDatabaseException, SMNoSuchObjectException, SMDuplicateException, SMStaleDataException {
        SMDBObjectID sMDBObjectID;
        this.debugLogWriter.println("MrReportTemplateController: Inside method save for Category");
        Connection connection = MSDB.getConnection();
        try {
            SMDBObjectID sMDBObjectID2;
            sMDBObjectID = sMDBObjectID2 = this.save(sMReportCategory, connection);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return sMDBObjectID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SMDBObjectID save(SMReportCategory sMReportCategory, Connection connection) throws SMDatabaseException, SMNoSuchObjectException, SMDuplicateException, SMStaleDataException {
        SMDBObjectID sMDBObjectID;
        this.debugLogWriter.println("MrReportTemplateController: Inside save category with connection");
        SMDBObjectID sMDBObjectID2 = null;
        if (connection == null) {
            return sMDBObjectID2;
        }
        Connection connection2 = connection;
        int n = 1;
        if (sMReportCategory.getObjectID() == null) {
            n = 2;
        }
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection2.prepareCall("{call sp_save_category(?,?,?,?,?,?)}");
                callableStatement.registerOutParameter(1, 2);
                callableStatement.registerOutParameter(5, 93);
                callableStatement.registerOutParameter(6, 93);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMReportCategory.getObjectID());
                MSDB.setNullable((PreparedStatement)callableStatement, (int)5, (Timestamp)sMReportCategory.getUpdateTime());
                MSDB.setNullable((PreparedStatement)callableStatement, (int)6, (Timestamp)sMReportCategory.getCreateTime());
                callableStatement.setString(2, sMReportCategory.getName());
                MSDB.setNullable((PreparedStatement)callableStatement, (int)3, (String)sMReportCategory.getDescription());
                callableStatement.setString(4, this.getCurrentUserName());
                callableStatement.execute();
                long l = callableStatement.getLong(1);
                sMDBObjectID2 = new SMDBObjectID(l, "report_category");
                SMReportEvent sMReportEvent = new SMReportEvent(sMDBObjectID2, n, "report_category", sMReportCategory.getName(), sMReportCategory.getObjectID(), null);
                connection2.commit();
                MrReportServiceImpl.fireEvent((SMDBChangeEvent)sMReportEvent);
                sMDBObjectID = sMDBObjectID2;
                Object var12_17 = null;
            }
            catch (SMLengthException sMLengthException) {
                this.debugLogWriter.println("MrReportTemplateController: got SMLengthException exception");
                SMDBObjectID sMDBObjectID3 = null;
                Object var12_18 = null;
                MrReportTools.close(callableStatement);
                return sMDBObjectID3;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.debugLogWriter.println("MrReportTemplateController: got IllegalArgumentException exception");
                SMDBObjectID sMDBObjectID4 = null;
                Object var12_19 = null;
                MrReportTools.close(callableStatement);
                return sMDBObjectID4;
            }
            catch (SQLException sQLException) {
                MSDB.rollback((Connection)connection2);
                this.debugLogWriter.println("MrReportTemplateController: got SQLException exception");
                if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                    throw sMNoSuchObjectException;
                }
                if (sQLException.getMessage().indexOf("DUPLICATE_INDEX") >= 0) {
                    SMDuplicateException sMDuplicateException = new SMDuplicateException((Throwable)sQLException);
                    throw sMDuplicateException;
                }
                if (sQLException.getMessage().indexOf("STALE_DATA") >= 0) {
                    SMStaleDataException sMStaleDataException = new SMStaleDataException((Throwable)sQLException);
                    throw sMStaleDataException;
                }
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
        }
        catch (Throwable throwable) {
            Object var12_20 = null;
            MrReportTools.close(callableStatement);
            throw throwable;
        }
        MrReportTools.close(callableStatement);
        return sMDBObjectID;
    }

    public SMDBObjectID save(SMReportSubCategory sMReportSubCategory) throws SMDatabaseException, SMNoSuchObjectException, SMDuplicateException, SMStaleDataException {
        SMDBObjectID sMDBObjectID;
        this.debugLogWriter.println("MrReportTemplateController: Inside method save for sub category");
        Connection connection = MSDB.getConnection();
        try {
            SMDBObjectID sMDBObjectID2;
            sMDBObjectID = sMDBObjectID2 = this.save(sMReportSubCategory, connection);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return sMDBObjectID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SMDBObjectID save(SMReportSubCategory sMReportSubCategory, Connection connection) throws SMDatabaseException, SMNoSuchObjectException, SMDuplicateException, SMStaleDataException {
        SMDBObjectID sMDBObjectID;
        SMDBObjectID sMDBObjectID2 = null;
        if (connection == null) {
            return sMDBObjectID2;
        }
        Connection connection2 = connection;
        int n = 1;
        if (sMReportSubCategory.getObjectID() == null) {
            n = 2;
        }
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection2.prepareCall("{call sp_save_subcategory(?,?,?,?,?,?,?)}");
                callableStatement.registerOutParameter(2, 2);
                callableStatement.registerOutParameter(6, 93);
                callableStatement.registerOutParameter(7, 93);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)2, (SMDBObjectID)sMReportSubCategory.getObjectID());
                MSDB.setNullable((PreparedStatement)callableStatement, (int)6, (Timestamp)sMReportSubCategory.getUpdateTime());
                MSDB.setNullable((PreparedStatement)callableStatement, (int)7, (Timestamp)sMReportSubCategory.getCreateTime());
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMReportSubCategory.getCategoryID());
                callableStatement.setString(3, sMReportSubCategory.getName());
                MSDB.setNullable((PreparedStatement)callableStatement, (int)4, (String)sMReportSubCategory.getDescription());
                callableStatement.setString(5, this.getCurrentUserName());
                callableStatement.execute();
                long l = callableStatement.getLong(2);
                sMDBObjectID2 = new SMDBObjectID(l, "report_subcategory");
                SMReportEvent sMReportEvent = new SMReportEvent(sMDBObjectID2, n, "report_subcategory", sMReportSubCategory.getName(), sMReportSubCategory.getCategoryID(), sMDBObjectID2);
                connection2.commit();
                MrReportServiceImpl.fireEvent((SMDBChangeEvent)sMReportEvent);
                sMDBObjectID = sMDBObjectID2;
                Object var12_17 = null;
            }
            catch (SMLengthException sMLengthException) {
                this.debugLogWriter.println("MrReportTemplateController: got SMLengthException exception");
                SMDBObjectID sMDBObjectID3 = null;
                Object var12_18 = null;
                MrReportTools.close(callableStatement);
                return sMDBObjectID3;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.debugLogWriter.println("MrReportTemplateController: got IllegalArgumentException exception");
                SMDBObjectID sMDBObjectID4 = null;
                Object var12_19 = null;
                MrReportTools.close(callableStatement);
                return sMDBObjectID4;
            }
            catch (SQLException sQLException) {
                MSDB.rollback((Connection)connection2);
                this.debugLogWriter.println("MrReportTemplateController: got SQLException exception");
                if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                    throw sMNoSuchObjectException;
                }
                if (sQLException.getMessage().indexOf("DUPLICATE_INDEX") >= 0) {
                    SMDuplicateException sMDuplicateException = new SMDuplicateException((Throwable)sQLException);
                    throw sMDuplicateException;
                }
                if (sQLException.getMessage().indexOf("STALE_DATA") >= 0) {
                    SMStaleDataException sMStaleDataException = new SMStaleDataException((Throwable)sQLException);
                    throw sMStaleDataException;
                }
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
        }
        catch (Throwable throwable) {
            Object var12_20 = null;
            MrReportTools.close(callableStatement);
            throw throwable;
        }
        MrReportTools.close(callableStatement);
        return sMDBObjectID;
    }

    public SMReportCategory getReportCategory(SMDBObjectID sMDBObjectID) throws SMDatabaseException, SMNoSuchObjectException {
        SMReportCategory sMReportCategory;
        this.debugLogWriter.println("MrReportTemplateController: Inside method getReportCategory");
        Connection connection = MSDB.getConnection();
        try {
            sMReportCategory = this.getReportCategory(sMDBObjectID, connection);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return sMReportCategory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SMReportCategory getReportCategory(SMDBObjectID sMDBObjectID, Connection connection) throws SMDatabaseException, SMNoSuchObjectException {
        SMReportCategory sMReportCategory;
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection.prepareCall("{call sp_get_category(?,?,?,?,?,?,?)}");
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMDBObjectID);
                callableStatement.registerOutParameter(2, 12);
                callableStatement.registerOutParameter(3, 12);
                callableStatement.registerOutParameter(4, 12);
                callableStatement.registerOutParameter(5, 12);
                callableStatement.registerOutParameter(6, 93);
                callableStatement.registerOutParameter(7, 93);
                callableStatement.execute();
                SMReportCategory sMReportCategory2 = null;
                sMReportCategory2 = new SMReportCategory(callableStatement.getString(2), callableStatement.getString(3), sMDBObjectID);
                sMReportCategory2.setDefinedBy(callableStatement.getString(4));
                sMReportCategory2.setUpdatedBy(callableStatement.getString(5));
                sMReportCategory2.setUpdateTime(callableStatement.getTimestamp(6));
                sMReportCategory2.setCreateTime(callableStatement.getTimestamp(7));
                sMReportCategory2.setChanged(false);
                sMReportCategory = sMReportCategory2;
                Object var8_10 = null;
            }
            catch (SQLException sQLException) {
                this.debugLogWriter.println("MrReportTemplateController: got SQLException exception");
                if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                    throw sMNoSuchObjectException;
                }
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
            catch (SMLengthException sMLengthException) {
                this.debugLogWriter.println("MrReportTemplateController: got SMLengthException exception");
                SMReportCategory sMReportCategory3 = null;
                Object var8_11 = null;
                MrReportTools.close(callableStatement);
                return sMReportCategory3;
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            MrReportTools.close(callableStatement);
            throw throwable;
        }
        MrReportTools.close(callableStatement);
        return sMReportCategory;
    }

    public SMReportSubCategory getReportSubCategory(SMDBObjectID sMDBObjectID) throws SMDatabaseException, SMNoSuchObjectException {
        SMReportSubCategory sMReportSubCategory;
        this.debugLogWriter.println("MrReportTemplateController: Inside method getReportSubCategory");
        Connection connection = MSDB.getConnection();
        Object var3_3 = null;
        try {
            sMReportSubCategory = this.getReportSubCategory(sMDBObjectID, connection);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return sMReportSubCategory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SMReportSubCategory getReportSubCategory(SMDBObjectID sMDBObjectID, Connection connection) throws SMDatabaseException, SMNoSuchObjectException {
        SMReportSubCategory sMReportSubCategory;
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection.prepareCall("{call sp_get_subcategory(?,?,?,?,?,?,?,?)}");
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMDBObjectID);
                callableStatement.registerOutParameter(2, 2);
                callableStatement.registerOutParameter(3, 12);
                callableStatement.registerOutParameter(4, 12);
                callableStatement.registerOutParameter(5, 12);
                callableStatement.registerOutParameter(6, 12);
                callableStatement.registerOutParameter(7, 93);
                callableStatement.registerOutParameter(8, 93);
                callableStatement.execute();
                SMReportSubCategory sMReportSubCategory2 = new SMReportSubCategory(callableStatement.getString(3), callableStatement.getString(4), new SMDBObjectID(callableStatement.getLong(2), "report_category"), sMDBObjectID);
                sMReportSubCategory2.setDefinedBy(callableStatement.getString(5));
                sMReportSubCategory2.setUpdatedBy(callableStatement.getString(6));
                sMReportSubCategory2.setUpdateTime(callableStatement.getTimestamp(7));
                sMReportSubCategory2.setCreateTime(callableStatement.getTimestamp(8));
                sMReportSubCategory2.setChanged(false);
                sMReportSubCategory = sMReportSubCategory2;
                Object var8_10 = null;
            }
            catch (SQLException sQLException) {
                this.debugLogWriter.println("MrReportTemplateController: got SQLException exception");
                if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                    throw sMNoSuchObjectException;
                }
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
            catch (SMLengthException sMLengthException) {
                this.debugLogWriter.println("MrReportTemplateController: got SMLengthException exception");
                SMReportSubCategory sMReportSubCategory3 = null;
                Object var8_11 = null;
                MrReportTools.close(callableStatement);
                return sMReportSubCategory3;
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            MrReportTools.close(callableStatement);
            throw throwable;
        }
        MrReportTools.close(callableStatement);
        return sMReportSubCategory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteCategory(SMDBObjectID sMDBObjectID) throws SMDatabaseException, SMNoSuchObjectException, SMReferenceExistsException {
        this.debugLogWriter.println("MrReportTemplateController: Inside method deleteCategory");
        Connection connection = MSDB.getConnection();
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection.prepareCall("{call sp_delete_category(?)}");
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMDBObjectID);
                callableStatement.execute();
                connection.commit();
                SMReportEvent sMReportEvent = new SMReportEvent(sMDBObjectID, 3, "report_category", null, sMDBObjectID, null);
                MrReportServiceImpl.fireEvent((SMDBChangeEvent)sMReportEvent);
            }
            catch (SMLengthException sMLengthException) {
                this.debugLogWriter.println("MrReportTemplateController: got SMLengthException exception");
                MSDB.rollback((Connection)connection);
                Object var9_7 = null;
                MrReportTools.close(callableStatement);
                MSDB.closeConnection((Connection)connection);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.debugLogWriter.println("MrReportTemplateController: got IllegalArgumentException exception");
                MSDB.rollback((Connection)connection);
                Object var9_8 = null;
                MrReportTools.close(callableStatement);
                MSDB.closeConnection((Connection)connection);
                return;
            }
            catch (SQLException sQLException) {
                MSDB.rollback((Connection)connection);
                this.debugLogWriter.println("MrReportTemplateController: got SQLException exception, Message = " + sQLException.getMessage());
                if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                    throw sMNoSuchObjectException;
                }
                if (sQLException.getMessage().indexOf(REFERENCES_EXIST) >= 0) {
                    SMReferenceExistsException sMReferenceExistsException = new SMReferenceExistsException((Throwable)sQLException);
                    throw sMReferenceExistsException;
                }
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
            Object var9_6 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MrReportTools.close(callableStatement);
        MSDB.closeConnection((Connection)connection);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteSubCategory(SMDBObjectID sMDBObjectID) throws SMDatabaseException, SMNoSuchObjectException, SMReferenceExistsException {
        this.debugLogWriter.println("MrReportTemplateController: Inside method deleteSubCategory");
        Connection connection = MSDB.getConnection();
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection.prepareCall("{call sp_delete_subcategory(?)}");
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMDBObjectID);
                callableStatement.execute();
                connection.commit();
                SMReportEvent sMReportEvent = new SMReportEvent(sMDBObjectID, 3, "report_subcategory", null, null, sMDBObjectID);
                MrReportServiceImpl.fireEvent((SMDBChangeEvent)sMReportEvent);
            }
            catch (SMLengthException sMLengthException) {
                this.debugLogWriter.println("MrReportTemplateController: got SMLengthException exception");
                MSDB.rollback((Connection)connection);
                Object var9_7 = null;
                MrReportTools.close(callableStatement);
                MSDB.closeConnection((Connection)connection);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.debugLogWriter.println("MrReportTemplateController: got IllegalArgumentException exception");
                MSDB.rollback((Connection)connection);
                Object var9_8 = null;
                MrReportTools.close(callableStatement);
                MSDB.closeConnection((Connection)connection);
                return;
            }
            catch (SQLException sQLException) {
                MSDB.rollback((Connection)connection);
                this.debugLogWriter.println("MrReportTemplateController: got SQLException exception");
                if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                    throw sMNoSuchObjectException;
                }
                if (sQLException.getMessage().indexOf(REFERENCES_EXIST) >= 0) {
                    SMReferenceExistsException sMReferenceExistsException = new SMReferenceExistsException((Throwable)sQLException);
                    throw sMReferenceExistsException;
                }
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
            Object var9_6 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MrReportTools.close(callableStatement);
        MSDB.closeConnection((Connection)connection);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getAllRequestProperties(long l, int n, Connection connection) throws SMDatabaseException, SMNoSuchObjectException {
        Object object;
        this.debugLogWriter.println("MrReportTemplateController: Inside method getAllRequestProperties");
        Vector<SMReportProperty> vector = new Vector<SMReportProperty>();
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection.prepareCall("{call sp_get_request_properties(?,?)}");
                callableStatement.setLong(1, l);
                callableStatement.registerOutParameter(2, -10);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(2);
                while (true) {
                    if (!oracleResultSet.next()) {
                        object = vector;
                        Object var13_14 = null;
                        break;
                    }
                    SMReportProperty sMReportProperty = new SMReportProperty(oracleResultSet.getString("property"), oracleResultSet.getString("property_instance"), oracleResultSet.getString("module"), oracleResultSet.getString("module_instance"), oracleResultSet.getString("units"), new SMDBObjectID(oracleResultSet.getLong("property_id"), "report_property"));
                    sMReportProperty.setDataType(oracleResultSet.getString("data_type"));
                    sMReportProperty.setLovPresent(oracleResultSet.getString("lov_available"));
                    sMReportProperty.setPropertyType(n);
                    if (n == 8) {
                        object = this.getTableI18nKey(sMReportProperty.getPropertyName());
                        if (object == null) {
                            sMReportProperty.setI18nKey(sMReportProperty.getPropertyName());
                        } else {
                            sMReportProperty.setI18nKey((String)object);
                        }
                        this.getCfgData();
                        if (this.advHWCfgData != null) {
                            String[] stringArray = this.advHWCfgData.getProperties(sMReportProperty.getPropertyName());
                            String[] stringArray2 = this.advHWCfgData.getPropI18nKeys(sMReportProperty.getPropertyName());
                            sMReportProperty.setPropertyColumns(stringArray);
                            sMReportProperty.setpropertyColumnsI18nKeys(stringArray2);
                        } else {
                            this.debugLogWriter.println("MrReportTemplateController: Some problem in geting cfgdata");
                        }
                    } else {
                        sMReportProperty.setI18nKey(oracleResultSet.getString("i18n_key"));
                    }
                    sMReportProperty.setChanged(false);
                    vector.addElement(sMReportProperty);
                }
            }
            catch (SQLException sQLException) {
                this.debugLogWriter.println("MrReportTemplateController: got SQLException exception");
                if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                    throw sMNoSuchObjectException;
                }
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            MrReportTools.close(callableStatement);
            throw throwable;
        }
        MrReportTools.close(callableStatement);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getAllOperators(String string) throws SMDatabaseException, SMNoSuchObjectException {
        Vector<String> vector;
        this.debugLogWriter.println("MrReportTemplateController: Inside method getAllOperators");
        Connection connection = MSDB.getConnection();
        Vector<String> vector2 = new Vector<String>();
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection.prepareCall("{call sp_get_operators(?,?)}");
                callableStatement.setString(1, string);
                callableStatement.registerOutParameter(2, -10);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(2);
                while (true) {
                    if (!oracleResultSet.next()) {
                        vector = vector2;
                        Object var8_10 = null;
                        break;
                    }
                    vector2.addElement(oracleResultSet.getString("operator"));
                }
            }
            catch (SQLException sQLException) {
                this.debugLogWriter.println("MrReportTemplateController: got SQLException exception");
                if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                    throw sMNoSuchObjectException;
                }
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MrReportTools.close(callableStatement);
        MSDB.closeConnection((Connection)connection);
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getPropertyValues(String string) throws SMDatabaseException, SMNoSuchObjectException {
        Vector<String> vector;
        this.debugLogWriter.println("MrReportTemplateController: Inside method getPropertyValues");
        Connection connection = MSDB.getConnection();
        Vector<String> vector2 = new Vector<String>();
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection.prepareCall("{call sp_get_property_lovs(?,?)}");
                callableStatement.setString(1, string);
                callableStatement.registerOutParameter(2, -10);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(2);
                while (true) {
                    if (!oracleResultSet.next()) {
                        vector = vector2;
                        Object var8_10 = null;
                        break;
                    }
                    vector2.addElement(oracleResultSet.getString("value"));
                }
            }
            catch (SQLException sQLException) {
                this.debugLogWriter.println("MrReportTemplateController: got SQLException exception");
                if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                    throw sMNoSuchObjectException;
                }
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MrReportTools.close(callableStatement);
        MSDB.closeConnection((Connection)connection);
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getProperties(int n) throws SMDatabaseException, SMNoSuchObjectException {
        Object object;
        this.debugLogWriter.println("MrReportTemplateController: Inside method getProperties");
        Connection connection = MSDB.getConnection();
        Vector<SMReportProperty> vector = new Vector<SMReportProperty>();
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection.prepareCall("{call sp_get_properties(?,?)}");
                callableStatement.setInt(1, n);
                callableStatement.registerOutParameter(2, -10);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(2);
                int n2 = 0;
                while (true) {
                    if (!oracleResultSet.next()) {
                        object = vector;
                        Object var12_14 = null;
                        break;
                    }
                    ++n2;
                    SMReportProperty sMReportProperty = new SMReportProperty(oracleResultSet.getString("property"), null, oracleResultSet.getString("module"), null, oracleResultSet.getString("units"), new SMDBObjectID(oracleResultSet.getLong("property_id"), "report_property"));
                    sMReportProperty.setDataType(oracleResultSet.getString("data_type"));
                    sMReportProperty.setLovPresent(oracleResultSet.getString("lov_available"));
                    sMReportProperty.setFilterAllowed(oracleResultSet.getString("filter_allowed"));
                    sMReportProperty.setPropertyType(n);
                    if (n == 8 && n2 > 2) {
                        object = this.getTableI18nKey(sMReportProperty.getPropertyName());
                        this.debugLogWriter.println("MrReportTemplateController: i18nkey = " + (String)object + " " + "For " + sMReportProperty.getPropertyName());
                        if (object == null) {
                            sMReportProperty.setI18nKey(sMReportProperty.getPropertyName());
                        } else {
                            sMReportProperty.setI18nKey((String)object);
                        }
                        this.getCfgData();
                        if (this.advHWCfgData != null) {
                            String[] stringArray = this.advHWCfgData.getProperties(sMReportProperty.getPropertyName());
                            String[] stringArray2 = this.advHWCfgData.getPropI18nKeys(sMReportProperty.getPropertyName());
                            sMReportProperty.setPropertyColumns(stringArray);
                            sMReportProperty.setpropertyColumnsI18nKeys(stringArray2);
                        } else {
                            this.debugLogWriter.println("MrReportTemplateController: Some problem in geting cfgdata");
                        }
                    } else {
                        sMReportProperty.setI18nKey(oracleResultSet.getString("i18n_key"));
                    }
                    sMReportProperty.setChanged(false);
                    vector.addElement(sMReportProperty);
                }
            }
            catch (SQLException sQLException) {
                this.debugLogWriter.println("MrReportTemplateController: got SQLException exception");
                if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                    throw sMNoSuchObjectException;
                }
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MrReportTools.close(callableStatement);
        MSDB.closeConnection((Connection)connection);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void save(SMReportProperty sMReportProperty, Connection connection, long l) throws SMDatabaseException, SMNoSuchObjectException, SMDuplicateException, SMStaleDataException {
        if (connection == null) return;
        if (sMReportProperty == null) {
            return;
        }
        Connection connection2 = connection;
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection2.prepareCall("{call sp_save_request_property(?,?,?,?,?,?,?,?,?,?)}");
                callableStatement.registerOutParameter(9, 93);
                callableStatement.registerOutParameter(10, 93);
                callableStatement.setLong(1, l);
                callableStatement.setString(2, sMReportProperty.getPropertyName());
                MSDB.setNullable((PreparedStatement)callableStatement, (int)3, (String)sMReportProperty.getModuleName());
                MSDB.setNullable((PreparedStatement)callableStatement, (int)4, (String)sMReportProperty.getModuleInstance());
                MSDB.setNullable((PreparedStatement)callableStatement, (int)5, (String)sMReportProperty.getPropertyInstance());
                MSDB.setNullable((PreparedStatement)callableStatement, (int)6, (String)sMReportProperty.getUnit());
                MSDB.setNullable((PreparedStatement)callableStatement, (int)7, (String)sMReportProperty.getI18nKey());
                callableStatement.setString(8, this.getCurrentUserName());
                callableStatement.execute();
                Object var11_6 = null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.debugLogWriter.println("MrReportTemplateController: got IllegalArgumentException exception");
                Object var11_7 = null;
                MrReportTools.close(callableStatement);
                return;
            }
            catch (SQLException sQLException) {
                this.debugLogWriter.println("MrReportTemplateController: got SQLException exception");
                if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                    throw sMNoSuchObjectException;
                }
                if (sQLException.getMessage().indexOf("DUPLICATE_INDEX") >= 0) {
                    SMDuplicateException sMDuplicateException = new SMDuplicateException((Throwable)sQLException);
                    throw sMDuplicateException;
                }
                if (sQLException.getMessage().indexOf("STALE_DATA") >= 0) {
                    SMStaleDataException sMStaleDataException = new SMStaleDataException((Throwable)sQLException);
                    throw sMStaleDataException;
                }
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
        }
        catch (Throwable throwable) {
            Object var11_8 = null;
            MrReportTools.close(callableStatement);
            throw throwable;
        }
        MrReportTools.close(callableStatement);
    }

    protected void save(Vector vector, Connection connection, long l) throws SMDatabaseException, SMNoSuchObjectException, SMDuplicateException, SMStaleDataException {
        if (vector == null) {
            return;
        }
        Enumeration enumeration = vector.elements();
        if (enumeration == null) {
            return;
        }
        SMReportProperty sMReportProperty = null;
        while (enumeration.hasMoreElements()) {
            sMReportProperty = (SMReportProperty)enumeration.nextElement();
            if (sMReportProperty == null) continue;
            this.save(sMReportProperty, connection, l);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SMReportRequestInfo[] getAllReportRequestInfo(SMDBObjectID sMDBObjectID, SMDBObjectID sMDBObjectID2) throws SMDatabaseException, SMNoSuchObjectException {
        SMDBObjectID sMDBObjectID3;
        this.debugLogWriter.println("MrReportTemplateController: Inside method getAllReportRequestInfo");
        Connection connection = MSDB.getConnection();
        Vector<SMReportRequestInfo> vector = new Vector<SMReportRequestInfo>();
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection.prepareCall("{call sp_get_all_report_requests(?,?,?)}");
                callableStatement.registerOutParameter(3, -10);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMDBObjectID);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)2, (SMDBObjectID)sMDBObjectID2);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(3);
                while (true) {
                    SMDBObjectID sMDBObjectID4;
                    if (!oracleResultSet.next()) {
                        sMDBObjectID4 = new SMReportRequestInfo[vector.size()];
                        vector.copyInto((Object[])sMDBObjectID4);
                        sMDBObjectID3 = sMDBObjectID4;
                        Object var16_19 = null;
                        break;
                    }
                    try {
                        sMDBObjectID4 = new SMDBObjectID(oracleResultSet.getLong("cat_id"), "report_category");
                        long l = oracleResultSet.getLong("subcat_id");
                        SMDBObjectID sMDBObjectID5 = null;
                        if (l != 0L) {
                            sMDBObjectID5 = new SMDBObjectID(l, "report_subcategory");
                        }
                        SMReportRequestInfo sMReportRequestInfo = new SMReportRequestInfo(oracleResultSet.getString("request_name"), oracleResultSet.getString("request_desc"), sMDBObjectID4, sMDBObjectID5);
                        sMReportRequestInfo.setDefinedBy(oracleResultSet.getString("system_defined"));
                        int n = oracleResultSet.getInt("request_type");
                        sMReportRequestInfo.setReportType(n);
                        sMReportRequestInfo.setOutputFormat(oracleResultSet.getString("output_mode"));
                        sMReportRequestInfo.setAgentGroupName(oracleResultSet.getString("object_group_name"));
                        String string = oracleResultSet.getString("hostname_list");
                        sMReportRequestInfo.setAgentList(MrReportTools.getStringToArray(string, ","));
                        SMDBObjectID sMDBObjectID6 = n == 6 ? new SMDBObjectID(oracleResultSet.getLong("request_id"), "report_composite_request") : new SMDBObjectID(oracleResultSet.getLong("request_id"), "report_request");
                        sMReportRequestInfo.setObjectID(sMDBObjectID6);
                        vector.addElement(sMReportRequestInfo);
                    }
                    catch (SMLengthException sMLengthException) {
                        this.debugLogWriter.println("MrReportTemplateController: got SMLengthException exception");
                    }
                }
            }
            catch (SQLException sQLException) {
                this.debugLogWriter.println("MrReportTemplateController: got SQLException exception");
                if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                    throw sMNoSuchObjectException;
                }
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MrReportTools.close(callableStatement);
        MSDB.closeConnection((Connection)connection);
        return sMDBObjectID3;
    }

    public SMReportRequest getReportRequest(SMDBObjectID sMDBObjectID) throws SMDatabaseException, SMNoSuchObjectException {
        SMReportRequest sMReportRequest;
        this.debugLogWriter.println("MrReportTemplateController: Inside method getReportRequest");
        Connection connection = MSDB.getConnection();
        try {
            sMReportRequest = this.getReportRequest(sMDBObjectID, connection);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return sMReportRequest;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SMReportRequest getReportRequest(SMDBObjectID sMDBObjectID, Connection connection) throws SMDatabaseException, SMNoSuchObjectException {
        SMReportRequest sMReportRequest;
        CallableStatement callableStatement;
        block16: {
            SMReportRequest sMReportRequest2;
            block15: {
                callableStatement = null;
                try {
                    try {
                        callableStatement = connection.prepareCall("{call sp_get_report_request(?,?)}");
                        callableStatement.registerOutParameter(2, -10);
                        MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMDBObjectID);
                        callableStatement.execute();
                        OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(2);
                        SMReportRequest sMReportRequest3 = null;
                        try {
                            Date date;
                            Cloneable cloneable;
                            if (!oracleResultSet.next()) {
                                sMReportRequest2 = null;
                                Object var42_12 = null;
                                break block15;
                            }
                            long l = oracleResultSet.getLong("request_id");
                            SMDBObjectID sMDBObjectID2 = new SMDBObjectID(oracleResultSet.getLong("cat_id"), "report_category");
                            long l2 = oracleResultSet.getLong("subcat_id");
                            SMDBObjectID sMDBObjectID3 = null;
                            if (l2 != 0L) {
                                sMDBObjectID3 = new SMDBObjectID(l2, "report_subcategory");
                            }
                            String string = oracleResultSet.getString("presentation_info");
                            String string2 = oracleResultSet.getString("output_mode");
                            int n = oracleResultSet.getInt("data_focus");
                            String string3 = oracleResultSet.getString("filter_criteria");
                            String string4 = oracleResultSet.getString("function_name");
                            int n2 = oracleResultSet.getInt("time_interval");
                            Timestamp timestamp = oracleResultSet.getTimestamp("start_date");
                            Timestamp timestamp2 = oracleResultSet.getTimestamp("end_date");
                            String string5 = oracleResultSet.getString("request_name");
                            String string6 = oracleResultSet.getString("request_desc");
                            String string7 = oracleResultSet.getString("object_group_name");
                            String string8 = oracleResultSet.getString("system_defined");
                            String string9 = oracleResultSet.getString("updated_by");
                            Timestamp timestamp3 = oracleResultSet.getTimestamp("timestamp");
                            Timestamp timestamp4 = oracleResultSet.getTimestamp("created_date");
                            int n3 = oracleResultSet.getInt("request_level");
                            int n4 = oracleResultSet.getInt("ref_count");
                            int n5 = oracleResultSet.getInt("request_window");
                            int n6 = oracleResultSet.getInt("request_type");
                            String string10 = oracleResultSet.getString("hostname_list");
                            MrReportTools.close(callableStatement);
                            SMReportCategory sMReportCategory = this.getReportCategory(sMDBObjectID2, connection);
                            SMReportSubCategory sMReportSubCategory = null;
                            if (sMDBObjectID3 != null) {
                                sMReportSubCategory = this.getReportSubCategory(sMDBObjectID3, connection);
                            }
                            SMReportGraphPresentation sMReportGraphPresentation = null;
                            if (string != null) {
                                sMReportGraphPresentation = new SMReportGraphPresentation();
                                sMReportGraphPresentation.setGraphPresentation(string);
                            }
                            SMReportFormat sMReportFormat = null;
                            if (string2 != null || n >= 0 || sMReportGraphPresentation != null) {
                                sMReportFormat = new SMReportFormat(string2, n, sMReportGraphPresentation);
                            }
                            SMReportFilter sMReportFilter = null;
                            if (string3 != null || string4 != null || timestamp != null || timestamp2 != null || n2 >= 0) {
                                cloneable = null;
                                if (timestamp != null) {
                                    cloneable = new Date(((Date)timestamp).getTime());
                                }
                                date = null;
                                if (timestamp2 != null) {
                                    date = new Date(((Date)timestamp2).getTime());
                                }
                                sMReportFilter = new SMReportFilter(string3, string4, n2, cloneable, date);
                            }
                            cloneable = this.getAllRequestProperties(l, n6, connection);
                            date = new SMReportPropertyGroup((Vector)cloneable);
                            date.setCategory(sMReportCategory);
                            SMReportTemplate sMReportTemplate = new SMReportTemplate((SMReportPropertyGroup)date, sMReportFilter, sMReportFormat);
                            sMReportRequest3 = new SMReportRequest(string5, string6, sMReportCategory, sMReportSubCategory, string7, sMReportTemplate, new SMDBObjectID(l, "report_request"));
                            sMReportRequest3.setDefinedBy(string8);
                            sMReportRequest3.setUpdatedBy(string9);
                            sMReportRequest3.setUpdateTime(timestamp3);
                            sMReportRequest3.setCreateTime(timestamp4);
                            sMReportRequest3.setRequestDataType(n3);
                            sMReportRequest3.setReferenceCount(n4);
                            sMReportRequest3.setRequestType(n5);
                            sMReportRequest3.setReportType(n6);
                            sMReportRequest3.setAgentList(MrReportTools.getStringToArray(string10, ","));
                            sMReportRequest3.setChanged(false);
                        }
                        catch (SMLengthException sMLengthException) {
                            this.debugLogWriter.println("MrReportTemplateController: got SMLengthException exception");
                        }
                        sMReportRequest = sMReportRequest3;
                        break block16;
                    }
                    catch (SQLException sQLException) {
                        this.debugLogWriter.println("MrReportTemplateController: got SQLException exception");
                        if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                            SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                            throw sMNoSuchObjectException;
                        }
                        SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                        throw sMDatabaseException;
                    }
                }
                catch (Throwable throwable) {
                    Object var42_14 = null;
                    MrReportTools.close(callableStatement);
                    throw throwable;
                }
            }
            MrReportTools.close(callableStatement);
            return sMReportRequest2;
        }
        Object var42_13 = null;
        MrReportTools.close(callableStatement);
        return sMReportRequest;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getAllChildRequests(long l, Connection connection) throws SMDatabaseException, SMNoSuchObjectException {
        this.debugLogWriter.println("MrReportTemplateController: Inside method getAllChildRequests");
        Vector<SMDBObjectID> vector = new Vector<SMDBObjectID>();
        Vector<SMReportRequest> vector2 = new Vector<SMReportRequest>();
        CallableStatement callableStatement = null;
        try {
            try {
                SMDBObjectID sMDBObjectID;
                callableStatement = connection.prepareCall("{call sp_get_all_child_requests(?,?)}");
                callableStatement.registerOutParameter(2, -10);
                callableStatement.setLong(1, l);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(2);
                while (oracleResultSet.next()) {
                    sMDBObjectID = new SMDBObjectID(oracleResultSet.getLong("request_id"), "report_request");
                    vector.addElement(sMDBObjectID);
                }
                MrReportTools.close(callableStatement);
                SMReportRequest sMReportRequest = null;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    sMDBObjectID = (SMDBObjectID)enumeration.nextElement();
                    try {
                        sMReportRequest = this.getReportRequest(sMDBObjectID, connection);
                        vector2.addElement(sMReportRequest);
                    }
                    catch (SMDatabaseException sMDatabaseException) {
                        this.debugLogWriter.println("MrReportTemplateController: got SMDatabaseException exception");
                    }
                }
                Vector<SMReportRequest> vector3 = vector2;
                Object var13_15 = null;
                MrReportTools.close(callableStatement);
                return vector3;
            }
            catch (SQLException sQLException) {
                this.debugLogWriter.println("MrReportTemplateController: got SQLException exception");
                if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                    throw sMNoSuchObjectException;
                }
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            MrReportTools.close(callableStatement);
            throw throwable;
        }
    }

    public SMReportCompositeRequest getCompositeRequest(SMDBObjectID sMDBObjectID) throws SMDatabaseException, SMNoSuchObjectException {
        SMReportCompositeRequest sMReportCompositeRequest;
        this.debugLogWriter.println("MrReportTemplateController: Inside method getCompositeRequest");
        Connection connection = MSDB.getConnection();
        try {
            sMReportCompositeRequest = this.getCompositeRequest(sMDBObjectID, connection);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return sMReportCompositeRequest;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SMReportCompositeRequest getCompositeRequest(SMDBObjectID sMDBObjectID, Connection connection) throws SMDatabaseException, SMNoSuchObjectException {
        SMReportCompositeRequest sMReportCompositeRequest;
        CallableStatement callableStatement;
        block14: {
            SMReportCompositeRequest sMReportCompositeRequest2;
            block13: {
                SMReportCompositeRequest sMReportCompositeRequest3;
                block12: {
                    this.debugLogWriter.println("MrReportTemplateController: Inside method getCompositeRequest");
                    callableStatement = null;
                    try {
                        try {
                            callableStatement = connection.prepareCall("{call sp_get_report_request(?,?)}");
                            callableStatement.registerOutParameter(2, -10);
                            MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMDBObjectID);
                            callableStatement.execute();
                            OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(2);
                            SMReportCompositeRequest sMReportCompositeRequest4 = null;
                            try {
                                if (!oracleResultSet.next()) {
                                    sMReportCompositeRequest3 = null;
                                    Object var24_13 = null;
                                    break block12;
                                }
                                int n = oracleResultSet.getInt("request_type");
                                if (n != 6) {
                                    sMReportCompositeRequest2 = null;
                                    break block13;
                                }
                                long l = oracleResultSet.getLong("request_id");
                                SMDBObjectID sMDBObjectID2 = new SMDBObjectID(oracleResultSet.getLong("cat_id"), "report_category");
                                long l2 = oracleResultSet.getLong("subcat_id");
                                SMDBObjectID sMDBObjectID3 = null;
                                if (l2 != 0L) {
                                    sMDBObjectID3 = new SMDBObjectID(l2, "report_subcategory");
                                }
                                String string = oracleResultSet.getString("request_name");
                                String string2 = oracleResultSet.getString("request_desc");
                                String string3 = oracleResultSet.getString("system_defined");
                                String string4 = oracleResultSet.getString("updated_by");
                                Timestamp timestamp = oracleResultSet.getTimestamp("timestamp");
                                Timestamp timestamp2 = oracleResultSet.getTimestamp("created_date");
                                MrReportTools.close(callableStatement);
                                SMReportCategory sMReportCategory = this.getReportCategory(sMDBObjectID2, connection);
                                SMReportSubCategory sMReportSubCategory = null;
                                if (sMDBObjectID3 != null) {
                                    sMReportSubCategory = this.getReportSubCategory(sMDBObjectID3, connection);
                                }
                                sMReportCompositeRequest4 = new SMReportCompositeRequest(string, string2, sMReportCategory, sMReportSubCategory, null, new SMDBObjectID(l, "report_composite_request"));
                                sMReportCompositeRequest4.setDefinedBy(string3);
                                sMReportCompositeRequest4.setUpdatedBy(string4);
                                sMReportCompositeRequest4.setUpdateTime(timestamp);
                                sMReportCompositeRequest4.setCreateTime(timestamp2);
                            }
                            catch (SMLengthException sMLengthException) {
                                this.debugLogWriter.println("MrReportTemplateController: got SMLengthException exception");
                            }
                            Vector vector = this.getAllChildRequests(sMReportCompositeRequest4.getObjectID().getID(), connection);
                            sMReportCompositeRequest4.setRequests(vector);
                            sMReportCompositeRequest4.setChanged(false);
                            sMReportCompositeRequest = sMReportCompositeRequest4;
                            break block14;
                        }
                        catch (SMLengthException sMLengthException) {
                            this.debugLogWriter.println("MrReportTemplateController: got SMLengthException exception");
                            Object var24_16 = null;
                            MrReportTools.close(callableStatement);
                            return null;
                        }
                        catch (SQLException sQLException) {
                            this.debugLogWriter.println("MrReportTemplateController: got SQLException exception");
                            if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                                SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                                throw sMNoSuchObjectException;
                            }
                            SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                            throw sMDatabaseException;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var24_17 = null;
                        MrReportTools.close(callableStatement);
                        throw throwable;
                    }
                }
                MrReportTools.close(callableStatement);
                return sMReportCompositeRequest3;
            }
            Object var24_14 = null;
            MrReportTools.close(callableStatement);
            return sMReportCompositeRequest2;
        }
        Object var24_15 = null;
        MrReportTools.close(callableStatement);
        return sMReportCompositeRequest;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SMReportCompositeRequest[] getAllCompositeReportRequest() throws SMDatabaseException, SMNoSuchObjectException {
        this.debugLogWriter.println("MrReportTemplateController: Inside method getAllCompositeReportRequest");
        Connection connection = MSDB.getConnection();
        Vector<SMDBObjectID> vector = new Vector<SMDBObjectID>();
        Vector<SMReportCompositeRequest> vector2 = new Vector<SMReportCompositeRequest>();
        CallableStatement callableStatement = null;
        try {
            try {
                SMDBObjectID sMDBObjectID;
                callableStatement = connection.prepareCall("{call sp_get_all_report_requests(?,?,?)}");
                callableStatement.registerOutParameter(3, -10);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)null);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)2, (SMDBObjectID)null);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(3);
                while (oracleResultSet.next()) {
                    sMDBObjectID = new SMDBObjectID(oracleResultSet.getLong("request_id"), "report_composite_request");
                    if (6 != oracleResultSet.getInt("request_type")) continue;
                    vector.addElement(sMDBObjectID);
                }
                MrReportTools.close(callableStatement);
                SMReportCompositeRequest sMReportCompositeRequest = null;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    sMDBObjectID = (SMDBObjectID)enumeration.nextElement();
                    try {
                        sMReportCompositeRequest = this.getCompositeRequest(sMDBObjectID, connection);
                        vector2.addElement(sMReportCompositeRequest);
                    }
                    catch (SMDatabaseException sMDatabaseException) {
                        this.debugLogWriter.println("MrReportTemplateController: got SMDatabaseException exception");
                    }
                }
                Object[] objectArray = new SMReportCompositeRequest[vector2.size()];
                vector2.copyInto(objectArray);
                Object[] objectArray2 = objectArray;
                Object var12_15 = null;
                MrReportTools.close(callableStatement);
                MSDB.closeConnection((Connection)connection);
                return objectArray2;
            }
            catch (SQLException sQLException) {
                this.debugLogWriter.println("MrReportTemplateController: got SQLException exception");
                if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                    throw sMNoSuchObjectException;
                }
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SMReportRequest[] getAllReportRequest(SMDBObjectID sMDBObjectID, SMDBObjectID sMDBObjectID2) throws SMDatabaseException, SMNoSuchObjectException {
        this.debugLogWriter.println("MrReportTemplateController: Inside method getAllReportRequest");
        Connection connection = MSDB.getConnection();
        Vector<SMDBObjectID> vector = new Vector<SMDBObjectID>();
        Vector<SMReportRequest> vector2 = new Vector<SMReportRequest>();
        CallableStatement callableStatement = null;
        try {
            try {
                SMDBObjectID sMDBObjectID3;
                callableStatement = connection.prepareCall("{call sp_get_all_report_requests(?,?,?)}");
                callableStatement.registerOutParameter(3, -10);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMDBObjectID);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)2, (SMDBObjectID)sMDBObjectID2);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(3);
                while (oracleResultSet.next()) {
                    sMDBObjectID3 = new SMDBObjectID(oracleResultSet.getLong("request_id"), "report_request");
                    if (6 == oracleResultSet.getInt("request_type")) continue;
                    vector.addElement(sMDBObjectID3);
                }
                MrReportTools.close(callableStatement);
                SMReportRequest sMReportRequest = null;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    sMDBObjectID3 = (SMDBObjectID)enumeration.nextElement();
                    try {
                        sMReportRequest = this.getReportRequest(sMDBObjectID3, connection);
                        vector2.addElement(sMReportRequest);
                    }
                    catch (SMDatabaseException sMDatabaseException) {
                        sMDatabaseException.printStackTrace();
                        this.debugLogWriter.println("MrReportTemplateController: got SMLengthException exception");
                    }
                }
                Object[] objectArray = new SMReportRequest[vector2.size()];
                vector2.copyInto(objectArray);
                Object[] objectArray2 = objectArray;
                Object var14_17 = null;
                MrReportTools.close(callableStatement);
                MSDB.closeConnection((Connection)connection);
                return objectArray2;
            }
            catch (SQLException sQLException) {
                this.debugLogWriter.println("MrReportTemplateController: got SQLException exception");
                if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                    throw sMNoSuchObjectException;
                }
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SMReportRequestInfo[] getScheduleableRequests(boolean bl) throws SMDatabaseException {
        SMDBObjectID sMDBObjectID;
        Connection connection = MSDB.getConnection();
        Vector<SMReportRequestInfo> vector = new Vector<SMReportRequestInfo>();
        int n = bl ? 1 : 0;
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection.prepareCall("{call sp_get_scheduler_requests(?,?)}");
                callableStatement.setInt(1, n);
                callableStatement.registerOutParameter(2, -10);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(2);
                while (true) {
                    SMDBObjectID sMDBObjectID2;
                    if (!oracleResultSet.next()) {
                        sMDBObjectID2 = new SMReportRequestInfo[vector.size()];
                        vector.copyInto((Object[])sMDBObjectID2);
                        sMDBObjectID = sMDBObjectID2;
                        Object var14_16 = null;
                        break;
                    }
                    try {
                        sMDBObjectID2 = new SMDBObjectID(oracleResultSet.getLong("cat_id"), "report_category");
                        long l = oracleResultSet.getLong("subcat_id");
                        SMDBObjectID sMDBObjectID3 = null;
                        if (l != 0L) {
                            sMDBObjectID3 = new SMDBObjectID(l, "report_subcategory");
                        }
                        SMReportRequestInfo sMReportRequestInfo = new SMReportRequestInfo(oracleResultSet.getString("request_name"), oracleResultSet.getString("request_desc"), sMDBObjectID2, sMDBObjectID3);
                        sMReportRequestInfo.setDefinedBy(oracleResultSet.getString("system_defined"));
                        sMReportRequestInfo.setReportType(oracleResultSet.getInt("request_type"));
                        sMReportRequestInfo.setOutputFormat(oracleResultSet.getString("output_mode"));
                        SMDBObjectID sMDBObjectID4 = new SMDBObjectID(oracleResultSet.getLong("request_id"), "report_request");
                        sMReportRequestInfo.setObjectID(sMDBObjectID4);
                        vector.addElement(sMReportRequestInfo);
                    }
                    catch (SMLengthException sMLengthException) {
                        this.debugLogWriter.println("MrReportTemplateController: got SMLengthException exception");
                    }
                }
            }
            catch (SQLException sQLException) {
                this.debugLogWriter.println("MrReportTemplateController: got SQLException exception");
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MrReportTools.close(callableStatement);
        MSDB.closeConnection((Connection)connection);
        return sMDBObjectID;
    }

    protected void saveAllFilterCriteria(String string, long l, Connection connection) throws SMDatabaseException, SMNoSuchObjectException, SMDuplicateException, SMStaleDataException {
        if (connection == null) {
            return;
        }
        Connection connection2 = connection;
        this.debugLogWriter.println("MrReportTemplateController: Saving all the filter criteria");
        CallableStatement callableStatement = null;
        try {
            try {
                if (string != null) {
                    String string2 = null;
                    String string3 = null;
                    String string4 = null;
                    String string5 = null;
                    String string6 = null;
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "{}", false);
                    while (stringTokenizer.hasMoreTokens()) {
                        StringTokenizer stringTokenizer2;
                        string2 = null;
                        string3 = null;
                        string4 = null;
                        string5 = null;
                        string6 = null;
                        string6 = stringTokenizer.nextToken();
                        if (stringTokenizer.hasMoreTokens()) {
                            string5 = stringTokenizer.nextToken();
                        }
                        if (!(stringTokenizer2 = new StringTokenizer(string6, "|", false)).hasMoreTokens()) continue;
                        string2 = stringTokenizer2.nextToken();
                        if (!stringTokenizer2.hasMoreTokens()) continue;
                        string3 = stringTokenizer2.nextToken();
                        if (!stringTokenizer2.hasMoreTokens()) continue;
                        string4 = stringTokenizer2.nextToken();
                        callableStatement = connection2.prepareCall("{call sp_save_filter_criteria(?,?,?,?,?)}");
                        callableStatement.setLong(1, l);
                        MSDB.setNullable((PreparedStatement)callableStatement, (int)2, (String)string2);
                        MSDB.setNullable((PreparedStatement)callableStatement, (int)3, (String)string3);
                        MSDB.setNullable((PreparedStatement)callableStatement, (int)4, (String)string4);
                        MSDB.setNullable((PreparedStatement)callableStatement, (int)5, (String)string5);
                        callableStatement.execute();
                        callableStatement.close();
                    }
                }
                callableStatement = connection2.prepareCall("{call pkg_gen_filter_query.generate_query(?)}");
                callableStatement.setLong(1, l);
                callableStatement.execute();
                callableStatement.close();
            }
            catch (SQLException sQLException) {
                this.debugLogWriter.println("MrReportTemplateController: got SQLException exception");
                if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                    throw sMNoSuchObjectException;
                }
                if (sQLException.getMessage().indexOf("DUPLICATE_INDEX") >= 0) {
                    SMDuplicateException sMDuplicateException = new SMDuplicateException((Throwable)sQLException);
                    throw sMDuplicateException;
                }
                if (sQLException.getMessage().indexOf("STALE_DATA") >= 0) {
                    SMStaleDataException sMStaleDataException = new SMStaleDataException((Throwable)sQLException);
                    throw sMStaleDataException;
                }
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
            Object var15_18 = null;
        }
        catch (Throwable throwable) {
            Object var15_19 = null;
            MrReportTools.close(callableStatement);
            throw throwable;
        }
        MrReportTools.close(callableStatement);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SMDBObjectID save(SMReportRequest sMReportRequest, Connection connection) throws SMDatabaseException, SMNoSuchObjectException, SMDuplicateException, SMStaleDataException {
        Object object;
        SMDBObjectID sMDBObjectID = null;
        long l = 0L;
        if (connection == null) {
            return sMDBObjectID;
        }
        Connection connection2 = connection;
        String string = sMReportRequest.getName();
        String string2 = sMReportRequest.getDescription();
        int n = sMReportRequest.getRequestDataType();
        int n2 = sMReportRequest.getRequestType();
        long l2 = sMReportRequest.getCategory().getObjectID().getID();
        SMDBObjectID sMDBObjectID2 = null;
        if (sMReportRequest.getSubCategory() != null) {
            sMDBObjectID2 = sMReportRequest.getSubCategory().getObjectID();
        }
        int n3 = sMReportRequest.getReportType();
        String string3 = sMReportRequest.getAgentGroupName();
        String string4 = MrReportTools.getArrayToString(sMReportRequest.getAgentList(), ",");
        String string5 = null;
        int n4 = 0;
        Timestamp timestamp = null;
        Timestamp timestamp2 = null;
        SMReportFilter sMReportFilter = sMReportRequest.getTemplate().getFilter();
        if (sMReportFilter != null) {
            string5 = sMReportFilter.getFunctionName();
            n4 = sMReportFilter.getDaysRange();
            if (sMReportFilter.getStartDate() != null) {
                timestamp = new Timestamp(sMReportFilter.getStartDate().getTime());
            }
            if (sMReportFilter.getEndDate() != null) {
                timestamp2 = new Timestamp(sMReportFilter.getEndDate().getTime());
            }
        }
        String string6 = null;
        int n5 = 0;
        String string7 = null;
        SMReportFormat sMReportFormat = sMReportRequest.getTemplate().getFormat();
        if (sMReportFormat != null) {
            string6 = sMReportFormat.getOutputFormat();
            n5 = sMReportFormat.getDataFocus();
            if (sMReportFormat.getPresentation() != null) {
                string7 = sMReportFormat.getPresentation().getGraphPresentation();
            }
        }
        int n6 = 1;
        if (sMReportRequest.getObjectID() == null) {
            n6 = 2;
        }
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection2.prepareCall("{call sp_save_report_request(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)}");
                callableStatement.registerOutParameter(1, 2);
                callableStatement.registerOutParameter(19, 93);
                callableStatement.registerOutParameter(20, 93);
                callableStatement.registerOutParameter(2, 12);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMReportRequest.getObjectID());
                MSDB.setNullable((PreparedStatement)callableStatement, (int)19, (Timestamp)sMReportRequest.getUpdateTime());
                MSDB.setNullable((PreparedStatement)callableStatement, (int)20, (Timestamp)sMReportRequest.getCreateTime());
                MSDB.setNullable((PreparedStatement)callableStatement, (int)2, (String)string);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)3, (String)string2);
                callableStatement.setLong(4, l2);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)5, (SMDBObjectID)sMDBObjectID2);
                callableStatement.setInt(6, n3);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)7, (String)string5);
                callableStatement.setInt(8, n4);
                if (timestamp != null) {
                    callableStatement.setTimestamp(9, timestamp);
                } else {
                    callableStatement.setNull(9, 93);
                }
                if (timestamp2 != null) {
                    callableStatement.setTimestamp(10, timestamp2);
                } else {
                    callableStatement.setNull(10, 93);
                }
                MSDB.setNullable((PreparedStatement)callableStatement, (int)11, (String)string6);
                callableStatement.setInt(12, n5);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)13, (String)string7);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)14, (String)string3);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)15, (String)string4);
                callableStatement.setInt(16, n);
                callableStatement.setInt(17, n2);
                callableStatement.setString(18, this.getCurrentUserName());
                callableStatement.execute();
                long l3 = callableStatement.getLong(1);
                sMDBObjectID = new SMDBObjectID(l3, "report_request");
                String string8 = callableStatement.getString(2);
                SMDBObjectID sMDBObjectID3 = null;
                if (sMReportRequest.getSubCategory() != null) {
                    sMDBObjectID3 = sMReportRequest.getSubCategory().getObjectID();
                }
                SMReportEvent sMReportEvent = new SMReportEvent(sMDBObjectID, n6, "report_request", string8, sMReportRequest.getCategory().getObjectID(), sMDBObjectID3);
                Vector vector = sMReportRequest.getTemplate().getPropertyGroup().getPropertySet();
                this.save(vector, connection2, l3);
                if (sMReportRequest.getReportType() != 5 && sMReportRequest.getReportType() != 11 && sMReportRequest.getReportType() != 12 && sMReportRequest.getReportType() != 13) {
                    object = null;
                    if (sMReportFilter != null) {
                        object = sMReportFilter.getFilterExp();
                    }
                    this.saveAllFilterCriteria((String)object, l3, connection2);
                }
                connection2.commit();
                MrReportServiceImpl.fireEvent((SMDBChangeEvent)sMReportEvent);
                object = sMDBObjectID;
                Object var36_39 = null;
            }
            catch (SMLengthException sMLengthException) {
                this.debugLogWriter.println("MrReportTemplateController: got SMLengthException exception");
                SMDBObjectID sMDBObjectID4 = null;
                Object var36_40 = null;
                MrReportTools.close(callableStatement);
                return sMDBObjectID4;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.debugLogWriter.println("MrReportTemplateController: got IllegalArgumentException exception");
                SMDBObjectID sMDBObjectID5 = null;
                Object var36_41 = null;
                MrReportTools.close(callableStatement);
                return sMDBObjectID5;
            }
            catch (SQLException sQLException) {
                MSDB.rollback((Connection)connection2);
                this.debugLogWriter.println("MrReportTemplateController: got SQLException exception");
                if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                    throw sMNoSuchObjectException;
                }
                if (sQLException.getMessage().indexOf("DUPLICATE_INDEX") >= 0) {
                    SMDuplicateException sMDuplicateException = new SMDuplicateException((Throwable)sQLException);
                    throw sMDuplicateException;
                }
                if (sQLException.getMessage().indexOf("STALE_DATA") >= 0) {
                    SMStaleDataException sMStaleDataException = new SMStaleDataException((Throwable)sQLException);
                    throw sMStaleDataException;
                }
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
        }
        catch (Throwable throwable) {
            Object var36_42 = null;
            MrReportTools.close(callableStatement);
            throw throwable;
        }
        MrReportTools.close(callableStatement);
        return object;
    }

    public SMDBObjectID save(SMReportRequest sMReportRequest) throws SMDatabaseException, SMNoSuchObjectException, SMDuplicateException, SMStaleDataException {
        SMDBObjectID sMDBObjectID;
        this.debugLogWriter.println("MrReportTemplateController: Inside method save for report request");
        String[] stringArray = sMReportRequest.getIPList();
        String[] stringArray2 = sMReportRequest.getAgentList();
        try {
            if (stringArray2 != null && stringArray != null) {
                stringArray2 = MrReportTools.convertIPtoHostname(stringArray2, stringArray);
                sMReportRequest.setAgentList(stringArray2);
            }
        }
        catch (SMLengthException sMLengthException) {
            this.debugLogWriter.println("MrReportTemplateController: got SMLengthException exception");
            return null;
        }
        Connection connection = MSDB.getConnection();
        try {
            SMDBObjectID sMDBObjectID2;
            sMDBObjectID = sMDBObjectID2 = this.save(sMReportRequest, connection);
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return sMDBObjectID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SMDBObjectID save(SMReportRequest sMReportRequest, String string) throws SMDatabaseException, SMNoSuchObjectException, SMDuplicateException, SMStaleDataException {
        SMDBObjectID sMDBObjectID;
        this.debugLogWriter.println("MrReportTemplateController: Inside method save request with name");
        SMDBObjectID sMDBObjectID2 = null;
        Connection connection = MSDB.getConnection();
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection.prepareCall("{call sp_copy_report_request(?,?,?,?,?,?,?)}");
                callableStatement.registerOutParameter(2, 2);
                callableStatement.registerOutParameter(6, 93);
                callableStatement.registerOutParameter(7, 93);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)6, (Timestamp)sMReportRequest.getUpdateTime());
                MSDB.setNullable((PreparedStatement)callableStatement, (int)7, (Timestamp)sMReportRequest.getCreateTime());
                callableStatement.setLong(1, sMReportRequest.getObjectID().getID());
                callableStatement.setString(3, string);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)4, (String)sMReportRequest.getDescription());
                callableStatement.setString(5, this.getCurrentUserName());
                callableStatement.execute();
                long l = callableStatement.getLong(2);
                sMDBObjectID2 = new SMDBObjectID(l, "report_request");
                SMDBObjectID sMDBObjectID3 = null;
                if (sMReportRequest.getSubCategory() != null) {
                    sMDBObjectID3 = sMReportRequest.getSubCategory().getObjectID();
                }
                SMReportEvent sMReportEvent = new SMReportEvent(sMDBObjectID2, 2, "report_request", string, sMReportRequest.getCategory().getObjectID(), sMDBObjectID3);
                connection.commit();
                MrReportServiceImpl.fireEvent((SMDBChangeEvent)sMReportEvent);
                sMDBObjectID = sMDBObjectID2;
                Object var12_17 = null;
            }
            catch (SMLengthException sMLengthException) {
                this.debugLogWriter.println("MrReportTemplateController: got SMLengthException exception");
                MSDB.rollback((Connection)connection);
                SMDBObjectID sMDBObjectID4 = null;
                Object var12_18 = null;
                MrReportTools.close(callableStatement);
                MSDB.closeConnection((Connection)connection);
                return sMDBObjectID4;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.debugLogWriter.println("MrReportTemplateController: got IllegalArgumentException exception");
                MSDB.rollback((Connection)connection);
                SMDBObjectID sMDBObjectID5 = null;
                Object var12_19 = null;
                MrReportTools.close(callableStatement);
                MSDB.closeConnection((Connection)connection);
                return sMDBObjectID5;
            }
            catch (SQLException sQLException) {
                MSDB.rollback((Connection)connection);
                this.debugLogWriter.println("MrReportTemplateController: got SQLException exception");
                if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                    throw sMNoSuchObjectException;
                }
                if (sQLException.getMessage().indexOf("DUPLICATE_INDEX") >= 0) {
                    SMDuplicateException sMDuplicateException = new SMDuplicateException((Throwable)sQLException);
                    throw sMDuplicateException;
                }
                if (sQLException.getMessage().indexOf("STALE_DATA") >= 0) {
                    SMStaleDataException sMStaleDataException = new SMStaleDataException((Throwable)sQLException);
                    throw sMStaleDataException;
                }
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
        }
        catch (Throwable throwable) {
            Object var12_20 = null;
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MrReportTools.close(callableStatement);
        MSDB.closeConnection((Connection)connection);
        return sMDBObjectID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SMDBObjectID save(SMReportCompositeRequest sMReportCompositeRequest) throws SMDatabaseException, SMNoSuchObjectException, SMDuplicateException, SMStaleDataException {
        this.debugLogWriter.println("MrReportTemplateController: Inside method save for composite request");
        SMDBObjectID sMDBObjectID = null;
        long l = 0L;
        Connection connection = MSDB.getConnection();
        int n = 1;
        if (sMReportCompositeRequest.getObjectID() == null) {
            n = 2;
        }
        CallableStatement callableStatement = null;
        try {
            try {
                SMDBObjectID sMDBObjectID2;
                callableStatement = connection.prepareCall("{call sp_save_composite_request(?,?,?,?,?,?,?,?,?)}");
                callableStatement.registerOutParameter(1, 2);
                callableStatement.registerOutParameter(8, 93);
                callableStatement.registerOutParameter(9, 93);
                callableStatement.registerOutParameter(2, 12);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMReportCompositeRequest.getObjectID());
                MSDB.setNullable((PreparedStatement)callableStatement, (int)8, (Timestamp)sMReportCompositeRequest.getUpdateTime());
                MSDB.setNullable((PreparedStatement)callableStatement, (int)9, (Timestamp)sMReportCompositeRequest.getCreateTime());
                callableStatement.setString(2, sMReportCompositeRequest.getName());
                MSDB.setNullable((PreparedStatement)callableStatement, (int)3, (String)sMReportCompositeRequest.getDescription());
                callableStatement.setLong(4, sMReportCompositeRequest.getCategory().getObjectID().getID());
                SMDBObjectID sMDBObjectID3 = null;
                if (sMReportCompositeRequest.getSubCategory() != null) {
                    sMDBObjectID3 = sMReportCompositeRequest.getSubCategory().getObjectID();
                }
                MSDB.setNullable((PreparedStatement)callableStatement, (int)5, (SMDBObjectID)sMDBObjectID3);
                callableStatement.setInt(6, 6);
                callableStatement.setString(7, this.getCurrentUserName());
                callableStatement.execute();
                String string = callableStatement.getString(2);
                l = callableStatement.getLong(1);
                sMDBObjectID = new SMDBObjectID(l, "report_composite_request");
                Enumeration enumeration = sMReportCompositeRequest.getRequests().elements();
                CallableStatement callableStatement2 = null;
                while (true) {
                    if (!enumeration.hasMoreElements()) {
                        sMDBObjectID2 = null;
                        if (sMReportCompositeRequest.getSubCategory() != null) {
                            sMDBObjectID2 = sMReportCompositeRequest.getSubCategory().getObjectID();
                        }
                        break;
                    }
                    try {
                        SMReportRequest sMReportRequest = (SMReportRequest)enumeration.nextElement();
                        callableStatement2 = connection.prepareCall("{call sp_save_child_request(?,?,?,?,?)}");
                        callableStatement2.setLong(1, l);
                        callableStatement2.registerOutParameter(4, 93);
                        callableStatement2.registerOutParameter(5, 93);
                        callableStatement2.setLong(2, sMReportRequest.getObjectID().getID());
                        callableStatement2.setString(3, this.getCurrentUserName());
                        callableStatement2.execute();
                        callableStatement2.close();
                    }
                    catch (SQLException sQLException) {
                        MrReportTools.close(callableStatement2);
                        throw sQLException;
                    }
                }
                SMReportEvent sMReportEvent = new SMReportEvent(sMDBObjectID, n, "report_composite_request", string, sMReportCompositeRequest.getCategory().getObjectID(), sMDBObjectID2);
                connection.commit();
                MrReportServiceImpl.fireEvent((SMDBChangeEvent)sMReportEvent);
                SMDBObjectID sMDBObjectID4 = sMDBObjectID;
                Object var17_25 = null;
                MrReportTools.close(callableStatement);
                MSDB.closeConnection((Connection)connection);
                return sMDBObjectID4;
            }
            catch (SMLengthException sMLengthException) {
                this.debugLogWriter.println("MrReportTemplateController: got SMLengthException exception");
                MSDB.rollback((Connection)connection);
                SMDBObjectID sMDBObjectID5 = null;
                Object var17_26 = null;
                MrReportTools.close(callableStatement);
                MSDB.closeConnection((Connection)connection);
                return sMDBObjectID5;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.debugLogWriter.println("MrReportTemplateController: got IllegalArgumentException exception");
                MSDB.rollback((Connection)connection);
                SMDBObjectID sMDBObjectID6 = null;
                Object var17_27 = null;
                MrReportTools.close(callableStatement);
                MSDB.closeConnection((Connection)connection);
                return sMDBObjectID6;
            }
            catch (SQLException sQLException) {
                MSDB.rollback((Connection)connection);
                this.debugLogWriter.println("MrReportTemplateController: got SQLException exception");
                if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                    throw sMNoSuchObjectException;
                }
                if (sQLException.getMessage().indexOf("DUPLICATE_INDEX") >= 0) {
                    SMDuplicateException sMDuplicateException = new SMDuplicateException((Throwable)sQLException);
                    throw sMDuplicateException;
                }
                if (sQLException.getMessage().indexOf("STALE_DATA") >= 0) {
                    SMStaleDataException sMStaleDataException = new SMStaleDataException((Throwable)sQLException);
                    throw sMStaleDataException;
                }
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
        }
        catch (Throwable throwable) {
            Object var17_28 = null;
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SMDBObjectID save(SMReportCompositeRequest sMReportCompositeRequest, String string) throws SMDatabaseException, SMNoSuchObjectException, SMDuplicateException, SMStaleDataException {
        SMDBObjectID sMDBObjectID;
        this.debugLogWriter.println("MrReportTemplateController: Inside method save composite request with name");
        SMDBObjectID sMDBObjectID2 = null;
        Connection connection = MSDB.getConnection();
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection.prepareCall("{call sp_copy_report_request(?,?,?,?,?,?,?)}");
                callableStatement.registerOutParameter(2, 2);
                callableStatement.registerOutParameter(6, 93);
                callableStatement.registerOutParameter(7, 93);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)6, (Timestamp)sMReportCompositeRequest.getUpdateTime());
                MSDB.setNullable((PreparedStatement)callableStatement, (int)7, (Timestamp)sMReportCompositeRequest.getCreateTime());
                callableStatement.setLong(1, sMReportCompositeRequest.getObjectID().getID());
                callableStatement.setString(3, string);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)4, (String)sMReportCompositeRequest.getDescription());
                callableStatement.setString(5, this.getCurrentUserName());
                callableStatement.execute();
                long l = callableStatement.getLong(2);
                sMDBObjectID2 = new SMDBObjectID(l, "report_composite_request");
                SMDBObjectID sMDBObjectID3 = null;
                if (sMReportCompositeRequest.getSubCategory() != null) {
                    sMDBObjectID3 = sMReportCompositeRequest.getSubCategory().getObjectID();
                }
                SMReportEvent sMReportEvent = new SMReportEvent(sMDBObjectID2, 2, "report_composite_request", string, sMReportCompositeRequest.getCategory().getObjectID(), sMDBObjectID3);
                connection.commit();
                MrReportServiceImpl.fireEvent((SMDBChangeEvent)sMReportEvent);
                sMDBObjectID = sMDBObjectID2;
                Object var12_17 = null;
            }
            catch (SMLengthException sMLengthException) {
                MSDB.rollback((Connection)connection);
                this.debugLogWriter.println("MrReportTemplateController: got SMLengthException exception");
                SMDBObjectID sMDBObjectID4 = null;
                Object var12_18 = null;
                MrReportTools.close(callableStatement);
                MSDB.closeConnection((Connection)connection);
                return sMDBObjectID4;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                MSDB.rollback((Connection)connection);
                this.debugLogWriter.println("MrReportTemplateController: got IllegalArgumentException exception");
                SMDBObjectID sMDBObjectID5 = null;
                Object var12_19 = null;
                MrReportTools.close(callableStatement);
                MSDB.closeConnection((Connection)connection);
                return sMDBObjectID5;
            }
            catch (SQLException sQLException) {
                MSDB.rollback((Connection)connection);
                this.debugLogWriter.println("MrReportTemplateController: got SQLException exception");
                if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                    throw sMNoSuchObjectException;
                }
                if (sQLException.getMessage().indexOf("DUPLICATE_INDEX") >= 0) {
                    SMDuplicateException sMDuplicateException = new SMDuplicateException((Throwable)sQLException);
                    throw sMDuplicateException;
                }
                if (sQLException.getMessage().indexOf("STALE_DATA") >= 0) {
                    SMStaleDataException sMStaleDataException = new SMStaleDataException((Throwable)sQLException);
                    throw sMStaleDataException;
                }
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
        }
        catch (Throwable throwable) {
            Object var12_20 = null;
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MrReportTools.close(callableStatement);
        MSDB.closeConnection((Connection)connection);
        return sMDBObjectID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteReportRequest(SMDBObjectID sMDBObjectID) throws SMDatabaseException, SMNoSuchObjectException, SMReferenceExistsException {
        this.debugLogWriter.println("MrReportTemplateController: Inside method deleteReportRequest");
        Connection connection = MSDB.getConnection();
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection.prepareCall("{call sp_delete_report_request(?)}");
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMDBObjectID);
                callableStatement.execute();
                connection.commit();
                SMReportEvent sMReportEvent = new SMReportEvent(sMDBObjectID, 3, "report_request", null, null, null);
                MrReportServiceImpl.fireEvent((SMDBChangeEvent)sMReportEvent);
            }
            catch (SMLengthException sMLengthException) {
                MSDB.rollback((Connection)connection);
                this.debugLogWriter.println("MrReportTemplateController: got SMLengthException exception");
                Object var9_7 = null;
                MrReportTools.close(callableStatement);
                MSDB.closeConnection((Connection)connection);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                MSDB.rollback((Connection)connection);
                this.debugLogWriter.println("MrReportTemplateController: got IllegalArgumentException exception");
                Object var9_8 = null;
                MrReportTools.close(callableStatement);
                MSDB.closeConnection((Connection)connection);
                return;
            }
            catch (SQLException sQLException) {
                MSDB.rollback((Connection)connection);
                this.debugLogWriter.println("MrReportTemplateController: got SQLException exception");
                if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                    throw sMNoSuchObjectException;
                }
                if (sQLException.getMessage().indexOf(REFERENCES_EXIST) >= 0) {
                    SMReferenceExistsException sMReferenceExistsException = new SMReferenceExistsException((Throwable)sQLException);
                    throw sMReferenceExistsException;
                }
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
            Object var9_6 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MrReportTools.close(callableStatement);
        MSDB.closeConnection((Connection)connection);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteReportCompositeRequest(SMDBObjectID sMDBObjectID) throws SMDatabaseException, SMNoSuchObjectException, SMReferenceExistsException {
        this.debugLogWriter.println("MrReportTemplateController: Inside method deleteReportCompositeRequest");
        Connection connection = MSDB.getConnection();
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection.prepareCall("{call sp_delete_report_request(?)}");
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMDBObjectID);
                callableStatement.execute();
                connection.commit();
                SMReportEvent sMReportEvent = new SMReportEvent(sMDBObjectID, 3, "report_composite_request", null, null, null);
                MrReportServiceImpl.fireEvent((SMDBChangeEvent)sMReportEvent);
            }
            catch (SMLengthException sMLengthException) {
                MSDB.rollback((Connection)connection);
                this.debugLogWriter.println("MrReportTemplateController: got SMLengthException exception");
                Object var9_7 = null;
                MrReportTools.close(callableStatement);
                MSDB.closeConnection((Connection)connection);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                MSDB.rollback((Connection)connection);
                this.debugLogWriter.println("MrReportTemplateController: got IllegalArgumentException exception");
                Object var9_8 = null;
                MrReportTools.close(callableStatement);
                MSDB.closeConnection((Connection)connection);
                return;
            }
            catch (SQLException sQLException) {
                MSDB.rollback((Connection)connection);
                this.debugLogWriter.println("MrReportTemplateController: got SQLException exception");
                if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                    throw sMNoSuchObjectException;
                }
                if (sQLException.getMessage().indexOf(REFERENCES_EXIST) >= 0) {
                    SMReferenceExistsException sMReferenceExistsException = new SMReferenceExistsException((Throwable)sQLException);
                    throw sMReferenceExistsException;
                }
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
            Object var9_6 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MrReportTools.close(callableStatement);
        MSDB.closeConnection((Connection)connection);
    }

    private void getReportHosts(int n, Connection connection, Vector vector) throws SMDatabaseException, SMNoSuchObjectException {
        this.debugLogWriter.println("MrReportTemplateController: Inside method getReportHosts, cstate = " + n);
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection.prepareCall("{call sp_get_prm_hosts(?,?,?)}");
                callableStatement.setInt(1, n);
                MrReportTools.setDate(callableStatement, 2, new Date());
                callableStatement.registerOutParameter(3, -10);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(3);
                String string = null;
                String string2 = null;
                int n2 = 0;
                boolean bl = false;
                SMReportHost sMReportHost = null;
                Date date = null;
                while (oracleResultSet.next()) {
                    try {
                        string = oracleResultSet.getString("ip_address");
                        string2 = oracleResultSet.getString("hostname");
                        n2 = oracleResultSet.getInt("port");
                        date = MrReportTools.getDate(oracleResultSet, "timestamp");
                        bl = oracleResultSet.getInt("alert_flag") == 0;
                        long l = 0L;
                        if (date != null) {
                            l = date.getTime();
                        }
                        sMReportHost = new SMReportHost(string, string2, n2, n, bl, l);
                        vector.addElement(sMReportHost);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.debugLogWriter.println("MrReportTemplateController: Exception in forming SMReporthosts error.");
                    }
                }
            }
            catch (SQLException sQLException) {
                this.debugLogWriter.println("MrReportTemplateController: got SQLException exception");
                if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                    throw sMNoSuchObjectException;
                }
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
            Object var15_17 = null;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            MrReportTools.close(callableStatement);
            throw throwable;
        }
        MrReportTools.close(callableStatement);
        this.debugLogWriter.println("MrReportTemplateController: Hosts being returned from getReportHosts = " + vector);
    }

    public SMReportHost[] getPRMHosts(int n) throws SMDatabaseException, SMNoSuchObjectException {
        Object[] objectArray;
        this.debugLogWriter.println("MrReportTemplateController: Inside method getPRMHosts, cstate = " + n);
        Connection connection = MSDB.getConnection();
        Vector vector = new Vector();
        try {
            switch (n) {
                case 1: 
                case 2: 
                case 3: {
                    this.getReportHosts(n, connection, vector);
                    break;
                }
                case 0: {
                    this.getReportHosts(1, connection, vector);
                    this.getReportHosts(2, connection, vector);
                    this.getReportHosts(3, connection, vector);
                }
            }
            this.debugLogWriter.println("MrReportTemplateController: Hosts being returned = " + vector);
            Object[] objectArray2 = new SMReportHost[vector.size()];
            vector.copyInto(objectArray2);
            objectArray = objectArray2;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return objectArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getLoggedProperties(String string, int n) throws SMDatabaseException, SMNoSuchObjectException, UnknownHostException {
        Vector<SMReportProperty> vector;
        this.debugLogWriter.println("MrReportTemplateController: Inside method getLoggedProperties, Host = " + string + " Port=" + n);
        MSReportHostAddrMapper mSReportHostAddrMapper = MSReportHostAddrMapper.getInstance();
        String string2 = mSReportHostAddrMapper.getIPAddress(string);
        this.debugLogWriter.println("MrReportTemplateController: Inside method getLoggedProperties, Host = " + string2 + " Port=" + n);
        Connection connection = MSDB.getConnection();
        CallableStatement callableStatement = null;
        Vector<SMReportProperty> vector2 = new Vector<SMReportProperty>();
        try {
            try {
                callableStatement = connection.prepareCall("{call sp_get_logged_properties(?,?,?,?)}");
                callableStatement.setString(1, string2);
                callableStatement.setInt(2, n);
                MrReportTools.setDate(callableStatement, 3, new Date());
                callableStatement.registerOutParameter(4, -10);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(4);
                SMReportProperty sMReportProperty = null;
                while (true) {
                    if (!oracleResultSet.next()) {
                        vector = vector2;
                        Object var12_14 = null;
                        break;
                    }
                    sMReportProperty = new SMReportProperty(oracleResultSet.getString("property"), oracleResultSet.getString("property_instance"), oracleResultSet.getString("module"), oracleResultSet.getString("module_instance"), oracleResultSet.getString("units"), new SMDBObjectID(oracleResultSet.getLong("property_id"), "report_property"));
                    sMReportProperty.setDataType(oracleResultSet.getString("data_type"));
                    sMReportProperty.setLovPresent(oracleResultSet.getString("lov_available"));
                    sMReportProperty.setI18nKey(oracleResultSet.getString("i18n_key"));
                    sMReportProperty.setFilterAllowed(oracleResultSet.getString("filter_allowed"));
                    sMReportProperty.setPropertyType(5);
                    sMReportProperty.setChanged(false);
                    this.debugLogWriter.println("MrReportTemplateController: got the property " + sMReportProperty.toString());
                    vector2.addElement(sMReportProperty);
                }
            }
            catch (SQLException sQLException) {
                this.debugLogWriter.println("MrReportTemplateController: got SQLException exception");
                if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                    throw sMNoSuchObjectException;
                }
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MrReportTools.close(callableStatement);
        MSDB.closeConnection((Connection)connection);
        return vector;
    }

    public String getCurrentUserName() {
        ScSecurityCredential scSecurityCredential = this.service.getUserSecurityCredential();
        return scSecurityCredential.getUser();
    }
}

