/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.report;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.report.SMProcessData;
import com.sun.symon.base.client.report.SMReferenceExistsException;
import com.sun.symon.base.client.report.SMReportCategory;
import com.sun.symon.base.client.report.SMReportCompositeRequest;
import com.sun.symon.base.client.report.SMReportData;
import com.sun.symon.base.client.report.SMReportHost;
import com.sun.symon.base.client.report.SMReportRequest;
import com.sun.symon.base.client.report.SMReportRequestInfo;
import com.sun.symon.base.client.report.SMReportServiceInterface;
import com.sun.symon.base.client.report.SMReportSubCategory;
import com.sun.symon.base.client.report.SMScheduledRequestStatus;
import com.sun.symon.base.client.service.SMDBChangeEvent;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMDBRemoteChangeListener;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.client.service.SMDuplicateException;
import com.sun.symon.base.client.service.SMNoSuchObjectException;
import com.sun.symon.base.client.service.SMSecurityException;
import com.sun.symon.base.client.service.SMStaleDataException;
import com.sun.symon.base.mgmtservice.collect.McCollectService;
import com.sun.symon.base.mgmtservice.collect.task.McProbeCommand;
import com.sun.symon.base.mgmtservice.common.MSDBChangeMulticaster;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.framework.MSBaseService;
import com.sun.symon.base.mgmtservice.report.MrReportConstants;
import com.sun.symon.base.mgmtservice.report.MrReportDataController;
import com.sun.symon.base.mgmtservice.report.MrReportFileController;
import com.sun.symon.base.mgmtservice.report.MrReportTemplateController;
import com.sun.symon.base.server.common.ScSecurityCredential;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Vector;

public class MrReportServiceImpl
extends MSBaseService
implements SMReportServiceInterface,
MrReportConstants {
    private MSLogPrintWriter errorLogWriter = MSLogPrintWriter.getErrorWriter();
    private MSLogPrintWriter warningLogWriter = MSLogPrintWriter.getWarningWriter();
    private MSLogPrintWriter infoLogWriter = MSLogPrintWriter.getInfoWriter();
    private MSLogPrintWriter debugLogWriter = MSLogPrintWriter.getDebugWriter();
    private MrReportDataController dataController;
    private MrReportTemplateController templateController = new MrReportTemplateController(this);
    private MrReportFileController fileController;
    private static MSDBChangeMulticaster dbEventHandler = new MSDBChangeMulticaster();

    public MrReportServiceImpl(ScSecurityCredential scSecurityCredential, String string) throws RemoteException, SMSecurityException {
        super("ReportService", scSecurityCredential, string);
        this.dataController = new MrReportDataController(this, this.templateController);
        this.fileController = new MrReportFileController();
        this.debugLogWriter.println("MrReportService: Service object instantiated");
    }

    public void finalize() throws Throwable {
        this.debugLogWriter.println("MrReportService: finalize called for Impl class.");
    }

    public void cleanup() {
        this.debugLogWriter.println("MrReportService: cleanup Called for Impl Class");
        dbEventHandler.remove((MSBaseService)this);
        this.errorLogWriter = null;
        this.warningLogWriter = null;
        this.infoLogWriter = null;
        this.debugLogWriter = null;
        this.dataController = null;
        this.templateController = null;
        this.fileController = null;
    }

    public void addEventListener(SMDBRemoteChangeListener sMDBRemoteChangeListener) throws RemoteException {
        this.debugLogWriter.println("MrReportService: Received request to add a listener");
        dbEventHandler.add((MSBaseService)this, sMDBRemoteChangeListener);
        this.debugLogWriter.println("MrReportService: Added a listener");
    }

    public void removeEventListener(SMDBRemoteChangeListener sMDBRemoteChangeListener) throws RemoteException {
        this.debugLogWriter.println("MrReportService: Received request to remove a listener");
        dbEventHandler.remove((MSBaseService)this, sMDBRemoteChangeListener);
        this.debugLogWriter.println("MrReportService: Removed a listener");
    }

    public static void fireEvent(SMDBChangeEvent sMDBChangeEvent) {
        dbEventHandler.fireEvent(sMDBChangeEvent);
    }

    public int getMaxAllowedRecords() throws RemoteException {
        return this.dataController.getMaxAllowedRecords();
    }

    public int getPageSize() throws RemoteException {
        return this.dataController.getPageSize();
    }

    public int getMaxPages() throws RemoteException {
        return this.dataController.getMaxPages();
    }

    public int getMaxNumberOfRequests() throws RemoteException {
        return this.dataController.getMaxNumberOfRequests();
    }

    public void setMaxAllowedRecords(int n) throws RemoteException {
        this.dataController.setMaxAllowedRecords(n);
    }

    public void setPageSize(int n) throws RemoteException {
        this.dataController.setPageSize(n);
    }

    public void setMaxNumberOfRequests(int n) throws RemoteException {
        this.dataController.setMaxNumberOfRequests(n);
    }

    public SMReportCategory[] getAllCategory() throws RemoteException, SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        this.checkAccess("getAllCategory");
        return this.templateController.getAllCategory();
    }

    public SMReportSubCategory[] getAllSubCategory(SMReportCategory sMReportCategory) throws RemoteException, SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        this.checkAccess("getAllSubCategory");
        return this.templateController.getAllSubCategory(sMReportCategory);
    }

    public SMReportCategory getReportCategory(SMDBObjectID sMDBObjectID) throws RemoteException, SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        this.checkAccess("getReportCategory");
        return this.templateController.getReportCategory(sMDBObjectID);
    }

    public SMReportSubCategory getReportSubCategory(SMDBObjectID sMDBObjectID) throws RemoteException, SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        this.checkAccess("getReportSubCategory");
        return this.templateController.getReportSubCategory(sMDBObjectID);
    }

    public SMDBObjectID save(SMReportCategory sMReportCategory) throws RemoteException, SMSecurityException, SMNoSuchObjectException, SMDuplicateException, SMStaleDataException, SMDatabaseException {
        this.checkAccess("save");
        return this.templateController.save(sMReportCategory);
    }

    public SMDBObjectID save(SMReportSubCategory sMReportSubCategory) throws RemoteException, SMSecurityException, SMNoSuchObjectException, SMDuplicateException, SMStaleDataException, SMDatabaseException {
        this.checkAccess("save");
        return this.templateController.save(sMReportSubCategory);
    }

    public void deleteCategory(SMDBObjectID sMDBObjectID) throws RemoteException, SMSecurityException, SMNoSuchObjectException, SMReferenceExistsException, SMDatabaseException {
        this.checkAccess("deleteCategory");
        this.templateController.deleteCategory(sMDBObjectID);
    }

    public void deleteSubCategory(SMDBObjectID sMDBObjectID) throws RemoteException, SMSecurityException, SMNoSuchObjectException, SMReferenceExistsException, SMDatabaseException {
        this.checkAccess("deleteSubCategory");
        this.templateController.deleteSubCategory(sMDBObjectID);
    }

    public Vector getAllOperators(String string) throws RemoteException, SMSecurityException, SMDatabaseException, SMNoSuchObjectException {
        this.checkAccess("getAllOperators");
        return this.templateController.getAllOperators(string);
    }

    public Vector getPropertyValues(String string) throws RemoteException, SMSecurityException, SMDatabaseException, SMNoSuchObjectException {
        this.checkAccess("getPropertyValues");
        return this.templateController.getPropertyValues(string);
    }

    public Vector getProperties(int n) throws RemoteException, SMSecurityException, SMDatabaseException, SMNoSuchObjectException {
        this.checkAccess("getProperties");
        return this.templateController.getProperties(n);
    }

    public SMReportRequestInfo[] getAllReportRequestInfo(SMDBObjectID sMDBObjectID, SMDBObjectID sMDBObjectID2) throws RemoteException, SMNoSuchObjectException, SMSecurityException, SMDatabaseException {
        this.checkAccess("getAllReportRequestInfo");
        return this.templateController.getAllReportRequestInfo(sMDBObjectID, sMDBObjectID2);
    }

    public SMReportRequest getReportRequest(SMDBObjectID sMDBObjectID) throws RemoteException, SMNoSuchObjectException, SMSecurityException, SMDatabaseException {
        this.checkAccess("getReportRequest");
        return this.templateController.getReportRequest(sMDBObjectID);
    }

    public SMReportCompositeRequest getCompositeRequest(SMDBObjectID sMDBObjectID) throws RemoteException, SMNoSuchObjectException, SMSecurityException, SMDatabaseException {
        this.checkAccess("getCompositeRequest");
        return this.templateController.getCompositeRequest(sMDBObjectID);
    }

    public SMReportRequest[] getAllReportRequest(SMDBObjectID sMDBObjectID, SMDBObjectID sMDBObjectID2) throws RemoteException, SMNoSuchObjectException, SMSecurityException, SMDatabaseException {
        this.checkAccess("getAllReportRequest");
        return this.templateController.getAllReportRequest(sMDBObjectID, sMDBObjectID2);
    }

    public SMReportCompositeRequest[] getAllCompositeReportRequest() throws RemoteException, SMNoSuchObjectException, SMSecurityException, SMDatabaseException {
        this.checkAccess("getAllCompositeReportRequest");
        return this.templateController.getAllCompositeReportRequest();
    }

    public SMDBObjectID save(SMReportRequest sMReportRequest) throws RemoteException, SMNoSuchObjectException, SMDuplicateException, SMStaleDataException, SMSecurityException, SMDatabaseException {
        this.checkAccess("save");
        return this.templateController.save(sMReportRequest);
    }

    public SMDBObjectID save(SMReportRequest sMReportRequest, String string) throws RemoteException, SMNoSuchObjectException, SMDuplicateException, SMStaleDataException, SMSecurityException, SMDatabaseException {
        this.checkAccess("save");
        return this.templateController.save(sMReportRequest, string);
    }

    public SMDBObjectID save(SMReportCompositeRequest sMReportCompositeRequest) throws RemoteException, SMNoSuchObjectException, SMDuplicateException, SMStaleDataException, SMSecurityException, SMDatabaseException {
        this.checkAccess("save");
        return this.templateController.save(sMReportCompositeRequest);
    }

    public SMDBObjectID save(SMReportCompositeRequest sMReportCompositeRequest, String string) throws RemoteException, SMNoSuchObjectException, SMDuplicateException, SMStaleDataException, SMSecurityException, SMDatabaseException {
        this.checkAccess("save");
        return this.templateController.save(sMReportCompositeRequest, string);
    }

    public void deleteReportRequest(SMDBObjectID sMDBObjectID) throws RemoteException, SMNoSuchObjectException, SMReferenceExistsException, SMSecurityException, SMDatabaseException {
        this.checkAccess("deleteReportRequest");
        this.templateController.deleteReportRequest(sMDBObjectID);
    }

    public void deleteReportCompositeRequest(SMDBObjectID sMDBObjectID) throws RemoteException, SMNoSuchObjectException, SMReferenceExistsException, SMSecurityException, SMDatabaseException {
        this.checkAccess("deleteReportCompositeRequest");
        this.templateController.deleteReportCompositeRequest(sMDBObjectID);
    }

    public SMReportData runReportRequest(SMReportRequest sMReportRequest, int n, String[] stringArray, String string, int n2) throws RemoteException, SMNoSuchObjectException, SMAPIException, SMSecurityException, UnknownHostException, SMDatabaseException {
        this.checkAccess("runReportRequest");
        return this.dataController.runReportRequest(sMReportRequest, n, stringArray, string, n2);
    }

    public SMReportData runReportRequest(SMReportRequest sMReportRequest, String[] stringArray, int n, int n2) throws RemoteException, SMNoSuchObjectException, SMAPIException, SMSecurityException, UnknownHostException, SMDatabaseException {
        this.checkAccess("runReportRequest");
        return this.dataController.runReportRequest(sMReportRequest, stringArray, n, n2);
    }

    public SMReportData runReportRequest(SMDBObjectID sMDBObjectID, int n, String[] stringArray, Date date, Date date2, String string, String string2, int n2) throws RemoteException, SMNoSuchObjectException, SMAPIException, SMSecurityException, UnknownHostException, SMDatabaseException {
        this.checkAccess("runReportRequest");
        return this.dataController.runReportRequest(sMDBObjectID, n, stringArray, date, date2, string, string2, n2);
    }

    public SMReportData runReportRequest(SMDBObjectID sMDBObjectID, String[] stringArray, Date date, Date date2, String string, int n, int n2, int n3) throws RemoteException, SMNoSuchObjectException, SMAPIException, SMSecurityException, UnknownHostException, SMDatabaseException {
        this.checkAccess("runReportRequest");
        return this.dataController.runReportRequest(sMDBObjectID, stringArray, date, date2, string, n, n2, n3);
    }

    public SMReportData runReportRequest(SMReportRequest sMReportRequest, String[] stringArray, int n, int n2, int n3) throws RemoteException, SMNoSuchObjectException, SMAPIException, SMSecurityException, UnknownHostException, SMDatabaseException {
        this.checkAccess("runReportRequest");
        return this.dataController.runReportRequest(sMReportRequest, stringArray, n, n2, n3);
    }

    public SMReportData[] runReportCompositeRequest(SMDBObjectID sMDBObjectID, int n) throws RemoteException, SMSecurityException, SMAPIException, UnknownHostException, SMDatabaseException {
        this.checkAccess("runReportCompositeRequest");
        return this.dataController.runReportCompositeRequest(sMDBObjectID, n);
    }

    public SMReportData getPageData(int n, int n2, int n3, String string, int n4) throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("getPageData");
        return this.dataController.getPageData(n, n2, n3, string, n4);
    }

    public SMReportData getPageData(int n, int n2, String string, int n3) throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("getPageData");
        return this.dataController.getPageData(n, n2, string, n3);
    }

    public SMProcessData getProcessData(String string, Date date, Date date2, String string2) throws RemoteException, SMSecurityException, UnknownHostException, SMAPIException {
        this.checkAccess("getProcessData");
        return this.dataController.getProcessData(string, date, date2, string2);
    }

    public SMReportData getAlarmData(String string, int n, Date date, Date date2) throws RemoteException, SMSecurityException, UnknownHostException, SMDatabaseException {
        this.checkAccess("getAlarmData");
        return this.dataController.getAlarmData(string, n, date, date2);
    }

    public boolean scheduleRequest(SMDBObjectID sMDBObjectID, String[] stringArray, long l, long l2, int n) throws RemoteException, SMSecurityException, SMAPIException {
        this.checkAccess("scheduleReportRequest");
        return this.dataController.scheduleRequest(sMDBObjectID, stringArray, l, l2, n);
    }

    public boolean removeScheduledRequest(SMDBObjectID sMDBObjectID) throws RemoteException, SMSecurityException, SMAPIException {
        this.checkAccess("removeScheduledRequest");
        return this.dataController.removeScheduledRequest(sMDBObjectID);
    }

    public SMScheduledRequestStatus[] getScheduledRequestStatus() throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("getScheduledRequestStatus");
        return this.dataController.getScheduledRequestStatus();
    }

    public SMReportRequestInfo[] getScheduleableRequests(boolean bl) throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("getScheduleableRequests");
        return this.templateController.getScheduleableRequests(bl);
    }

    public String createReportDir(String string) throws RemoteException, SMSecurityException, SMAPIException {
        this.checkAccess("createReportDir");
        return this.fileController.createReportDir(string);
    }

    public void changeReportDirOwner(String string) throws RemoteException, SMSecurityException, SMAPIException {
        this.checkAccess("changeReportDirOwner");
        this.fileController.changeReportDirOwner(string);
    }

    public void postFile(byte[] byArray, byte[] byArray2, byte[] byArray3) throws RemoteException, SMSecurityException, SMAPIException {
        this.checkAccess("postFile");
        this.fileController.postFile(byArray, byArray2, byArray3);
    }

    public SMReportHost[] getPRMHosts(int n) throws SMDatabaseException, SMNoSuchObjectException, SMSecurityException, RemoteException {
        this.checkAccess("getPRMHosts");
        return this.templateController.getPRMHosts(n);
    }

    public void stopDataCollection(String string, int n) throws SMAPIException, SMSecurityException, SMDatabaseException, RemoteException, UnknownHostException {
        this.checkAccess("stopDataCollection");
        this.dataController.stopDataCollection(string, n);
    }

    public void startDataCollection(String string, int n) throws SMAPIException, SMSecurityException, SMDatabaseException, RemoteException, UnknownHostException {
        this.checkAccess("startDataCollection");
        this.dataController.startDataCollection(string, n);
    }

    public Vector getLoggedProperties(String string, int n) throws SMDatabaseException, SMSecurityException, SMNoSuchObjectException, UnknownHostException, RemoteException {
        this.checkAccess("getLoggedProperties");
        return this.templateController.getLoggedProperties(string, n);
    }

    public void collectData(String string, int n) throws RemoteException {
        System.out.println("#############");
        SMAPIException sMAPIException = null;
        McCollectService mcCollectService = McCollectService.getInstance();
        if (!mcCollectService.collectDataFromAgent(string + ":" + n)) {
            return;
        }
        try {
            McProbeCommand mcProbeCommand = new McProbeCommand(mcCollectService);
            mcProbeCommand.setRequest("REPDATA", null);
            mcProbeCommand.sendToAgent(string, n);
        }
        catch (Exception exception) {
            sMAPIException = exception instanceof SMAPIException ? (SMAPIException)((Object)exception) : new SMAPIException((Throwable)exception);
        }
    }

    public Date getCurrentServerDate() throws RemoteException {
        return new Date();
    }

    public boolean deleteReports(String[] stringArray, String string) throws SMSecurityException, RemoteException {
        this.checkAccess("deleteWebReports");
        return this.fileController.deleteReports(stringArray, string);
    }
}

