/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.report;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.module.SMModuleRequest;
import com.sun.symon.base.client.report.SMProcessData;
import com.sun.symon.base.client.report.SMReportCompositeRequest;
import com.sun.symon.base.client.report.SMReportData;
import com.sun.symon.base.client.report.SMReportFilter;
import com.sun.symon.base.client.report.SMReportProperty;
import com.sun.symon.base.client.report.SMReportPropertyGroup;
import com.sun.symon.base.client.report.SMReportRequest;
import com.sun.symon.base.client.report.SMReportTemplate;
import com.sun.symon.base.client.report.SMScheduledRequestStatus;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.client.service.SMNoSuchObjectException;
import com.sun.symon.base.client.service.SMSecurityException;
import com.sun.symon.base.mgmtservice.collect.McAgentLogData;
import com.sun.symon.base.mgmtservice.collect.McAgentProperty;
import com.sun.symon.base.mgmtservice.collect.McAgentUptimeData;
import com.sun.symon.base.mgmtservice.collect.McCollectService;
import com.sun.symon.base.mgmtservice.collect.McLogData;
import com.sun.symon.base.mgmtservice.common.MSDB;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.common.MSReportHostAddrMapper;
import com.sun.symon.base.mgmtservice.report.MrReportCachedData;
import com.sun.symon.base.mgmtservice.report.MrReportDataCacheTable;
import com.sun.symon.base.mgmtservice.report.MrReportServiceImpl;
import com.sun.symon.base.mgmtservice.report.MrReportStoredProcedures;
import com.sun.symon.base.mgmtservice.report.MrReportTemplateController;
import com.sun.symon.base.mgmtservice.report.MrReportTools;
import com.sun.symon.base.server.common.ScSecurityCredential;
import com.sun.symon.base.utility.UcBeanIntrospector;
import com.sun.symon.base.utility.UcListUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

public class MrReportDataController
implements MrReportStoredProcedures {
    private MSLogPrintWriter errorLogWriter = MSLogPrintWriter.getErrorWriter();
    private MSLogPrintWriter warningLogWriter = MSLogPrintWriter.getWarningWriter();
    private MSLogPrintWriter infoLogWriter = MSLogPrintWriter.getInfoWriter();
    private MSLogPrintWriter debugLogWriter = MSLogPrintWriter.getDebugWriter();
    private MrReportServiceImpl service;
    private MrReportTemplateController templController;
    private MrReportDataCacheTable cacheTable = new MrReportDataCacheTable(10);
    private int topoport = 0;
    private int pageSize = 50;
    private int maxPages = 50;
    private int maxAllowedRecords = 10000;
    private static String SERVERCONFIGFILE = "javaserver.properties";
    private static String DOMAINCONFIGFILE = "domain-config.x";
    private static String PERFTOOLMODULE = "perftool";

    public MrReportDataController(MrReportServiceImpl mrReportServiceImpl, MrReportTemplateController mrReportTemplateController) {
        this.adjustMaxPages();
        this.service = mrReportServiceImpl;
        this.templController = mrReportTemplateController;
        try {
            UcBeanIntrospector ucBeanIntrospector = new UcBeanIntrospector();
            ucBeanIntrospector.readProperties(DOMAINCONFIGFILE, 0);
            ucBeanIntrospector.readProperties(SERVERCONFIGFILE);
            ucBeanIntrospector.apply((Object)this);
        }
        catch (Exception exception) {
            this.debugLogWriter.println("MrReportDataController: Exception in instantiating UcBeanIntrospector");
        }
    }

    public void finalize() throws Throwable {
        this.debugLogWriter.println("MrReportDataController: finalize Called for DataController");
        this.errorLogWriter = null;
        this.warningLogWriter = null;
        this.infoLogWriter = null;
        this.debugLogWriter = null;
        this.service = null;
        this.templController = null;
        this.cacheTable = null;
    }

    public void setTopologyPort(int n) {
        this.topoport = n;
    }

    public int getMaxAllowedRecords() {
        return this.maxAllowedRecords;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getMaxPages() {
        return this.maxPages;
    }

    public int getMaxNumberOfRequests() {
        return this.cacheTable.getNumberOfCaches();
    }

    public synchronized void setMaxAllowedRecords(int n) {
        this.maxAllowedRecords = n;
        this.adjustMaxPages();
    }

    public synchronized void setPageSize(int n) {
        this.pageSize = n;
        this.debugLogWriter.println("MrReportDataController: Page size set to " + this.pageSize);
        this.adjustMaxPages();
    }

    public void setMaxNumberOfRequests(int n) {
        this.cacheTable.setNumberOfCaches(n);
        this.debugLogWriter.println("MrReportDataController: Max requests set to " + n);
    }

    private synchronized void adjustMaxPages() {
        int n = this.maxAllowedRecords / this.pageSize;
        int n2 = this.maxAllowedRecords % this.pageSize;
        this.maxPages = n2 == 0 ? n : n + 1;
        this.debugLogWriter.println("MrReportDataController: Max pages set to " + this.maxPages);
    }

    protected SMReportData readDataFromFile(String string, int n, int n2, Hashtable hashtable, McLogData mcLogData, int n3) {
        File file;
        int n4;
        int n5 = mcLogData.totalLines();
        boolean bl = false;
        if (n5 > this.maxAllowedRecords) {
            n5 = this.maxAllowedRecords;
            bl = true;
        }
        if ((n4 = hashtable.size()) == 0) {
            this.debugLogWriter.println("MrReportDataController: number of properties = 0");
            return null;
        }
        if (n > n5) {
            n = n5;
        }
        if (n2 > n5) {
            n2 = n5;
        }
        if (!(file = new File(string)).canRead()) {
            this.debugLogWriter.println("MrReportDataController: Can not read" + string);
            return null;
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            long l = mcLogData.getLinePosition(n);
            if (l == -1L) {
                this.debugLogWriter.println("MrReportDataController: start line map is not present.");
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                return null;
            }
            try {
                randomAccessFile.seek(l);
            }
            catch (IOException iOException) {
                this.debugLogWriter.println("MrReportDataController: Caught IOException during seting the file pointer to start line.");
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                return null;
            }
            Vector vector = new Vector(this.pageSize, this.pageSize);
            String string2 = null;
            SMReportData sMReportData = new SMReportData();
            sMReportData.setPageSize(this.pageSize);
            sMReportData.setNumberOfPages((n2 - n + n3) / n3);
            sMReportData.setCurrentPageNumber(n / n3 + 1);
            int n6 = 0;
            int n7 = 0;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            String string10 = null;
            String string11 = null;
            String string12 = null;
            String string13 = null;
            Vector<String> vector2 = null;
            McAgentLogData mcAgentLogData = null;
            Vector vector3 = new Vector();
            int n8 = n;
            while (n8 <= n2) {
                n6 = n8;
                string2 = randomAccessFile.readLine();
                if (string2 == null) {
                    if (n8 != n) break;
                    this.debugLogWriter.println("MrReportDataController: There is no data for requested page");
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                    return null;
                }
                if (!UcListUtil.decomposeList((String)string2, vector3)) {
                    this.debugLogWriter.println("MrReportDataController: Could not parse the line " + string2);
                } else {
                    n7 = 0;
                    string5 = null;
                    string10 = null;
                    Enumeration enumeration = vector3.elements();
                    if (enumeration.hasMoreElements()) {
                        n7 = Integer.parseInt((String)enumeration.nextElement());
                    }
                    if (enumeration.hasMoreElements()) {
                        string5 = (String)enumeration.nextElement();
                        string5 = string5.concat("000");
                    }
                    if (enumeration.hasMoreElements()) {
                        string10 = (String)enumeration.nextElement();
                    }
                    if (mcAgentLogData == null) {
                        mcAgentLogData = this.getAgentLogData(mcLogData, n6);
                    } else {
                        int n9 = mcAgentLogData.getStartLine();
                        int n10 = mcAgentLogData.getEndLine();
                        if (n6 > n10 || n6 < n9) {
                            mcAgentLogData = this.getAgentLogData(mcLogData, n6);
                        }
                    }
                    enumeration = mcAgentLogData.getPropertyByIndex(n7);
                    if (enumeration == null) {
                        this.debugLogWriter.println("MrReportDataController: propertymap for propertyid " + n7 + "not found in agentLogData");
                    } else {
                        string3 = ((McAgentProperty)((Object)enumeration)).getHost();
                        string4 = ((McAgentProperty)((Object)enumeration)).getPort();
                        string6 = ((McAgentProperty)((Object)enumeration)).getModule();
                        string7 = ((McAgentProperty)((Object)enumeration)).getModuleInst();
                        string8 = ((McAgentProperty)((Object)enumeration)).getProp();
                        string9 = ((McAgentProperty)((Object)enumeration)).getPropInst();
                        string13 = string3.concat(":" + string4);
                        Integer n11 = (Integer)hashtable.get(this.getHashKey(string6, string7, string8, string9));
                        if (n11 == null) {
                            this.debugLogWriter.println("MrReportDataController: Index for property not found, continuing with rest of the data.");
                        } else {
                            int n12 = n11 + 2;
                            if (string11 == null) {
                                this.debugLogWriter.println("MrReportDataController: Creating new data vector.");
                                vector2 = new Vector<String>();
                                vector2.setSize(n4 + 2);
                                vector2.set(0, string13);
                                vector2.set(1, string5);
                                vector2.set(n12, string10);
                                vector.add(vector2);
                                string11 = string13;
                                string12 = string5;
                            } else if (string13.equals(string11) && string5.equals(string12)) {
                                vector2.set(n12, string10);
                            } else {
                                vector2 = new Vector();
                                vector2.setSize(n4 + 2);
                                vector2.set(0, string13);
                                vector2.set(1, string5);
                                vector2.set(n12, string10);
                                vector.add(vector2);
                                string11 = string13;
                                string12 = string5;
                            }
                        }
                    }
                }
                ++n8;
            }
            sMReportData.setReportData(vector);
            sMReportData.setTotalNumberOfPages((n5 + n3 - 1) / n3);
            if (bl) {
                sMReportData.setMaxRecordsReached();
            }
            randomAccessFile.close();
            return sMReportData;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.errorLogWriter.println("MrReportDataController: " + string + " not found");
        }
        catch (IOException iOException) {
            this.errorLogWriter.println("MrReportDataController: IOException while reading " + string);
        }
        try {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private McAgentLogData getAgentLogData(McLogData mcLogData, int n) {
        Vector vector = mcLogData.getAgentList();
        if (vector == null || vector.isEmpty()) {
            return null;
        }
        McAgentLogData mcAgentLogData = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < vector.size()) {
            mcAgentLogData = (McAgentLogData)vector.elementAt(n4);
            n2 = mcAgentLogData.getStartLine();
            n3 = mcAgentLogData.getEndLine();
            if (n <= n3 && n >= n2) break;
            ++n4;
        }
        return mcAgentLogData;
    }

    private SMReportData getEmptyData() {
        SMReportData sMReportData = new SMReportData();
        sMReportData.setNumberOfPages(0);
        sMReportData.setCurrentPageNumber(0);
        sMReportData.setTotalNumberOfPages(0);
        sMReportData.setHostMap(null);
        return sMReportData;
    }

    protected void setI18nKey(Vector vector, SMReportProperty sMReportProperty) {
        this.debugLogWriter.println("MrReportDataController: Inside setI18nKey Method");
        if (vector == null || sMReportProperty == null) {
            return;
        }
        Enumeration enumeration = vector.elements();
        SMReportProperty sMReportProperty2 = null;
        while (enumeration.hasMoreElements()) {
            sMReportProperty2 = (SMReportProperty)enumeration.nextElement();
            if (sMReportProperty2 == null || !sMReportProperty.equalsWithNoPropInstance(sMReportProperty2)) continue;
            sMReportProperty.setI18nKey(sMReportProperty2.getI18nKey());
            sMReportProperty.setPropertyType(sMReportProperty2.getPropertyType());
            break;
        }
    }

    public SMReportData getCurrentData(SMReportRequest sMReportRequest, int n, String[] stringArray, String string, int n2, String[] stringArray2, String[] stringArray3) throws SMDatabaseException, SMAPIException {
        this.debugLogWriter.println("MrReportDataController: Inside getCurrentData");
        McCollectService mcCollectService = McCollectService.getInstance();
        SMReportTemplate sMReportTemplate = sMReportRequest.getTemplate();
        SMReportPropertyGroup sMReportPropertyGroup = sMReportTemplate.getPropertyGroup();
        if (sMReportPropertyGroup == null) {
            this.debugLogWriter.println("MrReportDataController: property group is null");
            return null;
        }
        SMReportFilter sMReportFilter = sMReportTemplate.getFilter();
        if (sMReportFilter == null) {
            this.debugLogWriter.println("MrReportDataController: filter is null");
            return null;
        }
        Vector vector = sMReportPropertyGroup.getPropertySet();
        if (vector == null) {
            this.debugLogWriter.println("MrReportDataController: property list is null");
            return null;
        }
        Enumeration enumeration = vector.elements();
        SMReportProperty sMReportProperty = null;
        Vector<String> vector2 = new Vector<String>(10, 10);
        boolean bl = false;
        boolean bl2 = false;
        while (enumeration.hasMoreElements()) {
            sMReportProperty = (SMReportProperty)enumeration.nextElement();
            vector2.addElement(sMReportProperty.getStringform());
            if (sMReportProperty.getPropertyInstance() == null || !sMReportProperty.getPropertyInstance().equals("_ALL_")) continue;
            bl2 = true;
        }
        Object[] objectArray = new String[vector2.size()];
        vector2.copyInto(objectArray);
        Date date = sMReportFilter.getStartDate();
        Date date2 = sMReportFilter.getEndDate();
        long l = date.getTime() / 1000L;
        long l2 = date2.getTime() / 1000L;
        McLogData mcLogData = mcCollectService.getRawData(stringArray, l, l2, (String[])objectArray);
        if (mcLogData == null) {
            this.debugLogWriter.println("MrReportDataController: getRawData returned null");
            return this.getEmptyData();
        }
        if (mcLogData.getFileName() == null) {
            this.debugLogWriter.println("MrReportDataController: getRawData returned null filename");
            return this.getEmptyData();
        }
        Hashtable hashtable = null;
        if (bl2) {
            Vector vector3 = this.buildCompletePropList(mcLogData);
            if (vector3 == null) {
                this.debugLogWriter.println("MrReportDataController: problem in building property index");
                return this.getEmptyData();
            }
            Enumeration enumeration2 = vector3.elements();
            SMReportProperty sMReportProperty2 = null;
            while (enumeration2.hasMoreElements()) {
                sMReportProperty2 = (SMReportProperty)enumeration2.nextElement();
                this.setI18nKey(vector, sMReportProperty2);
            }
            vector = vector3;
        }
        hashtable = this.buildPropIndexMap(vector);
        int n3 = hashtable.size();
        int n4 = this.pageSize * n3;
        int n5 = 1;
        int n6 = 1;
        if (n != 0) {
            n5 = n4 * (n - 1) + 1;
            n6 = n5 + n4 - 1;
        } else {
            n5 = 1;
            n6 = n4 * this.maxPages;
        }
        int n7 = mcLogData.totalLines();
        if (n7 <= 0) {
            this.debugLogWriter.println("MrReportDataController: no data found.");
            return this.getEmptyData();
        }
        SMReportData sMReportData = this.readDataFromFile(mcLogData.getFileName(), n5, n6, hashtable, mcLogData, n4);
        MrReportCachedData mrReportCachedData = new MrReportCachedData(sMReportRequest, mcLogData, 2, null);
        mrReportCachedData.setPropertyList(vector);
        int n8 = this.cacheTable.cache(mrReportCachedData);
        sMReportData.setCacheID(n8);
        sMReportData.setPropertyList(vector);
        this.createIPHostMapping(mcLogData, sMReportData, stringArray3, stringArray2);
        return sMReportData;
    }

    protected Hashtable buildPropIndexMap(Vector vector) {
        Enumeration enumeration = vector.elements();
        SMReportProperty sMReportProperty = null;
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            sMReportProperty = (SMReportProperty)enumeration.nextElement();
            hashtable.put(sMReportProperty.getHashKey(), new Integer(n));
            ++n;
        }
        return hashtable;
    }

    protected Hashtable buildPropIndexMap(Vector vector, Vector vector2) {
        Enumeration enumeration = vector.elements();
        SMReportProperty sMReportProperty = null;
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            sMReportProperty = (SMReportProperty)enumeration.nextElement();
            if (hashtable.containsKey(sMReportProperty.getHashKey())) continue;
            this.debugLogWriter.println("MrReportDataController: Not Dup :Adding prop " + sMReportProperty.getHashKey());
            vector2.addElement(sMReportProperty);
            hashtable.put(sMReportProperty.getHashKey(), new Integer(n));
            ++n;
        }
        return hashtable;
    }

    protected Vector buildCompletePropList(McLogData mcLogData) {
        RandomAccessFile randomAccessFile = null;
        Vector<SMReportProperty> vector = new Vector<SMReportProperty>();
        String string = null;
        int n = 0;
        int n2 = 0;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        SMReportProperty sMReportProperty = null;
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        McAgentLogData mcAgentLogData = null;
        Vector vector2 = new Vector();
        int n3 = 0;
        try {
            String string9 = mcLogData.getFileName();
            File file = new File(string9);
            if (!file.canRead()) {
                this.debugLogWriter.println("MrReportDataController: Can not read" + string9);
                return null;
            }
            randomAccessFile = new RandomAccessFile(file, "r");
            while ((string = randomAccessFile.readLine()) != null) {
                Object object;
                ++n;
                if (UcListUtil.decomposeList((String)string, vector2)) {
                    n2 = 0;
                    object = vector2.elements();
                    if (object.hasMoreElements()) {
                        n2 = Integer.parseInt((String)object.nextElement());
                    }
                } else {
                    this.debugLogWriter.println("MrReportDataController: Could not parse the line " + string);
                    continue;
                }
                mcAgentLogData = this.getAgentLogData(mcLogData, n);
                object = mcAgentLogData.getPropertyByIndex(n2);
                if (object == null) {
                    this.debugLogWriter.println("MrReportDataController: propertymap for propertyid " + n2 + "not found in agentLogData");
                    continue;
                }
                string2 = ((McAgentProperty)object).getHost();
                string3 = ((McAgentProperty)object).getPort();
                string4 = ((McAgentProperty)object).getModule();
                string5 = ((McAgentProperty)object).getModuleInst();
                string6 = ((McAgentProperty)object).getProp();
                sMReportProperty = new SMReportProperty(string6, string7 = ((McAgentProperty)object).getPropInst(), string4, string5, string8 = ((McAgentProperty)object).getUnit());
                if (hashtable.get(sMReportProperty.getHashKey()) != null) continue;
                hashtable.put(sMReportProperty.getHashKey(), new Integer(++n3));
                vector.add(sMReportProperty);
            }
        }
        catch (Exception exception) {
            this.errorLogWriter.println("MrReportDataController: Got exception while reading file");
            vector = null;
        }
        if (randomAccessFile != null) {
            try {
                randomAccessFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SMReportData getHistoricalData(SMReportRequest sMReportRequest, int n, String[] stringArray, String string, int n2) throws SMDatabaseException {
        int n3;
        int n4;
        SMReportData sMReportData;
        SMReportData sMReportData2;
        Object object;
        Date date;
        Object object2;
        Object object3;
        String string2;
        ARRAY aRRAY;
        ARRAY aRRAY2;
        ARRAY aRRAY3;
        int n5;
        String[] stringArray2;
        Object object4;
        this.debugLogWriter.println("MrReportDataController: Inside getHistoricalData");
        SMReportTemplate sMReportTemplate = sMReportRequest.getTemplate();
        SMReportPropertyGroup sMReportPropertyGroup = sMReportTemplate.getPropertyGroup();
        if (sMReportPropertyGroup == null) {
            this.debugLogWriter.println("MrReportDataController: property group is null");
            return null;
        }
        Object object5 = sMReportPropertyGroup.getPropertySet();
        if (object5 == null) {
            this.debugLogWriter.println("MrReportDataController: proprty list is null");
            return null;
        }
        Enumeration enumeration = ((Vector)object5).elements();
        SMReportProperty sMReportProperty = null;
        Hashtable hashtable = new Hashtable();
        int n6 = -1;
        boolean bl = false;
        boolean bl2 = false;
        while (enumeration.hasMoreElements()) {
            sMReportProperty = (SMReportProperty)enumeration.nextElement();
            if (sMReportProperty.getPropertyInstance() == null || !sMReportProperty.getPropertyInstance().equals("_ALL_")) continue;
            bl = true;
        }
        Connection connection = MSDB.getConnection();
        CallableStatement callableStatement = null;
        boolean bl3 = false;
        Vector<Double> vector = new Vector<Double>(this.pageSize, this.pageSize);
        String string3 = null;
        int n7 = 0;
        try {
            try {
                callableStatement = connection.prepareCall("{call pkg_perf_data.get_perf_data_ids(?,?,?,?,?,?,?,?,?)}");
                callableStatement.registerOutParameter(9, -10);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMReportRequest.getObjectID());
                object4 = MrReportTools.extractFieldArray(stringArray, ":", 1);
                stringArray2 = MrReportTools.extractFieldArray(stringArray, ":", 2);
                this.debugLogWriter.print("MrReportDataController: host list =");
                int n8 = 0;
                while (n8 < ((String[])object4).length) {
                    this.debugLogWriter.print(" " + object4[n8]);
                    ++n8;
                }
                this.debugLogWriter.println("");
                this.debugLogWriter.print("MrReportDataController: port list =");
                n5 = 0;
                while (n5 < stringArray2.length) {
                    this.debugLogWriter.print(" " + stringArray2[n5]);
                    ++n5;
                }
                this.debugLogWriter.println("");
                ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)"REPORT.STR_ARRAY", (Connection)connection);
                aRRAY3 = new ARRAY(arrayDescriptor, connection, object4);
                aRRAY2 = (ARRAY)callableStatement;
                aRRAY2.setARRAY(2, aRRAY3);
                arrayDescriptor = ArrayDescriptor.createDescriptor((String)"REPORT.STR_ARRAY", (Connection)connection);
                aRRAY = new ARRAY(arrayDescriptor, connection, (Object)stringArray2);
                aRRAY2.setARRAY(3, aRRAY);
                string2 = null;
                if (sMReportRequest.getTemplate().getFilter() != null) {
                    string2 = sMReportRequest.getTemplate().getFilter().getFunctionName();
                }
                MSDB.setNullable((PreparedStatement)callableStatement, (int)4, string2);
                object3 = null;
                if (sMReportRequest.getTemplate().getFilter() != null) {
                    object3 = sMReportRequest.getTemplate().getFilter().getStartDate();
                    this.debugLogWriter.println("MrReportDataController: Start Date = " + ((Date)object3).toString());
                }
                MrReportTools.setDate(callableStatement, 5, object3);
                object2 = null;
                if (sMReportRequest.getTemplate().getFilter() != null) {
                    object2 = sMReportRequest.getTemplate().getFilter().getEndDate();
                    this.debugLogWriter.println("MrReportDataController: End Date = " + ((Date)object2).toString());
                }
                MrReportTools.setDate(callableStatement, 6, object2);
                date = new Date();
                MrReportTools.setDate(callableStatement, 7, date);
                this.debugLogWriter.println("MrReportDataController: Run Date = " + date.toString());
                callableStatement.registerOutParameter(8, 12);
                callableStatement.execute();
                object = (OracleResultSet)callableStatement.getObject(9);
                string3 = (String)callableStatement.getObject(8);
                while (object.next()) {
                    if (n7 >= this.maxAllowedRecords) {
                        bl3 = true;
                        break;
                    }
                    ++n7;
                    vector.add(new Double(object.getDouble(1)));
                }
                connection.commit();
                if (n7 <= 0) {
                    this.debugLogWriter.println("MrReportDataController: no data found.");
                    MSDB.closeConnection((Connection)connection);
                    SMReportData sMReportData3 = this.getEmptyData();
                    Object var36_49 = null;
                    MrReportTools.close(callableStatement);
                    return sMReportData3;
                }
                sMReportData2 = null;
            }
            catch (SQLException sQLException) {
                this.debugLogWriter.println("MrReportDataController: Got SQLException");
                MSDB.rollback((Connection)connection);
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                MSDB.closeConnection((Connection)connection);
                throw sMDatabaseException;
            }
            MrReportTools.close(callableStatement);
        }
        catch (Throwable throwable) {
            Object var36_51 = null;
            MrReportTools.close(callableStatement);
            throw throwable;
        }
        if (bl) {
            object4 = new Vector();
            try {
                block52: {
                    try {
                        callableStatement = connection.prepareCall("{call pkg_perf_data.get_perf_properties(?,?,?,?,?,?,?,?)}");
                        callableStatement.registerOutParameter(8, -10);
                        MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMReportRequest.getObjectID());
                        stringArray2 = MrReportTools.extractFieldArray(stringArray, ":", 1);
                        String[] stringArray3 = MrReportTools.extractFieldArray(stringArray, ":", 2);
                        this.debugLogWriter.print("MrReportDataController: host list =");
                        n5 = 0;
                        while (n5 < stringArray2.length) {
                            this.debugLogWriter.print(" " + stringArray2[n5]);
                            ++n5;
                        }
                        this.debugLogWriter.println("");
                        this.debugLogWriter.print("MrReportDataController: port list =");
                        int n9 = 0;
                        while (n9 < stringArray3.length) {
                            this.debugLogWriter.print(" " + stringArray3[n9]);
                            ++n9;
                        }
                        this.debugLogWriter.println("");
                        aRRAY3 = ArrayDescriptor.createDescriptor((String)"REPORT.STR_ARRAY", (Connection)connection);
                        aRRAY2 = new ARRAY((ArrayDescriptor)aRRAY3, connection, (Object)stringArray2);
                        aRRAY = (OracleCallableStatement)callableStatement;
                        aRRAY.setARRAY(2, aRRAY2);
                        aRRAY3 = ArrayDescriptor.createDescriptor((String)"REPORT.STR_ARRAY", (Connection)connection);
                        string2 = new ARRAY((ArrayDescriptor)aRRAY3, connection, (Object)stringArray3);
                        aRRAY.setARRAY(3, (ARRAY)string2);
                        object3 = null;
                        if (sMReportRequest.getTemplate().getFilter() != null) {
                            object3 = sMReportRequest.getTemplate().getFilter().getFunctionName();
                        }
                        MSDB.setNullable((PreparedStatement)callableStatement, (int)4, (String)object3);
                        object2 = null;
                        if (sMReportRequest.getTemplate().getFilter() != null) {
                            object2 = sMReportRequest.getTemplate().getFilter().getStartDate();
                        }
                        MrReportTools.setDate(callableStatement, 5, (Date)object2);
                        date = null;
                        if (sMReportRequest.getTemplate().getFilter() != null) {
                            date = sMReportRequest.getTemplate().getFilter().getEndDate();
                        }
                        MrReportTools.setDate(callableStatement, 6, date);
                        MSDB.setNullable((PreparedStatement)callableStatement, (int)7, (String)string3);
                        callableStatement.execute();
                        object = (OracleResultSet)callableStatement.getObject(8);
                        while (object.next()) {
                            sMReportProperty = new SMReportProperty(object.getString("property"), object.getString("property_instance"), object.getString("module"), object.getString("module_instance"), object.getString("units"), new SMDBObjectID(object.getLong("property_id"), "report_property"));
                            this.setI18nKey((Vector)object5, sMReportProperty);
                            ((Vector)object4).addElement(sMReportProperty);
                        }
                        connection.commit();
                        if (((Vector)object4).size() == 0) break block52;
                        object5 = object4;
                    }
                    catch (SQLException sQLException) {
                        this.debugLogWriter.println("MrReportDataController: Got SQLException");
                        SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                        MSDB.closeConnection((Connection)connection);
                        throw sMDatabaseException;
                    }
                }
                sMReportData = null;
                MrReportTools.close(callableStatement);
            }
            catch (Throwable throwable) {
                Object var38_56 = null;
                MrReportTools.close(callableStatement);
                throw throwable;
            }
        }
        if (n7 > (n4 = this.pageSize * (n3 = (hashtable = this.buildPropIndexMap((Vector)object5)).size()))) {
            MrReportCachedData mrReportCachedData = new MrReportCachedData(sMReportRequest, vector, 1, string3);
            mrReportCachedData.setPropertyList((Vector)object5);
            n6 = this.cacheTable.cache(mrReportCachedData);
        }
        int n10 = 0;
        n5 = this.maxPages * n4 - 1;
        if (n != 0) {
            n10 = (n - 1) * n4;
            n5 = n10 + n4 - 1;
        }
        if (n5 >= n7) {
            n5 = n7 - 1;
        }
        if (n10 >= n7) {
            n10 = n7 - 1;
        }
        Vector<Double> vector2 = new Vector<Double>();
        int n11 = n10;
        while (n11 <= n5) {
            vector2.add((Double)vector.elementAt(n11));
            ++n11;
        }
        aRRAY2 = new Double[vector2.size()];
        vector2.copyInto((Object[])aRRAY2);
        try {
            try {
                callableStatement = connection.prepareCall("{call pkg_perf_data.get_perf_data(?,?,?,?,?,?,?)}");
                callableStatement.registerOutParameter(7, -10);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMReportRequest.getObjectID());
                aRRAY = ArrayDescriptor.createDescriptor((String)"REPORT.NUM_ARRAY", (Connection)connection);
                string2 = new ARRAY((ArrayDescriptor)aRRAY, connection, (Object)aRRAY2);
                object3 = (OracleCallableStatement)callableStatement;
                object3.setARRAY(2, (ARRAY)string2);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)6, (String)string3);
                object2 = null;
                if (sMReportRequest.getTemplate().getFilter() != null) {
                    object2 = sMReportRequest.getTemplate().getFilter().getFunctionName();
                }
                MSDB.setNullable((PreparedStatement)callableStatement, (int)3, (String)object2);
                date = null;
                if (sMReportRequest.getTemplate().getFilter() != null) {
                    date = sMReportRequest.getTemplate().getFilter().getStartDate();
                }
                MrReportTools.setDate(callableStatement, 4, date);
                object = null;
                if (sMReportRequest.getTemplate().getFilter() != null) {
                    object = sMReportRequest.getTemplate().getFilter().getEndDate();
                }
                MrReportTools.setDate(callableStatement, 5, (Date)object);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(7);
                SMReportData sMReportData4 = this.readResultSet(oracleResultSet, hashtable);
                connection.commit();
                if (sMReportData4.isEmptyData()) {
                    this.debugLogWriter.println("MrReportDataController: Got empty data object");
                    sMReportData2 = sMReportData4;
                    Object var40_59 = null;
                    MrReportTools.close(callableStatement);
                    MSDB.closeConnection((Connection)connection);
                    return sMReportData2;
                }
                sMReportData4.setPropertyList((Vector)object5);
                sMReportData4.setPageSize(this.pageSize);
                if (string3.equals("report_data_trend_hour")) {
                    sMReportData4.setDataType(1);
                } else if (string3.equals("report_data_trend_day")) {
                    sMReportData4.setDataType(2);
                } else if (string3.equals("report_data_trend_week")) {
                    sMReportData4.setDataType(3);
                } else if (string3.equals("report_data_trend_month")) {
                    sMReportData4.setDataType(4);
                } else {
                    this.debugLogWriter.println("MrReportDataController: wrong table");
                    sMReportData4.setDataType(-1);
                }
                sMReportData4.setNumberOfPages((n5 - n10 + n4) / n4);
                sMReportData4.setCurrentPageNumber(n10 / n4 + 1);
                int n12 = n7 / n4;
                int n13 = n7 % n4;
                if (n13 == 0) {
                    sMReportData4.setTotalNumberOfPages(n12);
                } else {
                    sMReportData4.setTotalNumberOfPages(n12 + 1);
                }
                if (n6 >= 0) {
                    sMReportData4.setCacheID(n6);
                }
                if (bl3) {
                    sMReportData4.setMaxRecordsReached();
                }
                sMReportData = sMReportData4;
                Object var40_60 = null;
                MrReportTools.close(callableStatement);
                MSDB.closeConnection((Connection)connection);
                return sMReportData;
            }
            catch (SQLException sQLException) {
                this.debugLogWriter.println("MrReportDataController: Got SQLException");
                MSDB.rollback((Connection)connection);
                string2 = new SMDatabaseException((Throwable)sQLException);
                throw string2;
            }
        }
        catch (Throwable throwable) {
            Object var40_61 = null;
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SMReportData getHistoricalData(SMReportRequest sMReportRequest, String[] stringArray, int n, int n2, int n3) throws SMDatabaseException {
        SMReportProperty sMReportProperty;
        CallableStatement callableStatement;
        Connection connection;
        block19: {
            SMReportProperty sMReportProperty2;
            block18: {
                this.debugLogWriter.println("MrReportDataController: Inside getHistoricalData (aggregate)");
                String[] stringArray2 = MrReportTools.extractFieldArray(stringArray, ":", 1);
                String[] stringArray3 = MrReportTools.extractFieldArray(stringArray, ":", 2);
                Vector vector = new Vector();
                int n4 = this.getReportProperties(sMReportRequest, vector);
                if (vector.size() == 0) {
                    this.debugLogWriter.println("MrReportDataController: proprty list is null");
                    return null;
                }
                connection = MSDB.getConnection();
                callableStatement = null;
                String string = null;
                Hashtable hashtable = null;
                try {
                    try {
                        SMReportProperty sMReportProperty3;
                        callableStatement = connection.prepareCall("{call sp_get_perf_summary_data(?,?,?,?,?,?,?,?,?,?,?,?)}");
                        callableStatement.registerOutParameter(12, -10);
                        MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMReportRequest.getObjectID());
                        ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)"REPORT.STR_ARRAY", (Connection)connection);
                        ARRAY aRRAY = new ARRAY(arrayDescriptor, connection, (Object)stringArray2);
                        OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)callableStatement;
                        oracleCallableStatement.setARRAY(2, aRRAY);
                        arrayDescriptor = ArrayDescriptor.createDescriptor((String)"REPORT.STR_ARRAY", (Connection)connection);
                        ARRAY aRRAY2 = new ARRAY(arrayDescriptor, connection, (Object)stringArray3);
                        oracleCallableStatement.setARRAY(3, aRRAY2);
                        Date date = null;
                        String string2 = null;
                        Date date2 = null;
                        if (sMReportRequest.getTemplate().getFilter() != null) {
                            string2 = sMReportRequest.getTemplate().getFilter().getFunctionName();
                            date = sMReportRequest.getTemplate().getFilter().getStartDate();
                            date2 = sMReportRequest.getTemplate().getFilter().getEndDate();
                            this.debugLogWriter.println("MrReportDataController: " + string2 + ", " + date.toString() + ", " + date2.toString());
                        }
                        MSDB.setNullable((PreparedStatement)callableStatement, (int)4, string2);
                        MrReportTools.setDate(callableStatement, 5, date);
                        MrReportTools.setDate(callableStatement, 6, date2);
                        Date date3 = new Date();
                        MrReportTools.setDate(callableStatement, 7, date3);
                        callableStatement.setInt(8, n);
                        callableStatement.setInt(9, n3);
                        callableStatement.setInt(10, n2);
                        callableStatement.registerOutParameter(11, 12);
                        callableStatement.execute();
                        OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(12);
                        string = (String)callableStatement.getObject(11);
                        if (n4 == 1) {
                            vector = this.getReportProperties(sMReportRequest, stringArray2, stringArray3, vector, string);
                        }
                        if (n2 == 1) {
                            int n5 = 0;
                            while (n5 < vector.size()) {
                                sMReportProperty3 = (SMReportProperty)vector.elementAt(n5);
                                sMReportProperty3.setPropertyInstance(null);
                                ++n5;
                            }
                        }
                        Vector vector2 = new Vector();
                        this.debugLogWriter.println("Size before building hasmap " + vector.size());
                        hashtable = this.buildPropIndexMap(vector, vector2);
                        this.debugLogWriter.println("Size after building hashmap " + vector2.size());
                        sMReportProperty3 = this.readAggreResultSet(oracleResultSet, stringArray, n, n2, hashtable);
                        connection.commit();
                        if (sMReportProperty3.isEmptyData()) {
                            this.debugLogWriter.println("MrReportDataController: Got empty data object");
                            sMReportProperty2 = sMReportProperty3;
                            Object var27_30 = null;
                            break block18;
                        }
                        sMReportProperty3.setPropertyList(vector2);
                        if (string.equals("report_data_trend_hour")) {
                            sMReportProperty3.setDataType(1);
                        } else if (string.equals("report_data_trend_day")) {
                            sMReportProperty3.setDataType(2);
                        } else if (string.equals("report_data_trend_week")) {
                            sMReportProperty3.setDataType(3);
                        } else if (string.equals("report_data_trend_month")) {
                            sMReportProperty3.setDataType(4);
                        } else {
                            this.debugLogWriter.println("MrReportDataController: wrong table");
                            sMReportProperty3.setDataType(-1);
                        }
                        sMReportProperty = sMReportProperty3;
                        break block19;
                    }
                    catch (SQLException sQLException) {
                        this.debugLogWriter.println("MrReportDataController: Got SQLException");
                        MSDB.rollback((Connection)connection);
                        SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                        throw sMDatabaseException;
                    }
                }
                catch (Throwable throwable) {
                    Object var27_32 = null;
                    MrReportTools.close(callableStatement);
                    MSDB.closeConnection((Connection)connection);
                    throw throwable;
                }
            }
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
            return sMReportProperty2;
        }
        Object var27_31 = null;
        MrReportTools.close(callableStatement);
        MSDB.closeConnection((Connection)connection);
        return sMReportProperty;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SMReportData getNonPerfSummaryData(SMReportRequest sMReportRequest, int n, String[] stringArray, String string, int n2) throws SMDatabaseException {
        this.debugLogWriter.println("MrReportDataController: Inside getNonPerfSummaryData");
        SMReportTemplate sMReportTemplate = sMReportRequest.getTemplate();
        SMReportPropertyGroup sMReportPropertyGroup = sMReportTemplate.getPropertyGroup();
        if (sMReportPropertyGroup == null) {
            this.debugLogWriter.println("MrReportDataController: property group is null");
            return null;
        }
        Vector vector = sMReportPropertyGroup.getPropertySet();
        if (vector == null) {
            this.debugLogWriter.println("MrReportDataController: proprty list is null");
            return null;
        }
        Connection connection = MSDB.getConnection();
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection.prepareCall("{call sp_get_nonperf_summary_data(?,?,?,?,?)}");
                callableStatement.registerOutParameter(5, -10);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMReportRequest.getObjectID());
                callableStatement.setString(4, String.valueOf(this.topoport));
                String[] stringArray2 = MrReportTools.extractFieldArray(stringArray, ":", 1);
                String[] stringArray3 = MrReportTools.extractFieldArray(stringArray, ":", 2);
                this.debugLogWriter.print("MrReportDataController: host list =");
                int n3 = 0;
                while (n3 < stringArray2.length) {
                    this.debugLogWriter.print(" " + stringArray2[n3]);
                    ++n3;
                }
                this.debugLogWriter.println("");
                this.debugLogWriter.print("MrReportDataController: port list =");
                int n4 = 0;
                while (n4 < stringArray3.length) {
                    this.debugLogWriter.print(" " + stringArray3[n4]);
                    ++n4;
                }
                this.debugLogWriter.println("");
                ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)"REPORT.STR_ARRAY", (Connection)connection);
                ARRAY aRRAY = new ARRAY(arrayDescriptor, connection, (Object)stringArray2);
                OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)callableStatement;
                oracleCallableStatement.setARRAY(2, aRRAY);
                arrayDescriptor = ArrayDescriptor.createDescriptor((String)"REPORT.STR_ARRAY", (Connection)connection);
                ARRAY aRRAY2 = new ARRAY(arrayDescriptor, connection, (Object)stringArray3);
                oracleCallableStatement.setARRAY(3, aRRAY2);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(5);
                SMReportData sMReportData = null;
                sMReportData = this.readResultSet(oracleResultSet, 0, 0);
                connection.commit();
                if (sMReportData.isEmptyData()) {
                    SMReportData sMReportData2 = sMReportData;
                    Object var23_25 = null;
                    MrReportTools.close(callableStatement);
                    MSDB.closeConnection((Connection)connection);
                    return sMReportData2;
                }
                sMReportData.setPropertyList(vector);
                SMReportData sMReportData3 = sMReportData;
                Object var23_26 = null;
                MrReportTools.close(callableStatement);
                MSDB.closeConnection((Connection)connection);
                return sMReportData3;
            }
            catch (SQLException sQLException) {
                this.debugLogWriter.println("MrReportDataController: Got SQLException");
                MSDB.rollback((Connection)connection);
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
        }
        catch (Throwable throwable) {
            Object var23_27 = null;
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SMReportData getAdvHWTablesDataForSingleTable(SMReportRequest sMReportRequest, int n, SMReportProperty sMReportProperty, MrReportDataCacheTable mrReportDataCacheTable, Connection connection, String[] stringArray, String string, int n2) throws SMDatabaseException {
        SMReportData sMReportData;
        MrReportCachedData mrReportCachedData;
        OracleResultSet oracleResultSet;
        ARRAY aRRAY;
        OracleCallableStatement oracleCallableStatement;
        Object object;
        Object[] objectArray;
        int n3;
        this.debugLogWriter.println("MrReportDataController: Inside getAdvHWTablesDataForSingleTable");
        CallableStatement callableStatement = null;
        Vector<Double> vector = new Vector<Double>(this.pageSize, this.pageSize);
        int n4 = 0;
        int n5 = -1;
        boolean bl = false;
        try {
            block22: {
                try {
                    callableStatement = connection.prepareCall("{call pkg_adv_hw_data.get_adv_hw_data_ids(?,?,?,?,?)}");
                    callableStatement.registerOutParameter(5, -10);
                    MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMReportRequest.getObjectID());
                    MSDB.setNullable((PreparedStatement)callableStatement, (int)2, (String)sMReportProperty.getPropertyName());
                    String[] stringArray2 = MrReportTools.extractFieldArray(stringArray, ":", 1);
                    String[] stringArray3 = MrReportTools.extractFieldArray(stringArray, ":", 2);
                    this.debugLogWriter.print("MrReportDataController: host list =");
                    int n6 = 0;
                    while (n6 < stringArray2.length) {
                        this.debugLogWriter.print(" " + stringArray2[n6]);
                        ++n6;
                    }
                    this.debugLogWriter.println("");
                    this.debugLogWriter.print("MrReportDataController: port list =");
                    n3 = 0;
                    while (n3 < stringArray3.length) {
                        this.debugLogWriter.print(" " + stringArray3[n3]);
                        ++n3;
                    }
                    this.debugLogWriter.println("");
                    objectArray = ArrayDescriptor.createDescriptor((String)"REPORT.STR_ARRAY", (Connection)connection);
                    object = new ARRAY((ArrayDescriptor)objectArray, connection, (Object)stringArray2);
                    oracleCallableStatement = (OracleCallableStatement)callableStatement;
                    oracleCallableStatement.setARRAY(3, object);
                    objectArray = ArrayDescriptor.createDescriptor((String)"REPORT.STR_ARRAY", (Connection)connection);
                    aRRAY = new ARRAY((ArrayDescriptor)objectArray, connection, (Object)stringArray3);
                    oracleCallableStatement.setARRAY(4, aRRAY);
                    callableStatement.execute();
                    oracleResultSet = (OracleResultSet)callableStatement.getObject(5);
                    while (oracleResultSet.next()) {
                        if (n4 >= this.maxAllowedRecords) {
                            bl = true;
                            break;
                        }
                        ++n4;
                        vector.add(new Double(oracleResultSet.getDouble(1)));
                    }
                    connection.commit();
                    if (n4 <= 0) {
                        this.debugLogWriter.println("MrReportDataController: no data found.");
                        SMReportData sMReportData2 = this.getEmptyData();
                        Object var25_31 = null;
                        MrReportTools.close(callableStatement);
                        return sMReportData2;
                    }
                    if (n4 <= this.pageSize) break block22;
                    mrReportCachedData = new MrReportCachedData(sMReportRequest, vector, 8, sMReportProperty.getPropertyName());
                    n5 = mrReportDataCacheTable.cache(mrReportCachedData);
                }
                catch (SQLException sQLException) {
                    this.debugLogWriter.println("MrReportDataController: Got SQLException");
                    MSDB.rollback((Connection)connection);
                    SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                    throw sMDatabaseException;
                }
            }
            sMReportData = null;
            MrReportTools.close(callableStatement);
        }
        catch (Throwable throwable) {
            Object var25_33 = null;
            MrReportTools.close(callableStatement);
            throw throwable;
        }
        int n7 = 0;
        int n8 = this.maxPages * this.pageSize - 1;
        if (n != 0) {
            n7 = (n - 1) * this.pageSize;
            n8 = n7 + this.pageSize - 1;
        }
        if (n7 >= n4) {
            n7 = n4 - 1;
        }
        if (n8 >= n4) {
            n8 = n4 - 1;
        }
        Vector<Double> vector2 = new Vector<Double>();
        n3 = n7;
        while (n3 <= n8) {
            vector2.add((Double)vector.elementAt(n3));
            ++n3;
        }
        objectArray = new Double[vector2.size()];
        vector2.copyInto(objectArray);
        object = null;
        try {
            try {
                callableStatement = connection.prepareCall("{call pkg_adv_hw_data.get_adv_hw_data(?,?,?,?,?)}");
                callableStatement.registerOutParameter(5, -10);
                callableStatement.registerOutParameter(4, 12);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMReportRequest.getObjectID());
                MSDB.setNullable((PreparedStatement)callableStatement, (int)2, (String)sMReportProperty.getPropertyName());
                oracleCallableStatement = ArrayDescriptor.createDescriptor((String)"REPORT.NUM_ARRAY", (Connection)connection);
                aRRAY = new ARRAY((ArrayDescriptor)oracleCallableStatement, connection, (Object)objectArray);
                oracleResultSet = (OracleCallableStatement)callableStatement;
                oracleResultSet.setARRAY(3, aRRAY);
                callableStatement.execute();
                object = (String)callableStatement.getObject(4);
                mrReportCachedData = (OracleResultSet)callableStatement.getObject(5);
                SMReportData sMReportData3 = this.readAdvHWResultSet((OracleResultSet)mrReportCachedData, (String)object, sMReportProperty.getPropertyName());
                connection.commit();
                if (sMReportData3.isEmptyData()) {
                    sMReportData = sMReportData3;
                    Object var29_37 = null;
                    MrReportTools.close(callableStatement);
                    return sMReportData;
                }
                sMReportData3.setPageSize(this.pageSize);
                sMReportData3.setNumberOfPages((n8 - n7 + this.pageSize) / this.pageSize);
                sMReportData3.setCurrentPageNumber(n7 / this.pageSize + 1);
                int n9 = n4 / this.pageSize;
                int n10 = n4 % this.pageSize;
                if (n10 == 0) {
                    sMReportData3.setTotalNumberOfPages(n9);
                } else {
                    sMReportData3.setTotalNumberOfPages(n9 + 1);
                }
                if (n5 >= 0) {
                    sMReportData3.setSubCacheID(n5);
                }
                if (bl) {
                    sMReportData3.setMaxRecordsReached();
                }
                sMReportData3.setRequestType(9);
                SMReportData sMReportData4 = sMReportData3;
                Object var29_38 = null;
                MrReportTools.close(callableStatement);
                return sMReportData4;
            }
            catch (SQLException sQLException) {
                this.debugLogWriter.println("MrReportDataController: Got SQLException");
                MSDB.rollback((Connection)connection);
                aRRAY = new SMDatabaseException((Throwable)sQLException);
                throw aRRAY;
            }
        }
        catch (Throwable throwable) {
            Object var29_39 = null;
            MrReportTools.close(callableStatement);
            throw throwable;
        }
    }

    protected SMReportData readAdvHWResultSet(OracleResultSet oracleResultSet, String string, String string2) throws SQLException {
        SMReportData sMReportData;
        String string3;
        this.debugLogWriter.println("MrReportDataController: Inside readAdvHWResultSet method. " + string + " " + string2);
        Vector<SMReportData> vector = new Vector<SMReportData>();
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
        Vector<SMReportProperty> vector2 = new Vector<SMReportProperty>();
        String string4 = null;
        SMReportProperty sMReportProperty = null;
        string4 = stringTokenizer.nextToken();
        string4 = stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
            sMReportProperty = new SMReportProperty(string4, null, null, null, null);
            sMReportProperty.setPropertyType(7);
            string3 = this.templController.getPropertyI18nKey(string2, string4);
            if (string3 == null) {
                sMReportProperty.setI18nKey(string4);
            } else {
                sMReportProperty.setI18nKey(string3);
            }
            vector2.add(sMReportProperty);
        }
        if (vector2.isEmpty()) {
            this.debugLogWriter.println("MrReportDataController: no propertis found in table title.");
            return this.getEmptyData();
        }
        string3 = null;
        String string5 = null;
        while (oracleResultSet.next()) {
            ++n;
            sMReportData = new Vector();
            string3 = oracleResultSet.getString(1);
            string5 = oracleResultSet.getString(2);
            sMReportData.add(string3);
            stringTokenizer = new StringTokenizer(string5, "|", false);
            while (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
                sMReportData.add(string4);
            }
            vector.add(sMReportData);
        }
        if (n <= 0) {
            this.debugLogWriter.println("MrReportDataController: no data found.");
            return this.getEmptyData();
        }
        sMReportData = new SMReportData();
        sMReportData.setReportData(vector);
        sMReportData.setPropertyList(vector2);
        return sMReportData;
    }

    public SMReportData getAdvHWTablesData(SMReportRequest sMReportRequest, int n, String[] stringArray, String string, int n2) throws SMDatabaseException {
        MrReportCachedData mrReportCachedData;
        this.debugLogWriter.println("MrReportDataController: Inside getAdvHWTablesData");
        SMReportTemplate sMReportTemplate = sMReportRequest.getTemplate();
        SMReportPropertyGroup sMReportPropertyGroup = sMReportTemplate.getPropertyGroup();
        if (sMReportPropertyGroup == null) {
            this.debugLogWriter.println("MrReportDataController: property group is null");
            return null;
        }
        Vector vector = sMReportPropertyGroup.getPropertySet();
        if (vector == null) {
            this.debugLogWriter.println("MrReportDataController: Property list is null");
            return null;
        }
        Connection connection = MSDB.getConnection();
        MrReportDataCacheTable mrReportDataCacheTable = new MrReportDataCacheTable(100);
        Enumeration enumeration = vector.elements();
        SMReportProperty sMReportProperty = null;
        SMReportData sMReportData = null;
        int n3 = -1;
        Vector<MrReportCachedData> vector2 = new Vector<MrReportCachedData>();
        try {
            while (enumeration.hasMoreElements()) {
                sMReportProperty = (SMReportProperty)enumeration.nextElement();
                mrReportCachedData = this.getAdvHWTablesDataForSingleTable(sMReportRequest, n, sMReportProperty, mrReportDataCacheTable, connection, stringArray, string, n2);
                vector2.add(mrReportCachedData);
            }
            if (mrReportDataCacheTable.getCurrentNumberOfCachedData() > 0) {
                mrReportCachedData = new MrReportCachedData(sMReportRequest, mrReportDataCacheTable, 8, null);
                n3 = this.cacheTable.cache(mrReportCachedData);
                Enumeration enumeration2 = vector2.elements();
                SMReportData sMReportData2 = null;
                while (enumeration2.hasMoreElements()) {
                    sMReportData2 = (SMReportData)enumeration2.nextElement();
                    sMReportData2.setCacheID(n3);
                }
            }
            sMReportData = new SMReportData();
            sMReportData.setPropertyList(vector);
            sMReportData.setReportData(vector2);
            sMReportData.setCacheID(n3);
            mrReportCachedData = sMReportData;
            Object var20_19 = null;
        }
        catch (Throwable throwable) {
            Object var20_20 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return mrReportCachedData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SMReportData getNonPerfDetailData(SMReportRequest sMReportRequest, int n, String[] stringArray, String string, int n2) throws SMDatabaseException {
        SMReportData sMReportData;
        ARRAY aRRAY;
        OracleCallableStatement oracleCallableStatement;
        ARRAY aRRAY2;
        ArrayDescriptor arrayDescriptor;
        int n3;
        Object object;
        this.debugLogWriter.println("MrReportDataController: Inside getNonPerfDetailData");
        SMReportTemplate sMReportTemplate = sMReportRequest.getTemplate();
        SMReportPropertyGroup sMReportPropertyGroup = sMReportTemplate.getPropertyGroup();
        if (sMReportPropertyGroup == null) {
            this.debugLogWriter.println("MrReportDataController: property group is null");
            return null;
        }
        Vector vector = sMReportPropertyGroup.getPropertySet();
        if (vector == null) {
            this.debugLogWriter.println("MrReportDataController: Property list is null");
            return null;
        }
        Connection connection = MSDB.getConnection();
        Vector<Double> vector2 = new Vector<Double>(this.pageSize, this.pageSize);
        int n4 = -1;
        int n5 = 0;
        boolean bl = false;
        CallableStatement callableStatement = null;
        try {
            block26: {
                try {
                    OracleResultSet oracleResultSet = null;
                    String[] stringArray2 = MrReportTools.extractFieldArray(stringArray, ":", 1);
                    object = MrReportTools.extractFieldArray(stringArray, ":", 2);
                    this.debugLogWriter.print("MrReportDataController: host list =");
                    n3 = 0;
                    while (n3 < stringArray2.length) {
                        this.debugLogWriter.print(" " + stringArray2[n3]);
                        ++n3;
                    }
                    this.debugLogWriter.println("");
                    this.debugLogWriter.print("MrReportDataController: port list =");
                    int n6 = 0;
                    while (n6 < ((String[])object).length) {
                        this.debugLogWriter.print(" " + object[n6]);
                        ++n6;
                    }
                    this.debugLogWriter.println("");
                    if (sMReportRequest.getReportType() == 4) {
                        callableStatement = connection.prepareCall("{call pkg_nonperf_data.get_alarm_data_ids(?,?,?,?,?,?,?)}");
                        callableStatement.registerOutParameter(7, -10);
                        MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMReportRequest.getObjectID());
                        MSDB.setNullable((PreparedStatement)callableStatement, (int)4, (String)string);
                        callableStatement.setInt(5, n2);
                        callableStatement.setString(6, String.valueOf(this.topoport));
                        arrayDescriptor = ArrayDescriptor.createDescriptor((String)"REPORT.STR_ARRAY", (Connection)connection);
                        aRRAY2 = new ARRAY(arrayDescriptor, connection, (Object)stringArray2);
                        oracleCallableStatement = (OracleCallableStatement)callableStatement;
                        oracleCallableStatement.setARRAY(2, aRRAY2);
                        arrayDescriptor = ArrayDescriptor.createDescriptor((String)"REPORT.STR_ARRAY", (Connection)connection);
                        aRRAY = new ARRAY(arrayDescriptor, connection, object);
                        oracleCallableStatement.setARRAY(3, aRRAY);
                        callableStatement.execute();
                        oracleResultSet = (OracleResultSet)callableStatement.getObject(7);
                    } else {
                        callableStatement = connection.prepareCall("{call pkg_nonperf_data.get_nonperf_data_ids(?,?,?,?,?,?)}");
                        callableStatement.registerOutParameter(6, -10);
                        MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMReportRequest.getObjectID());
                        MSDB.setNullable((PreparedStatement)callableStatement, (int)4, (String)string);
                        callableStatement.setInt(5, n2);
                        arrayDescriptor = ArrayDescriptor.createDescriptor((String)"REPORT.STR_ARRAY", (Connection)connection);
                        aRRAY2 = new ARRAY(arrayDescriptor, connection, (Object)stringArray2);
                        oracleCallableStatement = (OracleCallableStatement)callableStatement;
                        oracleCallableStatement.setARRAY(2, aRRAY2);
                        arrayDescriptor = ArrayDescriptor.createDescriptor((String)"REPORT.STR_ARRAY", (Connection)connection);
                        aRRAY = new ARRAY(arrayDescriptor, connection, object);
                        oracleCallableStatement.setARRAY(3, aRRAY);
                        callableStatement.execute();
                        oracleResultSet = (OracleResultSet)callableStatement.getObject(6);
                    }
                    while (oracleResultSet.next()) {
                        if (n5 >= this.maxAllowedRecords) {
                            bl = true;
                            break;
                        }
                        ++n5;
                        vector2.add(new Double(oracleResultSet.getDouble(1)));
                    }
                    connection.commit();
                    if (n5 <= 0) {
                        this.debugLogWriter.println("MrReportDataController: no data found.");
                        arrayDescriptor = this.getEmptyData();
                        Object var25_30 = null;
                        MrReportTools.close(callableStatement);
                        MSDB.closeConnection((Connection)connection);
                        return arrayDescriptor;
                    }
                    if (n5 <= this.pageSize) break block26;
                    n4 = this.cacheTable.cache(vector2, sMReportRequest, null);
                }
                catch (SQLException sQLException) {
                    this.debugLogWriter.println("MrReportDataController: Got SQLException");
                    MSDB.rollback((Connection)connection);
                    SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                    throw sMDatabaseException;
                }
            }
            sMReportData = null;
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
        }
        catch (Throwable throwable) {
            Object var25_32 = null;
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        int n7 = 0;
        int n8 = this.maxPages * this.pageSize - 1;
        if (n != 0) {
            n7 = (n - 1) * this.pageSize;
            n8 = n7 + this.pageSize - 1;
        }
        if (n7 >= n5) {
            n7 = n5 - 1;
        }
        if (n8 >= n5) {
            n8 = n5 - 1;
        }
        object = new Vector();
        n3 = n7;
        while (n3 <= n8) {
            ((Vector)object).add((Double)vector2.elementAt(n3));
            ++n3;
        }
        Object[] objectArray = new Double[((Vector)object).size()];
        ((Vector)object).copyInto(objectArray);
        try {
            try {
                connection = MSDB.getConnection();
                callableStatement = connection.prepareCall("{call pkg_nonperf_data.get_nonperf_data(?,?,?,?,?)}");
                callableStatement.registerOutParameter(5, -10);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMReportRequest.getObjectID());
                MSDB.setNullable((PreparedStatement)callableStatement, (int)3, (String)string);
                callableStatement.setInt(4, n2);
                arrayDescriptor = ArrayDescriptor.createDescriptor((String)"REPORT.NUM_ARRAY", (Connection)connection);
                aRRAY2 = new ARRAY(arrayDescriptor, connection, (Object)objectArray);
                oracleCallableStatement = (OracleCallableStatement)callableStatement;
                oracleCallableStatement.setARRAY(2, aRRAY2);
                callableStatement.execute();
                aRRAY = (OracleResultSet)callableStatement.getObject(5);
                SMReportData sMReportData2 = null;
                sMReportData2 = this.readResultSet((OracleResultSet)aRRAY, 0, 0);
                connection.commit();
                if (sMReportData2.isEmptyData()) {
                    sMReportData = sMReportData2;
                    Object var29_36 = null;
                    MrReportTools.close(callableStatement);
                    MSDB.closeConnection((Connection)connection);
                    return sMReportData;
                }
                sMReportData2.setPageSize(this.pageSize);
                sMReportData2.setNumberOfPages((n8 - n7 + this.pageSize) / this.pageSize);
                sMReportData2.setCurrentPageNumber(n7 / this.pageSize + 1);
                int n9 = n5 / this.pageSize;
                int n10 = n5 % this.pageSize;
                if (n10 == 0) {
                    sMReportData2.setTotalNumberOfPages(n9);
                } else {
                    sMReportData2.setTotalNumberOfPages(n9 + 1);
                }
                if (n4 >= 0) {
                    sMReportData2.setCacheID(n4);
                }
                sMReportData2.setPropertyList(vector);
                if (bl) {
                    sMReportData2.setMaxRecordsReached();
                }
                SMReportData sMReportData3 = sMReportData2;
                Object var29_37 = null;
                MrReportTools.close(callableStatement);
                MSDB.closeConnection((Connection)connection);
                return sMReportData3;
            }
            catch (SQLException sQLException) {
                this.debugLogWriter.println("MrReportDataController: Got SQLException");
                MSDB.rollback((Connection)connection);
                aRRAY2 = new SMDatabaseException((Throwable)sQLException);
                throw aRRAY2;
            }
        }
        catch (Throwable throwable) {
            Object var29_38 = null;
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
    }

    public SMReportData runReportRequest(SMReportRequest sMReportRequest, int n, String[] stringArray, String string, int n2) throws SMDatabaseException, SMAPIException, UnknownHostException {
        return this.runReportRequest(sMReportRequest, n, stringArray, string, n2, 0, 0, 0);
    }

    public SMReportData runReportRequest(SMReportRequest sMReportRequest, String[] stringArray, int n, int n2, int n3) throws SMDatabaseException, SMAPIException, UnknownHostException {
        return this.runReportRequest(sMReportRequest, 0, stringArray, null, 0, n, n2, n3);
    }

    private SMReportData runReportRequest(SMReportRequest sMReportRequest, int n, String[] stringArray, String string, int n2, int n3, int n4, int n5) throws SMDatabaseException, SMAPIException, UnknownHostException {
        String[] stringArray2;
        String[] stringArray3;
        this.debugLogWriter.println("MrReportDataController: Inside runReportRequest with object");
        if (sMReportRequest == null) {
            this.debugLogWriter.println("MrReportDataController: report request must not be null");
            return null;
        }
        this.debugLogWriter.println("MrReportDataController: Inside runReportRequest with object");
        if (sMReportRequest == null) {
            this.debugLogWriter.println("MrReportDataController: report request must not be null");
            return null;
        }
        int n6 = sMReportRequest.getRequestType();
        if (n6 == 3) {
            this.debugLogWriter.println("MrReportDataController: Service does not support running dynamic requests");
            return null;
        }
        if (stringArray == null) {
            try {
                String string2 = sMReportRequest.getAgentGroupName();
                if (string2 != null) {
                    stringArray3 = McCollectService.getInstance();
                    stringArray2 = stringArray3.resolveGroup(string2);
                    stringArray = MrReportTools.getStringToArray((String)stringArray2, " ");
                } else {
                    stringArray = sMReportRequest.getAgentList();
                }
            }
            catch (SMNoSuchObjectException sMNoSuchObjectException) {
                stringArray = null;
            }
            catch (SMAPIException sMAPIException) {
                stringArray = null;
            }
            if (stringArray == null) {
                this.debugLogWriter.println("MrReportDataController: Problem in resolving group");
                return null;
            }
        }
        stringArray2 = stringArray;
        this.debugLogWriter.println("MrReportDataController: Agent list coming either in report or from user is");
        int n7 = 0;
        while (n7 < stringArray2.length) {
            this.debugLogWriter.print(" " + stringArray2[n7]);
            ++n7;
        }
        this.debugLogWriter.println("");
        stringArray3 = null;
        if (!"_ALL_".equals(stringArray[0])) {
            this.debugLogWriter.println("MrReportDataController: Converting agent list to ip list.");
            stringArray3 = MrReportTools.convertHostListToIPList(stringArray);
            this.debugLogWriter.print("MrReportDataController: Converted agent list to ip list.");
            Vector<String> vector = new Vector<String>();
            int n8 = 0;
            while (n8 < stringArray3.length) {
                this.debugLogWriter.print(" " + stringArray3[n8]);
                if (stringArray3[n8] != null && !vector.contains(stringArray3[n8])) {
                    vector.add(stringArray3[n8]);
                }
                ++n8;
            }
            this.debugLogWriter.println("");
            stringArray = new String[vector.size()];
            vector.copyInto(stringArray);
        }
        this.debugLogWriter.print("MrReportDataController: Final ip list =");
        int n9 = 0;
        while (n9 < stringArray.length) {
            this.debugLogWriter.print(" " + stringArray[n9]);
            ++n9;
        }
        this.debugLogWriter.println("");
        SMReportData sMReportData = null;
        int n10 = -1;
        SMReportFilter sMReportFilter = null;
        switch (sMReportRequest.getReportType()) {
            case 5: {
                sMReportFilter = sMReportRequest.getTemplate().getFilter();
                if (sMReportFilter == null) {
                    this.debugLogWriter.println("MrReportDataController: Filter in report request must not be null");
                    return null;
                }
                if (sMReportFilter.getStartDate() == null || sMReportFilter.getEndDate() == null) {
                    this.debugLogWriter.println("MrReportDataController: start and end date must not be null for performance request.");
                    return null;
                }
                if (n6 == 2) {
                    sMReportData = this.getCurrentData(sMReportRequest, n, stringArray, string, n2, stringArray2, stringArray3);
                    break;
                }
                if (n3 == 0) {
                    sMReportData = this.getHistoricalData(sMReportRequest, n, stringArray, string, n2);
                    break;
                }
                sMReportData = this.getHistoricalData(sMReportRequest, stringArray, n3, n4, n5);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n10 = sMReportRequest.getRequestDataType();
                if (n10 == 2) {
                    sMReportData = this.getNonPerfSummaryData(sMReportRequest, n, stringArray, string, n2);
                    break;
                }
                sMReportData = this.getNonPerfDetailData(sMReportRequest, n, stringArray, string, n2);
                break;
            }
            case 8: {
                sMReportData = this.getAdvHWTablesData(sMReportRequest, n, stringArray, string, n2);
                break;
            }
            case 11: {
                sMReportFilter = sMReportRequest.getTemplate().getFilter();
                if (sMReportFilter == null) {
                    this.debugLogWriter.println("MrReportDataController: Filter in report request must not be null");
                    return null;
                }
                if (sMReportFilter.getStartDate() == null || sMReportFilter.getEndDate() == null) {
                    this.debugLogWriter.println("MrReportDataController: start and end date must not be null for performance request.");
                    return null;
                }
                sMReportData = this.getCurrentUptimeStatusData(sMReportRequest, n, stringArray, string, n2, stringArray2, stringArray3);
                break;
            }
            case 12: {
                n10 = sMReportRequest.getRequestDataType();
                sMReportFilter = sMReportRequest.getTemplate().getFilter();
                if (sMReportFilter == null) {
                    this.debugLogWriter.println("MrReportDataController: Filter in report request must not be null");
                    return null;
                }
                if (sMReportFilter.getStartDate() == null || sMReportFilter.getEndDate() == null) {
                    this.debugLogWriter.println("MrReportDataController: start and end date must not be null for uptime request.");
                    return null;
                }
                if (n10 == 2) {
                    sMReportData = this.getCurrentUptimeTotalData(sMReportRequest, n, stringArray, string, n2, stringArray2, stringArray3);
                    break;
                }
                sMReportData = this.getHistoricalData(sMReportRequest, n, stringArray, string, n2);
                break;
            }
            case 13: {
                n10 = sMReportRequest.getRequestDataType();
                sMReportFilter = sMReportRequest.getTemplate().getFilter();
                if (sMReportFilter == null) {
                    this.debugLogWriter.println("MrReportDataController: Filter in report request must not be null");
                    return null;
                }
                if (sMReportFilter.getStartDate() == null || sMReportFilter.getEndDate() == null) {
                    this.debugLogWriter.println("MrReportDataController: start and end date must not be null for uptime request.");
                    return null;
                }
                sMReportData = n10 == 2 ? this.getCurrentUptimeTotalData(sMReportRequest, n, stringArray, string, n2, stringArray2, stringArray3) : this.getHistoricalData(sMReportRequest, n, stringArray, string, n2);
            }
        }
        if (sMReportData != null) {
            sMReportData.setRequestType(sMReportRequest.getReportType());
        }
        if (sMReportData != null && n6 != 2 && sMReportRequest.getReportType() == 5 || sMReportData != null && (sMReportRequest.getReportType() == 13 || sMReportRequest.getReportType() == 12) && n10 != 2) {
            this.createIPHostMapping(sMReportData, stringArray3, stringArray2);
        }
        return sMReportData;
    }

    public SMReportData runReportRequest(SMReportRequest sMReportRequest, String[] stringArray, int n, int n2) throws SMDatabaseException, SMAPIException, UnknownHostException {
        return this.runReportRequest(sMReportRequest, 0, stringArray, n, n2);
    }

    private SMReportData runReportRequest(SMReportRequest sMReportRequest, int n, String[] stringArray, int n2, int n3) throws SMDatabaseException, SMAPIException, UnknownHostException {
        String[] stringArray2;
        String[] stringArray3;
        this.debugLogWriter.println("MrReportDataController: Inside runReportRequest with request for sort");
        if (sMReportRequest == null) {
            this.debugLogWriter.println("MrReportDataController: report request must not be null");
            return null;
        }
        this.debugLogWriter.println("MrReportDataController: Inside runReportRequest with object");
        if (sMReportRequest == null) {
            this.debugLogWriter.println("MrReportDataController: report request must not be null");
            return null;
        }
        int n4 = sMReportRequest.getRequestType();
        if (n4 == 3) {
            this.debugLogWriter.println("MrReportDataController: Service does not support running dynamic requests");
            return null;
        }
        if (stringArray == null) {
            try {
                String string = sMReportRequest.getAgentGroupName();
                if (string != null) {
                    stringArray3 = McCollectService.getInstance();
                    stringArray2 = stringArray3.resolveGroup(string);
                    stringArray = MrReportTools.getStringToArray((String)stringArray2, " ");
                } else {
                    stringArray = sMReportRequest.getAgentList();
                }
            }
            catch (SMNoSuchObjectException sMNoSuchObjectException) {
                stringArray = null;
            }
            catch (SMAPIException sMAPIException) {
                stringArray = null;
            }
            if (stringArray == null) {
                this.debugLogWriter.println("MrReportDataController: Problem in resolving group");
                return null;
            }
        }
        stringArray2 = stringArray;
        this.debugLogWriter.println("MrReportDataController: Agent list coming either in report or from user is");
        int n5 = 0;
        while (n5 < stringArray2.length) {
            this.debugLogWriter.print(" " + stringArray2[n5]);
            ++n5;
        }
        this.debugLogWriter.println("");
        stringArray3 = null;
        if (!"_ALL_".equals(stringArray[0])) {
            this.debugLogWriter.println("MrReportDataController: Converting agent list to ip list.");
            stringArray3 = MrReportTools.convertHostListToIPList(stringArray);
            this.debugLogWriter.print("MrReportDataController: Converted agent list to ip list.");
            Vector<String> vector = new Vector<String>();
            int n6 = 0;
            while (n6 < stringArray3.length) {
                this.debugLogWriter.print(" " + stringArray3[n6]);
                if (stringArray3[n6] != null && !vector.contains(stringArray3[n6])) {
                    vector.add(stringArray3[n6]);
                }
                ++n6;
            }
            this.debugLogWriter.println("");
            stringArray = new String[vector.size()];
            vector.copyInto(stringArray);
        }
        this.debugLogWriter.print("MrReportDataController: Final ip list =");
        int n7 = 0;
        while (n7 < stringArray.length) {
            this.debugLogWriter.print(" " + stringArray[n7]);
            ++n7;
        }
        this.debugLogWriter.println("");
        SMReportData sMReportData = null;
        int n8 = -1;
        SMReportFilter sMReportFilter = null;
        sMReportFilter = sMReportRequest.getTemplate().getFilter();
        if (sMReportFilter == null) {
            this.debugLogWriter.println("MrReportDataController: Filter in report request must not be null");
            return null;
        }
        if (sMReportFilter.getStartDate() == null || sMReportFilter.getEndDate() == null) {
            this.debugLogWriter.println("MrReportDataController: start and end date must not be null for performance request.");
            return null;
        }
        sMReportData = this.getSortedHistoricalData(sMReportRequest, n, stringArray, n2, n3);
        if (sMReportData != null) {
            sMReportData.setRequestType(sMReportRequest.getReportType());
        }
        if (sMReportData != null && n4 != 2 && sMReportRequest.getReportType() == 5 || sMReportData != null && (sMReportRequest.getReportType() == 13 || sMReportRequest.getReportType() == 12) && n8 != 2) {
            this.createIPHostMapping(sMReportData, stringArray3, stringArray2);
        }
        return sMReportData;
    }

    public SMReportData runReportRequest(SMDBObjectID sMDBObjectID, int n, String[] stringArray, Date date, Date date2, String string, String string2, int n2) throws SMDatabaseException, SMAPIException, UnknownHostException {
        return this.runReportRequest(sMDBObjectID, n, stringArray, date, date2, string, string2, n2, 0, 0, 0);
    }

    public SMReportData runReportRequest(SMDBObjectID sMDBObjectID, String[] stringArray, Date date, Date date2, String string, int n, int n2, int n3) throws SMDatabaseException, SMAPIException, UnknownHostException {
        return this.runReportRequest(sMDBObjectID, 0, stringArray, date, date2, string, null, 0, n, n2, n3);
    }

    public SMReportData runReportRequest(SMDBObjectID sMDBObjectID, int n, String[] stringArray, Date date, Date date2, String string, String string2, int n2, int n3, int n4, int n5) throws SMDatabaseException, SMAPIException, UnknownHostException {
        this.debugLogWriter.println("MrReportDataController: Inside runReportRequest");
        SMReportRequest sMReportRequest = this.templController.getReportRequest(sMDBObjectID);
        if (sMReportRequest == null) {
            this.debugLogWriter.println("MrReportDataController: report request must not be null");
            return null;
        }
        SMReportFilter sMReportFilter = sMReportRequest.getTemplate().getFilter();
        if (sMReportFilter == null) {
            sMReportFilter = new SMReportFilter();
            sMReportRequest.getTemplate().setFilter(sMReportFilter);
        }
        if (date != null) {
            sMReportFilter.setStartDate(date);
        }
        if (date2 != null) {
            sMReportFilter.setEndDate(date2);
        }
        if (string != null) {
            sMReportFilter.setFunctionName(string);
        }
        return this.runReportRequest(sMReportRequest, n, stringArray, string2, n2, n3, n4, n5);
    }

    protected SMReportData runReportRequest(SMDBObjectID sMDBObjectID, int n) throws SMDatabaseException, SMAPIException, UnknownHostException {
        return this.runReportRequest(sMDBObjectID, n, null, null, null, null, null, 0);
    }

    public SMReportData[] runReportCompositeRequest(SMDBObjectID sMDBObjectID, int n) throws SMDatabaseException, SMAPIException, UnknownHostException {
        this.debugLogWriter.println("MrReportDataController: Inside runReportCompositeRequest");
        SMReportCompositeRequest sMReportCompositeRequest = this.templController.getCompositeRequest(sMDBObjectID);
        Vector vector = sMReportCompositeRequest.getRequests();
        if (vector == null) {
            this.debugLogWriter.println("MrReportDataController: Child request is null");
            return null;
        }
        Enumeration enumeration = vector.elements();
        SMReportData sMReportData = null;
        Vector<SMReportData> vector2 = new Vector<SMReportData>();
        while (enumeration.hasMoreElements()) {
            sMReportData = this.runReportRequest(((SMReportRequest)enumeration.nextElement()).getObjectID(), n);
            vector2.add(sMReportData);
        }
        Object[] objectArray = new SMReportData[vector2.size()];
        vector2.copyInto(objectArray);
        return objectArray;
    }

    public SMProcessData getProcessData(String string, Date date, Date date2, String string2) throws SMAPIException, UnknownHostException {
        this.debugLogWriter.println("MrReportDataController: Inside getProcessData, Agent = " + string + " start date = " + date.toString() + " end date = " + date2.toString() + " type = " + string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":", false);
        String string3 = null;
        String string4 = "161";
        if (stringTokenizer.hasMoreElements()) {
            string3 = (String)stringTokenizer.nextElement();
        }
        if (stringTokenizer.hasMoreElements()) {
            string4 = (String)stringTokenizer.nextElement();
        }
        MSReportHostAddrMapper mSReportHostAddrMapper = MSReportHostAddrMapper.getInstance();
        String string5 = mSReportHostAddrMapper.getIPAddress(string3);
        this.debugLogWriter.println("MrReportDataController: Converted " + string3 + " to " + string5);
        McCollectService mcCollectService = McCollectService.getInstance();
        long l = date.getTime() / 1000L;
        long l2 = date2.getTime() / 1000L;
        SMProcessData sMProcessData = mcCollectService.getProcessData(string5 + ":" + string4, l, l2, string2);
        return sMProcessData;
    }

    public SMReportData getPageData(int n, int n2, int n3, String string, int n4) throws SMDatabaseException {
        this.debugLogWriter.println("MrReportDataController: Inside getPageData");
        MrReportCachedData mrReportCachedData = this.cacheTable.getFromCache(n);
        if (mrReportCachedData == null) {
            this.debugLogWriter.println("MrReportDataController: No cache available.");
            return this.getEmptyData();
        }
        int n5 = mrReportCachedData.getCacheType();
        if (n5 == 2 || n5 == 1) {
            return this.getPageData(n, n3, string, n4);
        }
        this.debugLogWriter.println("MrReportDataController: Inside getPageData");
        if (n2 < 0) {
            this.debugLogWriter.println("MrReportDataController: No cache available.Sub cache id is < 0");
            return this.getEmptyData();
        }
        MrReportDataCacheTable mrReportDataCacheTable = (MrReportDataCacheTable)mrReportCachedData.getCachedObject();
        if (mrReportDataCacheTable == null) {
            this.debugLogWriter.println("MrReportDataController: No cache available.");
            return this.getEmptyData();
        }
        MrReportCachedData mrReportCachedData2 = mrReportDataCacheTable.getFromCache(n2);
        if (mrReportCachedData2 == null) {
            this.debugLogWriter.println("MrReportDataController: No cache available.");
            return this.getEmptyData();
        }
        SMReportData sMReportData = null;
        sMReportData = this.getAdvTablePageData(mrReportCachedData2, n3, string, n4);
        sMReportData.setCacheID(n);
        sMReportData.setSubCacheID(n2);
        return sMReportData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SMReportData getAdvTablePageData(MrReportCachedData mrReportCachedData, int n, String string, int n2) throws SMDatabaseException {
        this.debugLogWriter.println("MrReportDataController: Inside getAdvTablePageData");
        Connection connection = MSDB.getConnection();
        SMReportRequest sMReportRequest = (SMReportRequest)mrReportCachedData.getRequest();
        SMReportTemplate sMReportTemplate = sMReportRequest.getTemplate();
        SMReportPropertyGroup sMReportPropertyGroup = sMReportTemplate.getPropertyGroup();
        if (sMReportPropertyGroup == null) {
            this.debugLogWriter.println("MrReportDataController: property group is null");
            MSDB.closeConnection((Connection)connection);
            return null;
        }
        Vector vector = sMReportPropertyGroup.getPropertySet();
        if (vector == null) {
            this.debugLogWriter.println("MrReportDataController: Propert list is null");
            MSDB.closeConnection((Connection)connection);
            return null;
        }
        Vector vector2 = (Vector)mrReportCachedData.getCachedObject();
        int n3 = vector2.size();
        int n4 = 0;
        int n5 = this.maxPages * this.pageSize - 1;
        if (n != 0) {
            n4 = (n - 1) * this.pageSize;
            n5 = n4 + this.pageSize - 1;
        }
        if (n4 >= n3) {
            n4 = n3 - 1;
        }
        if (n5 >= n3) {
            n5 = n3 - 1;
        }
        Vector<Double> vector3 = new Vector<Double>();
        int n6 = n4;
        while (n6 <= n5) {
            vector3.add((Double)vector2.elementAt(n6));
            ++n6;
        }
        Object[] objectArray = new Double[vector3.size()];
        vector3.copyInto(objectArray);
        CallableStatement callableStatement = null;
        String string2 = mrReportCachedData.getCacheTag();
        String string3 = null;
        try {
            try {
                callableStatement = connection.prepareCall("{call pkg_adv_hw_data.get_adv_hw_data(?,?,?,?,?)}");
                callableStatement.registerOutParameter(5, -10);
                callableStatement.registerOutParameter(4, 12);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMReportRequest.getObjectID());
                MSDB.setNullable((PreparedStatement)callableStatement, (int)2, (String)string2);
                ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)"REPORT.NUM_ARRAY", (Connection)connection);
                ARRAY aRRAY = new ARRAY(arrayDescriptor, connection, (Object)objectArray);
                OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)callableStatement;
                oracleCallableStatement.setARRAY(3, aRRAY);
                callableStatement.execute();
                string3 = (String)callableStatement.getObject(4);
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(5);
                SMReportData sMReportData = this.readAdvHWResultSet(oracleResultSet, string3, string2);
                connection.commit();
                if (sMReportData.isEmptyData()) {
                    SMReportData sMReportData2 = sMReportData;
                    Object var29_29 = null;
                    MrReportTools.close(callableStatement);
                    MSDB.closeConnection((Connection)connection);
                    return sMReportData2;
                }
                sMReportData.setPageSize(this.pageSize);
                sMReportData.setNumberOfPages((n5 - n4 + this.pageSize) / this.pageSize);
                sMReportData.setCurrentPageNumber(n4 / this.pageSize + 1);
                int n7 = n3 / this.pageSize;
                int n8 = n3 % this.pageSize;
                if (n8 == 0) {
                    sMReportData.setTotalNumberOfPages(n7);
                } else {
                    sMReportData.setTotalNumberOfPages(n7 + 1);
                }
                SMReportData sMReportData3 = sMReportData;
                Object var29_30 = null;
                MrReportTools.close(callableStatement);
                MSDB.closeConnection((Connection)connection);
                return sMReportData3;
            }
            catch (SQLException sQLException) {
                this.debugLogWriter.println("MrReportDataController: Got SQLException");
                MSDB.rollback((Connection)connection);
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
        }
        catch (Throwable throwable) {
            Object var29_31 = null;
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
    }

    public SMReportData getPageData(int n, int n2, String string, int n3) throws SMDatabaseException {
        this.debugLogWriter.println("MrReportDataController: Inside getPageData");
        MrReportCachedData mrReportCachedData = this.cacheTable.getFromCache(n);
        SMReportData sMReportData = null;
        if (mrReportCachedData == null) {
            this.debugLogWriter.println("MrReportDataController: No cache available.");
            return this.getEmptyData();
        }
        int n4 = mrReportCachedData.getCacheType();
        if (n4 == 2) {
            sMReportData = this.getCurrentPageData(mrReportCachedData, n2, string, n3);
            if (!sMReportData.isEmptyData()) {
                sMReportData.setCacheID(n);
            }
            return sMReportData;
        }
        if (n4 == 1) {
            sMReportData = this.getHistoricalPageData(mrReportCachedData, n2, string, n3);
            if (!sMReportData.isEmptyData()) {
                sMReportData.setCacheID(n);
            } else {
                this.debugLogWriter.println("Returning empty data");
            }
            return sMReportData;
        }
        return null;
    }

    protected SMReportData getCurrentPageData(MrReportCachedData mrReportCachedData, int n, String string, int n2) throws SMDatabaseException {
        this.debugLogWriter.println("MrReportDataController: Inside getCurrentPageData");
        McLogData mcLogData = (McLogData)mrReportCachedData.getCachedObject();
        String string2 = mcLogData.getFileName();
        SMReportRequest sMReportRequest = (SMReportRequest)mrReportCachedData.getRequest();
        SMReportTemplate sMReportTemplate = sMReportRequest.getTemplate();
        SMReportPropertyGroup sMReportPropertyGroup = sMReportTemplate.getPropertyGroup();
        if (sMReportPropertyGroup == null) {
            this.debugLogWriter.println("MrReportDataController: property group is null");
            return null;
        }
        Vector vector = sMReportPropertyGroup.getPropertySet();
        if (vector == null) {
            this.debugLogWriter.println("MrReportDataController: property list is null");
            return null;
        }
        vector = mrReportCachedData.getPropertyList();
        if (vector == null) {
            this.debugLogWriter.println("MrReportDataController: Could not find property list in cache");
            return this.getEmptyData();
        }
        Hashtable hashtable = null;
        hashtable = this.buildPropIndexMap(vector);
        int n3 = hashtable.size();
        int n4 = this.pageSize * n3;
        int n5 = mcLogData.totalLines();
        int n6 = 1;
        int n7 = this.maxPages * n4;
        if (n != 0) {
            n6 = (n - 1) * n4 + 1;
            n7 = n6 + n4 - 1;
        }
        if (n6 > n5) {
            n6 = n5;
        }
        if (n7 > n5) {
            n7 = n5;
        }
        SMReportData sMReportData = this.readDataFromFile(string2, n6, n7, hashtable, mcLogData, n4);
        sMReportData.setPropertyList(vector);
        return sMReportData;
    }

    protected SMReportData getHistoricalPageData(MrReportCachedData mrReportCachedData, int n, String string, int n2) throws SMDatabaseException {
        this.debugLogWriter.println("MrReportDataController: Inside getHistoricalPageData, pagenumber = " + n);
        SMReportRequest sMReportRequest = (SMReportRequest)mrReportCachedData.getRequest();
        int n3 = sMReportRequest.getReportType();
        if (n3 == 5) {
            return this.getHistoricalPerfPageData(sMReportRequest, mrReportCachedData, n, string, n2);
        }
        return this.getNonPerfPageData(sMReportRequest, mrReportCachedData, n, string, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SMReportData getNonPerfPageData(SMReportRequest sMReportRequest, MrReportCachedData mrReportCachedData, int n, String string, int n2) throws SMDatabaseException {
        this.debugLogWriter.println("MrReportDataController: Inside getNonPerfPageData");
        SMReportTemplate sMReportTemplate = sMReportRequest.getTemplate();
        SMReportPropertyGroup sMReportPropertyGroup = sMReportTemplate.getPropertyGroup();
        if (sMReportPropertyGroup == null) {
            this.debugLogWriter.println("MrReportDataController: property group is null");
            return null;
        }
        Vector vector = sMReportPropertyGroup.getPropertySet();
        if (vector == null) {
            this.debugLogWriter.println("MrReportDataController: Propert list is null");
            return null;
        }
        Vector vector2 = (Vector)mrReportCachedData.getCachedObject();
        String string2 = mrReportCachedData.getCacheTag();
        int n3 = vector2.size();
        int n4 = 0;
        int n5 = this.maxPages * this.pageSize - 1;
        if (n != 0) {
            n4 = (n - 1) * this.pageSize;
            n5 = n4 + this.pageSize - 1;
        }
        if (n4 >= n3) {
            n4 = n3 - 1;
        }
        if (n5 >= n3) {
            n5 = n3 - 1;
        }
        Vector<Double> vector3 = new Vector<Double>();
        int n6 = n4;
        while (n6 <= n5) {
            vector3.add((Double)vector2.elementAt(n6));
            ++n6;
        }
        Object[] objectArray = new Double[vector3.size()];
        vector3.copyInto(objectArray);
        Connection connection = MSDB.getConnection();
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection.prepareCall("{call pkg_nonperf_data.get_nonperf_data(?,?,?,?,?)}");
                callableStatement.registerOutParameter(5, -10);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMReportRequest.getObjectID());
                MSDB.setNullable((PreparedStatement)callableStatement, (int)3, (String)string);
                callableStatement.setInt(4, n2);
                ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)"REPORT.NUM_ARRAY", (Connection)connection);
                ARRAY aRRAY = new ARRAY(arrayDescriptor, connection, (Object)objectArray);
                OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)callableStatement;
                oracleCallableStatement.setARRAY(2, aRRAY);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(5);
                SMReportData sMReportData = null;
                sMReportData = this.readResultSet(oracleResultSet, 0, 0);
                connection.commit();
                if (sMReportData.isEmptyData()) {
                    SMReportData sMReportData2 = sMReportData;
                    Object var28_28 = null;
                    MrReportTools.close(callableStatement);
                    MSDB.closeConnection((Connection)connection);
                    return sMReportData2;
                }
                sMReportData.setPropertyList(vector);
                sMReportData.setPageSize(this.pageSize);
                sMReportData.setNumberOfPages((n5 - n4 + this.pageSize) / this.pageSize);
                sMReportData.setCurrentPageNumber(n4 / this.pageSize + 1);
                int n7 = n3 / this.pageSize;
                int n8 = n3 % this.pageSize;
                if (n8 == 0) {
                    sMReportData.setTotalNumberOfPages(n7);
                } else {
                    sMReportData.setTotalNumberOfPages(n7 + 1);
                }
                SMReportData sMReportData3 = sMReportData;
                Object var28_29 = null;
                MrReportTools.close(callableStatement);
                MSDB.closeConnection((Connection)connection);
                return sMReportData3;
            }
            catch (SQLException sQLException) {
                this.debugLogWriter.println("MrReportDataController: Got SQLException");
                MSDB.rollback((Connection)connection);
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
        }
        catch (Throwable throwable) {
            Object var28_30 = null;
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SMReportData getHistoricalPerfPageData(SMReportRequest sMReportRequest, MrReportCachedData mrReportCachedData, int n, String string, int n2) throws SMDatabaseException {
        this.debugLogWriter.println("MrReportDataController: Inside getHistoricalPerfPageData");
        SMReportTemplate sMReportTemplate = sMReportRequest.getTemplate();
        SMReportPropertyGroup sMReportPropertyGroup = sMReportTemplate.getPropertyGroup();
        if (sMReportPropertyGroup == null) {
            this.debugLogWriter.println("MrReportDataController: property group is null");
            return null;
        }
        Vector vector = mrReportCachedData.getPropertyList();
        if (vector == null) {
            this.debugLogWriter.println("MrReportDataController: Property list is null");
            return null;
        }
        Hashtable hashtable = this.buildPropIndexMap(vector);
        int n3 = hashtable.size();
        int n4 = this.pageSize * n3;
        Vector vector2 = (Vector)mrReportCachedData.getCachedObject();
        String string2 = mrReportCachedData.getCacheTag();
        int n5 = vector2.size();
        int n6 = 0;
        int n7 = this.maxPages * n4 - 1;
        if (n != 0) {
            n6 = (n - 1) * n4;
            n7 = n6 + n4 - 1;
        }
        if (n6 >= n5) {
            n6 = n5 - 1;
        }
        if (n7 >= n5) {
            n7 = n5 - 1;
        }
        Vector<Double> vector3 = new Vector<Double>();
        int n8 = n6;
        while (n8 <= n7) {
            vector3.add((Double)vector2.elementAt(n8));
            ++n8;
        }
        Object[] objectArray = new Double[vector3.size()];
        vector3.copyInto(objectArray);
        Connection connection = MSDB.getConnection();
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection.prepareCall("{call pkg_perf_data.get_perf_data(?,?,?,?,?,?,?)}");
                callableStatement.registerOutParameter(7, -10);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMReportRequest.getObjectID());
                ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)"REPORT.NUM_ARRAY", (Connection)connection);
                ARRAY aRRAY = new ARRAY(arrayDescriptor, connection, (Object)objectArray);
                OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)callableStatement;
                oracleCallableStatement.setARRAY(2, aRRAY);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)6, (String)string2);
                String string3 = null;
                if (sMReportRequest.getTemplate().getFilter() != null) {
                    string3 = sMReportRequest.getTemplate().getFilter().getFunctionName();
                }
                MSDB.setNullable((PreparedStatement)callableStatement, (int)3, string3);
                Date date = null;
                if (sMReportRequest.getTemplate().getFilter() != null) {
                    date = sMReportRequest.getTemplate().getFilter().getStartDate();
                }
                MrReportTools.setDate(callableStatement, 4, date);
                Date date2 = null;
                if (sMReportRequest.getTemplate().getFilter() != null) {
                    date2 = sMReportRequest.getTemplate().getFilter().getEndDate();
                }
                MrReportTools.setDate(callableStatement, 5, date2);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(7);
                SMReportData sMReportData = this.readResultSet(oracleResultSet, hashtable);
                connection.commit();
                if (sMReportData.isEmptyData()) {
                    SMReportData sMReportData2 = sMReportData;
                    Object var34_34 = null;
                    MrReportTools.close(callableStatement);
                    MSDB.closeConnection((Connection)connection);
                    return sMReportData2;
                }
                sMReportData.setPropertyList(vector);
                sMReportData.setPageSize(this.pageSize);
                sMReportData.setNumberOfPages((n7 - n6 + n4) / n4);
                sMReportData.setCurrentPageNumber(n6 / n4 + 1);
                int n9 = n5 / n4;
                int n10 = n5 % n4;
                if (n10 == 0) {
                    sMReportData.setTotalNumberOfPages(n9);
                } else {
                    sMReportData.setTotalNumberOfPages(n9 + 1);
                }
                SMReportData sMReportData3 = sMReportData;
                Object var34_35 = null;
                MrReportTools.close(callableStatement);
                MSDB.closeConnection((Connection)connection);
                return sMReportData3;
            }
            catch (SQLException sQLException) {
                this.debugLogWriter.println("MrReportDataController: Got SQLException");
                MSDB.rollback((Connection)connection);
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
        }
        catch (Throwable throwable) {
            Object var34_36 = null;
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SMReportData getAlarmData(String string, int n, Date date, Date date2) throws SMDatabaseException, UnknownHostException {
        SMReportData sMReportData;
        CallableStatement callableStatement;
        Connection connection;
        block8: {
            SMReportData sMReportData2;
            block7: {
                this.debugLogWriter.println("MrReportDataController: Inside getAlarmData Hostname = " + string + " port = " + n + " start date = " + date.toString() + " end date = " + date2.toString());
                if (string == null || n <= 0) {
                    this.debugLogWriter.println("MrReportDataController: hostname can not be null or port can not be <= 0");
                    return null;
                }
                MSReportHostAddrMapper mSReportHostAddrMapper = MSReportHostAddrMapper.getInstance();
                String string2 = mSReportHostAddrMapper.getIPAddress(string);
                this.debugLogWriter.println("MrReportDataController: Converted " + string + " to " + string2);
                Vector vector = this.templController.getProperties(10);
                connection = MSDB.getConnection();
                callableStatement = null;
                try {
                    try {
                        callableStatement = connection.prepareCall("{call sp_get_alarms(?,?,?,?,?,?)}");
                        callableStatement.registerOutParameter(6, -10);
                        callableStatement.setString(1, string2);
                        callableStatement.setInt(2, n);
                        callableStatement.setString(3, String.valueOf(this.topoport));
                        MrReportTools.setDate(callableStatement, 4, date);
                        MrReportTools.setDate(callableStatement, 5, date2);
                        callableStatement.execute();
                        OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(6);
                        SMReportData sMReportData3 = this.readResultSet(oracleResultSet, 0, 0);
                        if (sMReportData3.isEmptyData()) {
                            sMReportData2 = sMReportData3;
                            Object var14_17 = null;
                            break block7;
                        }
                        sMReportData3.setPropertyList(vector);
                        sMReportData = sMReportData3;
                        break block8;
                    }
                    catch (SQLException sQLException) {
                        if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                            this.debugLogWriter.println("MrReportDataController: Got SQLException with MSDB.ROW_NOT_FOUND so sending empty data object to client");
                            SMReportData sMReportData4 = this.getEmptyData();
                            Object var14_19 = null;
                            MrReportTools.close(callableStatement);
                            MSDB.closeConnection((Connection)connection);
                            return sMReportData4;
                        }
                        this.debugLogWriter.println("MrReportDataController: Got SQLException");
                        SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                        throw sMDatabaseException;
                    }
                }
                catch (Throwable throwable) {
                    Object var14_20 = null;
                    MrReportTools.close(callableStatement);
                    MSDB.closeConnection((Connection)connection);
                    throw throwable;
                }
            }
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
            return sMReportData2;
        }
        Object var14_18 = null;
        MrReportTools.close(callableStatement);
        MSDB.closeConnection((Connection)connection);
        return sMReportData;
    }

    protected SMReportData readResultSet(OracleResultSet oracleResultSet, int n, int n2) throws SQLException {
        int n3;
        int n4;
        Object object;
        this.debugLogWriter.println("MrReportDataController: Inside read result set method.");
        Vector<Object> vector = new Vector<Object>();
        ResultSetMetaData resultSetMetaData = oracleResultSet.getMetaData();
        int n5 = resultSetMetaData.getColumnCount();
        int n6 = 1;
        int n7 = this.maxPages * this.pageSize;
        int n8 = 0;
        if (n != 0) {
            n6 = (n - 1) * this.pageSize + 1;
            n7 = n6 + this.pageSize - 1;
        }
        if (n6 > this.maxAllowedRecords) {
            n6 = this.maxAllowedRecords;
        }
        if (n7 > this.maxAllowedRecords) {
            n7 = this.maxAllowedRecords;
        }
        while (oracleResultSet.next()) {
            if (++n8 < n6) continue;
            if (n8 > n7) {
                if (n2 != 1) break;
                continue;
            }
            object = new Vector();
            n4 = 1;
            while (n4 <= n5) {
                n3 = resultSetMetaData.getColumnType(n4);
                switch (n3) {
                    case 4: {
                        ((Vector)object).add(String.valueOf(oracleResultSet.getInt(n4)));
                        break;
                    }
                    case 8: {
                        ((Vector)object).add(String.valueOf(oracleResultSet.getDouble(n4)));
                        break;
                    }
                    case 6: {
                        ((Vector)object).add(String.valueOf(oracleResultSet.getFloat(n4)));
                        break;
                    }
                    case 0: {
                        ((Vector)object).add(null);
                        break;
                    }
                    case 2: {
                        ((Vector)object).add(String.valueOf(oracleResultSet.getInt(n4)));
                        break;
                    }
                    case 12: {
                        if (resultSetMetaData.getColumnName(n4).toUpperCase().equals("INSTDATE")) {
                            ((Vector)object).add(this.readAsciiStream(oracleResultSet.getBinaryStream(n4), 512));
                            break;
                        }
                        ((Vector)object).add(oracleResultSet.getString(n4));
                        break;
                    }
                    case 1: {
                        ((Vector)object).add(oracleResultSet.getString(n4));
                        break;
                    }
                    case 93: {
                        Date date = MrReportTools.getDate(oracleResultSet, n4);
                        ((Vector)object).add(date);
                    }
                }
                ++n4;
            }
            vector.add(object);
        }
        if (n8 <= 0) {
            this.debugLogWriter.println("MrReportDataController: no data found.");
            return this.getEmptyData();
        }
        object = new SMReportData();
        object.setReportData(vector);
        if (n2 == 1) {
            object.setPageSize(this.pageSize);
            object.setNumberOfPages((n7 - n6 + this.pageSize) / this.pageSize);
            object.setCurrentPageNumber(n6 / this.pageSize + 1);
            n4 = n8 / this.pageSize;
            n3 = n8 % this.pageSize;
            if (n3 == 0) {
                object.setTotalNumberOfPages(n4);
            } else {
                object.setTotalNumberOfPages(n4 + 1);
            }
        }
        return object;
    }

    private String readAsciiStream(InputStream inputStream, int n) {
        byte[] byArray = new byte[n];
        try {
            int n2 = inputStream.read(byArray, 0, n);
            return new String(byArray, 0, n2, "US-ASCII");
        }
        catch (IOException iOException) {
            this.errorLogWriter.println("MrReportDataController readAsciiStream error: " + iOException.toString());
            return "";
        }
    }

    protected SMReportData readResultSet(OracleResultSet oracleResultSet, Hashtable hashtable) throws SQLException {
        Object object;
        this.debugLogWriter.println("MrReportDataController: Inside readResultSet for performance history data");
        Vector vector = new Vector();
        ResultSetMetaData resultSetMetaData = oracleResultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        int n2 = hashtable.size();
        if (n2 == 0) {
            this.debugLogWriter.println("MrReportDataController: Number of properties is 0, returning null");
            return null;
        }
        Vector<String> vector2 = null;
        int n3 = 0;
        while (oracleResultSet.next()) {
            if (++n3 > this.maxAllowedRecords) break;
            string = oracleResultSet.getString(1);
            object = MrReportTools.getDate(oracleResultSet, 6);
            string6 = String.valueOf(((Date)object).getTime());
            string2 = oracleResultSet.getString(2);
            string3 = oracleResultSet.getString(4);
            string4 = oracleResultSet.getString(3);
            string5 = oracleResultSet.getString(5);
            string7 = String.valueOf(oracleResultSet.getDouble(7));
            Integer n4 = (Integer)hashtable.get(this.getHashKey(string2, string3, string4, string5));
            if (n4 == null) {
                this.debugLogWriter.println("MrReportDataController: Could not find the index for property, ignoring it.");
                continue;
            }
            int n5 = n4 + 2;
            if (string8 == null) {
                vector2 = new Vector<String>();
                vector2.setSize(n2 + 2);
                vector2.set(0, string);
                vector2.set(1, string6);
                vector2.set(n5, string7);
                vector.add(vector2);
                string8 = string;
                string9 = string6;
                continue;
            }
            if (string.equals(string8) && string6.equals(string9)) {
                vector2.set(n5, string7);
                continue;
            }
            vector2 = new Vector();
            vector2.setSize(n2 + 2);
            vector2.set(0, string);
            vector2.set(1, string6);
            vector2.set(n5, string7);
            vector.add(vector2);
            string8 = string;
            string9 = string6;
        }
        if (n3 <= 0) {
            this.debugLogWriter.println("MrReportDataController: no data found.");
            return this.getEmptyData();
        }
        object = new SMReportData();
        object.setReportData(vector);
        return object;
    }

    protected SMReportData readAggreResultSet(OracleResultSet oracleResultSet, String[] stringArray, int n, int n2, Hashtable hashtable) throws SQLException {
        int n3;
        Serializable serializable;
        this.debugLogWriter.println("MrReportDataController: Inside readAggreResultSet for performance history data");
        Vector<Serializable> vector = new Vector<Serializable>();
        ResultSetMetaData resultSetMetaData = oracleResultSet.getMetaData();
        int n4 = resultSetMetaData.getColumnCount();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        if (stringArray == null && stringArray.length == 0) {
            this.debugLogWriter.println("MrReportDataController: Number of agents is 0, returning null");
            return null;
        }
        int n5 = hashtable.size();
        if (n5 == 0) {
            this.debugLogWriter.println("MrReportDataController: Number of properties is 0, returning null");
            return null;
        }
        if (n == 2) {
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append(stringArray[0]);
            n3 = 1;
            while (n3 < stringArray.length) {
                ((StringBuffer)serializable).append(",");
                ((StringBuffer)serializable).append(stringArray[n3]);
                ++n3;
            }
            string = ((StringBuffer)serializable).toString();
        }
        serializable = null;
        while (oracleResultSet.next()) {
            n3 = 1;
            if (n == 1) {
                string = oracleResultSet.getString(n3++);
            }
            string2 = oracleResultSet.getString(n3++);
            string4 = oracleResultSet.getString(n3++);
            string3 = oracleResultSet.getString(n3++);
            if (n2 == 2) {
                string5 = oracleResultSet.getString(n3++);
            }
            Date date = MrReportTools.getDate(oracleResultSet, n3++);
            string6 = String.valueOf(date.getTime());
            string7 = String.valueOf(oracleResultSet.getDouble(n3));
            Integer n6 = (Integer)hashtable.get(this.getHashKey(string2, string3, string4, string5));
            if (n6 == null) {
                this.debugLogWriter.println("MrReportDataController: Could not find the index for property, ignoring it.");
                continue;
            }
            int n7 = n6 + 2;
            if (string9 != null && string.equals(string8) && string6.equals(string9)) {
                ((Vector)serializable).set(n7, string7);
                continue;
            }
            serializable = new Vector();
            ((Vector)serializable).setSize(n5 + 2);
            ((Vector)serializable).set(0, string);
            ((Vector)serializable).set(1, string6);
            ((Vector)serializable).set(n7, string7);
            vector.add(serializable);
            string8 = string;
            string9 = string6;
        }
        SMReportData sMReportData = new SMReportData();
        sMReportData.setReportData(vector);
        return sMReportData;
    }

    public void stopDataCollection(String string, int n) throws SMAPIException, SMDatabaseException, UnknownHostException {
        this.debugLogWriter.println("MrReportDataController: Inside method stopDataCollection");
        MSReportHostAddrMapper mSReportHostAddrMapper = MSReportHostAddrMapper.getInstance();
        String string2 = mSReportHostAddrMapper.getIPAddress(string);
        this.debugLogWriter.println("MrReportDataController: Converted " + string + " to " + string2);
        ScSecurityCredential scSecurityCredential = this.service.getUserSecurityCredential();
        SMRawDataRequest sMRawDataRequest = new SMRawDataRequest(scSecurityCredential);
        SMModuleRequest sMModuleRequest = new SMModuleRequest(sMRawDataRequest);
        this.debugLogWriter.println("MrReportDataController: Got ModuleRequest object.");
        if (sMModuleRequest.isModuleLoaded(string2, n, PERFTOOLMODULE)) {
            this.debugLogWriter.println("MrReportDataController: Module is loaded, unloading it");
            sMModuleRequest.unloadModule(string2, n, PERFTOOLMODULE, null);
            this.debugLogWriter.println("MrReportDataController: Module unloaded");
        }
        Connection connection = MSDB.getConnection();
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection.prepareCall("{call sp_update_prm_host(?,?,?,?,?)}");
                callableStatement.setString(1, string2);
                callableStatement.setString(2, string);
                callableStatement.setInt(3, n);
                callableStatement.setInt(4, 0);
                MrReportTools.setDate(callableStatement, 5, new Date());
                callableStatement.execute();
                connection.commit();
            }
            catch (SQLException sQLException) {
                this.debugLogWriter.println("MrReportTemplateController: got SQLException exception");
                MSDB.rollback((Connection)connection);
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
            Object var13_10 = null;
        }
        catch (Throwable throwable) {
            Object var13_11 = null;
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MrReportTools.close(callableStatement);
        MSDB.closeConnection((Connection)connection);
    }

    public void startDataCollection(String string, int n) throws SMAPIException, SMDatabaseException, UnknownHostException {
        this.debugLogWriter.println("MrReportDataController: Inside method startDataCollection");
        MSReportHostAddrMapper mSReportHostAddrMapper = MSReportHostAddrMapper.getInstance();
        String string2 = mSReportHostAddrMapper.getIPAddress(string);
        this.debugLogWriter.println("MrReportDataController: Converted " + string + " to " + string2);
        ScSecurityCredential scSecurityCredential = this.service.getUserSecurityCredential();
        SMRawDataRequest sMRawDataRequest = new SMRawDataRequest(scSecurityCredential);
        SMModuleRequest sMModuleRequest = new SMModuleRequest(sMRawDataRequest);
        sMModuleRequest.loadModuleAnyway(string2, n, PERFTOOLMODULE, null);
        Connection connection = MSDB.getConnection();
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection.prepareCall("{call sp_update_prm_host(?,?,?,?,?)}");
                callableStatement.setString(1, string2);
                callableStatement.setString(2, string);
                callableStatement.setInt(3, n);
                callableStatement.setInt(4, 1);
                MrReportTools.setDate(callableStatement, 5, new Date());
                callableStatement.execute();
                connection.commit();
            }
            catch (SQLException sQLException) {
                this.debugLogWriter.println("MrReportTemplateController: got SQLException exception");
                MSDB.rollback((Connection)connection);
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                throw sMDatabaseException;
            }
            Object var13_10 = null;
        }
        catch (Throwable throwable) {
            Object var13_11 = null;
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MrReportTools.close(callableStatement);
        MSDB.closeConnection((Connection)connection);
    }

    /*
     * WARNING - void declaration
     */
    public boolean scheduleRequest(SMDBObjectID sMDBObjectID, String[] stringArray, long l, long l2, int n) throws SMAPIException {
        Object object;
        this.debugLogWriter.println("MrReportDataController: Inside scheduleRequest");
        SMReportRequest sMReportRequest = null;
        try {
            sMReportRequest = this.templController.getReportRequest(sMDBObjectID);
        }
        catch (SMDatabaseException sMDatabaseException) {
            this.debugLogWriter.println("MrReportDataController: Got exception while geting request using request_id");
            throw sMDatabaseException;
        }
        if (sMReportRequest == null) {
            this.debugLogWriter.println("MrReportDataController: report request must not be null");
            return false;
        }
        String[] stringArray2 = new String[]{};
        String[] stringArray3 = new String[]{};
        Object[] objectArray = sMReportRequest.getAgentList();
        String[] stringArray4 = null;
        if (objectArray != null && objectArray.length != 0 && !"_ALL_".equals(objectArray[0])) {
            this.debugLogWriter.println("MrReportDataController: Converting agent list to ip list.");
            try {
                stringArray4 = MrReportTools.convertHostListToIPList((String[])objectArray);
            }
            catch (UnknownHostException unknownHostException) {
                this.debugLogWriter.println("MrReportDataController: Got UnknownHostException.");
            }
            this.debugLogWriter.println("MrReportDataController: Converted agent list to ip list.");
            if (stringArray4 != null && stringArray4.length != 0) {
                void var14_15;
                object = new Vector();
                boolean n2 = false;
                while (var14_15 < stringArray4.length) {
                    if (stringArray4[var14_15] != null && !((Vector)object).contains(stringArray4[var14_15])) {
                        ((Vector)object).add(stringArray4[var14_15]);
                    }
                    ++var14_15;
                }
                objectArray = new String[((Vector)object).size()];
                ((Vector)object).copyInto(objectArray);
                stringArray2 = MrReportTools.extractFieldArray((String[])objectArray, ":", 1);
                stringArray3 = MrReportTools.extractFieldArray((String[])objectArray, ":", 2);
            }
        }
        object = McCollectService.getInstance();
        boolean bl2 = false;
        bl2 = ((McCollectService)object).createReportTaskRequest(sMDBObjectID, stringArray2, stringArray3, stringArray, l, l2, n);
        return bl2;
    }

    public boolean removeScheduledRequest(SMDBObjectID sMDBObjectID) throws SMAPIException {
        McCollectService mcCollectService = McCollectService.getInstance();
        boolean bl = mcCollectService.removeScheduledRequest(sMDBObjectID);
        return bl;
    }

    public SMScheduledRequestStatus[] getScheduledRequestStatus() throws SMSecurityException, SMDatabaseException {
        McCollectService mcCollectService = McCollectService.getInstance();
        return mcCollectService.getScheduledRequestStatus();
    }

    /*
     * Unable to fully structure code
     */
    private void createIPHostMapping(McLogData var1_1, SMReportData var2_2, String[] var3_3, String[] var4_4) {
        this.debugLogWriter.println("MrReportDataController: createIPHostMapping called for raw data");
        var5_5 = new Hashtable<K, V>();
        var6_6 = new Hashtable<String, String[]>();
        var7_7 = var1_1.getAgentList();
        var8_8 = var1_1.getFileName();
        if (var3_3 == null) {
            this.errorLogWriter.println("MrReportDataController: The complete IP list is null. Unable to generate host map");
            var2_2.setHostMap(null);
            return;
        }
        var9_9 = new File(var8_8);
        if (!var9_9.canRead()) {
            this.debugLogWriter.println("MrReportDataController: Can not read" + var8_8);
            var2_2.setHostMap(null);
            return;
        }
        var10_10 = null;
        try {
            var10_10 = new RandomAccessFile(var9_9, "r");
        }
        catch (FileNotFoundException var11_11) {
            this.errorLogWriter.println("MrReportDataController: Can not read" + var8_8);
            var2_2.setHostMap(null);
            return;
        }
        var11_12 = null;
        var12_13 = new Vector<E>();
        var13_14 = null;
        var14_15 = 0;
        while (var14_15 < var4_4.length) {
            block22: {
                block24: {
                    block23: {
                        block21: {
                            var15_16 = new String[1];
                            var16_18 = var3_3[var14_15];
                            if (var16_18 != null) break block21;
                            var15_16[0] = "";
                            var6_6.put(var4_4[var14_15], var15_16);
                            break block22;
                        }
                        if (!var5_5.contains(var16_18)) break block23;
                        var15_16 = (String[])var5_5.get(var16_18);
                        var6_6.put(var16_18, var15_16);
                        break block22;
                    }
                    var17_19 = false;
                    var18_20 = 0;
                    while (var18_20 < var7_7.size()) {
                        if (((McAgentLogData)var7_7.elementAt(var18_20)).getAgent().equals(var16_18)) {
                            var13_14 = (McAgentLogData)var7_7.elementAt(var18_20);
                            var17_19 = true;
                            break;
                        }
                        ++var18_20;
                    }
                    if (var17_19) break block24;
                    var15_16[0] = var4_4[var14_15];
                    var6_6.put(var4_4[var14_15], var15_16);
                    break block22;
                }
                var19_21 = var13_14.getStartLine();
                if (var19_21 != var13_14.getEndLine() || var19_21 != 0 && var19_21 != -1) ** GOTO lbl98
                this.debugLogWriter.println("MrReportDataController: No data for agent " + var13_14.getAgent());
                var15_16[0] = var4_4[var14_15];
                this.debugLogWriter.println("MrReportDataController: Adding - > " + var4_4[var14_15] + "with -> " + var15_16[0]);
                var6_6.put(var4_4[var14_15], var15_16);
                break block22;
lbl-1000:
                // 1 sources

                {
                    var20_22 = var1_1.getLinePosition(var19_21);
                    if (var20_22 == -1L) {
                        this.debugLogWriter.println("MrReportDataController: start line map is not present.");
                        try {
                            if (var10_10 != null) {
                                var10_10.close();
                            }
                        }
                        catch (IOException var22_24) {
                            // empty catch block
                        }
                        var2_2.setHostMap(null);
                        return;
                    }
                    try {
                        var10_10.seek(var20_22);
                        var11_12 = var10_10.readLine();
                    }
                    catch (IOException var22_25) {
                        break;
                    }
                    if (var11_12 != null) {
                        if (UcListUtil.decomposeList((String)var11_12, var12_13)) {
                            var22_26 = Integer.parseInt((String)var12_13.elementAt(0));
                            var23_27 = var13_14.getPropertyByIndex(var22_26);
                            if (var23_27 != null) {
                                var15_16[0] = var23_27.getHost();
                                var15_16[0] = var15_16[0] + ":" + var23_27.getPort();
                                this.debugLogWriter.println("MrReportDataController: Adding agentFromC-> " + var4_4[var14_15] + "with agentFromData-> " + var15_16[0]);
                                var6_6.put(var4_4[var14_15], var15_16);
                                break;
                            }
                            ++var19_21;
                            continue;
                        }
                        ++var19_21;
                        continue;
                    }
                    ++var19_21;
lbl98:
                    // 4 sources

                    ** while (var19_21 <= var13_14.getEndLine())
                }
lbl99:
                // 3 sources

                if (var15_16[0] == null) {
                    this.debugLogWriter.println("MrReportDataController: Unable to get agent name from data for " + var4_4[var14_15]);
                    var15_16[0] = var4_4[var14_15];
                    var6_6.put(var4_4[var14_15], var15_16);
                }
            }
            ++var14_15;
        }
        var2_2.setHostMap(var6_6);
        try {
            if (var10_10 != null) {
                var10_10.close();
            }
        }
        catch (IOException var15_17) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createIPHostMapping(SMReportData sMReportData, String[] stringArray, String[] stringArray2) throws SMDatabaseException {
        CallableStatement callableStatement;
        Connection connection;
        block11: {
            block10: {
                this.debugLogWriter.println("MrReportDataController: Inside createIPHostMapping ");
                Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
                if (stringArray2.length == 1 && "_ALL_".equals(stringArray2[0])) {
                    hashtable.put(stringArray2[0], stringArray2);
                    sMReportData.setHostMap(hashtable);
                    return;
                }
                if (stringArray == null) {
                    this.errorLogWriter.println("MrReportDataController: The complete IP list is null. Unable to generate host map");
                    sMReportData.setHostMap(null);
                    return;
                }
                connection = MSDB.getConnection();
                callableStatement = null;
                try {
                    try {
                        callableStatement = connection.prepareCall("{ call  sp_get_ip_host_map(?,?)}");
                        ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)"REPORT.STR_ARRAY", (Connection)connection);
                        ARRAY aRRAY = new ARRAY(arrayDescriptor, connection, (Object)stringArray);
                        OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)callableStatement;
                        oracleCallableStatement.setARRAY(1, aRRAY);
                        callableStatement.registerOutParameter(2, -10);
                        callableStatement.execute();
                        OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(2);
                        int n = 0;
                        while (true) {
                            if (!oracleResultSet.next()) {
                                connection.commit();
                                if (n == stringArray.length) break;
                                this.errorLogWriter.println("MrReportDataController: createIPHostMapping DB returned incorrect list");
                                sMReportData.setHostMap(null);
                                Object var14_15 = null;
                                break block10;
                            }
                            String[] stringArray3 = new String[]{oracleResultSet.getString("host_port")};
                            if (stringArray3[0] == null) {
                                stringArray3[0] = stringArray[n] == null ? "" : stringArray2[n];
                            }
                            hashtable.put(stringArray2[n], stringArray3);
                            this.debugLogWriter.println("MrReportDataConntroller: agent from console -> " + stringArray2[n] + "agent from db-> " + stringArray3[0]);
                            ++n;
                        }
                        sMReportData.setHostMap(hashtable);
                        break block11;
                    }
                    catch (SQLException sQLException) {
                        this.debugLogWriter.println("MrReportDataController: got SQLException exception");
                        SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                        throw sMDatabaseException;
                    }
                }
                catch (Throwable throwable) {
                    Object var14_17 = null;
                    MrReportTools.close(callableStatement);
                    MSDB.closeConnection((Connection)connection);
                    throw throwable;
                }
            }
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
            return;
        }
        Object var14_16 = null;
        MrReportTools.close(callableStatement);
        MSDB.closeConnection((Connection)connection);
    }

    public SMReportData getCurrentUptimeTotalData(SMReportRequest sMReportRequest, int n, String[] stringArray, String string, int n2, String[] stringArray2, String[] stringArray3) throws SMDatabaseException, SMAPIException {
        this.debugLogWriter.println("MrReportDataController: Inside getCurrentUptimeTotalData");
        McCollectService mcCollectService = McCollectService.getInstance();
        SMReportTemplate sMReportTemplate = sMReportRequest.getTemplate();
        SMReportPropertyGroup sMReportPropertyGroup = sMReportTemplate.getPropertyGroup();
        if (sMReportPropertyGroup == null) {
            this.debugLogWriter.println("MrReportDataController: property group is null");
            return null;
        }
        SMReportFilter sMReportFilter = sMReportTemplate.getFilter();
        if (sMReportFilter == null) {
            this.debugLogWriter.println("MrReportDataController: filter is null");
            return null;
        }
        Vector vector = sMReportPropertyGroup.getPropertySet();
        if (vector == null) {
            this.debugLogWriter.println("MrReportDataController: property list is null");
            return null;
        }
        Enumeration enumeration = vector.elements();
        SMReportProperty sMReportProperty = null;
        Vector<String> vector2 = new Vector<String>(10, 10);
        while (enumeration.hasMoreElements()) {
            sMReportProperty = (SMReportProperty)enumeration.nextElement();
            vector2.addElement(sMReportProperty.getPropertyName());
        }
        Object[] objectArray = new String[vector2.size()];
        vector2.copyInto(objectArray);
        Date date = sMReportFilter.getStartDate();
        Date date2 = sMReportFilter.getEndDate();
        long l = date.getTime() / 1000L;
        long l2 = date2.getTime() / 1000L;
        Vector vector3 = mcCollectService.getUptimeSummaryData(0, stringArray, l, l2, (String[])objectArray);
        if (vector3 == null) {
            this.debugLogWriter.println("MrReportDataController: getCurrentUptimeTotalData returned null");
            return this.getEmptyData();
        }
        enumeration = vector.elements();
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            sMReportProperty = (SMReportProperty)enumeration.nextElement();
            hashtable.put(sMReportProperty.getPropertyName(), new Integer(n3));
            ++n3;
        }
        int n4 = hashtable.size();
        SMReportData sMReportData = new SMReportData();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        McAgentUptimeData mcAgentUptimeData = null;
        Vector vector4 = new Vector();
        Vector<String> vector5 = null;
        int n5 = 0;
        while (n5 < vector3.size()) {
            mcAgentUptimeData = (McAgentUptimeData)vector3.elementAt(n5);
            Vector vector6 = mcAgentUptimeData.getData();
            int n6 = 0;
            while (n6 < vector6.size()) {
                Vector vector7;
                String string12 = (String)vector6.elementAt(n6);
                if (!UcListUtil.decomposeList((String)string12, vector7 = new Vector())) {
                    this.debugLogWriter.println("MrReportDataController: Could not parse the line " + string12);
                } else {
                    Object object = vector7.elements();
                    string2 = (String)object.nextElement();
                    string3 = (String)object.nextElement();
                    string7 = (String)object.nextElement();
                    string4 = (String)object.nextElement();
                    string4 = string4.concat("000");
                    string5 = (String)object.nextElement();
                    string5 = string5.concat("000");
                    string6 = (String)object.nextElement();
                    object = (Integer)hashtable.get(string7);
                    int n7 = (Integer)object + 3;
                    string9 = string2 + ":" + string3;
                    if (string8 == null) {
                        this.debugLogWriter.println("MrReportDataController: Creating new data vector.");
                        vector5 = new Vector<String>();
                        vector5.setSize(n4 + 3);
                        vector5.set(0, string9);
                        vector5.set(1, string4);
                        vector5.set(2, string5);
                        vector5.set(n7, string6);
                        vector4.add(vector5);
                        string8 = string9;
                        string11 = string4;
                        string10 = string5;
                    } else if (string9.equals(string8) && string4.equals(string11) && string5.equals(string10)) {
                        vector5.set(n7, string6);
                    } else {
                        vector5 = new Vector();
                        vector5.setSize(n4 + 3);
                        vector5.set(0, string9);
                        vector5.set(1, string4);
                        vector5.set(2, string5);
                        vector5.set(n7, string6);
                        vector4.add(vector5);
                        string8 = string9;
                        string11 = string4;
                        string10 = string5;
                    }
                }
                ++n6;
            }
            ++n5;
        }
        sMReportData.setReportData(vector4);
        sMReportData.setPropertyList(vector);
        this.createIPHostMapping(vector3, sMReportData, stringArray3, stringArray2);
        return sMReportData;
    }

    public SMReportData getCurrentUptimeStatusData(SMReportRequest sMReportRequest, int n, String[] stringArray, String string, int n2, String[] stringArray2, String[] stringArray3) throws SMDatabaseException, SMAPIException {
        this.debugLogWriter.println("MrReportDataController: Inside getCurrentUptimeStatusData");
        McCollectService mcCollectService = McCollectService.getInstance();
        SMReportTemplate sMReportTemplate = sMReportRequest.getTemplate();
        SMReportPropertyGroup sMReportPropertyGroup = sMReportTemplate.getPropertyGroup();
        if (sMReportPropertyGroup == null) {
            this.debugLogWriter.println("MrReportDataController: property group is null");
            return null;
        }
        SMReportFilter sMReportFilter = sMReportTemplate.getFilter();
        if (sMReportFilter == null) {
            this.debugLogWriter.println("MrReportDataController: filter is null");
            return null;
        }
        Vector vector = sMReportPropertyGroup.getPropertySet();
        if (vector == null) {
            this.debugLogWriter.println("MrReportDataController: property list is null");
            return null;
        }
        Enumeration enumeration = vector.elements();
        SMReportProperty sMReportProperty = null;
        Vector<String> vector2 = new Vector<String>(10, 10);
        while (enumeration.hasMoreElements()) {
            sMReportProperty = (SMReportProperty)enumeration.nextElement();
            vector2.addElement(sMReportProperty.getPropertyName());
        }
        Object[] objectArray = new String[vector2.size()];
        vector2.copyInto(objectArray);
        Date date = sMReportFilter.getStartDate();
        Date date2 = sMReportFilter.getEndDate();
        long l = date.getTime() / 1000L;
        long l2 = date2.getTime() / 1000L;
        Vector vector3 = mcCollectService.getUptimeSummaryData(1, stringArray, l, l2, (String[])objectArray);
        if (vector3 == null) {
            this.debugLogWriter.println("MrReportDataController: getCurrentUptimeTotalData returned null");
            return this.getEmptyData();
        }
        SMReportData sMReportData = new SMReportData();
        McAgentUptimeData mcAgentUptimeData = null;
        Vector vector4 = new Vector();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        Vector<String> vector5 = null;
        int n3 = 0;
        while (n3 < vector3.size()) {
            mcAgentUptimeData = (McAgentUptimeData)vector3.elementAt(n3);
            Vector vector6 = mcAgentUptimeData.getData();
            String string8 = null;
            int n4 = 0;
            while (n4 < vector6.size()) {
                Vector vector7;
                String string9 = (String)vector6.elementAt(n4);
                if (!UcListUtil.decomposeList((String)string9, vector7 = new Vector())) {
                    this.debugLogWriter.println("MrReportDataController: Could not parse the line " + string9);
                } else {
                    Object object = vector7.elements();
                    string2 = (String)object.nextElement();
                    string3 = (String)object.nextElement();
                    string4 = (String)object.nextElement();
                    string4 = string4.concat("000");
                    string5 = (String)object.nextElement();
                    string7 = string2 + ":" + string3;
                    if (string8 == null) {
                        vector5 = new Vector<String>();
                        vector5.setSize(4);
                        vector5.set(0, string7);
                        vector5.set(1, string4);
                        vector5.set(3, string5);
                        string6 = string5;
                        string8 = string7;
                        vector4.add(vector5);
                    } else {
                        object = (Vector)vector4.lastElement();
                        ((Vector)object).set(2, string4);
                        if (!string6.equals(string5)) {
                            vector5 = new Vector();
                            vector5.setSize(4);
                            vector5.set(0, string7);
                            vector5.set(1, string4);
                            vector5.set(3, string5);
                            string6 = string5;
                            if (n4 == vector6.size() - 1) {
                                String string10 = new Long(l2).toString();
                                string10 = string10.concat("000");
                                vector5.set(2, string10);
                            }
                            vector4.add(vector5);
                            string8 = string7;
                        }
                    }
                }
                ++n4;
            }
            ++n3;
        }
        sMReportData.setReportData(vector4);
        sMReportData.setPropertyList(vector);
        this.createIPHostMapping(vector3, sMReportData, stringArray3, stringArray2);
        return sMReportData;
    }

    private void createIPHostMapping(Vector vector, SMReportData sMReportData, String[] stringArray, String[] stringArray2) {
        this.debugLogWriter.println("MrReportDataController: createIPHostMapping called for uptime data");
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        if (stringArray == null) {
            this.errorLogWriter.println("MrReportDataController: The complete IP list is null. Unable to generate host map");
            sMReportData.setHostMap(null);
            return;
        }
        McAgentUptimeData mcAgentUptimeData = null;
        String string = null;
        Vector vector2 = new Vector();
        int n = 0;
        while (n < stringArray2.length) {
            String[] stringArray3 = new String[1];
            String string2 = stringArray[n];
            if (string2 == null) {
                stringArray3[0] = "";
                hashtable.put(stringArray2[n], stringArray3);
            } else {
                boolean bl = false;
                int n2 = 0;
                while (n2 < vector.size()) {
                    if (((McAgentUptimeData)vector.elementAt(n2)).getAgent().equals(string2)) {
                        mcAgentUptimeData = (McAgentUptimeData)vector.elementAt(n2);
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    stringArray3[0] = stringArray2[n];
                    hashtable.put(stringArray2[n], stringArray3);
                } else {
                    Vector vector3 = mcAgentUptimeData.getData();
                    int n3 = 0;
                    while (n3 < vector3.size()) {
                        string = (String)vector3.elementAt(n3);
                        if (UcListUtil.decomposeList((String)string, vector2)) {
                            String string3 = (String)vector2.elementAt(0);
                            String string4 = (String)vector2.elementAt(1);
                            stringArray3[0] = string3 + ":" + string4;
                            this.debugLogWriter.println("MrReportDataController: Adding - > " + stringArray2[n] + "with -> " + stringArray3[0]);
                            hashtable.put(stringArray2[n], stringArray3);
                            break;
                        }
                        ++n3;
                    }
                    if (stringArray3[0] == null) {
                        this.debugLogWriter.println("MrReportDataController: Unable to get agent name from data for " + stringArray2[n]);
                        stringArray3[0] = stringArray2[n];
                        hashtable.put(stringArray2[n], stringArray3);
                    }
                }
            }
            ++n;
        }
        sMReportData.setHostMap(hashtable);
        this.debugLogWriter.println("MrReportDataController: createIPHostMapping for uptime data finished");
    }

    private String getHashKey(String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("#");
        if (string != null) {
            stringBuffer.append(string);
        }
        stringBuffer.append("#");
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        stringBuffer.append("#");
        if (string3 != null) {
            stringBuffer.append(string3);
        }
        stringBuffer.append("#");
        if (string4 != null) {
            stringBuffer.append(string4);
        }
        stringBuffer.append("#");
        return stringBuffer.toString();
    }

    private int getReportProperties(SMReportRequest sMReportRequest, Vector vector) {
        int n = 0;
        SMReportTemplate sMReportTemplate = sMReportRequest.getTemplate();
        SMReportPropertyGroup sMReportPropertyGroup = sMReportTemplate.getPropertyGroup();
        if (sMReportPropertyGroup == null) {
            this.debugLogWriter.println("MrReportDataController: property group is null");
            return n;
        }
        Vector vector2 = sMReportPropertyGroup.getPropertySet();
        if (vector2 == null) {
            this.debugLogWriter.println("MrReportDataController: proprty list is null");
            return n;
        }
        Enumeration enumeration = vector2.elements();
        SMReportProperty sMReportProperty = null;
        Hashtable hashtable = new Hashtable();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            sMReportProperty = (SMReportProperty)enumeration.nextElement();
            vector.addElement(sMReportProperty);
            if (sMReportProperty.getPropertyInstance() == null || !sMReportProperty.getPropertyInstance().equals("_ALL_")) continue;
            n = 1;
        }
        return n;
    }

    private Vector getReportProperties(SMReportRequest sMReportRequest, String[] stringArray, String[] stringArray2, Vector vector, String string) throws SMDatabaseException {
        SMReportProperty sMReportProperty = null;
        Connection connection = MSDB.getConnection();
        CallableStatement callableStatement = null;
        Vector<SMReportProperty> vector2 = new Vector<SMReportProperty>();
        try {
            block6: {
                try {
                    callableStatement = connection.prepareCall("{call pkg_perf_data.get_perf_properties(?,?,?,?,?,?,?,?)}");
                    callableStatement.registerOutParameter(8, -10);
                    MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMReportRequest.getObjectID());
                    ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)"REPORT.STR_ARRAY", (Connection)connection);
                    ARRAY aRRAY = new ARRAY(arrayDescriptor, connection, (Object)stringArray);
                    OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)callableStatement;
                    oracleCallableStatement.setARRAY(2, aRRAY);
                    arrayDescriptor = ArrayDescriptor.createDescriptor((String)"REPORT.STR_ARRAY", (Connection)connection);
                    ARRAY aRRAY2 = new ARRAY(arrayDescriptor, connection, (Object)stringArray2);
                    oracleCallableStatement.setARRAY(3, aRRAY2);
                    String string2 = null;
                    Date date = null;
                    Date date2 = null;
                    if (sMReportRequest.getTemplate().getFilter() != null) {
                        string2 = sMReportRequest.getTemplate().getFilter().getFunctionName();
                        date = sMReportRequest.getTemplate().getFilter().getStartDate();
                        date2 = sMReportRequest.getTemplate().getFilter().getEndDate();
                    }
                    MSDB.setNullable((PreparedStatement)callableStatement, (int)4, string2);
                    MrReportTools.setDate(callableStatement, 5, date);
                    MrReportTools.setDate(callableStatement, 6, date2);
                    MSDB.setNullable((PreparedStatement)callableStatement, (int)7, (String)string);
                    callableStatement.execute();
                    OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(8);
                    while (oracleResultSet.next()) {
                        sMReportProperty = new SMReportProperty(oracleResultSet.getString("property"), oracleResultSet.getString("property_instance"), oracleResultSet.getString("module"), oracleResultSet.getString("module_instance"), oracleResultSet.getString("units"), new SMDBObjectID(oracleResultSet.getLong("property_id"), "report_property"));
                        this.setI18nKey(vector, sMReportProperty);
                        vector2.addElement(sMReportProperty);
                    }
                    connection.commit();
                    if (vector2.size() == 0) break block6;
                    vector = vector2;
                }
                catch (SQLException sQLException) {
                    this.debugLogWriter.println("MrReportDataController: Got SQLException");
                    MSDB.closeConnection((Connection)connection);
                    throw new SMDatabaseException("Error in get properties: " + sQLException.getMessage());
                }
            }
            Object var19_19 = null;
        }
        catch (Throwable throwable) {
            Object var19_20 = null;
            MrReportTools.close(callableStatement);
            throw throwable;
        }
        MrReportTools.close(callableStatement);
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SMReportData getSortedHistoricalData(SMReportRequest sMReportRequest, int n, String[] stringArray, int n2, int n3) throws SMDatabaseException {
        SMReportData sMReportData;
        Object object;
        Date date;
        Object object2;
        Date date2;
        Object object3;
        ARRAY aRRAY;
        Object[] objectArray;
        Object object4;
        int n4;
        this.debugLogWriter.println("MrReportDataController: Inside getSortedHistoricalData");
        SMReportTemplate sMReportTemplate = sMReportRequest.getTemplate();
        SMReportPropertyGroup sMReportPropertyGroup = sMReportTemplate.getPropertyGroup();
        if (sMReportPropertyGroup == null) {
            this.debugLogWriter.println("MrReportDataController: property group is null");
            return null;
        }
        Vector vector = sMReportPropertyGroup.getPropertySet();
        if (vector == null) {
            this.debugLogWriter.println("MrReportDataController: proprty list is null");
            return null;
        }
        Enumeration enumeration = vector.elements();
        SMReportProperty sMReportProperty = null;
        Hashtable hashtable = new Hashtable();
        int n5 = -1;
        boolean bl = true;
        boolean bl2 = false;
        Connection connection = MSDB.getConnection();
        CallableStatement callableStatement = null;
        CallableStatement callableStatement2 = null;
        boolean bl3 = false;
        Vector<Double> vector2 = new Vector<Double>(this.pageSize, this.pageSize);
        String string = null;
        int n6 = 0;
        try {
            try {
                callableStatement = connection.prepareCall("{call pkg_perf_data.get_perf_data_ids(?,?,?,?,?,?,?,?,?)}");
                callableStatement.registerOutParameter(9, -10);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMReportRequest.getObjectID());
                String[] stringArray2 = MrReportTools.extractFieldArray(stringArray, ":", 1);
                String[] stringArray3 = MrReportTools.extractFieldArray(stringArray, ":", 2);
                this.debugLogWriter.print("MrReportDataController: host list =");
                int n7 = 0;
                while (n7 < stringArray2.length) {
                    this.debugLogWriter.print(" " + stringArray2[n7]);
                    ++n7;
                }
                this.debugLogWriter.println("");
                this.debugLogWriter.print("MrReportDataController: port list =");
                n4 = 0;
                while (n4 < stringArray3.length) {
                    this.debugLogWriter.print(" " + stringArray3[n4]);
                    ++n4;
                }
                this.debugLogWriter.println("");
                object4 = ArrayDescriptor.createDescriptor((String)"REPORT.STR_ARRAY", (Connection)connection);
                ARRAY aRRAY2 = new ARRAY((ArrayDescriptor)object4, connection, (Object)stringArray2);
                objectArray = (Object[])callableStatement;
                objectArray.setARRAY(2, aRRAY2);
                object4 = ArrayDescriptor.createDescriptor((String)"REPORT.STR_ARRAY", (Connection)connection);
                aRRAY = new ARRAY((ArrayDescriptor)object4, connection, (Object)stringArray3);
                objectArray.setARRAY(3, aRRAY);
                object3 = null;
                if (sMReportRequest.getTemplate().getFilter() != null) {
                    object3 = sMReportRequest.getTemplate().getFilter().getFunctionName();
                }
                MSDB.setNullable((PreparedStatement)callableStatement, (int)4, object3);
                date2 = null;
                if (sMReportRequest.getTemplate().getFilter() != null) {
                    date2 = sMReportRequest.getTemplate().getFilter().getStartDate();
                    this.debugLogWriter.println("MrReportDataController: Start Date = " + date2.toString());
                }
                MrReportTools.setDate(callableStatement, 5, date2);
                object2 = null;
                if (sMReportRequest.getTemplate().getFilter() != null) {
                    object2 = sMReportRequest.getTemplate().getFilter().getEndDate();
                    this.debugLogWriter.println("MrReportDataController: End Date = " + ((Date)object2).toString());
                }
                MrReportTools.setDate(callableStatement, 6, object2);
                date = new Date();
                MrReportTools.setDate(callableStatement, 7, date);
                this.debugLogWriter.println("MrReportDataController: Run Date = " + date.toString());
                callableStatement.registerOutParameter(8, 12);
                callableStatement.execute();
                object = (OracleResultSet)callableStatement.getObject(9);
                string = (String)callableStatement.getObject(8);
                while (object.next()) {
                    if (n6 >= this.maxAllowedRecords) {
                        bl3 = true;
                        break;
                    }
                    ++n6;
                    vector2.add(new Double(object.getDouble(1)));
                }
                this.debugLogWriter.println("MrReportDataController: Got " + n6 + " ids");
                connection.commit();
                if (n6 <= 0) {
                    this.debugLogWriter.println("MrReportDataController: no data found.");
                    MSDB.closeConnection((Connection)connection);
                    SMReportData sMReportData2 = this.getEmptyData();
                    Object var37_45 = null;
                    MrReportTools.close(callableStatement);
                    return sMReportData2;
                }
                sMReportData = null;
            }
            catch (SQLException sQLException) {
                this.debugLogWriter.println("MrReportDataController: Got SQLException");
                MSDB.rollback((Connection)connection);
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                MSDB.closeConnection((Connection)connection);
                throw sMDatabaseException;
            }
            MrReportTools.close(callableStatement);
        }
        catch (Throwable throwable) {
            Object var37_47 = null;
            MrReportTools.close(callableStatement);
            throw throwable;
        }
        int n8 = n2;
        int n9 = this.pageSize * n8;
        if (n6 > n9) {
            MrReportCachedData mrReportCachedData = new MrReportCachedData(sMReportRequest, vector2, 1, string);
            mrReportCachedData.setPropertyList(vector);
            n5 = this.cacheTable.cache(mrReportCachedData);
        }
        int n10 = 0;
        n4 = this.maxPages * n9 - 1;
        if (n != 0) {
            n10 = (n - 1) * n9;
            n4 = n10 + n9 - 1;
        }
        if (n4 >= n6) {
            n4 = n6 - 1;
        }
        if (n10 >= n6) {
            n10 = n6 - 1;
        }
        object4 = new Vector();
        int n11 = n10;
        while (n11 <= n4) {
            ((Vector)object4).add((Double)vector2.elementAt(n11));
            ++n11;
        }
        objectArray = new Double[((Vector)object4).size()];
        ((Vector)object4).copyInto(objectArray);
        try {
            try {
                SMReportData sMReportData3;
                callableStatement = connection.prepareCall("{call sp_get_sorted_perf_data(?,?,?,?,?,?,?,?,?)}");
                callableStatement.registerOutParameter(9, -10);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMReportRequest.getObjectID());
                aRRAY = ArrayDescriptor.createDescriptor((String)"REPORT.NUM_ARRAY", (Connection)connection);
                object3 = new ARRAY((ArrayDescriptor)aRRAY, connection, (Object)objectArray);
                date2 = (OracleCallableStatement)callableStatement;
                date2.setARRAY(2, (ARRAY)object3);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)6, (String)string);
                object2 = null;
                if (sMReportRequest.getTemplate().getFilter() != null) {
                    object2 = sMReportRequest.getTemplate().getFilter().getFunctionName();
                }
                MSDB.setNullable((PreparedStatement)callableStatement, (int)3, (String)object2);
                date = null;
                if (sMReportRequest.getTemplate().getFilter() != null) {
                    date = sMReportRequest.getTemplate().getFilter().getStartDate();
                }
                MrReportTools.setDate(callableStatement, 4, date);
                object = null;
                if (sMReportRequest.getTemplate().getFilter() != null) {
                    object = sMReportRequest.getTemplate().getFilter().getEndDate();
                }
                MrReportTools.setDate(callableStatement, 5, (Date)object);
                callableStatement.setInt(7, n3);
                callableStatement.setInt(8, n2);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(9);
                if (bl) {
                    sMReportData3 = new Vector();
                    try {
                        block46: {
                            try {
                                callableStatement2 = connection.prepareCall("{call sp_get_sorted_perf_properties(?,?)}");
                                callableStatement2.registerOutParameter(2, -10);
                                this.debugLogWriter.println("MrReportDataController: procedure {call sp_get_sorted_perf_properties(?,?)}");
                                callableStatement2.setInt(1, n2);
                                callableStatement2.execute();
                                sMReportData = (OracleResultSet)callableStatement2.getObject(2);
                                while (sMReportData.next()) {
                                    sMReportProperty = new SMReportProperty(sMReportData.getString("property"), sMReportData.getString("property_instance"), sMReportData.getString("module"), sMReportData.getString("module_instance"), sMReportData.getString("units"), new SMDBObjectID(sMReportData.getLong("property_id"), "report_property"));
                                    this.setI18nKey(vector, sMReportProperty);
                                    sMReportData3.addElement(sMReportProperty);
                                }
                                this.debugLogWriter.println("MrReportDataController: Got " + sMReportData3.size() + " sorted properties");
                                if (sMReportData3.size() == 0) break block46;
                                vector = sMReportData3;
                            }
                            catch (SQLException sQLException) {
                                this.debugLogWriter.println("MrReportDataController: Got SQLException");
                                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                                MSDB.closeConnection((Connection)connection);
                                throw sMDatabaseException;
                            }
                        }
                        Object var40_52 = null;
                        MrReportTools.close(callableStatement2);
                    }
                    catch (Throwable throwable) {
                        Object var40_53 = null;
                        MrReportTools.close(callableStatement2);
                        throw throwable;
                    }
                }
                hashtable = this.buildPropIndexMap(vector);
                sMReportData3 = this.readResultSet(oracleResultSet, hashtable);
                connection.commit();
                if (sMReportData3.isEmptyData()) {
                    this.debugLogWriter.println("MrReportDataController: Got empty data object");
                    sMReportData = sMReportData3;
                    Object var42_58 = null;
                    MrReportTools.close(callableStatement);
                    MSDB.closeConnection((Connection)connection);
                    return sMReportData;
                }
                sMReportData3.setPropertyList(vector);
                sMReportData3.setPageSize(this.pageSize);
                if (string.equals("report_data_trend_hour")) {
                    sMReportData3.setDataType(1);
                } else if (string.equals("report_data_trend_day")) {
                    sMReportData3.setDataType(2);
                } else if (string.equals("report_data_trend_week")) {
                    sMReportData3.setDataType(3);
                } else if (string.equals("report_data_trend_month")) {
                    sMReportData3.setDataType(4);
                } else {
                    this.debugLogWriter.println("MrReportDataController: wrong table");
                    sMReportData3.setDataType(-1);
                }
                sMReportData3.setNumberOfPages((n4 - n10 + n9) / n9);
                sMReportData3.setCurrentPageNumber(n10 / n9 + 1);
                int n12 = n6 / n9;
                int n13 = n6 % n9;
                if (n13 == 0) {
                    sMReportData3.setTotalNumberOfPages(n12);
                } else {
                    sMReportData3.setTotalNumberOfPages(n12 + 1);
                }
                if (n5 >= 0) {
                    sMReportData3.setCacheID(n5);
                }
                if (bl3) {
                    sMReportData3.setMaxRecordsReached();
                }
                SMReportData sMReportData4 = sMReportData3;
                Object var42_59 = null;
                MrReportTools.close(callableStatement);
                MSDB.closeConnection((Connection)connection);
                return sMReportData4;
            }
            catch (SQLException sQLException) {
                this.debugLogWriter.println("MrReportDataController: Got SQLException");
                MSDB.rollback((Connection)connection);
                object3 = new SMDatabaseException((Throwable)sQLException);
                throw object3;
            }
        }
        catch (Throwable throwable) {
            Object var42_60 = null;
            MrReportTools.close(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
    }
}

