/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.common;

import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.utility.UcBeanIntrospector;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Security;

public class MSReportHostAddrMapper
extends Thread {
    private static final int DEFAULT_MAPSIZE = 100;
    private static final int DEFAULT_REFRESHINTERVAL = 86400;
    private static final String PRM_CONFIG_FILE = "collect.properties";
    private static MSReportHostAddrMapper _instance = null;
    private static boolean CACHE_ENABLED = true;
    private static MSLogPrintWriter debugLogWriter;
    private String[] ipMap;
    private String[] hostMap;
    private int mapIndex = -1;
    private int allowedMapSize = 100;
    private long refreshInterval = 86400000L;

    public static MSReportHostAddrMapper getInstance() {
        if (_instance != null) {
            return _instance;
        }
        _instance = new MSReportHostAddrMapper();
        if (CACHE_ENABLED) {
            debugLogWriter.println("Cache is enabled so starting the refresher thread.");
            _instance.start();
        }
        return _instance;
    }

    private MSReportHostAddrMapper() {
        Object object;
        debugLogWriter = MSLogPrintWriter.getDebugWriter();
        try {
            object = new UcBeanIntrospector();
            object.readProperties(PRM_CONFIG_FILE);
            object.apply((Object)this);
        }
        catch (Exception exception) {
            debugLogWriter.println("MSReportHostAddrMapper: Exception in instantiating UcBeanIntrospector, parameters will have default values.");
            debugLogWriter.println("MSReportHostAddrMapper: Exception is " + exception.getMessage());
        }
        try {
            object = Security.getProperty("networkaddress.cache.ttl");
            if (object == null) {
                debugLogWriter.println("Disabling cache, ttl = null.");
                CACHE_ENABLED = false;
            } else {
                int n = Integer.parseInt((String)object);
                if (n < 0 || (long)n >= this.refreshInterval) {
                    debugLogWriter.println("Disabling cache, ttl = " + n);
                    CACHE_ENABLED = false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (CACHE_ENABLED) {
            debugLogWriter.println("Cache is enabled so creating host and ip maps.");
            this.ipMap = new String[this.allowedMapSize];
            this.hostMap = new String[this.allowedMapSize];
            int n = 0;
            while (n < this.allowedMapSize) {
                this.ipMap[n] = null;
                this.hostMap[n] = null;
                ++n;
            }
        }
    }

    public void setAddressMapSize(int n) {
        this.allowedMapSize = n <= 0 ? 0 : n;
        debugLogWriter.println("Set the allowedMapSize to " + this.allowedMapSize);
    }

    public void setAddressRefreshInterval(int n) {
        this.refreshInterval = n <= 0 ? 86400000L : (long)(n * 1000);
        debugLogWriter.println("Set the refreshInterval to " + this.refreshInterval);
    }

    public void finalize() throws Throwable {
        debugLogWriter = null;
    }

    private int getMapIndex() {
        if (this.allowedMapSize <= 0) {
            return this.mapIndex;
        }
        this.mapIndex = (this.mapIndex + 1) % this.allowedMapSize;
        return this.mapIndex;
    }

    public synchronized String getIPAddress(String string) throws UnknownHostException {
        if (string == null) {
            throw new UnknownHostException();
        }
        String string2 = null;
        if (!CACHE_ENABLED) {
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                string2 = inetAddress.getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                debugLogWriter.println("Could not resolve the hostname " + string);
                throw unknownHostException;
            }
            return new String(string2);
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.allowedMapSize) {
            if (string.equals(this.hostMap[n2])) {
                if (this.ipMap[n2] == null) {
                    n = n2;
                    break;
                }
                return new String(this.ipMap[n2]);
            }
            ++n2;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            string2 = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            debugLogWriter.println("Could not resolve the hostname " + string);
            throw unknownHostException;
        }
        if (n == -1) {
            n = this.getMapIndex();
        }
        if (n >= 0) {
            this.hostMap[n] = new String(string);
            this.ipMap[n] = string2;
        }
        return new String(string2);
    }

    private synchronized void updateIPAddress(int n) {
        String string = null;
        try {
            InetAddress inetAddress = InetAddress.getByName(this.hostMap[n]);
            string = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            debugLogWriter.println("Host could not be resolved " + this.hostMap[n]);
            this.ipMap[n] = null;
            return;
        }
        this.ipMap[n] = string;
    }

    public void run() {
        while (true) {
            debugLogWriter.println("Started refresh, will refresh all the ip addresses.");
            int n = 0;
            while (n < this.allowedMapSize) {
                if (this.hostMap[n] != null) {
                    this.updateIPAddress(n);
                }
                ++n;
            }
            try {
                Thread.sleep(this.refreshInterval);
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    public static void main(String[] stringArray) {
        MSReportHostAddrMapper mSReportHostAddrMapper = MSReportHostAddrMapper.getInstance();
        int n = 0;
        while (true) {
            int n2 = 0;
            while (n2 < mSReportHostAddrMapper.allowedMapSize) {
                System.out.print(mSReportHostAddrMapper.hostMap[n2]);
                ++n2;
            }
            System.out.println("");
            int n3 = 0;
            while (n3 < mSReportHostAddrMapper.allowedMapSize) {
                System.out.print(mSReportHostAddrMapper.ipMap[n3]);
                ++n3;
            }
            System.out.println("");
            try {
                mSReportHostAddrMapper.getIPAddress("10.6.9.100");
                ++n;
            }
            catch (Exception exception) {
                System.out.println("Host can not be resolved. nagi" + n);
                ++n;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }
}

