/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.collect.task;

import com.sun.symon.base.mgmtservice.collect.McCollectService;
import com.sun.symon.base.mgmtservice.common.MSServiceException;
import com.sun.symon.base.utility.UcListUtil;
import java.util.Vector;

public class McSystemInfo {
    private String host = null;
    private String port = null;
    private String os = null;
    private String osversion = null;
    private String clockFrequency = null;
    private String arch = null;
    private String machineType = null;
    private String platform = null;
    private String serialNumber = null;
    private int disks = 0;
    private String memory = null;
    private int processors = 0;
    private int tapes = 0;
    private String content = null;

    public McSystemInfo(String string) throws MSServiceException {
        if (string == null || string.length() == 0) {
            throw new MSServiceException("System data is null");
        }
        this.content = string;
        Vector vector = new Vector();
        if (!UcListUtil.decomposeList((String)string, vector)) {
            McCollectService.getErrorWriter().println("McSystemInfo: Unable to decompose");
            throw new MSServiceException("Incorrect system data");
        }
        if (vector.size() != 13) {
            McCollectService.getErrorWriter().println("McSystemInfo: data has incorrect format");
            throw new MSServiceException("Incorrect system data");
        }
        this.host = (String)vector.elementAt(0);
        this.port = (String)vector.elementAt(1);
        this.os = (String)vector.elementAt(2);
        this.osversion = (String)vector.elementAt(3);
        this.clockFrequency = (String)vector.elementAt(4);
        this.arch = (String)vector.elementAt(5);
        this.machineType = (String)vector.elementAt(6);
        this.platform = (String)vector.elementAt(7);
        this.serialNumber = (String)vector.elementAt(8);
        this.disks = new Integer((String)vector.elementAt(9));
        this.memory = (String)vector.elementAt(10);
        this.processors = new Integer((String)vector.elementAt(11));
        this.tapes = new Integer((String)vector.elementAt(12));
    }

    public int getTapes() {
        return this.tapes;
    }

    public String getHostname() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getOS() {
        return this.os;
    }

    public String getOSVersion() {
        return this.osversion;
    }

    public String getClockFrequency() {
        return this.clockFrequency;
    }

    public String getArch() {
        return this.arch;
    }

    public String getMachineType() {
        return this.machineType;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public int getDisks() {
        return this.disks;
    }

    public String getMemory() {
        return this.memory;
    }

    public int getProcessors() {
        return this.processors;
    }

    public String getText() {
        return this.content;
    }
}

