/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.collect.task;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.mgmtservice.collect.McCollectConstants;
import com.sun.symon.base.mgmtservice.collect.McCollectService;
import com.sun.symon.base.mgmtservice.collect.McProbeConnection;
import com.sun.symon.base.mgmtservice.collect.task.McBaseHandler;
import com.sun.symon.base.mgmtservice.collect.task.McRequestData;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.common.MSObjectHandles;
import com.sun.symon.base.mgmtservice.common.MSServiceException;
import com.sun.symon.base.utility.UcListUtil;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;

public class McProbeCommand
implements McCollectConstants {
    private static final String CommandCfgFile = "com.sun.symon.base.mgmtservice.collect.task.collectCfg";
    private static MSLogPrintWriter logWriter;
    private String diffs = null;
    private String req = null;
    private String args = null;
    private String origReq = null;
    private Object resultData = null;
    private String notifyStr = "NOTIFY ";
    private boolean needResponse = true;
    private McCollectService handle = null;
    private static MSObjectHandles objHandle;
    private Vector requestList = null;
    private String hostname;
    private int agentPort;

    public McProbeCommand(McCollectService mcCollectService) {
        this.handle = mcCollectService;
        this.requestList = new Vector();
    }

    protected void finalize() throws Throwable {
        this.requestList.removeAllElements();
        this.requestList = null;
        this.handle = null;
    }

    public void setRequest(String string, String string2) {
        this.origReq = string;
        this.args = string2;
        this.req = string2 != null ? string + " " + string2 : string;
    }

    public void setResultData(Object object) {
        this.resultData = object;
    }

    public Object getResultData() {
        return this.resultData;
    }

    public void addRequests(McRequestData mcRequestData) {
        this.requestList.addElement(mcRequestData);
    }

    public void setTimeDiff(String string) {
        this.diffs = string;
    }

    public String getTimeDiff() {
        return this.diffs;
    }

    public void sendToAgent(String string, int n) throws SMAPIException {
        McProbeConnection mcProbeConnection = null;
        if (objHandle == null) {
            logWriter.println("No response handler available, request stop");
            return;
        }
        this.agentPort = n;
        try {
            mcProbeConnection = this.handle.getProbeConnection(string, n);
            mcProbeConnection.getConnection();
        }
        catch (Exception exception) {
            logWriter.println("Failed in establish probe connection to " + string);
            logWriter.println("Exception: " + exception.getMessage());
            mcProbeConnection.releaseConnection();
            if (this.origReq.equals("REPDATA")) {
                this.collectionFailed(string, n);
            }
            if (exception instanceof SMAPIException) {
                throw (SMAPIException)((Object)exception);
            }
            throw new SMAPIException((Throwable)exception);
        }
        McRequestData mcRequestData = null;
        try {
            this.sendToAgent(mcProbeConnection, string);
            while (this.requestList.size() > 0) {
                mcRequestData = (McRequestData)this.requestList.remove(0);
                if (mcRequestData == null) continue;
                this.setRequest(mcRequestData.getRequest(), mcRequestData.getArgs());
                this.notifyStr = mcRequestData.getNotifyStr();
                this.needResponse = mcRequestData.isNeedResponse();
                this.resultData = mcRequestData.getResultData();
                this.sendToAgent(mcProbeConnection, string);
            }
            mcProbeConnection.releaseConnection();
        }
        catch (Exception exception) {
            mcProbeConnection.releaseConnection();
            logWriter.println("Failed in sending request to agent: " + string);
            exception.printStackTrace();
            logWriter.println("Exception: " + exception.getMessage());
            if (this.origReq.equals("REPDATA")) {
                this.collectionFailed(string, n);
            }
            if (exception instanceof SMAPIException) {
                throw (SMAPIException)((Object)exception);
            }
            throw new SMAPIException((Throwable)exception);
        }
        if (this.hostname != null) {
            logWriter.println("McProbeConnection: calling updateIPHost");
            this.handle.updateIPHost(string, this.hostname, n);
        } else {
            logWriter.println("McProbeConnection: No update of the db as hostname is null. Probe was Successfull, no data from agent or raw/process request");
        }
    }

    private void sendToAgent(McProbeConnection mcProbeConnection, String string) throws SMAPIException {
        String string2 = null;
        Vector vector = new Vector();
        StringBuffer stringBuffer = null;
        if (this.notifyStr != null) {
            stringBuffer = new StringBuffer(this.notifyStr);
        }
        StringTokenizer stringTokenizer = null;
        if (!this.needResponse) {
            mcProbeConnection.request(this.req);
        } else {
            while (true) {
                String string3 = mcProbeConnection.requestResponse(this.req);
                stringTokenizer = new StringTokenizer(string3, "\n");
                String string4 = stringTokenizer.nextToken();
                UcListUtil.decomposeList((String)string4, vector);
                String string5 = (String)vector.elementAt(0);
                String string6 = (String)vector.elementAt(1);
                while (stringTokenizer.hasMoreTokens()) {
                    Object object;
                    string4 = stringTokenizer.nextToken();
                    if (!string4.startsWith("BEGIN")) continue;
                    UcListUtil.decomposeList((String)string4, vector);
                    if (vector.size() != 2) {
                        if (logWriter == null) break;
                        logWriter.println("McProbeReader: Response had incorrect format");
                        break;
                    }
                    String string7 = (String)vector.elementAt(1);
                    StringBuffer stringBuffer2 = new StringBuffer();
                    while (stringTokenizer.hasMoreTokens()) {
                        string4 = stringTokenizer.nextToken();
                        if (string4.startsWith("END")) break;
                        stringBuffer2.append(string4 + "\n");
                    }
                    if (this.hostname != null) {
                        if (this.hostname.equals(string)) {
                            object = this.getHostFromData(stringBuffer2, string7);
                            if (object != null) {
                                stringBuffer2 = this.processResponse(stringBuffer2.toString(), (String)object, string);
                            } else {
                                logWriter.println("McProbeConnection: Unable to get host from data for ip " + string);
                            }
                        } else {
                            int n = this.hostname.indexOf(46);
                            if (n != -1) {
                                String string8 = this.hostname.substring(0, n);
                                stringBuffer2 = this.processResponse(stringBuffer2.toString(), string8, this.hostname);
                            }
                        }
                    } else {
                        logWriter.println("McProbeCommand: Hostname is null. Raw or Process req");
                    }
                    object = null;
                    try {
                        object = objHandle.getInstance(string7);
                    }
                    catch (MSServiceException mSServiceException) {
                        logWriter.println(mSServiceException.getMessage());
                        continue;
                    }
                    if (object == null || !(object instanceof McBaseHandler)) continue;
                    if (string7.equals("SYSTEM")) {
                        this.handle.updateIPHost(string, this.hostname, this.agentPort);
                    }
                    if ((string2 = ((McBaseHandler)object).doOp(stringBuffer2.toString(), this)) == null) continue;
                    stringBuffer.append(string2 + " ");
                }
                if (!string5.equals("1")) break;
                this.req = "MORE" + this.origReq + " " + string6;
            }
        }
        if (stringBuffer == null || this.notifyStr == null) {
            return;
        }
        if (!stringBuffer.toString().trim().equals(this.notifyStr.trim())) {
            mcProbeConnection.request(stringBuffer.toString());
        }
    }

    public void setHostname(String string) {
        this.hostname = string;
    }

    public String getHostname() {
        return this.hostname;
    }

    private void collectionFailed(String string, int n) {
        Date date = new Date();
        logWriter.println("McProbeCommand: collectionFailed calling DB with " + string + ":" + n + ":" + date.toString());
        this.handle.updateDBForFail(string, n, this.hostname, date);
    }

    /*
     * Unable to fully structure code
     */
    private StringBuffer processResponse(String var1_1, String var2_2, String var3_3) {
        block2: {
            if (var1_1 == null) {
                return null;
            }
            var3_3 = "{" + var3_3 + "}";
            var2_2 = "{" + var2_2 + "}";
            var4_4 = 0;
            var5_5 = 0;
            var6_6 = new StringBuffer();
            var5_5 = var1_1.indexOf(var2_2, var4_4);
            if (var5_5 >= 0) ** GOTO lbl21
            var6_6.append(var1_1);
            break block2;
lbl-1000:
            // 1 sources

            {
                var7_7 = var1_1.substring(var4_4, var5_5);
                var6_6.append(var7_7);
                var6_6.append(var3_3);
                var4_4 = var5_5 + var2_2.length();
                if (var4_4 >= var1_1.length()) continue;
                var5_5 = var1_1.indexOf(var2_2, var4_4);
lbl21:
                // 3 sources

                ** while (var5_5 >= 0)
            }
lbl22:
            // 1 sources

            var6_6.append(var1_1.substring(var4_4, var1_1.length()));
        }
        return var6_6;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String getHostFromData(StringBuffer stringBuffer, String string) {
        if (string.equals("CONFIG")) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), "\n");
        String string2 = null;
        Vector vector = new Vector();
        if (string.equals("SUMMARY")) {
            if (!stringTokenizer.hasMoreTokens()) {
                return null;
            }
            string2 = stringTokenizer.nextToken();
        }
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!UcListUtil.decomposeList((String)string2, vector)) continue;
            return (String)vector.elementAt(0);
        }
        return null;
    }

    static {
        objHandle = null;
        logWriter = McCollectService.getLogWriter();
        try {
            objHandle = new MSObjectHandles(CommandCfgFile);
        }
        catch (MSServiceException mSServiceException) {
            logWriter.println(mSServiceException.getMessage());
        }
    }
}

