/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.collect;

import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.mgmtservice.collect.McCollectService;
import com.sun.symon.base.mgmtservice.collect.task.McBaseHandler;
import com.sun.symon.base.mgmtservice.common.MSBaseTrapHandler;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.common.MSObjectHandles;
import com.sun.symon.base.mgmtservice.common.MSServiceException;
import com.sun.symon.base.mgmtservice.common.MSTrapData;

public class McTrapHandler
extends MSBaseTrapHandler {
    private final String TRAP_HANDLER = "prm_collection";
    private SMRawDataRequest handle;
    private McCollectService service;
    private MSObjectHandles trapHandleTable;
    private final String TrapCfgFile = "com.sun.symon.base.mgmtservice.collect.trapOp";
    private static MSLogPrintWriter logWriter = McCollectService.getLogWriter();

    public McTrapHandler() {
        this.init(McCollectService.getInstance());
    }

    public McTrapHandler(McCollectService mcCollectService) {
        this.init(mcCollectService);
    }

    public String getName() {
        return "prm_collection";
    }

    public void handleTrap(MSTrapData mSTrapData) {
        logWriter.println("Got trap: " + mSTrapData.getType());
        if (mSTrapData == null) {
            return;
        }
        if (mSTrapData.isRefreshTrap()) {
            this.handleRefreshTrap(mSTrapData.getSourceIp(), mSTrapData.getContext(), mSTrapData.getVarValue());
        }
    }

    private void handleRefreshTrap(String string, String string2, String string3) {
        if (string3 == null) {
            return;
        }
        if (this.trapHandleTable == null) {
            return;
        }
        Object object = null;
        try {
            object = this.trapHandleTable.getInstance(string3);
        }
        catch (MSServiceException mSServiceException) {
            logWriter.println("No handler for refresh trap: " + mSServiceException.getMessage());
            return;
        }
        if (object == null) {
            return;
        }
        logWriter.println("Mc: handleRefreshTrap :" + string);
        if (object instanceof McBaseHandler) {
            this.emitOperation((McBaseHandler)object, string);
        }
    }

    private void init(McCollectService mcCollectService) {
        this.service = mcCollectService;
        this.handle = mcCollectService.getHandle();
        this.trapHandleTable = null;
        try {
            this.trapHandleTable = new MSObjectHandles("com.sun.symon.base.mgmtservice.collect.trapOp");
        }
        catch (MSServiceException mSServiceException) {
            logWriter.println(mSServiceException.getMessage());
        }
        this.subscribe(MSTrapData.REFRESH_TRAP);
    }

    private void emitOperation(McBaseHandler mcBaseHandler, String string) {
        try {
            mcBaseHandler.doOp(string, mcBaseHandler);
        }
        catch (Exception exception) {
            logWriter.println("Exception: " + exception.getMessage());
            exception.printStackTrace();
        }
    }
}

