/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.collect;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.probe.SMProbeConnection;
import com.sun.symon.base.client.probe.SMProbeListener;
import com.sun.symon.base.mgmtservice.collect.McCollectConstants;
import com.sun.symon.base.mgmtservice.collect.McCollectService;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.server.common.ScPortAllocator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class McProbeConnection
implements McCollectConstants {
    private static final String PERF_EOM = "REPEOM";
    private static final int TIMEOUT = 60000;
    private static final long RETRYTIME = 60000L;
    private Hashtable connectTable;
    private String hostname;
    private int port;
    private SMProbeConnection probeConnection;
    private String probeUrl = null;
    private static MSLogPrintWriter logWriter = McCollectService.getLogWriter();
    private static MSLogPrintWriter errorWriter = McCollectService.getErrorWriter();
    private McLocker locker;
    private SMRawDataRequest handle;
    private DataListener listener = null;
    private boolean readerStopped = true;
    private long errorTime = 0L;

    public McProbeConnection(SMRawDataRequest sMRawDataRequest, String string, int n) throws SMAPIException {
        this.hostname = string;
        this.port = n;
        this.handle = sMRawDataRequest;
        this.probeUrl = "snmp://" + string + ":" + n + "/mod/perftool/timer?runadhoccommand.report";
        this.locker = new McLocker(this);
    }

    protected void finalize() throws Throwable {
        if (this.probeConnection != null) {
            this.probeConnection.close();
        }
    }

    public void request(String string) throws SMAPIException {
        this.request(string, true);
    }

    public void request(String string, boolean bl) throws SMAPIException {
        String string2 = new String(string + " " + PERF_EOM);
        if (this.readerStopped) {
            this.readerStopped = false;
            this.probeConnection.startReader();
        }
        this.probeConnection.write2probe(string2);
    }

    public String requestResponse(String string) throws SMAPIException {
        return this.requestResponse(string, true);
    }

    public String requestResponse(String string, boolean bl) throws SMAPIException {
        int n;
        String string2 = new String(string + " " + PERF_EOM);
        String string3 = null;
        SMAPIException sMAPIException = null;
        this.listener.cleanup();
        if (this.readerStopped) {
            this.readerStopped = false;
            this.probeConnection.startReader();
        }
        this.probeConnection.write2probe(string2);
        this.listener.waitForData();
        sMAPIException = this.listener.getException();
        string3 = this.listener.getResult();
        if (sMAPIException != null) {
            throw sMAPIException;
        }
        if (string3 != null && (n = string3.indexOf(PERF_EOM)) > 0) {
            string3 = string3.substring(0, n);
        }
        return string3;
    }

    public void getConnection() throws SMAPIException {
        this.locker.hold();
        this.openConnection();
    }

    public void releaseConnection() throws SMAPIException {
        this.closeConnection();
        this.locker.release();
    }

    public boolean isConnected() {
        return null != this.probeConnection && this.probeConnection.isConnected();
    }

    void openConnection() throws SMAPIException {
        int n;
        String[] stringArray;
        logWriter.println("McProbeonnection: open new connect at " + this.probeUrl);
        if (this.errorTime > 0L && new Date().getTime() - this.errorTime < 60000L) {
            logWriter.println("McProbeonnection: previously fail to open connection on: " + this.probeUrl);
            this.probeConnection = null;
            throw new SMAPIException("Error in connect to " + this.probeUrl);
        }
        ScPortAllocator scPortAllocator = ScPortAllocator.getInstance();
        Vector vector = scPortAllocator.getLogicalHostname();
        if (vector.size() == 2) {
            logWriter.println("McProbeConnection: number of interfaces = 2 so will add loopback address too.");
            stringArray = new String[]{(String)vector.elementAt(0), (String)vector.elementAt(1), "127.0.0.1"};
        } else {
            stringArray = new String[vector.size()];
            n = 0;
            while (n < vector.size()) {
                stringArray[n] = (String)vector.elementAt(n);
                ++n;
            }
        }
        logWriter.print("McProbeConnection: setting server's ip address(es) to ");
        n = 0;
        while (n < stringArray.length) {
            if (n == 0) {
                logWriter.print(stringArray[n]);
            } else {
                logWriter.print(", " + stringArray[n]);
            }
            ++n;
        }
        logWriter.println("");
        this.probeConnection = new SMProbeConnection(this.handle);
        this.probeConnection.setEndOfStream(PERF_EOM);
        this.listener = new DataListener(this.probeConnection);
        int n2 = 0;
        int n3 = 5;
        long l = 30000L;
        while (n2 < n3) {
            try {
                this.probeConnection.connect(this.probeUrl, stringArray);
                break;
            }
            catch (SMAPIException sMAPIException) {
                if (++n2 == n3) {
                    throw sMAPIException;
                }
                try {
                    Thread.sleep(l);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            this.probeConnection.setResponse((SMProbeListener)this.listener);
            this.probeConnection.setTimeOut(60000);
            this.readerStopped = false;
            this.probeConnection.startReader();
            this.errorTime = 0L;
            logWriter.println("McProbeconnection: connect to: " + this.probeUrl);
        }
        catch (Exception exception) {
            logWriter.println("McProbeconnection: fail to open connection on: " + this.probeUrl);
            this.errorTime = new Date().getTime();
            this.probeConnection = null;
            throw new SMAPIException((Throwable)exception);
        }
    }

    void closeConnection() throws SMAPIException {
        if (this.probeConnection != null) {
            try {
                this.probeConnection.close();
                this.listener = null;
                this.probeConnection = null;
            }
            catch (Exception exception) {
                logWriter.println("McProbeonnection: close connect failed: " + exception.getMessage());
            }
        }
        logWriter.println("McProbeonnection: close connect on " + this.hostname);
    }

    class McLocker {
        private boolean available = true;
        McProbeConnection probeConnection = null;

        public McLocker(McProbeConnection mcProbeConnection2) {
            this.probeConnection = mcProbeConnection2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void hold() throws SMAPIException {
            McLocker mcLocker = this;
            synchronized (mcLocker) {
                while (!this.available) {
                    try {
                        this.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.available = false;
                return;
            }
        }

        public void release() throws SMAPIException {
            McLocker mcLocker = this;
            synchronized (mcLocker) {
                this.available = true;
                this.notify();
            }
        }
    }

    class DataListener
    implements SMProbeListener {
        private String result = null;
        private SMAPIException exception = null;
        private SMProbeConnection probeConnection;

        public DataListener(SMProbeConnection sMProbeConnection) {
            this.probeConnection = sMProbeConnection;
        }

        public void waitForData() {
            DataListener dataListener = this;
            synchronized (dataListener) {
                if (this.result == null && this.exception == null) {
                    try {
                        this.wait();
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
            }
        }

        public void receiveData(String string) {
            DataListener dataListener = this;
            synchronized (dataListener) {
                if (this.result != null || this.exception != null) {
                    return;
                }
                if (string.length() == 0) {
                    return;
                }
                this.result = string;
                this.notify();
            }
        }

        public void receiveException(SMAPIException sMAPIException) {
            DataListener dataListener = this;
            synchronized (dataListener) {
                if (this.exception != null || this.result != null) {
                    return;
                }
                this.exception = sMAPIException;
                try {
                    this.probeConnection.stopReader();
                    McProbeConnection.this.readerStopped = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.notify();
            }
        }

        void cleanup() {
            this.result = null;
            this.exception = null;
        }

        String getResult() {
            return this.result;
        }

        SMAPIException getException() {
            return this.exception;
        }
    }
}

