/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.collect;

import com.sun.symon.base.mgmtservice.collect.McAgentLogData;
import com.sun.symon.base.mgmtservice.collect.McCollectService;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Vector;

public class McLogData {
    private static int cnt;
    private String fileName;
    private Vector agentList = new Vector();
    private Vector lineCharMap = new Vector();
    private File file;
    private FileOutputStream ostream;
    private static MSLogPrintWriter logWriter;
    private static String logFilePath;
    private static String logFilePrefix;
    static /* synthetic */ Class class$com$sun$symon$base$mgmtservice$collect$McLogData;

    public McLogData() {
        this.lineCharMap.insertElementAt(new Long(0L), 0);
        String string = logFilePrefix + new Date().getTime();
        Class clazz = class$com$sun$symon$base$mgmtservice$collect$McLogData == null ? (class$com$sun$symon$base$mgmtservice$collect$McLogData = McLogData.class$("com.sun.symon.base.mgmtservice.collect.McLogData")) : class$com$sun$symon$base$mgmtservice$collect$McLogData;
        synchronized (clazz) {
            string = string + "-" + cnt;
            ++cnt;
        }
        this.fileName = new String(logFilePath + File.separator + string);
        File file = new File(logFilePath);
        if (!file.isDirectory()) {
            file.mkdirs();
        }
        try {
            this.ostream = new FileOutputStream(this.fileName, true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            logWriter.println(fileNotFoundException.getMessage());
        }
        this.file = new File(this.fileName);
    }

    protected void finalize() throws Throwable {
        this.cleanUp();
    }

    public void write(String string) throws IOException {
        if (this.ostream == null) {
            try {
                this.ostream = new FileOutputStream(this.fileName, true);
            }
            catch (FileNotFoundException fileNotFoundException) {
                logWriter.println(fileNotFoundException.getMessage());
            }
        }
        if (this.ostream != null) {
            string = string + "\n";
            this.ostream.write(string.getBytes());
        }
    }

    public boolean isEmpty() {
        return this.file.length() == 0L;
    }

    public void close() throws IOException {
        if (this.ostream != null) {
            this.ostream.close();
        }
        this.ostream = null;
    }

    public void setLinePosition(int n, long l) {
        this.lineCharMap.insertElementAt(new Long(l), n);
    }

    public void addAgentData(McAgentLogData mcAgentLogData) {
        if (mcAgentLogData != null) {
            this.agentList.addElement(mcAgentLogData);
        }
    }

    public McAgentLogData getLastAgent() {
        return (McAgentLogData)this.agentList.lastElement();
    }

    public long getLinePosition(int n) {
        if (n >= this.lineCharMap.size()) {
            return -1L;
        }
        Long l = (Long)this.lineCharMap.elementAt(n);
        if (l == null) {
            return -1L;
        }
        return l;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getFileLength() {
        return this.file.length();
    }

    public Vector getAgentList() {
        return this.agentList;
    }

    public McAgentLogData getAgentLogData(int n) {
        if (this.agentList == null || this.agentList.size() == 0) {
            return null;
        }
        int n2 = 0;
        while (n2 < this.agentList.size()) {
            McAgentLogData mcAgentLogData = (McAgentLogData)this.agentList.elementAt(n2);
            if (mcAgentLogData != null && (mcAgentLogData.getStartLine() <= n || mcAgentLogData.getEndLine() >= n)) {
                return mcAgentLogData;
            }
            ++n2;
        }
        return null;
    }

    public int totalLines() {
        return this.lineCharMap.size();
    }

    public void cleanUp() {
        logWriter.println("McLogData: cleanUp");
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.file != null) {
            this.file.delete();
            this.file = null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        logFilePath = "/var/opt/SUNWsymon/PRM/service";
        logFilePrefix = "log.";
        logWriter = McCollectService.getLogWriter();
        cnt = 0;
    }
}

