/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.collect;

import com.sun.symon.base.mgmtservice.collect.McCollectConstants;
import com.sun.symon.base.mgmtservice.collect.db.McDbload;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;

class McDataFile
implements McCollectConstants {
    private FileOutputStream ostream;
    private FileInputStream istream;
    private File file;
    private boolean empty;
    private int dataType;
    private String path;
    private String absName;
    private String filename;
    private String dbLogFileName;
    private Vector pendings;
    private int count;
    private MSLogPrintWriter logWriter;
    private McDbload loader;

    public McDataFile(int n, String string, String string2, String string3, MSLogPrintWriter mSLogPrintWriter, McDbload mcDbload) throws IOException {
        Object object;
        String[] stringArray;
        this.dataType = n;
        this.path = string;
        this.absName = string2;
        this.filename = new String(string + File.separator + string2);
        this.logWriter = mSLogPrintWriter;
        this.loader = mcDbload;
        this.pendings = new Vector();
        this.dbLogFileName = string3;
        this.empty = true;
        this.count = 0;
        this.file = new File(string);
        if (!this.file.isDirectory()) {
            this.file.mkdirs();
        }
        if ((stringArray = new File(string).list()) != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                block17: {
                    if (!stringArray[n2].equals(this.absName) && stringArray[n2].startsWith(this.absName)) {
                        object = new String(string + File.separator + stringArray[n2]);
                        File file = new File((String)object);
                        if (file.length() == 0L) {
                            file.delete();
                        } else {
                            String string4 = this.getName();
                            if (string4.equals(object)) {
                                this.pendings.addElement(object);
                            } else {
                                File file2 = new File(string4);
                                if (file.renameTo(file2)) {
                                    this.pendings.addElement(string4);
                                } else {
                                    int n3 = stringArray[n2].lastIndexOf(95);
                                    if (n3 + 1 < stringArray[n2].length()) {
                                        block16: {
                                            String string5 = stringArray[n2].substring(0, n3 + 1);
                                            try {
                                                int n4 = Integer.parseInt(string5);
                                                if (n4 <= this.count) break block16;
                                                this.count = n4 + 1;
                                            }
                                            catch (Throwable throwable) {
                                                break block17;
                                            }
                                        }
                                        this.pendings.addElement(object);
                                    }
                                }
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        this.file = new File(this.filename);
        this.empty = true;
        if (this.file.length() != 0L) {
            String string6 = this.getName();
            object = new File(string6);
            if (this.file.renameTo((File)object)) {
                this.pendings.addElement(string6);
                this.file = new File(this.filename);
            } else {
                this.empty = false;
            }
        }
        this.ostream = new FileOutputStream(this.filename, true);
    }

    protected void finalize() throws Throwable {
        if (this.ostream != null) {
            this.ostream.close();
        }
        this.pendings.removeAllElements();
        this.pendings = null;
    }

    public String getFileName() {
        return this.filename;
    }

    public synchronized boolean isEmpty() {
        if (!this.empty) {
            return false;
        }
        return this.pendings.size() == 0;
    }

    public synchronized void write(String string) throws IOException {
        this.ostream.write(string.getBytes());
        this.empty = false;
    }

    public synchronized void clean() {
        this.file.delete();
    }

    public synchronized void close() throws IOException {
        this.ostream.close();
    }

    public void dbInsert() throws IOException {
        Object[] objectArray;
        if (!this.empty && (objectArray = this.renameFile()) != null) {
            this.pendings.addElement(objectArray);
        }
        objectArray = new String[this.pendings.size()];
        this.pendings.copyInto(objectArray);
        int[] nArray = this.loader.insert(this.dataType + 1, (String[])objectArray, this.path, this.dbLogFileName, 1);
        this.pendings.removeAllElements();
        int n = 0;
        if (nArray == null) {
            this.clean();
            return;
        }
        n = 0;
        while (n < nArray.length) {
            if (nArray[n] == -1) {
                this.logWriter.println("insert file : " + (String)objectArray[n] + " failed");
                this.pendings.addElement(objectArray[n]);
            } else {
                if (nArray[n] != 0) {
                    this.logWriter.println("Error in loading file: " + (String)objectArray[n] + ",  " + nArray[n] + " records got rejected");
                }
                File file = new File((String)objectArray[n]);
                file.delete();
            }
            ++n;
        }
        if (this.pendings.size() == 0) {
            this.count = 0;
        }
    }

    private synchronized String renameFile() throws IOException {
        String string;
        File file;
        if (this.ostream != null) {
            this.ostream.close();
        }
        if (this.file.renameTo(file = new File(string = this.getName()))) {
            this.ostream = new FileOutputStream(this.filename, true);
            this.file = new File(this.filename);
            this.empty = true;
            return string;
        }
        this.ostream = new FileOutputStream(this.filename, true);
        this.file = new File(this.filename);
        return null;
    }

    private String getName() {
        String string = this.filename + "_" + this.count;
        ++this.count;
        return string;
    }
}

