/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.collect;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.mgmtservice.collect.McCfgData;
import com.sun.symon.base.mgmtservice.collect.McCfgTableObj;
import com.sun.symon.base.mgmtservice.collect.McCollectConstants;
import com.sun.symon.base.mgmtservice.collect.McCollectService;
import com.sun.symon.base.mgmtservice.collect.McCollectTimer;
import com.sun.symon.base.mgmtservice.collect.McDataFile;
import com.sun.symon.base.mgmtservice.collect.McLogDBAccess;
import com.sun.symon.base.mgmtservice.collect.db.McDbload;
import com.sun.symon.base.mgmtservice.collect.task.McSystemInfo;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.common.MSServiceException;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.server.types.StString;
import com.sun.symon.base.utility.UcAgentURL;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class McDataAccessor
implements McCollectConstants {
    private McCollectService service = null;
    private static MSLogPrintWriter logWriter;
    private McDataFile[] dataFiles = null;
    private int maxDataTypes = 0;
    private DBAccessor dbRollup;
    private DBAccessor dbPartAdder;
    private DBLoader dbLoader;
    private McDbload loader;
    private McCfgData[] cfgData;
    private Hashtable propertyTable;
    private Vector pendingList;
    private SMRawDataRequest rawDataHandle = null;
    private Object dbLocker = null;

    public McDataAccessor(McCollectService mcCollectService) {
        this.service = mcCollectService;
        this.rawDataHandle = mcCollectService.getHandle();
        logWriter = McCollectService.getLogWriter();
        this.maxDataTypes = McCollectConstants.FILENAMES.length;
        this.dataFiles = new McDataFile[this.maxDataTypes];
        this.loader = new McDbload(logWriter);
        this.removeFiles("/var/opt/SUNWsymon/PRM/service", "log.");
        int n = 0;
        while (n < this.maxDataTypes) {
            try {
                this.dataFiles[n] = new McDataFile(n, "/var/opt/SUNWsymon/PRM/service", McCollectConstants.FILENAMES[n], "dbload.log", logWriter, this.loader);
            }
            catch (Exception exception) {
                this.dataFiles[n] = null;
                logWriter.println("Error in create file: " + McCollectConstants.FILENAMES[n] + ", " + exception.getMessage());
            }
            ++n;
        }
        this.propertyTable = new Hashtable();
        this.pendingList = new Vector();
        try {
            this.initCfgData();
        }
        catch (Exception exception) {
            if (this.cfgData != null) {
                logWriter.println("Error in read cfg data into database: " + exception.getMessage());
            }
            logWriter.println("Error in insert cfg data into database: " + exception.getMessage());
        }
    }

    public void init() {
        int n = this.service.getSavingTime();
        long l = this.service.getSavingInterval();
        int n2 = this.service.getRollupTime();
        int n3 = this.service.getAddDBPartTime();
        long l2 = this.service.getRollupInterval();
        this.dbLocker = new Object();
        if (n3 >= 0) {
            this.dbPartAdder = new DBAccessor(n3, this.service.getDbAccessor());
        }
        if (n <= n3) {
            n = n3 + 60;
        }
        this.dbLoader = new DBLoader(n, l);
        this.dbRollup = new DBAccessor(n2, l2, this.service.getDbAccessor());
    }

    public int saveData(int n, String string) {
        McDataFile mcDataFile = null;
        try {
            mcDataFile = this.getDataFile(n);
        }
        catch (IOException iOException) {
            logWriter.println("saveData Exception [" + n + "]:  Invalid data type");
            return -1;
        }
        try {
            mcDataFile.write(string);
        }
        catch (Exception exception) {
            logWriter.println("saveData Exception [" + n + "]:  " + exception.getMessage());
            return -1;
        }
        return 0;
    }

    public int saveData(McSystemInfo mcSystemInfo) throws SMAPIException {
        McLogDBAccess mcLogDBAccess = this.service.getDbAccessor();
        try {
            if (mcSystemInfo != null) {
                mcLogDBAccess.saveSysData(mcSystemInfo);
            }
        }
        catch (SMDatabaseException sMDatabaseException) {
            logWriter.println("McDataAccessor: unable to save hardware system data for agent " + mcSystemInfo.getHostname());
            return -1;
        }
        return 0;
    }

    public void saveData(McCfgData[] mcCfgDataArray) throws SMAPIException {
        McLogDBAccess mcLogDBAccess = this.service.getDbAccessor();
        try {
            if (mcCfgDataArray != null) {
                int n = 0;
                while (n < mcCfgDataArray.length) {
                    mcLogDBAccess.saveCfgData(mcCfgDataArray[n]);
                    ++n;
                }
            }
        }
        catch (SMDatabaseException sMDatabaseException) {
            logWriter.println("McDataAccessor: unable to save cfg data into database");
            throw new SMAPIException((Throwable)sMDatabaseException);
        }
    }

    public synchronized void savePropI18nKeys(Vector vector) {
        Object object;
        Object object2;
        int n = 0;
        if (vector != null) {
            n = vector.size();
        }
        Vector<Object> vector2 = new Vector<Object>();
        HashSet<String[]> hashSet = new HashSet<String[]>();
        int n2 = 0;
        while (n2 < n) {
            object2 = (String[])vector.elementAt(n2);
            if (object2 != null && ((String[])object2).length == 4 && object2[0] != null && object2[1] != null && this.propertyTable.get(object = new String((String)object2[0] + "+" + (String)object2[1])) == null && !hashSet.contains(object)) {
                object2[3] = object;
                vector2.addElement(object2);
                hashSet.add((String[])object);
            }
            ++n2;
        }
        n = vector2.size();
        if (n != 0) {
            String[] stringArray;
            object2 = new String[n];
            object = new String[n];
            int n3 = 0;
            while (n3 < n) {
                stringArray = (String[])vector2.elementAt(n3);
                object2[n3] = stringArray[0];
                object[n3] = stringArray[1];
                ++n3;
            }
            stringArray = this.getPropI18nKeys((String[])object2, (String[])object);
            if (stringArray != null && stringArray.length == n) {
                int n4 = 0;
                while (n4 < n) {
                    String[] stringArray2 = (String[])vector2.elementAt(n4);
                    this.propertyTable.put(stringArray2[3], stringArray[n4]);
                    stringArray2[3] = stringArray[n4];
                    ++n4;
                }
            } else {
                n = 0;
            }
        }
        object2 = this.service.getDbAccessor();
        if (n != 0) {
            try {
                ((McLogDBAccess)object2).savePropI18nKeys(vector2);
            }
            catch (SMDatabaseException sMDatabaseException) {
                logWriter.println("Error in inert property I18n keys in database: " + sMDatabaseException.getMessage());
                this.pendingList.addAll(vector2);
                return;
            }
        }
        if (this.pendingList.size() > 0) {
            try {
                ((McLogDBAccess)object2).savePropI18nKeys(this.pendingList);
                this.pendingList.removeAllElements();
            }
            catch (SMDatabaseException sMDatabaseException) {
                logWriter.println("Error in inert property I18n keys in database: " + sMDatabaseException.getMessage());
            }
        }
    }

    public McCfgData[] getCfgData() {
        if (this.cfgData == null) {
            this.initCfgData();
        }
        return this.cfgData;
    }

    public McCfgData getCfgData(String string) {
        if (this.cfgData == null) {
            this.getCfgData();
        }
        if (this.cfgData == null) {
            return null;
        }
        int n = 0;
        while (n < this.cfgData.length) {
            if (string.equals(this.cfgData[n].getType())) {
                McCfgData mcCfgData = this.cfgData[n];
                synchronized (mcCfgData) {
                    if (!this.cfgData[n].isI18nKeyAvailable()) {
                        this.cfgData[n] = this.getCfgI18nKeys(this.cfgData[n]);
                    }
                }
                return this.cfgData[n];
            }
            ++n;
        }
        return null;
    }

    private void removeFiles(String string, String string2) {
        File file = new File("/var/opt/SUNWsymon/PRM/service");
        if (!file.isDirectory()) {
            return;
        }
        String[] stringArray = new File(string).list();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith(string2)) {
                String string3 = new String(string + File.separator + stringArray[n]);
                File file2 = new File(string3);
                file2.delete();
            }
            ++n;
        }
    }

    private synchronized void initCfgData() {
        try {
            this.cfgData = this.readInCfgData();
        }
        catch (Exception exception) {
            logWriter.println("Error in read cfg data into database: " + exception.getMessage());
            return;
        }
        try {
            this.saveData(this.cfgData);
        }
        catch (Exception exception) {
            logWriter.println("Error in insert cfg data into database: " + exception.getMessage());
        }
    }

    private void initCfgDataI18nKeys() {
        if (this.cfgData == null) {
            this.initCfgData();
        }
        if (this.cfgData == null) {
            return;
        }
        int n = 0;
        while (n < this.cfgData.length) {
            McCfgData mcCfgData = this.cfgData[n];
            synchronized (mcCfgData) {
                if (!this.cfgData[n].isI18nKeyAvailable()) {
                    this.cfgData[n] = this.getCfgI18nKeys(this.cfgData[n]);
                }
            }
            ++n;
        }
    }

    private synchronized McDataFile getDataFile(int n) throws IOException {
        if (n >= this.maxDataTypes) {
            return null;
        }
        McDataFile mcDataFile = this.dataFiles[n];
        if (mcDataFile == null) {
            this.dataFiles[n] = mcDataFile = new McDataFile(n, "/var/opt/SUNWsymon/PRM/service", McCollectConstants.FILENAMES[n], "dbload.log", logWriter, this.loader);
        }
        return mcDataFile;
    }

    private McCfgData[] readInCfgData() throws MSServiceException {
        Object object;
        Vector<Object> vector;
        String[] stringArray = null;
        try {
            stringArray = new File("/var/opt/SUNWsymon/PRM/service/cfg/").list();
        }
        catch (Exception exception) {
            logWriter.println("Exception in readInCfgData: " + exception.getMessage());
            throw new MSServiceException(exception.getMessage());
        }
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        String string = null;
        File file = null;
        String string2 = null;
        RandomAccessFile randomAccessFile = null;
        StringTokenizer stringTokenizer = null;
        Hashtable<Object[], McCfgData> hashtable = new Hashtable<Object[], McCfgData>();
        McCfgData mcCfgData = null;
        try {
            int n = 0;
            while (n < stringArray.length) {
                String string3;
                string = new String("/var/opt/SUNWsymon/PRM/service/cfg/" + File.separator + stringArray[n]);
                file = new File(string);
                string2 = new Long(file.lastModified()).toString();
                randomAccessFile = new RandomAccessFile(string, "r");
                vector = new Vector();
                object = null;
                String string4 = null;
                String string5 = null;
                while ((string3 = randomAccessFile.readLine()) != null) {
                    stringTokenizer = new StringTokenizer(string3, "=");
                    String string6 = null;
                    String string7 = null;
                    if (stringTokenizer.countTokens() != 2) continue;
                    string6 = stringTokenizer.nextToken().trim();
                    string7 = stringTokenizer.nextToken().trim();
                    if (object == null && string6.equals("CFG_TYPE")) {
                        object = string7;
                        continue;
                    }
                    if (string4 == null && string6.equals("CFG_MODULE")) {
                        string4 = string7;
                        continue;
                    }
                    if (string5 == null && string6.equals("CFG_LOCATION")) {
                        string5 = string7;
                        continue;
                    }
                    String[] stringArray2 = new String[]{string6, string7};
                    vector.addElement(stringArray2);
                }
                randomAccessFile.close();
                if (object != null && string4 != null) {
                    mcCfgData = (McCfgData)hashtable.get(object);
                    if (mcCfgData == null) {
                        mcCfgData = new McCfgData((String)object);
                        hashtable.put((Object[])object, mcCfgData);
                    }
                    mcCfgData.addModule(string4, string5, stringArray[n], string, string2, vector);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            logWriter.println("Exception in readInCfgData: " + exception.getMessage());
            throw new MSServiceException(exception.getMessage());
        }
        Enumeration enumeration = hashtable.elements();
        vector = new Vector<Object>();
        while (enumeration.hasMoreElements()) {
            vector.addElement((McCfgData)enumeration.nextElement());
        }
        object = new McCfgData[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    private McCfgData getCfgI18nKeys(McCfgData mcCfgData) {
        String[] stringArray = mcCfgData.getTableNames();
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length) {
            McCfgTableObj mcCfgTableObj = mcCfgData.getTable(stringArray[n]);
            if (mcCfgTableObj != null && !mcCfgTableObj.isI18nKeyAvailable()) {
                boolean bl2 = this.getCfgI18nKeys(mcCfgTableObj);
                bl = bl && bl2;
            }
            ++n;
        }
        mcCfgData.setI18nKeyAvailable(bl);
        return mcCfgData;
    }

    private boolean getCfgI18nKeys(McCfgTableObj mcCfgTableObj) {
        String[] stringArray;
        String[] stringArray2;
        String string;
        if (mcCfgTableObj == null) {
            return true;
        }
        Vector vector = mcCfgTableObj.getModules();
        String string2 = mcCfgTableObj.getPropertyStr();
        String string3 = mcCfgTableObj.getTableName();
        if (string2 == null || vector == null || vector.size() == 0) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        int n = stringTokenizer.countTokens();
        int n2 = 0;
        if (n >= 3) {
            n2 = n - 2;
        }
        String[] stringArray3 = new String[n2 + 1];
        String[] stringArray4 = new String[n2];
        stringArray3[0] = string = stringTokenizer.nextToken();
        if (n2 > 0) {
            stringArray2 = stringTokenizer.nextToken();
            int n3 = 0;
            while (n3 < n2) {
                stringArray = stringTokenizer.nextToken();
                stringArray3[n3 + 1] = new String(string + "." + (String)stringArray2 + "." + (String)stringArray);
                stringArray4[n3] = stringArray;
                ++n3;
            }
        }
        if ((stringArray2 = this.getPropI18nKeys(vector, stringArray3)) == null || stringArray2.length != n2 + 1) {
            return false;
        }
        String string4 = stringArray2[0];
        stringArray = new String[n2];
        int n4 = 0;
        while (n4 < n2) {
            stringArray[n4] = stringArray2[n4 + 1];
            ++n4;
        }
        mcCfgTableObj.setTableNameKey(string4);
        mcCfgTableObj.setProperties(stringArray4);
        mcCfgTableObj.setPropI18nKeys(stringArray);
        return true;
    }

    private String getURLOnMDR(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.rawDataHandle.getMDRBaseURL());
        stringBuffer.append("mod/");
        stringBuffer.append(string);
        String string2 = stringBuffer.toString();
        UcAgentURL ucAgentURL = new UcAgentURL(stringBuffer.toString());
        String string3 = ucAgentURL.getMdrModuleId();
        stringBuffer.append("+" + string3);
        stringBuffer.append("/");
        return stringBuffer.toString();
    }

    private String[] getPropI18nKeys(Vector vector, String[] stringArray) {
        if (vector == null || vector.size() == 0 || stringArray == null || stringArray.length == 0) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            int n2 = 0;
            while (n2 < stringArray2.length) {
                stringArray2[n2] = string;
                ++n2;
            }
            String[] stringArray3 = this.getPropI18nKeys(stringArray2, stringArray);
            if (stringArray3 != null) {
                return stringArray3;
            }
            ++n;
        }
        return null;
    }

    private String[] getPropI18nKeys(String[] stringArray, String[] stringArray2) {
        Object object;
        if (stringArray == null || stringArray2 == null || stringArray2.length == 0 || stringArray.length != stringArray2.length) {
            return null;
        }
        int n = stringArray.length;
        String[] stringArray3 = new String[n];
        StObject[][] stObjectArray = new StObject[n][1];
        String string = "mediumDesc";
        int n2 = 0;
        while (n2 < n) {
            object = null;
            object = this.getURLOnMDR(stringArray[n2]);
            object = (String)object + stringArray2[n2];
            stringArray3[n2] = SMRawDataRequest.buildShadowURL((String)object, (String)"consoleHintKey", null);
            stObjectArray[n2][0] = new StString(string);
            ++n2;
        }
        object = null;
        try {
            object = this.rawDataHandle.setURLValue(stringArray3, stObjectArray);
        }
        catch (SMAPIException sMAPIException) {
            logWriter.println("Error in get I18n keys for the hw properties: " + sMAPIException.getMessage());
            return null;
        }
        if (object == null || ((StObject[][])object).length != n) {
            return null;
        }
        String[] stringArray4 = new String[n];
        int n3 = 0;
        while (n3 < n) {
            stringArray4[n3] = object[n3][0].toString();
            ++n3;
        }
        return stringArray4;
    }

    class DBAccessor
    extends McCollectTimer {
        private McLogDBAccess dbHandle;
        private MSLogPrintWriter dbAddPartWriter;
        private MSLogPrintWriter dbDropPartWriter;
        private boolean addPartOnly = false;

        public DBAccessor(int n, long l, McLogDBAccess mcLogDBAccess) {
            super(n, l);
            this.dbHandle = mcLogDBAccess;
            this.initLogWriter();
            this.addPartOnly = false;
        }

        public DBAccessor(int n, McLogDBAccess mcLogDBAccess) {
            super(-n, 0L);
            this.dbHandle = mcLogDBAccess;
            this.initLogWriter();
            this.addPartOnly = true;
        }

        public void doit() {
            Object object = McDataAccessor.this.dbLocker;
            synchronized (object) {
                if (!this.addPartOnly) {
                    logWriter.println("Begin rollup data");
                    this.rollupData();
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    logWriter.println("Begin drop db partition");
                    this.dbPartition(2);
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                logWriter.println("Begin add db partition");
                this.dbPartition(1);
                try {
                    Thread.sleep(60000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void logErrorMessage(String string) {
            logWriter.println(string);
        }

        private void initLogWriter() {
            try {
                if (this.dbDropPartWriter == null) {
                    this.dbDropPartWriter = MSLogPrintWriter.getChannel((String)"dbdrop");
                }
            }
            catch (IOException iOException) {
                logWriter.println("create dbDropPartWriter");
                try {
                    this.dbDropPartWriter = MSLogPrintWriter.createChannel((String)"dbdrop");
                }
                catch (IOException iOException2) {
                    logWriter.println("dbDropPartWriter " + iOException2.getMessage());
                    this.dbDropPartWriter = logWriter;
                }
            }
            try {
                if (this.dbAddPartWriter == null) {
                    this.dbAddPartWriter = MSLogPrintWriter.getChannel((String)"dbadd");
                }
            }
            catch (IOException iOException) {
                logWriter.println("create dbAddPartWriter");
                try {
                    this.dbAddPartWriter = MSLogPrintWriter.createChannel((String)"dbadd");
                }
                catch (IOException iOException3) {
                    logWriter.println("dbAddPartWriter " + iOException3.getMessage());
                    this.dbAddPartWriter = logWriter;
                }
            }
        }

        private void rollupData() {
            try {
                this.dbHandle.rollupData();
            }
            catch (Exception exception) {
                this.logErrorMessage(exception.getMessage());
            }
        }

        private void dbPartition(int n) {
            Vector vector = null;
            try {
                vector = this.dbHandle.dbPartition(n);
            }
            catch (Exception exception) {
                this.logErrorMessage(exception.getMessage());
            }
            if (vector == null || vector.size() == 0) {
                return;
            }
            MSLogPrintWriter mSLogPrintWriter = null;
            switch (n) {
                case 1: {
                    mSLogPrintWriter = this.dbAddPartWriter;
                    break;
                }
                case 2: {
                    mSLogPrintWriter = this.dbDropPartWriter;
                    break;
                }
            }
            if (mSLogPrintWriter == null) {
                return;
            }
            int n2 = 0;
            while (n2 < vector.size()) {
                mSLogPrintWriter.println((String)vector.elementAt(n2));
                ++n2;
            }
        }
    }

    class DBLoader
    extends McCollectTimer {
        private boolean isI18ned = false;

        public DBLoader(int n, long l) {
            super(-n, l);
        }

        public void doit() {
            Object object = McDataAccessor.this.dbLocker;
            synchronized (object) {
                logWriter.println("Begin loading files");
                this.loadData();
            }
            if (!this.isI18ned) {
                McDataAccessor.this.initCfgDataI18nKeys();
                this.isI18ned = true;
            }
        }

        public void logErrorMessage(String string) {
            logWriter.println(string);
        }

        private void loadData() {
            int n = 0;
            while (n < McDataAccessor.this.dataFiles.length) {
                McDataFile mcDataFile = McDataAccessor.this.dataFiles[n];
                if (mcDataFile != null && !mcDataFile.isEmpty()) {
                    try {
                        mcDataFile.dbInsert();
                    }
                    catch (IOException iOException) {
                        logWriter.println("dbLoadFile: " + mcDataFile.getFileName() + ", " + iOException.getMessage());
                    }
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n;
            }
        }
    }
}

