/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.collect;

import com.sun.symon.base.mgmtservice.collect.McCollectService;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.utility.UcPeriodicException;
import com.sun.symon.base.utility.UcTickerTimer;
import com.sun.symon.base.utility.UcTickerTimerResponse;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class McCollectTimer
implements UcTickerTimerResponse {
    private boolean firstTime;
    private int startHour;
    private long period;
    private UcTickerTimer timer = null;
    private static MSLogPrintWriter logWriter = McCollectService.getLogWriter();
    private TaskThread oTaskThread_ = null;

    public McCollectTimer(int n, long l) {
        this.period = l;
        this.startHour = n;
        this.firstTime = true;
        GregorianCalendar gregorianCalendar = null;
        long l2 = 0L;
        if (n >= 0) {
            gregorianCalendar = new GregorianCalendar(TimeZone.getDefault());
            Date date = new Date();
            gregorianCalendar.setTime(date);
            int n2 = gregorianCalendar.get(11);
            if (n < n2) {
                ((Calendar)gregorianCalendar).add(5, 1);
            }
            gregorianCalendar.set(11, n);
            gregorianCalendar.set(12, 0);
            gregorianCalendar.set(13, 0);
            l2 = (gregorianCalendar.getTime().getTime() - new Date().getTime()) / 1000L;
        } else {
            l2 -= (long)n;
        }
        if (l2 == 0L) {
            l2 = 1L;
        }
        logWriter.println("Timer is active in " + l2 + " sec.,  period is " + l);
        try {
            this.timer = new UcTickerTimer(l2, (UcTickerTimerResponse)this);
            this.timer.start();
        }
        catch (UcPeriodicException ucPeriodicException) {
            this.logErrorMessage("bad starttime: " + ucPeriodicException.getMessage());
        }
    }

    public void processTick() {
        if (this.oTaskThread_ == null || !this.oTaskThread_.isRunning()) {
            this.oTaskThread_ = new TaskThread();
            this.oTaskThread_.start();
        }
        if (this.firstTime) {
            try {
                if (this.timer != null) {
                    this.timer.stop();
                }
                if (this.period > 0L) {
                    this.timer = new UcTickerTimer(this.period, (UcTickerTimerResponse)this);
                    this.timer.start();
                }
                this.firstTime = false;
            }
            catch (UcPeriodicException ucPeriodicException) {
                this.logErrorMessage("bad period: " + ucPeriodicException.getMessage());
            }
        }
    }

    public void processTickEnd() {
    }

    public void doit() {
    }

    public void logErrorMessage(String string) {
        logWriter.println(string);
    }

    class TaskThread
    extends Thread {
        private boolean bRunning_ = false;

        TaskThread() {
        }

        public void run() {
            this.bRunning_ = true;
            McCollectTimer.this.doit();
            this.bRunning_ = false;
        }

        public boolean isRunning() {
            return this.bRunning_;
        }
    }
}

