/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.collect;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.group.SMFilterCriteria;
import com.sun.symon.base.client.group.SMFilterData;
import com.sun.symon.base.client.group.SMModuleCriteria;
import com.sun.symon.base.client.group.SMObjectGroupData;
import com.sun.symon.base.client.group.SMObjectGroupInfo;
import com.sun.symon.base.client.report.SMProcessData;
import com.sun.symon.base.client.report.SMReportConstants;
import com.sun.symon.base.client.report.SMScheduledRequestStatus;
import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.client.service.SMLengthException;
import com.sun.symon.base.client.service.SMNoSuchObjectException;
import com.sun.symon.base.client.service.SMSecurityException;
import com.sun.symon.base.client.task.SMTaskData;
import com.sun.symon.base.client.task.SMTaskOperationData;
import com.sun.symon.base.client.task.SMTaskRequestData;
import com.sun.symon.base.client.task.SMTaskRequestInfo;
import com.sun.symon.base.mgmtservice.collect.McAgentLogData;
import com.sun.symon.base.mgmtservice.collect.McAgentUptimeData;
import com.sun.symon.base.mgmtservice.collect.McCfgData;
import com.sun.symon.base.mgmtservice.collect.McCollectConstants;
import com.sun.symon.base.mgmtservice.collect.McDataAccessor;
import com.sun.symon.base.mgmtservice.collect.McLogDBAccess;
import com.sun.symon.base.mgmtservice.collect.McLogData;
import com.sun.symon.base.mgmtservice.collect.McProbeConnection;
import com.sun.symon.base.mgmtservice.collect.McTrapHandler;
import com.sun.symon.base.mgmtservice.collect.task.McProbeCommand;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.common.MSReportHostAddrMapper;
import com.sun.symon.base.mgmtservice.common.MSSecurity;
import com.sun.symon.base.mgmtservice.group.MgFilterImpl;
import com.sun.symon.base.mgmtservice.group.MgFilterService;
import com.sun.symon.base.mgmtservice.group.MgObjectGroupImpl;
import com.sun.symon.base.mgmtservice.group.MgObjectGroupService;
import com.sun.symon.base.mgmtservice.task.MtTaskImpl;
import com.sun.symon.base.mgmtservice.task.MtTaskRequestService;
import com.sun.symon.base.mgmtservice.task.MtTaskService;
import com.sun.symon.base.server.common.ScSecurityCredential;
import com.sun.symon.base.utility.UcBeanIntrospector;
import com.sun.symon.base.utility.UcListUtil;
import com.sun.symon.base.utility.UcPeriodicException;
import com.sun.symon.base.utility.UcTickerTimer;
import com.sun.symon.base.utility.UcTickerTimerResponse;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.AbstractCollection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class McCollectService
implements McCollectConstants,
SMReportConstants {
    private static MSSecurity scService;
    private static MSLogPrintWriter logWriter;
    private static MSLogPrintWriter errorWriter;
    private static ScSecurityCredential master;
    private static McCollectService collectService;
    private static McLogDBAccess dbAccess;
    private UcTickerTimer domainChecker = null;
    private Vector domainGroup;
    private Vector allEntities;
    private String[][] domains;
    private ScSecurityCredential sc = null;
    private MgFilterImpl filterImpl = null;
    private MgObjectGroupImpl groupImpl = null;
    private MtTaskImpl taskImpl = null;
    private MtTaskRequestService taskReqImpl = null;
    private SMRawDataRequest handle = null;
    private Hashtable probeConnectTable = null;
    private McDataAccessor dataAccessor = null;
    private McTrapHandler trapSubscriber = null;
    private SMDBObject obj = null;
    private int savingTime = 1800;
    private long savingInterval = 1800L;
    private int pollStartTime = 10;
    private long pollInterval = 1L;
    private int rollupTime = 2;
    private long rollupInterval = 86400L;
    private int addDBPartTime = 60;
    private int checkInterval = 3600;
    private boolean started = false;
    private Hashtable contextAgents = null;
    private Date tableTime = null;
    private MSReportHostAddrMapper hostAddrMapper;
    private Hashtable ipHost;

    public static McCollectService getInstance() {
        if (collectService == null) {
            collectService = new McCollectService(master, "localhost");
        }
        return collectService;
    }

    public static McCollectService getInstance(SMRawDataRequest sMRawDataRequest) {
        if (collectService == null) {
            collectService = new McCollectService(sMRawDataRequest);
        }
        return collectService;
    }

    protected void finalize() throws Throwable {
        this.filterImpl = null;
        this.groupImpl = null;
        this.taskImpl = null;
        this.taskReqImpl = null;
        this.dataAccessor = null;
        this.handle = null;
        Enumeration enumeration = this.probeConnectTable.elements();
        while (enumeration.hasMoreElements()) {
            McProbeConnection mcProbeConnection = (McProbeConnection)enumeration.nextElement();
            mcProbeConnection = null;
        }
        this.probeConnectTable = null;
    }

    public static ScSecurityCredential getMasterUser() {
        return master;
    }

    public McCollectService(ScSecurityCredential scSecurityCredential, String string) {
        this.handle = new SMRawDataRequest(scSecurityCredential);
        try {
            UcBeanIntrospector ucBeanIntrospector = new UcBeanIntrospector();
            ucBeanIntrospector.readProperties("collect.properties");
            ucBeanIntrospector.apply((Object)this);
        }
        catch (Exception exception) {
            logWriter.println("McCollectService: reading properties: " + exception.getMessage());
        }
        this.init();
    }

    public McCollectService(SMRawDataRequest sMRawDataRequest) {
        this.handle = sMRawDataRequest;
        try {
            UcBeanIntrospector ucBeanIntrospector = new UcBeanIntrospector();
            ucBeanIntrospector.readProperties("/var/opt/SUNWsymon/PRM/servicecollect.properties");
            ucBeanIntrospector.apply((Object)this);
        }
        catch (Exception exception) {
            logWriter.println("McCollectService: reading properties: " + exception.getMessage());
        }
        this.init();
    }

    public static MSLogPrintWriter getLogWriter() {
        return logWriter;
    }

    public static MSLogPrintWriter getErrorWriter() {
        return errorWriter;
    }

    public SMRawDataRequest getHandle() {
        return this.handle;
    }

    public void setSavingTime(String string) {
        try {
            this.savingTime = Integer.parseInt(string);
        }
        catch (Exception exception) {
            this.savingTime = 1800;
        }
    }

    public void setSavingInterval(String string) {
        try {
            this.savingInterval = Integer.parseInt(string);
        }
        catch (Exception exception) {
            this.savingInterval = 1800L;
        }
    }

    public void setPollStartTime(String string) {
        try {
            this.pollStartTime = Integer.parseInt(string);
        }
        catch (Exception exception) {
            this.pollStartTime = 10;
        }
    }

    public void setPollInterval(String string) {
        try {
            this.pollInterval = Integer.parseInt(string);
        }
        catch (Exception exception) {
            this.pollInterval = 1L;
        }
    }

    public void setRollupTime(String string) {
        try {
            this.rollupTime = Integer.parseInt(string);
        }
        catch (Exception exception) {
            this.rollupTime = 2;
        }
    }

    public void setRollupInterval(String string) {
        try {
            this.rollupInterval = Integer.parseInt(string);
        }
        catch (Exception exception) {
            this.rollupInterval = 86400L;
        }
    }

    public void setCheckInterval(String string) {
        try {
            this.checkInterval = Integer.parseInt(string);
        }
        catch (Exception exception) {
            this.checkInterval = 3600;
        }
    }

    public void setAddDBPartTime(String string) {
        try {
            this.addDBPartTime = Integer.parseInt(string);
        }
        catch (Exception exception) {
            this.addDBPartTime = 60;
        }
    }

    public int getSavingTime() {
        return this.savingTime;
    }

    public long getSavingInterval() {
        return this.savingInterval;
    }

    public int getRollupTime() {
        return this.rollupTime;
    }

    public long getRollupInterval() {
        return this.rollupInterval;
    }

    public int getPollStartTime() {
        return this.pollStartTime;
    }

    public long getPollInterval() {
        return this.pollInterval;
    }

    public int getAddDBPartTime() {
        return this.addDBPartTime;
    }

    public McDataAccessor getDataAccessor() {
        return this.dataAccessor;
    }

    public McProbeConnection getProbeConnection(String string, int n) throws SMAPIException {
        logWriter.println("McCollectService : in getProbeConnextion for " + string + " " + n);
        if (n == 0) {
            n = 161;
        }
        String string2 = string + ":" + n;
        McProbeConnection mcProbeConnection = null;
        Hashtable hashtable = this.probeConnectTable;
        synchronized (hashtable) {
            mcProbeConnection = (McProbeConnection)this.probeConnectTable.get(string2);
            if (mcProbeConnection == null) {
                mcProbeConnection = new McProbeConnection(this.handle, string, n);
                this.probeConnectTable.put(string2, mcProbeConnection);
            }
        }
        return mcProbeConnection;
    }

    public McLogData getRawData(String[] stringArray, long l, long l2, String[] stringArray2) throws SMAPIException {
        logWriter.println("McCollectService: In getRawData ");
        McLogData mcLogData = new McLogData();
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        if (stringArray2 == null || stringArray2.length == 0) {
            return null;
        }
        String string = null;
        int n = 161;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(l + " ");
        stringBuffer.append(l2 + " ");
        int n2 = 0;
        while (n2 < stringArray2.length - 1) {
            stringBuffer.append(stringArray2[n2] + "|");
            ++n2;
        }
        stringBuffer.append(stringArray2[stringArray2.length - 1]);
        McProbeCommand mcProbeCommand = new McProbeCommand(this);
        mcProbeCommand.setResultData(mcLogData);
        int n3 = 0;
        while (n3 < stringArray.length) {
            int n4 = stringArray[n3].indexOf(58);
            if (n4 < 0) {
                string = stringArray[n3];
            } else {
                string = stringArray[n3].substring(0, n4);
                n = Integer.parseInt(stringArray[n3].substring(n4 + 1));
            }
            String string2 = new String(string + ":" + n);
            McCollectService mcCollectService = this;
            synchronized (mcCollectService) {
                if (this.contextAgents == null) {
                    this.initializeTable();
                }
            }
            if (this.contextAgents.containsKey(string2)) {
                McAgentLogData mcAgentLogData = new McAgentLogData(string2);
                mcLogData.addAgentData(mcAgentLogData);
                mcProbeCommand.setRequest("HISTORY", stringBuffer.toString());
                try {
                    mcProbeCommand.sendToAgent(string, n);
                }
                catch (SMAPIException sMAPIException) {
                    mcAgentLogData.setException(true);
                    mcAgentLogData.setExceptionObj(sMAPIException);
                    errorWriter.println("McCollectService: SMAPIException for host " + string + ":" + n);
                }
            }
            ++n3;
        }
        mcLogData = (McLogData)mcProbeCommand.getResultData();
        if (mcLogData.isEmpty()) {
            mcLogData.cleanUp();
            mcLogData = null;
        }
        try {
            if (mcLogData != null) {
                mcLogData.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mcLogData;
    }

    public SMProcessData getProcessData(String string, long l, long l2) throws SMAPIException {
        return this.getProcessData(string, l, l2, null);
    }

    public SMProcessData getProcessData(String string, long l, long l2, String string2) throws SMAPIException {
        logWriter.println("McCollectService: In getProcessData");
        SMProcessData sMProcessData = new SMProcessData();
        String string3 = "PROCESS";
        String string4 = l + " " + l2 + " " + string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        String string5 = stringTokenizer.nextToken().trim();
        int n = Integer.parseInt(stringTokenizer.nextToken());
        McCollectService mcCollectService = this;
        synchronized (mcCollectService) {
            if (this.contextAgents == null) {
                this.initializeTable();
            }
        }
        if (!this.contextAgents.containsKey(string)) {
            throw new SMAPIException("Agent is not in server context");
        }
        McProbeCommand mcProbeCommand = new McProbeCommand(this);
        mcProbeCommand.setRequest(string3, string4);
        mcProbeCommand.setResultData(sMProcessData);
        mcProbeCommand.sendToAgent(string5, n);
        sMProcessData = (SMProcessData)mcProbeCommand.getResultData();
        return sMProcessData;
    }

    public McCfgData getCfgData(String string) {
        return this.dataAccessor.getCfgData(string);
    }

    public McLogDBAccess getDbAccessor() {
        return dbAccess;
    }

    public synchronized void updateDomains() {
        logWriter.println("McCollectService: in updateDomains ");
        if (!this.started) {
            logWriter.println("McCollectService: init all domains");
            this.domains = this.getDomainsByPerfGroups();
        }
        String[][] stringArray = null;
        String[][] stringArray2 = null;
        String[] stringArray3 = null;
        if (this.domains == null || this.domains.length == 0) {
            stringArray = this.getAllDomains();
            if (stringArray == null || stringArray.length == 0) {
                return;
            }
            stringArray2 = stringArray;
        } else {
            stringArray = this.getAllDomains();
            if (stringArray == null || stringArray.length == 0) {
                stringArray3 = new String[this.domains.length];
                int n = 0;
                while (n < this.domains.length) {
                    stringArray3[n] = this.domains[n][0];
                    ++n;
                }
            } else {
                HashSet<String> hashSet = new HashSet<String>();
                int n = 0;
                while (n < this.domains.length) {
                    hashSet.add(this.domains[n][0]);
                    ++n;
                }
                Vector<String[]> vector = new Vector<String[]>();
                Vector vector2 = new Vector();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (!hashSet.contains(stringArray[n2][0])) {
                        vector.addElement(stringArray[n2]);
                    } else {
                        hashSet.remove(stringArray[n2][0]);
                    }
                    ++n2;
                }
                if (vector.size() != 0) {
                    stringArray2 = new String[vector.size()][2];
                    vector.copyInto((Object[])stringArray2);
                }
                if (hashSet.size() != 0) {
                    stringArray3 = new String[hashSet.size()];
                    stringArray3 = ((AbstractCollection)hashSet).toArray(stringArray3);
                }
            }
        }
        if (stringArray2 != null) {
            try {
                this.createPerfGroups(stringArray2);
                this.createPerfGroupRequest(1, stringArray2);
            }
            catch (SMDatabaseException sMDatabaseException) {
                errorWriter.println("McCollectService : Error in adding new domains");
            }
        }
        if (stringArray3 != null) {
            this.deleteDomain(stringArray3);
        }
        this.domains = stringArray;
    }

    public String resolveGroup(String string) throws SMNoSuchObjectException, SMDatabaseException, SMAPIException {
        Object object;
        logWriter.println("McCollectService: in resolveGroup - " + string);
        String[] stringArray = null;
        try {
            object = this.groupImpl.load(string);
            stringArray = this.groupImpl.resolve((SMObjectGroupData)object);
        }
        catch (SMSecurityException sMSecurityException) {
            errorWriter.println("McCollectService: Security Exception while resolving object group");
            return null;
        }
        object = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            ((StringBuffer)object).append(stringArray[n] + " ");
            ++n;
        }
        return ((StringBuffer)object).toString();
    }

    public void deleteDomain(String[] stringArray) {
        logWriter.println("McCollectService: in deleteDomain ");
        try {
            int n = 0;
            while (n < stringArray.length) {
                String string = "_Perf_Req_" + stringArray[n];
                SMDBObjectID sMDBObjectID = null;
                logWriter.println("McCollectService: deleteDomain:  " + stringArray[n]);
                if (this.taskReqImpl.load(string) != null) {
                    sMDBObjectID = this.taskReqImpl.load(string).getObjectID();
                    this.taskReqImpl.delete(sMDBObjectID);
                }
                if (this.groupImpl.load(string = "_Perf_Group_" + stringArray[n]) != null) {
                    sMDBObjectID = this.groupImpl.load(string).getObjectID();
                    this.groupImpl.delete(sMDBObjectID);
                }
                ++n;
            }
        }
        catch (SMSecurityException sMSecurityException) {
            errorWriter.println("McCollectService: exception in deleteDomaim");
        }
        catch (SMDatabaseException sMDatabaseException) {
            errorWriter.println("McCollectService: exception while accessing database in deleteDomain");
        }
        catch (RemoteException remoteException) {
            errorWriter.println("McCollectService: remote Exception while deletingDomains");
        }
    }

    public void startCollection() {
        try {
            this.ipHost = dbAccess.getHostnameIP();
        }
        catch (SMDatabaseException sMDatabaseException) {
            sMDatabaseException.printStackTrace();
            errorWriter.println("McCollecService: unable to init ipHost table from db");
            this.ipHost = new Hashtable();
        }
        if (!this.started) {
            this.initTasks();
            this.trapSubscriber = new McTrapHandler(this);
            logWriter.println("McCollectService: Collection service is running");
            this.started = true;
        } else {
            logWriter.println("McCollectService: Collection service has been running");
        }
    }

    public boolean createReportTaskRequest(SMDBObjectID sMDBObjectID, String[] stringArray, String[] stringArray2, String[] stringArray3, long l, long l2, int n) throws SMAPIException {
        String string = String.valueOf(sMDBObjectID.getID());
        logWriter.println("McCollectService: in createReportTaskRequest for " + string);
        String string2 = this.repReqNameToTaskName(string);
        String string3 = this.repReqNameToTaskReqName(string);
        String string4 = this.repReqNameToGroupName(string);
        Object var14_12 = null;
        SMTaskData sMTaskData = null;
        SMTaskRequestData sMTaskRequestData = null;
        SMObjectGroupData sMObjectGroupData = null;
        McGroupTaskReqData mcGroupTaskReqData = this.getRepGroupTaskReqData(string);
        if (mcGroupTaskReqData.isExist()) {
            dbAccess.updateSchedReport(sMDBObjectID, true);
            return false;
        }
        this.deleteRepGrpTaskRequest(mcGroupTaskReqData.getObjectGroupData(), mcGroupTaskReqData.getTaskData(), mcGroupTaskReqData.getTaskRequestData());
        String[] stringArray4 = dbAccess.getReportGroup(sMDBObjectID, stringArray, stringArray2);
        if (stringArray4 == null) {
            errorWriter.println("McCollectService: Create object group failed");
            throw new SMAPIException("McCollectService: Create object group failed");
        }
        String string5 = null;
        if (stringArray4[0] != null) {
            string5 = stringArray4[0];
        } else {
            try {
                sMObjectGroupData = this.createReportObjGroup(string4, string, stringArray4[1], stringArray4[2]);
                this.groupImpl.save(sMObjectGroupData);
            }
            catch (SMAPIException sMAPIException) {
                errorWriter.println("McCollectService: Error in create object group for scheduling report");
                throw sMAPIException;
            }
            string5 = string4;
        }
        try {
            sMTaskData = this.createSchedReportTask(string2, string);
            this.taskImpl.save(sMTaskData);
        }
        catch (SMAPIException sMAPIException) {
            errorWriter.println("McCollectService: save the report task failed");
            this.deleteRepGrpTaskRequest(sMObjectGroupData, null, null);
            throw sMAPIException;
        }
        sMTaskRequestData = new SMTaskRequestData();
        sMTaskRequestData.setName(string3);
        sMTaskRequestData.setPeriod(l2);
        sMTaskRequestData.setPeriodUnits(n);
        sMTaskRequestData.setStartDate(new Date(l));
        sMTaskRequestData.setScheduled(true);
        sMTaskRequestData.setTaskName(string2);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < stringArray3.length) {
            UcListUtil.appendElement((StringBuffer)stringBuffer, (String)stringArray3[n2], (boolean)true);
            ++n2;
        }
        sMTaskRequestData.setDescription(stringBuffer.toString());
        sMTaskRequestData.setObjectGroupName(string5);
        try {
            this.taskReqImpl.save(sMTaskRequestData);
        }
        catch (SMAPIException sMAPIException) {
            errorWriter.println("McCollectService: save the report task failed");
            this.deleteRepGrpTaskRequest(sMObjectGroupData, sMTaskData, null);
            throw sMAPIException;
        }
        catch (RemoteException remoteException) {
            errorWriter.println("McCollectService: save the report task failed");
            this.deleteRepGrpTaskRequest(sMObjectGroupData, sMTaskData, null);
            throw new SMAPIException((Throwable)remoteException);
        }
        try {
            dbAccess.updateSchedReport(sMDBObjectID, true);
        }
        catch (SMDatabaseException sMDatabaseException) {
            errorWriter.println("McCollectService: update scheduled report failed");
            throw sMDatabaseException;
        }
        return true;
    }

    public boolean removeScheduledRequest(SMDBObjectID sMDBObjectID) throws SMAPIException {
        try {
            dbAccess.updateSchedReport(sMDBObjectID, false);
        }
        catch (SMDatabaseException sMDatabaseException) {
            errorWriter.println("McCollectService: update scheduled report failed");
            throw sMDatabaseException;
        }
        Object var2_3 = null;
        Object var3_4 = null;
        boolean bl = true;
        Object var5_6 = null;
        String string = String.valueOf(sMDBObjectID.getID());
        logWriter.println("McCollectService : in removeScheduledRequest for " + string);
        McGroupTaskReqData mcGroupTaskReqData = this.getRepGroupTaskReqData(string);
        if (!mcGroupTaskReqData.isExist()) {
            return false;
        }
        SMTaskData sMTaskData = mcGroupTaskReqData.getTaskData();
        SMTaskRequestData sMTaskRequestData = mcGroupTaskReqData.getTaskRequestData();
        SMObjectGroupData sMObjectGroupData = mcGroupTaskReqData.getObjectGroupData();
        this.deleteRepGrpTaskRequest(sMObjectGroupData, sMTaskData, sMTaskRequestData);
        return true;
    }

    public SMScheduledRequestStatus[] getScheduledRequestStatus() throws SMDatabaseException {
        SMScheduledRequestStatus[] sMScheduledRequestStatusArray = dbAccess.getRepTaskReqStatus("_Perf_rr_");
        if (sMScheduledRequestStatusArray == null) {
            return null;
        }
        Vector vector = null;
        int n = 0;
        while (n < sMScheduledRequestStatusArray.length) {
            String string = sMScheduledRequestStatusArray[n].getDescription();
            if (UcListUtil.decomposeList((String)string, vector = new Vector())) {
                Object[] objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
                sMScheduledRequestStatusArray[n].setUserData((String[])objectArray);
                String string2 = this.taskReqNameToRepReqName(sMScheduledRequestStatusArray[n].getName());
                long l = Long.parseLong(string2);
                sMScheduledRequestStatusArray[n].setRequestId(new SMDBObjectID(l, "report_request"));
                long l2 = ((Date)sMScheduledRequestStatusArray[n].getTimestamp().getValue()).getTime();
                sMScheduledRequestStatusArray[n].setLastModDate(new Date(l2));
                long l3 = this.getNextExecTime(sMScheduledRequestStatusArray[n]);
                if (l3 != -1L) {
                    sMScheduledRequestStatusArray[n].setNextScheduledDate(new Date(l3));
                }
            }
            ++n;
        }
        return sMScheduledRequestStatusArray;
    }

    private long getNextExecTime(SMScheduledRequestStatus sMScheduledRequestStatus) {
        block13: {
            try {
                long l = sMScheduledRequestStatus.getStartTime();
                String[] stringArray = sMScheduledRequestStatus.getUserData();
                int n = new Integer(stringArray[3]);
                long l2 = new Date().getTime();
                if (sMScheduledRequestStatus.isPeriodic()) {
                    int n2 = sMScheduledRequestStatus.getPeriodUnits();
                    int n3 = 0;
                    switch (n2) {
                        case 1: {
                            n3 = 60000;
                            break;
                        }
                        case 2: {
                            n3 = 3600000;
                            break;
                        }
                        case 3: {
                            n3 = 86400000;
                            break;
                        }
                        case 4: {
                            n3 = 604800000;
                            break;
                        }
                        case 5: {
                            GregorianCalendar gregorianCalendar = new GregorianCalendar();
                            gregorianCalendar.setTime(new Date(l));
                            while (gregorianCalendar.getTime().getTime() <= l2) {
                                gregorianCalendar.add(2, (int)sMScheduledRequestStatus.getPeriod());
                            }
                            return gregorianCalendar.getTime().getTime();
                        }
                    }
                    if (n3 > 0) {
                        if (l2 > l) {
                            long l3 = sMScheduledRequestStatus.getPeriod() * (long)n3;
                            long l4 = (l2 - l) / l3 + 1L;
                            return l + l4 * l3;
                        }
                        return l;
                    }
                    break block13;
                }
                return sMScheduledRequestStatus.isFailure() || sMScheduledRequestStatus.isSuccess() ? -1L : l;
            }
            catch (Exception exception) {
                logWriter.println("McCollectService.getNextExecTime: " + exception);
            }
        }
        return -1L;
    }

    private McGroupTaskReqData getRepGroupTaskReqData(String string) throws SMAPIException {
        SMTaskRequestData sMTaskRequestData = null;
        SMTaskData sMTaskData = null;
        SMObjectGroupData sMObjectGroupData = null;
        boolean bl = true;
        Object var6_6 = null;
        McGroupTaskReqData mcGroupTaskReqData = new McGroupTaskReqData();
        String string2 = null;
        try {
            sMTaskRequestData = this.taskReqImpl.load(this.repReqNameToTaskReqName(string));
            string2 = sMTaskRequestData.getObjectGroupName();
            mcGroupTaskReqData.setTaskRequestData(sMTaskRequestData);
            logWriter.println("McCollectService: exist: task request: ");
        }
        catch (SMNoSuchObjectException sMNoSuchObjectException) {
            logWriter.println("McCollectService: exist: task request: no such object ");
            bl = false;
        }
        catch (RemoteException remoteException) {
            throw new SMAPIException((Throwable)remoteException);
        }
        try {
            sMTaskData = this.taskImpl.load(this.repReqNameToTaskName(string));
            mcGroupTaskReqData.setTaskData(sMTaskData);
            logWriter.println("McCollectService: exist: task  ");
        }
        catch (SMNoSuchObjectException sMNoSuchObjectException) {
            logWriter.println("McCollectService: exist: task : no such object ");
            bl = false;
        }
        if (string2 != null && string2.equals(this.repReqNameToGroupName(string))) {
            try {
                sMObjectGroupData = this.groupImpl.load(string2);
                mcGroupTaskReqData.setObjectGroupData(sMObjectGroupData);
                logWriter.println("McCollectService: exist: group  ");
            }
            catch (SMDatabaseException sMDatabaseException) {
                bl = false;
                logWriter.println("McCollectService: exist: group : db error: " + sMDatabaseException.getMessage());
            }
        }
        if (bl) {
            mcGroupTaskReqData.setExist(true);
        }
        return mcGroupTaskReqData;
    }

    private void deleteRepGrpTaskRequest(SMObjectGroupData sMObjectGroupData, SMTaskData sMTaskData, SMTaskRequestData sMTaskRequestData) {
        try {
            if (sMTaskRequestData != null) {
                this.taskReqImpl.delete(sMTaskRequestData.getObjectID());
            } else {
                logWriter.println("McCollectService: no task req");
            }
        }
        catch (Exception exception) {
            errorWriter.println("McCollectService: remove shceduled report request failed");
        }
        try {
            if (sMTaskData != null) {
                this.taskImpl.delete(sMTaskData.getObjectID());
            } else {
                logWriter.println("McCollectService: no task");
            }
        }
        catch (Exception exception) {
            errorWriter.println("McCollectService: remove shceduled report task");
        }
        try {
            if (sMObjectGroupData != null) {
                this.groupImpl.delete(sMObjectGroupData.getObjectID());
            } else {
                logWriter.println("McCollectService: no group");
            }
        }
        catch (Exception exception) {
            errorWriter.println("McCollectService: remove shceduled report object group");
        }
    }

    private String repReqNameToTaskReqName(String string) {
        return new String("_Perf_rr_" + string);
    }

    private String taskReqNameToRepReqName(String string) {
        if (!string.startsWith("_Perf_rr_")) {
            return string;
        }
        return string.substring("_Perf_rr_".length());
    }

    private String repReqNameToTaskName(String string) {
        return new String("_Perf_t_" + string);
    }

    private String repReqNameToGroupName(String string) {
        return new String("_Perf_Group_r_" + string);
    }

    private String taskNameToRepReqName(String string) {
        if (!string.startsWith("_Perf_t_")) {
            return string;
        }
        return string.substring("_Perf_t_".length());
    }

    private void init() {
        this.probeConnectTable = new Hashtable();
        this.dataAccessor = new McDataAccessor(this);
        this.hostAddrMapper = MSReportHostAddrMapper.getInstance();
        this.startCollection();
    }

    private void initTasks() {
        try {
            this.filterImpl = MgFilterService.getFilterImpl((ScSecurityCredential)master);
            this.groupImpl = MgObjectGroupService.getObjectGroupImpl((ScSecurityCredential)master);
            this.taskImpl = MtTaskService.getTaskImpl((ScSecurityCredential)master);
            try {
                this.taskReqImpl = new MtTaskRequestService(master, "localhost");
            }
            catch (RemoteException remoteException) {
                logWriter.println("McCollectService: Unable to obtain handle to the TaskRequestService");
                remoteException.printStackTrace();
            }
        }
        catch (Exception exception) {
            errorWriter.println("McCollectService: Unable to get handle to grouping services ");
            exception.printStackTrace();
            return;
        }
        logWriter.println("initTask: ");
        try {
            this.createPerfFilter();
            this.createPerfTask(1);
            this.resumeRequests();
            this.updateDomains();
        }
        catch (SMDatabaseException sMDatabaseException) {
            errorWriter.println("McCollectService: Unable to create canned grouping components");
        }
        logWriter.println("Create checker: interval=" + this.checkInterval);
        try {
            this.domainChecker = new UcTickerTimer((long)this.checkInterval, new UcTickerTimerResponse(){

                public void processTick() {
                    McCollectService.this.updateDomains();
                }

                public void processTickEnd() {
                }
            });
        }
        catch (UcPeriodicException ucPeriodicException) {
            // empty catch block
        }
        this.domainChecker.start();
        logWriter.println("McCollectService: All canned group requests created");
        this.dataAccessor.init();
    }

    private String[][] getAllDomains() {
        this.domainGroup = new Vector();
        try {
            this.domainGroup = dbAccess.getAllDomains();
            String[][] stringArray = new String[this.domainGroup.size()][2];
            this.domainGroup.copyInto((Object[])stringArray);
            return stringArray;
        }
        catch (SMDatabaseException sMDatabaseException) {
            errorWriter.println("McCollectService: Unable to obtain topology information from the database");
            sMDatabaseException.printStackTrace();
        }
        catch (Exception exception) {
            errorWriter.println("McCollectService: An exception occured while accessing the database");
            exception.printStackTrace();
        }
        return null;
    }

    private void createPerfGroupRequest(int n) throws SMDatabaseException {
        if (this.domains == null) {
            this.domains = this.getAllDomains();
        }
        this.createPerfGroupRequest(n, this.domains);
    }

    private void createPerfGroupRequest(int n, String[][] stringArray) throws SMDatabaseException {
        SMTaskRequestData sMTaskRequestData = null;
        String string = null;
        logWriter.println("McCollectService: create Perf group:");
        if (stringArray == null) {
            errorWriter.println("McCollectService: Unable to create canned object groups");
            return;
        }
        try {
            int n2 = 0;
            while (n2 < stringArray.length) {
                logWriter.println("McCollectService: createPerfgroup for: " + stringArray[n2][0] + " , " + stringArray[n2][1]);
                sMTaskRequestData = new SMTaskRequestData();
                Date date = new Date();
                switch (n) {
                    case 1: {
                        string = "_Perf_Req_" + stringArray[n2][0];
                        sMTaskRequestData.setName(string);
                        sMTaskRequestData.setTaskName("_Perf_All_task");
                        sMTaskRequestData.setPeriod(this.pollInterval);
                        sMTaskRequestData.setPeriodUnits(2);
                        sMTaskRequestData.setStartDate(new Date(date.getTime() + (long)(this.pollStartTime * 60 * 1000)));
                        break;
                    }
                }
                sMTaskRequestData.setDescription("Defaults for perftool");
                sMTaskRequestData.setObjectGroupName("_Perf_Group_" + stringArray[n2][0]);
                sMTaskRequestData.setScheduled(true);
                this.obj = this.taskReqImpl.save(sMTaskRequestData);
                ++n2;
            }
        }
        catch (SMDatabaseException sMDatabaseException) {
            errorWriter.println("McCollectService: Unable to save group requests in the database");
            sMDatabaseException.printStackTrace();
            throw sMDatabaseException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SMDatabaseException((Throwable)exception);
        }
    }

    private void createPerfGroups() throws SMDatabaseException {
        if (this.domains == null) {
            this.domains = this.getAllDomains();
        }
        if (this.domains == null) {
            errorWriter.println("McCollectService: Unable to create canned object groups");
            return;
        }
        this.createPerfGroups(this.domains);
    }

    private void createPerfGroups(String[][] stringArray) throws SMDatabaseException {
        SMObjectGroupData sMObjectGroupData = new SMObjectGroupData();
        try {
            SMFilterData sMFilterData = this.filterImpl.load("_Perf_Filter");
            int n = 0;
            while (n < stringArray.length) {
                String string = "_Perf_Group_" + stringArray[n][0];
                sMObjectGroupData.setName(string);
                sMObjectGroupData.setDescription("Defaults for perftool");
                sMObjectGroupData.setDomain(stringArray[n][1]);
                sMObjectGroupData.setAllObjectsInDomain(true);
                sMObjectGroupData.setFilter(sMFilterData.getObjectID());
                this.obj = this.groupImpl.save(sMObjectGroupData);
                ++n;
            }
        }
        catch (SMDatabaseException sMDatabaseException) {
            errorWriter.println("McCollectService: Unable to create canned perf groups");
            sMDatabaseException.printStackTrace();
            throw sMDatabaseException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SMDatabaseException((Throwable)exception);
        }
    }

    private String[][] getDomainsByPerfGroups() {
        String[][] stringArray;
        SMObjectGroupInfo[] sMObjectGroupInfoArray = null;
        try {
            sMObjectGroupInfoArray = this.groupImpl.getAll();
        }
        catch (Exception exception) {
            logWriter.println("Cannot get domains through perf groups: " + exception.getMessage());
            return null;
        }
        if (sMObjectGroupInfoArray == null || sMObjectGroupInfoArray.length == 0) {
            return null;
        }
        Vector<String[][]> vector = new Vector<String[][]>();
        String string = new String("_Perf_Group_");
        int n = 0;
        while (n < sMObjectGroupInfoArray.length) {
            if (sMObjectGroupInfoArray[n].getName().startsWith(string) && !sMObjectGroupInfoArray[n].getName().startsWith("_Perf_Group_r_")) {
                stringArray = new String[]{sMObjectGroupInfoArray[n].getName().substring(string.length()), sMObjectGroupInfoArray[n].getDomain()};
                vector.addElement(stringArray);
            }
            ++n;
        }
        stringArray = new String[vector.size()][2];
        vector.copyInto((Object[])stringArray);
        return stringArray;
    }

    private SMObjectGroupData createReportObjGroup(String string, String string2, String string3, String string4) throws SMAPIException {
        logWriter.println("McCollectService: createReportObjGroup: " + string2 + ", " + string4 + ", " + string3);
        Object var5_5 = null;
        try {
            if (string4 == null) {
                string4 = "Default Domain";
            }
            if (string3 == null) {
                string3 = InetAddress.getLocalHost().getHostName();
            }
            SMObjectGroupData sMObjectGroupData = new SMObjectGroupData();
            String[] stringArray = new String[]{string3};
            sMObjectGroupData.setObjects(stringArray);
            sMObjectGroupData.setName(string);
            sMObjectGroupData.setDescription("Dummy Object Group");
            sMObjectGroupData.setDomain(string4);
            logWriter.println("McCollectService: createReportObjGroup: return " + string);
            return sMObjectGroupData;
        }
        catch (Exception exception) {
            errorWriter.println("McCollectService: Unable to create dummy group");
            throw new SMAPIException((Throwable)exception);
        }
    }

    private SMTaskData createSchedReportTask(String string, String string2) throws SMLengthException {
        SMTaskData sMTaskData = new SMTaskData();
        sMTaskData.setName(string);
        sMTaskData.setDescription("Report task:  " + string2);
        sMTaskData.setTaskType(9);
        SMTaskOperationData sMTaskOperationData = new SMTaskOperationData();
        SMTaskOperationData[] sMTaskOperationDataArray = new SMTaskOperationData[]{sMTaskOperationData};
        sMTaskOperationData.setOperand("perftool");
        sMTaskOperationData.setOperation("schedulereport");
        sMTaskOperationData.setUserData(string2);
        sMTaskData.setOperations(sMTaskOperationDataArray);
        return sMTaskData;
    }

    private void createPerfTask(int n) throws SMDatabaseException {
        try {
            switch (n) {
                case 1: {
                    SMTaskData sMTaskData = this.taskImpl.load("_Perf_All_task");
                    logWriter.println("createPerfTask: already exists: " + sMTaskData.getName());
                    return;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        SMTaskData sMTaskData = new SMTaskData();
        logWriter.println("createPerfTask:  create one");
        try {
            SMTaskOperationData sMTaskOperationData = new SMTaskOperationData();
            switch (n) {
                case 1: {
                    sMTaskData.setName("_Perf_All_task");
                    sMTaskOperationData.setOperation("datacollect");
                    break;
                }
            }
            sMTaskData.setDescription("Canned hardware task for perftool");
            sMTaskData.setTaskType(9);
            sMTaskOperationData.setOperand("perftool");
            SMTaskOperationData[] sMTaskOperationDataArray = new SMTaskOperationData[]{sMTaskOperationData};
            sMTaskData.setOperations(sMTaskOperationDataArray);
            this.obj = this.taskImpl.save(sMTaskData);
        }
        catch (SMDatabaseException sMDatabaseException) {
            errorWriter.println("McCollectService: Unable to create canned report tasks");
            sMDatabaseException.printStackTrace();
            throw sMDatabaseException;
        }
        catch (Exception exception) {
            errorWriter.println("McCollectService: Unable to create canned report tasks");
            exception.printStackTrace();
            throw new SMDatabaseException((Throwable)exception);
        }
    }

    private void createPerfFilter() throws SMDatabaseException {
        try {
            SMFilterData sMFilterData = this.filterImpl.load("_Perf_Filter");
            logWriter.println(" createPerfFilter: already exist: " + sMFilterData.getName());
            return;
        }
        catch (Exception exception) {
            String[] stringArray = new String[1];
            logWriter.println(" createPerfFilter: create one: ");
            stringArray[0] = new String("perftool");
            SMFilterData sMFilterData = new SMFilterData();
            try {
                sMFilterData.setName("_Perf_Filter");
                sMFilterData.setDescription("Defaults for perftool");
                SMModuleCriteria sMModuleCriteria = new SMModuleCriteria(stringArray, true, true);
                SMFilterCriteria[] sMFilterCriteriaArray = new SMFilterCriteria[]{sMModuleCriteria};
                sMFilterData.setFilterCriteria(sMFilterCriteriaArray);
                this.obj = this.filterImpl.save(sMFilterData);
            }
            catch (SMDatabaseException sMDatabaseException) {
                sMDatabaseException.printStackTrace();
                errorWriter.println("McCollectService: Database exception while creating perf filter");
                throw sMDatabaseException;
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
                errorWriter.println("McCollectService: Database exception while creating perf filter");
                throw new SMDatabaseException((Throwable)exception2);
            }
            return;
        }
    }

    private void resumeRequests() {
        SMTaskRequestInfo[] sMTaskRequestInfoArray = null;
        try {
            sMTaskRequestInfoArray = this.taskReqImpl.getAll();
        }
        catch (Exception exception) {
            logWriter.println("resumeRequests: getAll Failed");
            return;
        }
        int n = 0;
        while (n < sMTaskRequestInfoArray.length) {
            String string = sMTaskRequestInfoArray[n].getName();
            if (string.startsWith("_Perf_") && sMTaskRequestInfoArray[n].isSuspended()) {
                try {
                    logWriter.println("resumeRequests: resume PRM task: " + string);
                    this.taskReqImpl.resume(sMTaskRequestInfoArray[n].getObjectID());
                }
                catch (Exception exception) {
                    logWriter.println("resumeRequests: Failed on " + sMTaskRequestInfoArray[n].getName());
                }
            }
            ++n;
        }
    }

    public synchronized boolean collectDataFromAgent(String string) {
        this.initializeTable();
        String string2 = this.getValue(string);
        if (string2 != null && string2.equals("0")) {
            this.updateAgentTable(string);
            return true;
        }
        return false;
    }

    private void initializeTable() {
        if (this.tableTime == null || new Date().getTime() - this.tableTime.getTime() > 3000000L) {
            this.contextAgents = new Hashtable();
            this.tableTime = new Date();
            try {
                Vector vector = dbAccess.getAgentsInServerContext();
                int n = 0;
                while (n < vector.size()) {
                    String string = (String)vector.elementAt(n);
                    this.contextAgents.put(string, "0");
                    ++n;
                }
            }
            catch (SMDatabaseException sMDatabaseException) {
                errorWriter.println("McCollectService: Database exception occured while getting agents in the server context");
            }
        }
    }

    private Date getTableTimestamp() {
        return this.tableTime;
    }

    private void setTableTimestamp(Date date) {
        if (date != null) {
            this.tableTime = date;
        }
    }

    private String getValue(String string) {
        String string2 = (String)this.contextAgents.get(string);
        return string2;
    }

    private void updateAgentTable(String string) {
        this.contextAgents.put(string, "1");
    }

    public MSReportHostAddrMapper getHostAddrMapper() {
        return this.hostAddrMapper;
    }

    public synchronized void updateIPHost(String string, String string2, int n) {
        logWriter.println("McCollectService:updateIPHost: ip-> " + string + "Hostname -> " + string2 + "port ->" + n);
        String string3 = String.valueOf(n);
        String string4 = string + ":" + string3;
        String string5 = (String)this.ipHost.get(string4);
        if (string5 == null || !string5.equals(string2)) {
            try {
                dbAccess.setHostname(string, string2, String.valueOf(n));
            }
            catch (SMDatabaseException sMDatabaseException) {
                sMDatabaseException.printStackTrace();
                errorWriter.println("Unable to update Database for hostname " + string2);
                return;
            }
        }
        this.ipHost.put(string4, string2);
    }

    public synchronized void updateDBForFail(String string, int n, String string2, Date date) {
        logWriter.println("McCollectService: updateDBForFail called for host " + string + ":" + n);
        String string3 = String.valueOf(n);
        if (string2 == null && (string2 = (String)this.ipHost.get(string + ":" + string3)) == null) {
            string2 = string;
        }
        this.updateIPHost(string, string2, n);
        try {
            dbAccess.setCollectionFailedForHost(string, string3, date);
        }
        catch (SMDatabaseException sMDatabaseException) {
            errorWriter.println("McCollectService: updateDBForFail got Exception " + sMDatabaseException.getMessage());
        }
    }

    public Vector getUptimeSummaryData(int n, String[] stringArray, long l, long l2, String[] stringArray2) throws SMAPIException {
        Object object;
        int n2;
        logWriter.println("McCollectService: In getUptimeSummaryData ");
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        if (stringArray2 == null || stringArray2.length == 0) {
            return null;
        }
        String string = null;
        int n3 = 161;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(l + " ");
        stringBuffer.append(l2 + " ");
        int n4 = 0;
        while (n4 < stringArray2.length - 1) {
            stringBuffer.append(stringArray2[n4] + "|");
            ++n4;
        }
        stringBuffer.append(stringArray2[stringArray2.length - 1]);
        Vector vector = new Vector();
        McProbeCommand mcProbeCommand = new McProbeCommand(this);
        mcProbeCommand.setResultData(vector);
        int n5 = 0;
        while (n5 < stringArray.length) {
            n2 = stringArray[n5].indexOf(58);
            if (n2 < 0) {
                string = stringArray[n5];
            } else {
                string = stringArray[n5].substring(0, n2);
                n3 = Integer.parseInt(stringArray[n5].substring(n2 + 1));
            }
            String string2 = new String(string + ":" + n3);
            object = this;
            synchronized (object) {
                if (this.contextAgents == null) {
                    this.initializeTable();
                }
            }
            if (this.contextAgents.containsKey(string2)) {
                McAgentUptimeData mcAgentUptimeData = new McAgentUptimeData(string2);
                mcAgentUptimeData.setStartTime(new Long(l).toString());
                mcAgentUptimeData.setEndTime(new Long(l2).toString());
                vector.add(mcAgentUptimeData);
                if (n == 0) {
                    mcProbeCommand.setRequest("UPTIMESUMMARY", stringBuffer.toString());
                } else {
                    mcProbeCommand.setRequest("UPTIMEHISTORY", stringBuffer.toString());
                }
                try {
                    mcProbeCommand.sendToAgent(string, n3);
                }
                catch (SMAPIException sMAPIException) {
                    mcAgentUptimeData.setException(true);
                    mcAgentUptimeData.setExceptionObj(sMAPIException);
                    errorWriter.println("McCollectService: SMAPIException for host " + string + ":" + n3);
                }
            }
            ++n5;
        }
        vector = (Vector)mcProbeCommand.getResultData();
        n2 = 1;
        int n6 = 0;
        while (n6 < vector.size()) {
            object = (McAgentUptimeData)vector.elementAt(n6);
            if (!((McAgentUptimeData)object).isException()) {
                n2 = 0;
                break;
            }
            ++n6;
        }
        if (n2 != 0) {
            vector = null;
        }
        return vector;
    }

    static {
        master = null;
        collectService = null;
        try {
            errorWriter = logWriter = MSLogPrintWriter.getChannel((String)"prmlog");
        }
        catch (Exception exception) {
            try {
                errorWriter = logWriter = MSLogPrintWriter.createChannel((String)"prmlog");
            }
            catch (Exception exception2) {
                logWriter = MSLogPrintWriter.getInfoWriter();
                errorWriter = MSLogPrintWriter.getErrorWriter();
            }
        }
        try {
            scService = MSSecurity.getInstance();
            dbAccess = McLogDBAccess.getInstance();
            master = MSSecurity.getMasterUser();
        }
        catch (SMSecurityException sMSecurityException) {
            errorWriter.println("McCollectService: Security service is not available.\nExiting ...");
            System.exit(1);
        }
    }

    class McGroupTaskReqData {
        private SMTaskData taskData = null;
        private SMTaskRequestData reqData = null;
        private SMObjectGroupData groupData = null;
        private boolean exist = false;

        McGroupTaskReqData() {
        }

        void setTaskData(SMTaskData sMTaskData) {
            this.taskData = sMTaskData;
        }

        void setTaskRequestData(SMTaskRequestData sMTaskRequestData) {
            this.reqData = sMTaskRequestData;
        }

        void setObjectGroupData(SMObjectGroupData sMObjectGroupData) {
            this.groupData = sMObjectGroupData;
        }

        SMTaskData getTaskData() {
            return this.taskData;
        }

        SMTaskRequestData getTaskRequestData() {
            return this.reqData;
        }

        SMObjectGroupData getObjectGroupData() {
            return this.groupData;
        }

        void setExist(boolean bl) {
            this.exist = bl;
        }

        boolean isExist() {
            return this.exist;
        }
    }
}

