/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.collect;

import com.sun.symon.base.mgmtservice.collect.McCfgTableObj;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class McCfgData {
    private String type;
    private Vector tables;
    private Hashtable tableList;
    private Hashtable moduleList;
    private boolean i18nKeyAvailable;
    private static final String DEFAULT_MODULE = "Config-Reader4u";

    public McCfgData(String string) {
        this.type = string;
        this.tables = new Vector();
        this.tableList = new Hashtable();
        this.moduleList = new Hashtable();
        this.i18nKeyAvailable = false;
    }

    public void addModule(String string, String string2, String string3, String string4, String string5, Vector vector) {
        McCfgModule mcCfgModule = (McCfgModule)this.moduleList.get(string);
        if (mcCfgModule != null) {
            return;
        }
        mcCfgModule = new McCfgModule(this.type, string, string2, string3, string4, string5);
        if (vector == null) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            String[] stringArray = (String[])vector.elementAt(n);
            if (stringArray != null && stringArray.length == 2) {
                McCfgTableObj mcCfgTableObj = (McCfgTableObj)this.tableList.get(stringArray[0]);
                if (mcCfgTableObj != null) {
                    mcCfgTableObj.addModule(string);
                } else {
                    this.tables.addElement(stringArray[0]);
                    mcCfgTableObj = new McCfgTableObj(string, stringArray[0], stringArray[1]);
                    this.tableList.put(stringArray[0], mcCfgTableObj);
                }
                mcCfgModule.addTable(stringArray[0], stringArray[1]);
            }
            ++n;
        }
        this.moduleList.put(string, mcCfgModule);
    }

    public String getType() {
        return this.type;
    }

    public String[] getTableNames() {
        Object[] objectArray = new String[this.tables.size()];
        this.tables.copyInto(objectArray);
        return objectArray;
    }

    public String[] getTableNameI18nKeys() {
        String[] stringArray = new String[this.tables.size()];
        int n = 0;
        while (n < this.tables.size()) {
            String string = (String)this.tables.elementAt(n);
            McCfgTableObj mcCfgTableObj = (McCfgTableObj)this.tableList.get(string);
            stringArray[n] = mcCfgTableObj == null ? null : mcCfgTableObj.getTableNameKey();
            ++n;
        }
        return stringArray;
    }

    public String getPropertyStr(String string) {
        McCfgTableObj mcCfgTableObj = (McCfgTableObj)this.tableList.get(string);
        if (mcCfgTableObj == null) {
            return null;
        }
        return mcCfgTableObj.getPropertyStr();
    }

    public boolean isI18nKeyAvailable() {
        return this.i18nKeyAvailable;
    }

    public void setI18nKeyAvailable(boolean bl) {
        this.i18nKeyAvailable = bl;
    }

    public String getLastModTime(String string, String string2) {
        String string3;
        McCfgModule mcCfgModule = (McCfgModule)this.moduleList.get(string);
        if (mcCfgModule == null) {
            mcCfgModule = (McCfgModule)this.moduleList.get(DEFAULT_MODULE);
        }
        if ((string3 = mcCfgModule.getFilename()).equals(string2)) {
            return mcCfgModule.getLastModTime();
        }
        return null;
    }

    public McCfgTableObj[] getTables() {
        Object[] objectArray = new String[this.tables.size()];
        this.tables.copyInto(objectArray);
        return this.getTables((String[])objectArray);
    }

    public McCfgTableObj[] getTables(String[] stringArray) {
        McCfgTableObj[] mcCfgTableObjArray = new McCfgTableObj[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            mcCfgTableObjArray[n] = (McCfgTableObj)this.tableList.get(stringArray[n]);
            ++n;
        }
        return mcCfgTableObjArray;
    }

    public McCfgTableObj getTable(String string) {
        return (McCfgTableObj)this.tableList.get(string);
    }

    public String[] getProperties(String string) {
        McCfgTableObj mcCfgTableObj = (McCfgTableObj)this.tableList.get(string);
        if (mcCfgTableObj == null) {
            return null;
        }
        return mcCfgTableObj.getProperties();
    }

    public String[] getPropI18nKeys(String string) {
        McCfgTableObj mcCfgTableObj = (McCfgTableObj)this.tableList.get(string);
        if (mcCfgTableObj == null) {
            return null;
        }
        return mcCfgTableObj.getPropI18nKeys();
    }

    public String getCfgDataStr(String string) {
        McCfgModule mcCfgModule = (McCfgModule)this.moduleList.get(string);
        if (mcCfgModule == null) {
            mcCfgModule = (McCfgModule)this.moduleList.get(DEFAULT_MODULE);
        }
        return mcCfgModule.getModDataStr();
    }

    public void dump() {
        McCfgTableObj[] mcCfgTableObjArray = this.getTables();
        int n = 0;
        while (n < mcCfgTableObjArray.length) {
            mcCfgTableObjArray[n].dump();
            ++n;
        }
        Enumeration enumeration = this.moduleList.elements();
        while (enumeration.hasMoreElements()) {
            McCfgModule mcCfgModule = (McCfgModule)enumeration.nextElement();
            System.out.println(mcCfgModule.getModDataStr());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        McCfgTableObj[] mcCfgTableObjArray = this.getTables();
        int n = 0;
        while (n < mcCfgTableObjArray.length) {
            stringBuffer.append(mcCfgTableObjArray[n].toString());
            stringBuffer.append("\n");
            ++n;
        }
        Enumeration enumeration = this.moduleList.elements();
        while (enumeration.hasMoreElements()) {
            McCfgModule mcCfgModule = (McCfgModule)enumeration.nextElement();
            stringBuffer.append(mcCfgModule.getModDataStr());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    class McCfgModule {
        private String type = null;
        private String module = null;
        private String location = null;
        private String filename = null;
        private String fullname = null;
        private String lastModTime = null;
        private Vector tables = null;
        private Hashtable propTable = null;
        private String tablePropStr = null;

        McCfgModule(String string, String string2, String string3, String string4, String string5, String string6) {
            this.type = string;
            this.module = string2;
            this.location = string3;
            this.filename = string4;
            this.fullname = string5;
            this.lastModTime = string6;
            this.tables = new Vector();
            this.propTable = new Hashtable();
            McCfgData.this.i18nKeyAvailable = false;
        }

        void addTable(String string, String string2) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{" + string + "} ");
            stringBuffer.append("{" + string2 + "}");
            this.tables.addElement(stringBuffer.toString());
        }

        boolean isI18nKeyAvailable() {
            return McCfgData.this.i18nKeyAvailable;
        }

        String getType() {
            return this.type;
        }

        String getModule() {
            return this.module;
        }

        String getLocation() {
            return this.location;
        }

        String getFilename() {
            return this.filename;
        }

        String getFullname() {
            return this.fullname;
        }

        String getLastModTime() {
            return this.lastModTime;
        }

        String getModDataStr() {
            if (this.tablePropStr != null) {
                return this.tablePropStr;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{" + this.type + "} ");
            stringBuffer.append("{" + this.filename + "} ");
            stringBuffer.append("{" + this.lastModTime + "} ");
            stringBuffer.append("{" + this.module + "} ");
            stringBuffer.append("{" + this.location + "}");
            Enumeration enumeration = this.propTable.elements();
            int n = 0;
            while (n < this.tables.size()) {
                String string = (String)this.tables.elementAt(n);
                stringBuffer.append(" " + string);
                ++n;
            }
            this.tablePropStr = stringBuffer.toString();
            return this.tablePropStr;
        }
    }
}

