/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.discovery.console.presentation;

import com.sun.symon.tools.discovery.console.presentation.DiscoverGUIException;
import com.sun.symon.tools.discovery.console.presentation.DiscoverPanel;
import com.sun.symon.tools.discovery.console.presentation.DiscoverRequest;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public class DiscoverConfirmDialog {
    String[] data;
    DiscoverRequest request;
    DiscoverPanel parent;
    String message;
    String operation;
    String requestId;
    String requestName;
    JDialog dialog = null;
    boolean show_yes = true;
    boolean show_no = true;
    boolean show_cancel = true;
    JTextArea messageText;
    JButton yesbut;
    JButton nobut;
    JButton cancelbut;

    public DiscoverConfirmDialog(DiscoverPanel discoverPanel, DiscoverRequest discoverRequest, String string, String string2) {
        this.parent = discoverPanel;
        this.message = string;
        this.operation = string2;
        this.request = discoverRequest;
        this.requestId = discoverRequest.getId();
        this.requestName = discoverRequest.getName();
        this.yesbut = new JButton(this.parent.getI18NString("Yes"));
        this.nobut = new JButton(this.parent.getI18NString("No"));
        this.cancelbut = new JButton(this.parent.getI18NString("Cancel"));
    }

    public void init() {
        this.dialog = new JDialog(this.parent.getParentFrame());
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DiscoverConfirmDialog.this.parent.closeConfirmDialog();
            }
        });
        if (this.operation.equals("log")) {
            this.dialog.setTitle(this.parent.getI18NString("Request_Log_File"));
            this.dialog.setModal(false);
        } else if (this.operation.equals("add") || this.operation.equals("edit") || this.operation.equals("duplicate")) {
            this.dialog.setTitle(this.parent.getI18NString("Confirm"));
            this.dialog.setModal(true);
        } else {
            this.dialog.setTitle(this.parent.getI18NString("Warning"));
            this.dialog.setModal(true);
        }
        JPanel jPanel = new JPanel();
        this.yesbut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiscoverConfirmDialog.this.YesPressed();
            }
        });
        this.nobut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiscoverConfirmDialog.this.NoPressed();
            }
        });
        this.cancelbut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiscoverConfirmDialog.this.CancelPressed();
            }
        });
        this.cancelbut.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiscoverConfirmDialog.this.CancelPressed();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        if (this.show_yes) {
            jPanel.add(this.yesbut);
        }
        if (this.show_no) {
            jPanel.add(this.nobut);
        }
        if (this.show_cancel) {
            jPanel.add(this.cancelbut);
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(10, 10));
        Border border = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        jPanel2.setBorder(border);
        if (this.operation.equals("log")) {
            this.messageText = new JTextArea();
            this.messageText.setBackground(((Component)this.dialog).getBackground());
            this.messageText.setFont(this.dialog.getFont());
            Insets insets = new Insets(0, 0, 0, 0);
            this.messageText.setMargin(insets);
            this.messageText.setEditable(false);
            this.updateText(this.message);
            JScrollPane jScrollPane = new JScrollPane(this.messageText);
            jScrollPane.setPreferredSize(new Dimension(450, 300));
            jPanel2.add("Center", jScrollPane);
        } else {
            JLabel jLabel = new JLabel(this.message);
            jPanel2.add("North", jLabel);
        }
        jPanel2.add("South", jPanel);
        this.dialog.getRootPane().setDefaultButton(this.yesbut);
        this.dialog.getContentPane().add(jPanel2);
        this.dialog.setLocationRelativeTo(this.parent);
        this.dialog.pack();
    }

    public void showButtons(boolean bl, boolean bl2, boolean bl3) {
        this.show_yes = bl;
        this.show_no = bl2;
        this.show_cancel = bl3;
    }

    public void setYesText(String string) {
        this.yesbut.setText(string);
    }

    public void setNoText(String string) {
        this.nobut.setText(string);
    }

    public void setCancelText(String string) {
        this.cancelbut.setText(string);
    }

    public void YesPressed() {
        if (this.operation.equals("log")) {
            this.updateText(this.parent.getRequestLog(this.request));
            return;
        }
        ((Component)this.dialog).setVisible(false);
        this.parent.closeConfirmDialog();
        try {
            this.parent.doRequestOperation(this.requestId, this.operation, true);
        }
        catch (DiscoverGUIException discoverGUIException) {
            discoverGUIException.print();
        }
    }

    public void NoPressed() {
        ((Component)this.dialog).setVisible(false);
        this.parent.closeConfirmDialog();
        try {
            this.parent.doRequestOperation(this.requestId, this.operation, false);
        }
        catch (DiscoverGUIException discoverGUIException) {
            discoverGUIException.print();
        }
    }

    public void CancelPressed() {
        ((Component)this.dialog).setVisible(false);
        this.parent.closeConfirmDialog();
    }

    public void show() {
        this.dialog.show();
    }

    public void hide() {
        ((Component)this.dialog).setVisible(false);
    }

    public void updateRequest(DiscoverRequest discoverRequest) {
        this.request = discoverRequest;
        this.requestId = discoverRequest.getId();
        this.requestName = discoverRequest.getName();
        this.updateText(this.parent.getRequestLog(this.request));
    }

    public void updateText(String string) {
        this.messageText.setText("");
        this.messageText.append(this.parent.getI18NString("Key_RequestId") + this.requestId);
        this.messageText.append(this.parent.getI18NString("Key_RequestName") + this.requestName);
        this.messageText.append(this.parent.getI18NString("log_file_line_separator"));
        int n = 0;
        int n2 = string.length() - 1;
        while (n2 >= 0) {
            if (string.charAt(n2) == '\n' && ++n > 2000) {
                this.messageText.append(this.parent.getI18NString("Truncated_output_to_show_last_2000_lines"));
                this.messageText.append("\n");
                this.messageText.append("\n");
                this.messageText.append(string.substring(n2 + 1));
                break;
            }
            --n2;
        }
        if (n <= 2000) {
            this.messageText.append(string);
        }
    }
}

