/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.hierarchy;

import com.sun.symon.base.console.views.CvToolTip;
import com.sun.symon.base.console.views.hierarchy.CvHierarchyData;
import com.sun.symon.base.console.views.hierarchy.CvHierarchyManager;
import com.sun.symon.base.utility.UcDDL;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class CvHierarchyTree
extends JTree
implements FocusListener,
TreeSelectionListener {
    private CvHierarchyData latestCollapsedObjectData = null;
    private TreePath latestCollapsedPath = null;
    private boolean latestCollapsedPathSelected = false;
    private TreePath syncPath = null;
    private TreePath discardPath = null;
    private CvHierarchyManager manager = null;
    private TreePath previousSelectionPath = null;
    private boolean displayToolTip = true;

    public CvHierarchyTree(TreeModel treeModel, CvHierarchyManager cvHierarchyManager) {
        super(treeModel);
        this.manager = cvHierarchyManager;
        this.addTreeSelectionListener(this);
    }

    public void collapseRoot() {
        if (this.latestCollapsedPath != null && this.latestCollapsedObjectData != null) {
            this.selectPath(this.latestCollapsedPath, true, null);
            this.manager.fireDrillDownEvents(this.latestCollapsedObjectData);
            this.latestCollapsedPath = null;
            this.latestCollapsedObjectData = null;
        }
    }

    public JToolTip createToolTip() {
        return new CvToolTip();
    }

    public void enableToolTip(boolean bl) {
        this.displayToolTip = bl;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.repaint();
    }

    public Insets getInsets() {
        return new Insets(4, 4, 4, 4);
    }

    public CvHierarchyData getLatestCollapsedObjectData() {
        return this.latestCollapsedObjectData;
    }

    public TreePath getLatestCollapsedPath() {
        return this.latestCollapsedPath;
    }

    public boolean getLatestCollapsedPathSelected() {
        return this.latestCollapsedPathSelected;
    }

    public CvHierarchyManager getManager() {
        return this.manager;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width += 25;
        return dimension;
    }

    public TreePath getPreviousSelectedPath() {
        return this.previousSelectionPath;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isToolTipEnabled() {
        return this.displayToolTip;
    }

    public void selectPath(TreePath treePath, boolean bl, TreePath treePath2) {
        this.discardPath = treePath2;
        this.selectPath(treePath, bl);
    }

    public void selectPath(TreePath treePath, boolean bl) {
        TreePath treePath2 = this.getSelectionPath();
        this.setSelectionPath(treePath);
        if (this.getSelectionPath() == null) {
            UcDDL.logWarningMessage((String)("CvHierarchyTree.selectPath() - New selection on path " + treePath + " failed.  " + "No change in selection, i.e. set the path back to " + "where it was: " + treePath2));
            treePath = treePath2;
            this.setSelectionPath(treePath);
        }
        if (bl) {
            this.scrollPathToVisible(treePath);
        }
        this.previousSelectionPath = treePath;
        if (this.discardPath != null) {
            this.syncPath = treePath;
        }
    }

    public void setLatestCollapsedObjectData(CvHierarchyData cvHierarchyData) {
        this.latestCollapsedObjectData = cvHierarchyData;
    }

    public void setLatestCollapsedPath(TreePath treePath) {
        this.latestCollapsedPath = treePath;
    }

    public void setLatestCollapsedPathSelected(boolean bl) {
        this.latestCollapsedPathSelected = bl;
    }

    public void setPreviousSelectedPath(TreePath treePath) {
        this.previousSelectionPath = treePath;
    }

    protected void syncSelection(TreePath treePath) {
        if (treePath != null && this.discardPath != null && treePath.equals(this.discardPath)) {
            this.discardPath = null;
            if (this.syncPath != null) {
                this.selectPath(this.syncPath, false);
                this.syncPath = null;
            }
        }
    }

    public void updateUI() {
        this.setRowHeight(16);
        this.collapseRoot();
        super.updateUI();
        this.setRowHeight(-1);
        this.collapseRoot();
        this.expandRow(0);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.syncSelection(treeSelectionEvent.getPath());
    }
}

