/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.graph;

import com.sun.symon.base.console.views.graph.CvGraphAxisFormat;
import com.sun.symon.base.console.views.graph.CvGraphFormat;
import com.sun.symon.base.console.views.graph.CvGraphInvalidInputException;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;

public class CvGraphYAxisFormat
extends CvGraphAxisFormat {
    private double minValue = 0.0;
    private double maxValue = 20.0;
    private double tickSpacing = 1.0;
    private double numSpacing = 2.0;
    private double gridSpacing = 1.0;
    boolean autoScale = true;

    public String getConfiguration() {
        return "YAxis^" + this.getAutoScale() + "^" + this.getMinValue() + "^" + this.getMaxValue() + "^" + this.getNumSpacing() + "^" + this.getTickSpacing() + "^" + this.getGridSpacing();
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getGridSpacing() {
        return this.gridSpacing;
    }

    public double getTickSpacing() {
        return this.tickSpacing;
    }

    public double getNumSpacing() {
        return this.numSpacing;
    }

    public void setConfiguration(String string) throws CvGraphInvalidInputException {
        double d;
        double d2;
        if (string == null || string.length() == 0) {
            return;
        }
        String[] stringArray = CvGraphFormat.splitString(string, "^");
        if (stringArray.length != 7) {
            UcDDL.logDebugMessage((String)("CvGraphYAxisFormat::setConfiguration - invalid number of parameters '" + string + "'"));
            return;
        }
        if (!stringArray[0].equals("YAxis")) {
            UcDDL.logDebugMessage((String)("CvGraphYAxisFormat::setConfiguration - invalid format keyword '" + stringArray[0] + "'"));
            return;
        }
        this.setAutoScale(Boolean.valueOf(stringArray[1]));
        if (this.autoScale) {
            return;
        }
        try {
            d2 = Double.valueOf(stringArray[2]);
        }
        catch (NumberFormatException numberFormatException) {
            UcDDL.logDebugMessage((String)"CvGraphYAxisFormat::setConfiguration -- invalid Min , replaced by default");
            String string2 = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:invalidMin");
            throw new CvGraphInvalidInputException(string2);
        }
        try {
            d = Double.valueOf(stringArray[3]);
        }
        catch (NumberFormatException numberFormatException) {
            UcDDL.logDebugMessage((String)"CvGraphYAxisFormat::setConfiguration -- invalid Max , replaced by default");
            String string3 = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:invalidMax");
            throw new CvGraphInvalidInputException(string3);
        }
        if (d <= d2) {
            String string4 = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:minMax");
            throw new CvGraphInvalidInputException(string4);
        }
        this.setMinValue(d2);
        this.setMaxValue(d);
        try {
            this.setNumSpacing(Double.valueOf(stringArray[4]));
        }
        catch (NumberFormatException numberFormatException) {
            UcDDL.logDebugMessage((String)"CvGraphYAxisFormat::setConfiguration -- invalid Max , replaced by default");
            String string5 = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:invalidYLabelSpacing");
            throw new CvGraphInvalidInputException(string5);
        }
        try {
            this.setTickSpacing(Double.valueOf(stringArray[5]));
        }
        catch (NumberFormatException numberFormatException) {
            UcDDL.logDebugMessage((String)"CvGraphYAxisFormat::setConfiguration -- invalid Max , replaced by default");
            String string6 = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:invalidYTickSpacing");
            throw new CvGraphInvalidInputException(string6);
        }
        try {
            double d3 = Double.valueOf(stringArray[6]);
            if (d3 <= 0.0) {
                String string7 = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:non-positiveGrid");
                throw new CvGraphInvalidInputException(string7);
            }
            this.setGridSpacing(d3);
        }
        catch (NumberFormatException numberFormatException) {
            UcDDL.logDebugMessage((String)"CvGraphYAxisFormat::setConfiguration -- invalid grid spacing, replaced by default");
            String string8 = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:invalidYGridSpacing");
            throw new CvGraphInvalidInputException(string8);
        }
    }

    public void setMaxValue(double d) {
        this.maxValue = d;
    }

    public void setMinValue(double d) {
        this.minValue = d;
    }

    public boolean getAutoScale() {
        return this.autoScale;
    }

    public void setAutoScale(boolean bl) {
        this.autoScale = bl;
    }

    public void setGridSpacing(double d) {
        this.gridSpacing = d;
    }

    public void setTickSpacing(double d) {
        this.tickSpacing = d;
    }

    public void setNumSpacing(double d) {
        this.numSpacing = d;
    }
}

