/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.graph;

import com.klg.jclass.chart.ChartDataModel;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.EventTrigger;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCAxisTitle;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.util.legend.JCLegend;
import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.client.graph.SMGraphData;
import com.sun.symon.base.client.graph.SMGraphInfo;
import com.sun.symon.base.client.graph.SMGraphRequest;
import com.sun.symon.base.client.graph.SMGraphResponse;
import com.sun.symon.base.console.views.graph.CvGraphBorderFormat;
import com.sun.symon.base.console.views.graph.CvGraphDirectionFormat;
import com.sun.symon.base.console.views.graph.CvGraphFooterFormat;
import com.sun.symon.base.console.views.graph.CvGraphFormat;
import com.sun.symon.base.console.views.graph.CvGraphHeaderFormat;
import com.sun.symon.base.console.views.graph.CvGraphInvalidInputException;
import com.sun.symon.base.console.views.graph.CvGraphLegendFormat;
import com.sun.symon.base.console.views.graph.CvGraphLineFormat;
import com.sun.symon.base.console.views.graph.CvGraphLineInfo;
import com.sun.symon.base.console.views.graph.CvGraphModel;
import com.sun.symon.base.console.views.graph.CvGraphStyleFormat;
import com.sun.symon.base.console.views.graph.CvGraphThread;
import com.sun.symon.base.console.views.graph.CvGraphXAxisFormat;
import com.sun.symon.base.console.views.graph.CvGraphXLabelFormat;
import com.sun.symon.base.console.views.graph.CvGraphYAxisFormat;
import com.sun.symon.base.console.views.graph.CvGraphYLabelFormat;
import com.sun.symon.base.console.views.graph.CvMesgDialog;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcURL;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;

public class CvGraph
extends JCChart
implements SMGraphResponse,
MouseListener,
MouseMotionListener {
    protected static final int DEFAULT_SCROLL_SIZE = 6;
    protected static final double DEFAULT_HOLE_VALUE = -123456.789;
    protected static final int DEFAULT_SECONDS_TO_NEXT_UPDATE = 30;
    protected static final int DEFAULT_SLEEP_TIME = 300;
    protected static final int DEFAULT_SLEEP_TIME1 = 120;
    protected static final int DEFAULT_MIN_UPDATE_TIME = 10;
    protected static final String CONFIG_DELIMITER = "$";
    protected static final String URL_DELIMITER = ",";
    protected static final String TITLE_DELIMITER = "^";
    protected static final String URL_INIT = "snmp";
    private CvGraphFormat graphFormat = new CvGraphFormat();
    private CvGraphModel graphModel = null;
    private SMRawDataRequest origDataSource = null;
    private SMGraphRequest graphDataSource = null;
    private String unit = "";
    private Vector lineInfo = new Vector();
    private boolean configurationSpecified = false;
    private int sleepTime = 300;
    private int otherSleepTime = 120;
    private int minSleepTime = 10;
    private boolean liveData = true;
    private boolean zoomEnabled = false;
    private boolean translationEnabled = false;
    private long graphStartTime;
    private long graphEndTime;
    private long currentTimeStamp = Calendar.getInstance().getTime().getTime() / 1000L;
    private int secsToDisplay;
    private Color graphBackground = Color.white;
    private boolean sourceFirst = true;
    private CvMesgDialog mesgDialog;
    private boolean interrupted = false;
    private boolean oldGraph = false;
    private double minData = 0.0;
    private double maxData = 0.1;
    private int count = 0;
    private boolean hasHist = false;
    private boolean beanConstructed = false;
    private int graphBorderType;
    private int chartAreaBorderType;

    public CvGraph() {
        this.graphModel = new CvGraphModel();
        this.getDataView(0).setDataSource((ChartDataModel)this.graphModel);
        this.getHeader().setVisible(false);
        this.getFooter().setVisible(false);
        this.getLegend().setVisible(true);
        JCAxis jCAxis = this.getChartArea().getXAxis(0);
        JCAxis jCAxis2 = this.getChartArea().getYAxis(0);
        jCAxis.setAnnotationMethod(2);
        jCAxis.setTimeUnit(1000L);
        jCAxis.setTimeBase(new Date(0L));
        jCAxis2.setAnnotationMethod(0);
        jCAxis.setGridVisible(false);
        jCAxis2.setGridVisible(false);
        jCAxis.getTitle().setVisible(true);
        jCAxis2.getTitle().setVisible(true);
        this.setBackground(this.graphBackground);
        ((Component)((Object)this)).addMouseListener(this);
        ((Component)((Object)this)).addMouseMotionListener(this);
        this.beanConstructed = true;
    }

    public void addAnotherOne(String string) {
        String string2 = "";
        try {
            string2 = this.graphDataSource.getUnitForURL(string);
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logErrorMessage((String)("CvGraph::init -- cannot find unit for " + string));
            this.checkForTimeout(sMAPIException);
        }
        if (this.lineInfo.size() < 5) {
            if (!string2.equals(this.unit)) {
                Object[] objectArray = new String[]{UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:dialog.ok")};
                String string3 = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:dialog.error");
                JOptionPane.showOptionDialog((Component)((Object)this), UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:notSameUnit"), string3, -1, 0, null, objectArray, objectArray[0]);
                return;
            }
        } else {
            Object[] objectArray = new String[]{UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:dialog.ok")};
            String string4 = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:dialog.error");
            JOptionPane.showOptionDialog((Component)((Object)this), UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:max5sets"), string4, -1, 0, null, objectArray, objectArray[0]);
            return;
        }
        this.addManagedProperty(string);
    }

    public void addManagedProperty(String string) {
        if (string == null || string.length() == 0) {
            this.oldGraph = true;
            return;
        }
        if (this.graphDataSource == null) {
            this.sourceFirst = false;
        }
        if (string != null && string.length() > 0) {
            int n = 0;
            while (n < this.graphFormat.getNumLines()) {
                CvGraphLineFormat cvGraphLineFormat = this.graphFormat.getLineFormat(n);
                if (string.equals(cvGraphLineFormat.getManagedProperty())) {
                    return;
                }
                ++n;
            }
            this.updateRecord(string);
        }
    }

    private void updateRecord(String string) {
        String string2 = this.getPropertyName(string);
        String string3 = this.getPrefixForLegend(string);
        CvGraphLineFormat cvGraphLineFormat = new CvGraphLineFormat(string, string3 + string2);
        this.graphFormat.addLine(cvGraphLineFormat);
        if (this.oldGraph && this.graphFormat.getNumLines() == 1) {
            this.setBatched(true);
            this.initialize();
        }
        this.requestDataForURL(string);
        this.setBatched(false);
    }

    public String[] getLegendTexts() {
        int n = this.graphFormat.getNumLines();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.graphFormat.getLineFormat(n2).getLegendText();
            ++n2;
        }
        return stringArray;
    }

    private String getPrefixForLegend(String string) {
        Object object;
        if (string == null) {
            return "";
        }
        UcURL ucURL = new UcURL(string);
        String string2 = ucURL.getHost();
        try {
            object = InetAddress.getByName(string2);
            string2 = ((InetAddress)object).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            UcDDL.logErrorMessage((String)("unknown host name " + string2));
        }
        object = "";
        try {
            if (this.graphDataSource != null) {
                object = this.graphDataSource.getRowName(string).trim();
            }
        }
        catch (SMAPIException sMAPIException) {
            this.checkForTimeout(sMAPIException);
        }
        if (((String)object).length() >= 0) {
            object = (String)object + " ";
        }
        return string2 + ":" + (String)object;
    }

    public void addOrRemoveZoom() {
        int n = this.eventEnabled(1);
        if (n == -1) {
            this.setTrigger(this.getNumTriggers(), new EventTrigger(1, 1));
            this.zoomEnabled = true;
        } else {
            this.setTrigger(n, null);
            this.zoomEnabled = false;
        }
    }

    private int eventEnabled(int n) {
        int n2 = this.getNumTriggers();
        int n3 = 0;
        while (n3 < n2) {
            EventTrigger eventTrigger = this.getTrigger(n3);
            if (n == eventTrigger.getAction()) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public void addOrRemoveTranslate() {
        int n = this.eventEnabled(2);
        if (n == -1) {
            this.setTrigger(this.getNumTriggers(), new EventTrigger(2, 2));
            this.translationEnabled = true;
        } else {
            this.setTrigger(n, null);
            this.translationEnabled = false;
        }
    }

    public void applyTemplate(String string, String string2) throws CvGraphInvalidInputException {
        try {
            SMGraphInfo[] sMGraphInfoArray = this.graphDataSource.getUserGraphTemplateInfo(string);
            int n = 0;
            while (n < sMGraphInfoArray.length) {
                SMGraphInfo sMGraphInfo = sMGraphInfoArray[n];
                if (string2.equals(sMGraphInfo.getGraphName())) {
                    String string3 = sMGraphInfo.getGraphInfo();
                    this.setConfiguration(string3);
                }
                ++n;
            }
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logDebugMessage((String)("cannot retrieve template info for  user " + string));
            this.checkForTimeout(sMAPIException);
        }
    }

    public void changeGraphType(int n) {
        CvGraphYAxisFormat cvGraphYAxisFormat = this.graphFormat.getYAxisFormat();
        this.setBatched(true);
        JCAxis jCAxis = this.getChartArea().getYAxis(0);
        JCAxis jCAxis2 = this.getChartArea().getXAxis(0);
        if (n == 8 || n == 9) {
            jCAxis.setMaxIsDefault(false);
            jCAxis.setMinIsDefault(false);
            jCAxis2.setPlacement(jCAxis, jCAxis.getMin());
        } else {
            jCAxis.setMaxIsDefault(cvGraphYAxisFormat.getAutoScale());
            jCAxis.setMinIsDefault(cvGraphYAxisFormat.getAutoScale());
            if (cvGraphYAxisFormat.getAutoScale()) {
                jCAxis2.setPlacementIsDefault(true);
            } else {
                jCAxis2.setPlacementIsDefault(false);
            }
            if (cvGraphYAxisFormat.getAutoScale()) {
                jCAxis2.setPlacementIsDefault(true);
            }
        }
        this.getDataView(0).setChartType(n);
        this.setBatched(false);
    }

    private void correctBugs() {
        JCAxis jCAxis = this.getChartArea().getXAxis(0);
        JCAxis jCAxis2 = this.getChartArea().getYAxis(0);
        ChartDataView chartDataView = this.getDataView(0);
        CvGraphDirectionFormat cvGraphDirectionFormat = this.graphFormat.getDirectionFormat();
        JCAxisTitle jCAxisTitle = this.getDataView(0).getXAxis().getTitle();
        JCAxisTitle jCAxisTitle2 = this.getDataView(0).getYAxis().getTitle();
        if (!(chartDataView.isInverted() || jCAxis.isReversed() || jCAxis2.isReversed())) {
            jCAxisTitle.setPlacement(32);
            jCAxisTitle2.setPlacement(2);
            cvGraphDirectionFormat.setDirections("nnn");
        } else if (!chartDataView.isInverted() && !jCAxis.isReversed() && jCAxis2.isReversed()) {
            jCAxisTitle.setPlacement(16);
            jCAxisTitle2.setPlacement(2);
            cvGraphDirectionFormat.setDirections("nnr");
        } else if (chartDataView.isInverted() && !jCAxis.isReversed() && jCAxis2.isReversed()) {
            jCAxisTitle.setPlacement(1);
            jCAxisTitle2.setPlacement(32);
            cvGraphDirectionFormat.setDirections("inr");
        } else if (chartDataView.isInverted() && !jCAxis.isReversed() && !jCAxis2.isReversed()) {
            jCAxisTitle.setPlacement(2);
            jCAxisTitle2.setPlacement(32);
            cvGraphDirectionFormat.setDirections("inn");
        } else if (!chartDataView.isInverted() && jCAxis.isReversed() && !jCAxis2.isReversed()) {
            jCAxisTitle.setPlacement(32);
            jCAxisTitle2.setPlacement(1);
            cvGraphDirectionFormat.setDirections("nrn");
        } else if (!chartDataView.isInverted() && jCAxis.isReversed() && jCAxis2.isReversed()) {
            jCAxisTitle.setPlacement(16);
            jCAxisTitle2.setPlacement(1);
            cvGraphDirectionFormat.setDirections("nrr");
        } else if (chartDataView.isInverted() && jCAxis.isReversed() && !jCAxis2.isReversed()) {
            jCAxisTitle.setPlacement(2);
            jCAxisTitle2.setPlacement(16);
            cvGraphDirectionFormat.setDirections("irn");
        } else if (chartDataView.isInverted() && jCAxis.isReversed() && jCAxis2.isReversed()) {
            jCAxisTitle.setPlacement(1);
            jCAxisTitle2.setPlacement(16);
            cvGraphDirectionFormat.setDirections("irr");
        }
        int n = jCAxisTitle.getPlacement();
        int n2 = jCAxisTitle2.getPlacement();
        this.graphFormat.getXLabelFormat().setPlacement(n);
        this.graphFormat.getYLabelFormat().setPlacement(n2);
    }

    public void deleteGraph(String string, String string2) {
        try {
            this.graphDataSource.deleteGraph(string, string2);
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logDebugMessage((String)"CvGraph::deleteGraph -- failed ");
            this.checkForTimeout(sMAPIException);
        }
    }

    public void deleteTemplate(String string, String string2) {
        try {
            this.graphDataSource.deleteGraphTemplate(string, string2);
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logDebugMessage((String)"CvGraph::deleteTemplate -- failed ");
            this.checkForTimeout(sMAPIException);
        }
    }

    public void endZoomOrTranslate() {
        this.setBatched(true);
        JCAxis jCAxis = this.getChartArea().getXAxis(0);
        JCAxis jCAxis2 = this.getChartArea().getYAxis(0);
        jCAxis.setMin((double)this.graphStartTime);
        jCAxis.setMax((double)this.graphEndTime);
        this.setupYAxis(this.graphFormat.getYAxisFormat(), jCAxis2);
        if (this.getDataView(0).getChartType() != 0) {
            UcDDL.logDebugMessage((String)("go back to " + this.minData + ", " + this.maxData));
            jCAxis2.setMin(this.minData);
            jCAxis2.setMax(this.maxData);
            jCAxis.setPlacement(jCAxis2, this.minData);
        } else {
            jCAxis.setPlacementIsDefault(true);
        }
        this.setBatched(false);
    }

    public void flipXAxis() {
        if (this.getChartArea().getXAxis(0).isReversed()) {
            this.getChartArea().getXAxis(0).setReversed(false);
        } else {
            this.getChartArea().getXAxis(0).setReversed(true);
        }
        this.correctBugs();
        this.update();
    }

    public void flipYAxis() {
        if (this.getChartArea().getYAxis(0).isReversed()) {
            this.getChartArea().getYAxis(0).setReversed(false);
        } else {
            this.getChartArea().getYAxis(0).setReversed(true);
        }
        this.correctBugs();
        this.update();
    }

    private void formatSeries(ChartDataViewSeries chartDataViewSeries, CvGraphLineFormat cvGraphLineFormat) {
        chartDataViewSeries.setIncluded(true);
        chartDataViewSeries.setVisible(true);
        chartDataViewSeries.setVisibleInLegend(true);
        chartDataViewSeries.setLabel(cvGraphLineFormat.getLegendText());
        chartDataViewSeries.setFirstPoint(0);
        chartDataViewSeries.setLastPointIsDefault(true);
    }

    public String[] getAllGraphs() {
        try {
            SMGraphInfo[] sMGraphInfoArray = this.graphDataSource.getUserGraphInfo(this.getGraphUserId());
            String[] stringArray = new String[sMGraphInfoArray.length];
            int n = 0;
            while (n < sMGraphInfoArray.length) {
                SMGraphInfo sMGraphInfo = sMGraphInfoArray[n];
                stringArray[n] = sMGraphInfo.getGraphName();
                ++n;
            }
            return stringArray;
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logDebugMessage((String)("cannot retrieve graph info for  user " + this.getGraphUserId()));
            this.checkForTimeout(sMAPIException);
            return null;
        }
    }

    public String[] getAllTemplates() {
        try {
            SMGraphInfo[] sMGraphInfoArray = this.graphDataSource.getUserGraphTemplateInfo(this.getGraphUserId());
            String[] stringArray = new String[sMGraphInfoArray.length];
            int n = 0;
            while (n < sMGraphInfoArray.length) {
                SMGraphInfo sMGraphInfo = sMGraphInfoArray[n];
                stringArray[n] = sMGraphInfo.getGraphName();
                ++n;
            }
            return stringArray;
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logDebugMessage((String)("cannot retrieve graph info for  user " + this.getGraphUserId()));
            this.checkForTimeout(sMAPIException);
            return null;
        }
    }

    public String getConfiguration() {
        return this.graphFormat != null ? this.graphFormat.getConfiguration() : "";
    }

    public CvGraphFormat getGraphFormat() {
        return this.graphFormat;
    }

    public CvGraphModel getGraphModel() {
        return this.graphModel;
    }

    public String getGraphUserId() {
        return this.graphDataSource.getGraphUserId();
    }

    public boolean getGridShown() {
        return this.getChartArea().getXAxis(0).isGridVisible();
    }

    public boolean getHeaderShown() {
        return this.getHeader().isVisible();
    }

    public boolean getFooterShown() {
        return this.getFooter().isVisible();
    }

    public boolean getTitleShown() {
        return this.getChartArea().getXAxis(0).getTitle().isVisible();
    }

    public boolean getAxesShown() {
        return this.getChartArea().getXAxis(0).isVisible();
    }

    public boolean getLegendShown() {
        return this.getLegend().isVisible();
    }

    public int getMinutesToDisplay() {
        if (this.graphFormat != null && this.graphFormat.getXAxisFormat() != null) {
            return this.graphFormat.getXAxisFormat().getMinutesToDisplay();
        }
        return 60;
    }

    public Dimension getPreferredSize() {
        return new Dimension(500, 500);
    }

    private String getPropertyName(String string) {
        String string2 = "???";
        if (string != null && this.origDataSource != null) {
            UcURL ucURL = new UcURL(string);
            String string3 = ucURL.getFragment();
            if (string3.length() > 1) {
                string3 = string3.substring(1);
            }
            String[] stringArray = new String[]{SMRawDataRequest.buildShadowURL((String)string, (String)"i18ndesc", (String)string3)};
            try {
                StObject[][] stObjectArray = this.origDataSource.getURLValue(stringArray);
                if (stObjectArray != null) {
                    string2 = stObjectArray[0][0].toString();
                }
            }
            catch (SMAPIException sMAPIException) {
                UcDDL.logWarningMessage((String)"Error getting property name", (Throwable)sMAPIException);
                this.checkForTimeout(sMAPIException);
            }
        }
        return UcInternationalizer.translateKey((String)string2);
    }

    public int getSecondsToNextUpdate(String string) {
        int n = 0;
        while (n < this.lineInfo.size()) {
            CvGraphLineInfo cvGraphLineInfo = (CvGraphLineInfo)this.lineInfo.elementAt(n);
            if (string.equals(cvGraphLineInfo.getUrl())) {
                return cvGraphLineInfo.getSecondsToNextUpdate();
            }
            ++n;
        }
        return 30;
    }

    private Window getTopWindow(Component component) {
        Component component2 = component;
        while (component2 != null) {
            if (component2 instanceof Window) {
                return (Window)component2;
            }
            component2 = component2.getParent();
        }
        return null;
    }

    public double getXMaxValue() {
        return this.getChartArea().getXAxis(0).getMax();
    }

    public double getXMinValue() {
        return this.getChartArea().getXAxis(0).getMin();
    }

    public boolean getYAxisIsAutomatic() {
        return this.getChartArea().getYAxis(0).getMaxIsDefault();
    }

    public double getYMaxValue() {
        return this.getChartArea().getYAxis(0).getMax();
    }

    public double getYMinValue() {
        return this.getChartArea().getYAxis(0).getMin();
    }

    public void initialize() {
        CvGraphLineFormat cvGraphLineFormat = this.graphFormat.getLineFormat(0);
        String string = this.getPropertyName(cvGraphLineFormat.getManagedProperty());
        try {
            this.unit = this.graphDataSource.getUnitForURL(cvGraphLineFormat.getManagedProperty());
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logErrorMessage((String)("CvGraph::init -- cannot find unit for " + cvGraphLineFormat.getManagedProperty()));
            this.checkForTimeout(sMAPIException);
        }
        ((JLabel)this.getHeader()).setText(string);
        ((JLabel)this.getFooter()).setText(string);
        this.getChartArea().getXAxis(0).getTitle().setText(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:Time"));
        this.getChartArea().getYAxis(0).getTitle().setText(this.unit);
        String string2 = this.getPrefixForLegend(cvGraphLineFormat.getManagedProperty());
        cvGraphLineFormat.setLegendText(string2 + string);
        if (!this.configurationSpecified) {
            this.setGraphFromConfiguration();
        }
    }

    public boolean getDataState() {
        return this.liveData;
    }

    private void resetAllOtherFormats() {
        CvGraphLineInfo cvGraphLineInfo;
        int n;
        this.liveData = this.graphFormat.getDataState();
        if (!this.liveData) {
            n = 0;
            while (n < this.lineInfo.size()) {
                cvGraphLineInfo = (CvGraphLineInfo)this.lineInfo.elementAt(n);
                CvGraphThread cvGraphThread = cvGraphLineInfo.getRequesterThread();
                if (cvGraphThread != null) {
                    cvGraphThread.suspend();
                }
                ++n;
            }
        } else {
            n = 0;
            while (n < this.lineInfo.size()) {
                cvGraphLineInfo = (CvGraphLineInfo)this.lineInfo.elementAt(n);
                CvGraphThread cvGraphThread = cvGraphLineInfo.getRequesterThread();
                if (cvGraphThread != null) {
                    cvGraphThread.resume();
                }
                ++n;
            }
        }
        JCAxis jCAxis = this.getChartArea().getXAxis(0);
        cvGraphLineInfo = this.getChartArea().getYAxis(0);
        if (this.graphFormat.getShowGraphGrids()) {
            cvGraphLineInfo.setGridVisible(true);
            jCAxis.setGridVisible(true);
        } else {
            cvGraphLineInfo.setGridVisible(false);
            jCAxis.setGridVisible(false);
        }
        if (this.graphFormat.getShowGraphAxes()) {
            cvGraphLineInfo.setVisible(true);
            jCAxis.setVisible(true);
        } else {
            cvGraphLineInfo.setVisible(false);
            jCAxis.setVisible(false);
        }
        this.update();
    }

    public void init() {
        if (!this.beanConstructed) {
            super.init();
            return;
        }
        if (this.oldGraph) {
            return;
        }
        CvGraphLineFormat cvGraphLineFormat = this.graphFormat.getLineFormat(0);
        if (cvGraphLineFormat != null) {
            String string = this.getPropertyName(cvGraphLineFormat.getManagedProperty());
            try {
                this.unit = this.graphDataSource.getUnitForURL(cvGraphLineFormat.getManagedProperty());
            }
            catch (SMAPIException sMAPIException) {
                UcDDL.logErrorMessage((String)("CvGraph::init -- cannot find unit for " + cvGraphLineFormat.getManagedProperty()));
                this.checkForTimeout(sMAPIException);
            }
            ((JLabel)this.getHeader()).setText(string);
            ((JLabel)this.getFooter()).setText(string);
            this.getChartArea().getYAxis(0).getTitle().setText(this.unit);
            String string2 = this.getPrefixForLegend(cvGraphLineFormat.getManagedProperty());
            cvGraphLineFormat.setLegendText(string2 + string);
        }
        this.getChartArea().getXAxis(0).getTitle().setText(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:Time"));
        if (!this.configurationSpecified) {
            this.setGraphFromConfiguration();
        }
        if (!this.sourceFirst && cvGraphLineFormat != null) {
            this.requestDataForURL(cvGraphLineFormat.getManagedProperty());
        }
        this.setBatched(false);
    }

    public void invertGraphAxes() {
        if (this.getChartArea().getYAxis(0).isReversed()) {
            this.getChartArea().getYAxis(0).setReversed(false);
        } else {
            this.getChartArea().getYAxis(0).setReversed(true);
        }
        if (this.getChartArea().getXAxis(0).isReversed()) {
            this.getChartArea().getXAxis(0).setReversed(false);
        } else {
            this.getChartArea().getXAxis(0).setReversed(true);
        }
        this.update();
    }

    public void makeDataRequest(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        int n = 0;
        while (n < this.lineInfo.size()) {
            CvGraphLineInfo cvGraphLineInfo = (CvGraphLineInfo)this.lineInfo.elementAt(n);
            if (cvGraphLineInfo.getUrl().equals(string)) {
                try {
                    this.graphDataSource.getGraphCurrentValue(string, (SMGraphResponse)this, (Object)cvGraphLineInfo);
                }
                catch (SMAPIException sMAPIException) {
                    UcDDL.logErrorMessage((String)("Error requesting current value for " + string), (Throwable)sMAPIException);
                    this.checkForTimeout(sMAPIException);
                }
            }
            ++n;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.zoomEnabled || this.translationEnabled) {
            this.setBatched(true);
        }
        super.mousePressed(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.zoomEnabled || this.translationEnabled) {
            this.resetAxes();
            this.setBatched(false);
            this.update();
        }
        super.mouseReleased(mouseEvent);
    }

    public void openOldGraph(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.oldGraph = true;
        String[] stringArray = CvGraphFormat.splitString(string, CONFIG_DELIMITER);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = stringArray[2];
        String[] stringArray2 = CvGraphFormat.splitString(string2, ",snmp");
        String[] stringArray3 = CvGraphFormat.splitString(string3, TITLE_DELIMITER);
        int n = 0;
        while (n < stringArray2.length) {
            this.addManagedProperty(stringArray2[n]);
            ++n;
        }
        try {
            this.resetAllTitles(stringArray3);
            this.setConfiguration(string4);
        }
        catch (CvGraphInvalidInputException cvGraphInvalidInputException) {
            // empty catch block
        }
    }

    public void openGraph(String string, String string2) throws CvGraphInvalidInputException {
        try {
            SMGraphInfo[] sMGraphInfoArray = this.graphDataSource.getUserGraphInfo(string);
            int n = 0;
            while (n < sMGraphInfoArray.length) {
                SMGraphInfo sMGraphInfo = sMGraphInfoArray[n];
                if (string2.equals(sMGraphInfo.getGraphName())) {
                    String string3 = sMGraphInfo.getGraphInfo();
                    String[] stringArray = CvGraphFormat.splitString(string3, CONFIG_DELIMITER);
                    String string4 = stringArray[0];
                    String string5 = stringArray[1];
                    String string6 = stringArray[2];
                    String[] stringArray2 = CvGraphFormat.splitString(string4, ",snmp");
                    String[] stringArray3 = CvGraphFormat.splitString(string5, TITLE_DELIMITER);
                    this.shutdown();
                    this.setConfiguration(string6);
                    int n2 = 0;
                    while (n2 < stringArray2.length) {
                        this.addManagedProperty(stringArray2[n2]);
                        ++n2;
                    }
                    try {
                        this.unit = this.graphDataSource.getUnitForURL(stringArray2[0]);
                    }
                    catch (SMAPIException sMAPIException) {
                        UcDDL.logErrorMessage((String)"cannot get unit !!");
                    }
                    this.resetAllTitles(stringArray3);
                }
                ++n;
            }
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logDebugMessage((String)("cannot retrieve template info for  user " + string));
        }
    }

    public void overwriteGraph(String string) throws SMAPIException {
        String string2 = this.getGraphUserId();
        this.deleteGraph(string2, string);
        this.saveGraph(string);
    }

    public void overwriteTemplate(String string) throws SMAPIException {
        String string2 = this.getGraphUserId();
        this.deleteTemplate(string2, string);
        this.saveTemplate(string);
    }

    private void popupMesgDialog(String string, String string2) {
        this.mesgDialog = new CvMesgDialog(this.getTopWindow((Component)((Object)this)), string, string2);
        this.mesgDialog.pack();
        this.mesgDialog.show();
        Point point = ((Component)((Object)this)).getLocationOnScreen();
        ((Component)this.mesgDialog).setLocation(point.x + ((Component)((Object)this)).getSize().width - 300, point.y + ((Component)((Object)this)).getSize().height - 80);
    }

    public void printConfiguration() {
        UcDDL.logDebugMessage((String)("CvGraph::printConfiguration -- " + this.graphFormat.getConfiguration()));
    }

    private void keepThemLive(int n) {
        int n2 = 0;
        while (n2 < this.lineInfo.size()) {
            CvGraphLineInfo cvGraphLineInfo = (CvGraphLineInfo)this.lineInfo.elementAt(n2);
            CvGraphThread cvGraphThread = cvGraphLineInfo.getRequesterThread();
            cvGraphLineInfo.setSecondsToNextUpdate(n);
            if (cvGraphThread != null) {
                cvGraphThread.resume();
            }
            ++n2;
        }
    }

    public void receiveGraphData(SMRequestStatus sMRequestStatus, SMGraphData[] sMGraphDataArray, Object object) {
        if (sMRequestStatus == null) {
            UcDDL.logErrorMessage((String)"CvGraph::status is NULL");
            this.keepThemLive(this.sleepTime);
            return;
        }
        if (sMRequestStatus.getReturnCode() == 0) {
            this.addNewDataPoints(sMGraphDataArray, object);
        } else {
            String string = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:warn");
            String string2 = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:otherError");
            if (sMRequestStatus.getReturnCode() == 1) {
                UcDDL.logDebugMessage((String)"CvGraph::security error ");
                string2 = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:securityError");
            } else if (sMRequestStatus.getReturnCode() == 4) {
                UcDDL.logDebugMessage((String)"CvGraph::time out error");
                string2 = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:agentdown");
            }
            if (this.mesgDialog == null || !this.mesgDialog.isVisible()) {
                this.popupMesgDialog(string, string2);
            }
            this.keepThemLive(this.sleepTime);
        }
    }

    private void addNewDataPoints(SMGraphData[] sMGraphDataArray, Object object) {
        if (!this.configurationSpecified) {
            this.setGraphFromConfiguration();
        }
        if (this.mesgDialog != null) {
            this.mesgDialog.dispose();
        }
        if (sMGraphDataArray == null || sMGraphDataArray.length == 0) {
            UcDDL.logDebugMessage((String)"CvGraph::receiveGraphData --  No data received in last try ");
            this.keepThemLive(this.sleepTime);
            return;
        }
        UcDDL.logDebugMessage((String)"got another data set");
        int n = 0;
        while (n < this.lineInfo.size()) {
            CvGraphLineInfo cvGraphLineInfo = (CvGraphLineInfo)this.lineInfo.elementAt(n);
            if (object == cvGraphLineInfo) {
                boolean bl;
                Object object2;
                int n2;
                if (sMGraphDataArray.length == 1) {
                    this.currentTimeStamp = sMGraphDataArray[0].getTimestamp();
                    if (this.currentTimeStamp > this.graphEndTime && !this.zoomOrTranslated()) {
                        this.scrollXAxis(this.currentTimeStamp);
                    }
                    if ((n2 = sMGraphDataArray[0].getSecondsToNextUpdate()) == -1) {
                        if (this.mesgDialog == null || !this.mesgDialog.isVisible()) {
                            object2 = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:warn");
                            String string = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:invalidtime");
                            String string2 = cvGraphLineInfo.getUrl();
                            String string3 = this.getPrefixForLegend(string2) + this.getPropertyName(string2);
                            this.popupMesgDialog((String)object2, string3 + "\n" + string);
                        }
                        cvGraphLineInfo.setSecondsToNextUpdate(this.sleepTime);
                    } else {
                        if (this.mesgDialog != null) {
                            this.mesgDialog.dispose();
                        }
                        this.graphModel.addDataPoint(n * 2, new Long(this.currentTimeStamp), new Double(sMGraphDataArray[0].getPointValue()));
                        if (n2 == 97644 || n2 == 97645 || n2 == 97646) {
                            cvGraphLineInfo.setSecondsToNextUpdate(this.otherSleepTime);
                        } else if (n2 < 10) {
                            cvGraphLineInfo.setSecondsToNextUpdate(this.minSleepTime);
                        } else {
                            cvGraphLineInfo.setSecondsToNextUpdate(n2);
                        }
                        if (this.count == 0) {
                            this.minData = this.getChartArea().getYAxis(0).getMin();
                            this.maxData = this.getChartArea().getYAxis(0).getMax();
                            ++this.count;
                        }
                        if (this.minData > sMGraphDataArray[0].getPointValue()) {
                            this.minData = sMGraphDataArray[0].getPointValue();
                        }
                        if (this.maxData < sMGraphDataArray[0].getPointValue()) {
                            double d = this.minData;
                            double d2 = this.getChartArea().getYAxis(0).getNumSpacing();
                            while (d < sMGraphDataArray[0].getPointValue()) {
                                d += d2;
                            }
                            this.maxData = d;
                        }
                        if (this.getDataView(0).getChartType() != 0 && this.graphFormat.getYAxisFormat().getAutoScale()) {
                            this.setBatched(true);
                            JCAxis jCAxis = this.getChartArea().getXAxis(0);
                            JCAxis jCAxis2 = this.getChartArea().getYAxis(0);
                            jCAxis2.setMinIsDefault(false);
                            jCAxis2.setMaxIsDefault(false);
                            if (this.maxData > jCAxis2.getMax()) {
                                jCAxis2.setMax(this.maxData);
                            }
                            if (this.minData < jCAxis2.getMin()) {
                                jCAxis2.setMin(this.minData);
                            }
                            jCAxis.setPlacement(jCAxis2, jCAxis2.getMin());
                        }
                        this.update();
                        this.setBatched(false);
                    }
                } else {
                    n2 = 0;
                    while (n2 < sMGraphDataArray.length) {
                        this.currentTimeStamp = sMGraphDataArray[n2].getTimestamp();
                        this.graphModel.addDataPoint(n * 2, new Long(this.currentTimeStamp), new Double(sMGraphDataArray[n2].getPointValue()));
                        ++n2;
                    }
                }
                object2 = this.getDataView(0);
                boolean bl2 = bl = sMGraphDataArray[0].getSecondsToNextUpdate() == -1;
                if (!bl && object2 != null && object2.getNumSeries() <= n) {
                    int n3 = object2.getNumSeries();
                    while (n3 <= n) {
                        ChartDataViewSeries chartDataViewSeries = new ChartDataViewSeries();
                        this.formatSeries(chartDataViewSeries, this.graphFormat.getLineFormat(n3));
                        ++n3;
                    }
                }
                if (cvGraphLineInfo.getRequesterThread() != null) {
                    cvGraphLineInfo.getRequesterThread().resume();
                }
            }
            ++n;
        }
    }

    void requestDataForURL(String string) {
        if (this.graphDataSource == null) {
            return;
        }
        CvGraphThread cvGraphThread = new CvGraphThread(string, this);
        CvGraphLineInfo cvGraphLineInfo = new CvGraphLineInfo(string, 0, cvGraphThread);
        this.lineInfo.addElement(cvGraphLineInfo);
        int n = this.graphFormat.getNumLines() - 1;
        SMGraphData[] sMGraphDataArray = this.graphDataSource.getGraphHistory(string);
        if (sMGraphDataArray != null) {
            this.graphModel.addSeriesLabel(this.graphFormat.getLineFormat(n).getLegendText());
            int n2 = 0;
            while (n2 < sMGraphDataArray.length) {
                this.hasHist = true;
                this.currentTimeStamp = sMGraphDataArray[n2].getTimestamp();
                this.graphModel.addDataPoint(n * 2, new Long(this.currentTimeStamp), new Double(sMGraphDataArray[n2].getPointValue()));
                ++n2;
            }
        }
        cvGraphThread.start();
    }

    public boolean hasHistoryData() {
        return this.hasHist;
    }

    public void resetBack() {
        JCAxis jCAxis = this.getChartArea().getXAxis(0);
        JCAxis jCAxis2 = this.getChartArea().getYAxis(0);
        ChartDataView chartDataView = this.getDataView(0);
        chartDataView.setInverted(false);
        jCAxis.setReversed(false);
        jCAxis2.setReversed(false);
        this.correctBugs();
        this.update();
    }

    public void rotate180Deg() {
        this.rotate90Deg();
        this.rotate90Deg();
    }

    public void rotate270Deg() {
        this.rotate90Deg();
        this.rotate90Deg();
        this.rotate90Deg();
    }

    public void rotate90Deg() {
        JCAxis jCAxis = this.getChartArea().getXAxis(0);
        JCAxis jCAxis2 = this.getChartArea().getYAxis(0);
        ChartDataView chartDataView = this.getDataView(0);
        if (!(chartDataView.isInverted() || jCAxis.isReversed() || jCAxis2.isReversed())) {
            chartDataView.setInverted(true);
            jCAxis2.setReversed(true);
            JCAxisTitle jCAxisTitle = this.getDataView(0).getXAxis().getTitle();
            jCAxisTitle.setPlacement(1);
        } else if (!chartDataView.isInverted() && !jCAxis.isReversed() && jCAxis2.isReversed()) {
            jCAxis2.setReversed(false);
            chartDataView.setInverted(true);
        } else if (chartDataView.isInverted() && !jCAxis.isReversed() && jCAxis2.isReversed()) {
            jCAxis.setReversed(true);
            chartDataView.setInverted(false);
        } else if (chartDataView.isInverted() && !jCAxis.isReversed() && !jCAxis2.isReversed()) {
            jCAxis2.setReversed(false);
            jCAxis.setReversed(true);
            chartDataView.setInverted(false);
        } else if (!chartDataView.isInverted() && jCAxis.isReversed() && !jCAxis2.isReversed()) {
            chartDataView.setInverted(true);
            jCAxis2.setReversed(true);
        } else if (!chartDataView.isInverted() && jCAxis.isReversed() && jCAxis2.isReversed()) {
            jCAxis2.setReversed(false);
            chartDataView.setInverted(true);
        } else if (chartDataView.isInverted() && jCAxis.isReversed() && !jCAxis2.isReversed()) {
            jCAxis2.setReversed(false);
            jCAxis.setReversed(false);
            chartDataView.setInverted(false);
        } else if (chartDataView.isInverted() && jCAxis.isReversed() && jCAxis2.isReversed()) {
            jCAxis.setReversed(false);
            chartDataView.setInverted(false);
        }
        this.correctBugs();
        this.update();
    }

    public boolean saveGraph(String string) throws SMAPIException {
        if (string == null || string.trim().length() == 0) {
            String string2 = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:needGraphName");
            UcDDL.logErrorMessage((String)("CvGraph::saveGraph -- " + string2));
            throw new SMAPIException(string2);
        }
        String string3 = this.getAllGraphInfo();
        return this.graphDataSource.createGraph(string, string3);
    }

    private String getAllGraphInfo() {
        String string = this.getURLsInOne();
        String string2 = this.getTitlesInOne();
        return string + CONFIG_DELIMITER + string2 + CONFIG_DELIMITER + this.graphFormat.getConfiguration();
    }

    public String getURLsInOne() {
        String string = "";
        if (this.lineInfo.size() == 0) {
            return string;
        }
        CvGraphLineFormat cvGraphLineFormat = this.graphFormat.getLineFormat(0);
        string = string + cvGraphLineFormat.getManagedProperty();
        int n = 1;
        while (n < this.lineInfo.size()) {
            cvGraphLineFormat = this.graphFormat.getLineFormat(n);
            string = string + URL_DELIMITER + cvGraphLineFormat.getManagedProperty();
            ++n;
        }
        return string;
    }

    public String getTitlesInOne() {
        String string = ((JLabel)this.getHeader()).getText();
        string = string + TITLE_DELIMITER + ((JLabel)this.getFooter()).getText();
        string = string + TITLE_DELIMITER + this.getChartArea().getXAxis(0).getTitle().getText();
        string = string + TITLE_DELIMITER + this.getChartArea().getYAxis(0).getTitle().getText();
        int n = 0;
        while (n < this.lineInfo.size()) {
            CvGraphLineFormat cvGraphLineFormat = this.graphFormat.getLineFormat(n);
            string = string + TITLE_DELIMITER + cvGraphLineFormat.getLegendText();
            ++n;
        }
        return string;
    }

    public void resetAllTitles(String[] stringArray) {
        ((JLabel)this.header).setText(stringArray[0]);
        ((JLabel)this.footer).setText(stringArray[1]);
        this.getChartArea().getXAxis(0).getTitle().setText(stringArray[2]);
        this.getChartArea().getYAxis(0).getTitle().setText(stringArray[3]);
        int n = 0;
        while (n < this.lineInfo.size()) {
            CvGraphLineFormat cvGraphLineFormat = this.graphFormat.getLineFormat(n);
            cvGraphLineFormat.setLegendText(stringArray[n + 4]);
            this.graphModel.setSeriesLabel(n, stringArray[n + 4]);
            ++n;
        }
    }

    public boolean saveTemplate(String string) throws SMAPIException {
        if (string == null || string.trim().length() == 0) {
            String string2 = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:needTemplateName");
            UcDDL.logErrorMessage((String)("CvGraph::saveGraph -- " + string2));
            throw new SMAPIException(string2);
        }
        this.getCurrentYAxisConfiguration();
        return this.graphDataSource.createGraphTemplate(string, this.graphFormat.getConfiguration());
    }

    private void scrollXAxis(long l) {
        JCAxis jCAxis = this.getChartArea().getXAxis(0);
        this.graphEndTime = (long)this.getXMaxValue();
        long l2 = this.graphEndTime - (long)this.getXMinValue();
        while (l > this.graphEndTime) {
            this.graphEndTime += l2 / 6L;
        }
        this.graphStartTime = this.graphEndTime - l2;
        jCAxis.setMax((double)this.graphEndTime);
        jCAxis.setMin((double)this.graphStartTime);
    }

    public String getCurrentYAxisConfiguration() {
        CvGraphYAxisFormat cvGraphYAxisFormat = this.graphFormat.getYAxisFormat();
        JCAxis jCAxis = this.getChartArea().getYAxis(0);
        cvGraphYAxisFormat.setMinValue(jCAxis.getMin());
        cvGraphYAxisFormat.setMaxValue(jCAxis.getMax());
        cvGraphYAxisFormat.setGridSpacing(jCAxis.getGridSpacing());
        cvGraphYAxisFormat.setTickSpacing(jCAxis.getTickSpacing());
        cvGraphYAxisFormat.setNumSpacing(jCAxis.getNumSpacing());
        return cvGraphYAxisFormat.getConfiguration();
    }

    public double getAutoMin() {
        return this.minData;
    }

    public double getAutoMax() {
        return this.maxData;
    }

    public void resetAxes() {
        CvGraphYAxisFormat cvGraphYAxisFormat = this.graphFormat.getYAxisFormat();
        JCAxis jCAxis = this.getChartArea().getXAxis(0);
        JCAxis jCAxis2 = this.getChartArea().getYAxis(0);
        int n = this.graphFormat.getStyleFormat().getGraphType();
        if (n != 0 && (this.zoomEnabled || this.translationEnabled)) {
            jCAxis2.setMinIsDefault(false);
            jCAxis2.setMaxIsDefault(false);
            double d = jCAxis2.getMin();
            if (d > 0.0) {
                jCAxis.setPlacement(jCAxis2, jCAxis2.getMin());
            } else {
                jCAxis.setPlacement(jCAxis2, 0.0);
            }
        }
        this.update();
    }

    private void resetXAxis(CvGraphXAxisFormat cvGraphXAxisFormat, JCAxis jCAxis) {
        if (cvGraphXAxisFormat.getAutoScale()) {
            int n = 3600;
            if (n < this.secsToDisplay) {
                while (this.graphStartTime + (long)n < this.currentTimeStamp) {
                    this.graphStartTime += (long)n;
                }
                this.graphEndTime = this.graphStartTime + (long)n;
            } else {
                this.graphEndTime = this.graphStartTime + (long)n;
            }
            this.secsToDisplay = n;
            jCAxis.setMaxIsDefault(false);
            jCAxis.setMinIsDefault(false);
            jCAxis.setMin((double)this.graphStartTime);
            jCAxis.setMax((double)this.graphEndTime);
            jCAxis.setGridSpacing(600.0);
            jCAxis.setGridSpacingIsDefault(false);
            jCAxis.setTickSpacing(600.0);
            jCAxis.setTickSpacingIsDefault(false);
        } else {
            int n = cvGraphXAxisFormat.getMinutesToDisplay() * 60;
            if (n < this.secsToDisplay) {
                while (this.graphStartTime + (long)n < this.currentTimeStamp) {
                    this.graphStartTime += (long)n;
                }
                this.graphEndTime = this.graphStartTime + (long)n;
            } else {
                this.graphEndTime = this.graphStartTime + (long)n;
            }
            this.secsToDisplay = n;
            jCAxis.setMaxIsDefault(false);
            jCAxis.setMinIsDefault(false);
            jCAxis.setMin((double)this.graphStartTime);
            jCAxis.setMax((double)this.graphEndTime);
            jCAxis.setGridSpacing(cvGraphXAxisFormat.getGridSpacing() * 60.0);
            jCAxis.setGridSpacingIsDefault(false);
            jCAxis.setTickSpacing(cvGraphXAxisFormat.getTickSpacing() * 60.0);
            jCAxis.setTickSpacingIsDefault(false);
        }
    }

    private void resetYAxis(CvGraphYAxisFormat cvGraphYAxisFormat, JCAxis jCAxis) {
        JCAxis jCAxis2 = this.getChartArea().getXAxis(0);
        if (cvGraphYAxisFormat.getAutoScale()) {
            jCAxis.setGridSpacingIsDefault(true);
            if (this.getDataView(0).getChartType() == 0) {
                jCAxis.setMinIsDefault(true);
                jCAxis.setMaxIsDefault(true);
                jCAxis2.setPlacementIsDefault(true);
            } else {
                jCAxis.setMinIsDefault(false);
                jCAxis.setMaxIsDefault(false);
                jCAxis2.setPlacement(jCAxis, jCAxis.getMin());
            }
            jCAxis.setTickSpacingIsDefault(true);
            jCAxis.setGridSpacingIsDefault(true);
            jCAxis.setNumSpacingIsDefault(true);
        } else {
            jCAxis.setGridSpacing(cvGraphYAxisFormat.getGridSpacing());
            jCAxis.setGridSpacingIsDefault(false);
            jCAxis.setMin(cvGraphYAxisFormat.getMinValue());
            jCAxis.setMax(cvGraphYAxisFormat.getMaxValue());
            jCAxis.setMinIsDefault(false);
            jCAxis.setMaxIsDefault(false);
            jCAxis.setTickSpacing(cvGraphYAxisFormat.getTickSpacing());
            jCAxis.setTickSpacingIsDefault(false);
            jCAxis.setNumSpacing(cvGraphYAxisFormat.getNumSpacing());
            jCAxis.setNumSpacingIsDefault(false);
            jCAxis2.setPlacementIsDefault(true);
        }
    }

    public void setAxisConfiguration(String string) throws CvGraphInvalidInputException {
        this.graphFormat.setConfiguration(string);
        CvGraphXAxisFormat cvGraphXAxisFormat = this.graphFormat.getXAxisFormat();
        CvGraphYAxisFormat cvGraphYAxisFormat = this.graphFormat.getYAxisFormat();
        JCAxis jCAxis = this.getChartArea().getXAxis(0);
        JCAxis jCAxis2 = this.getChartArea().getYAxis(0);
        this.setBatched(true);
        this.resetXAxis(cvGraphXAxisFormat, jCAxis);
        this.resetYAxis(cvGraphYAxisFormat, jCAxis2);
        this.setBatched(false);
        this.update();
    }

    public void setAxisFont(Font font) {
        if (font != null) {
            this.getChartArea().getXAxis(0).setFont(font);
            this.getChartArea().getYAxis(0).setFont(font);
        }
    }

    public void setBorderConfiguration(String string) throws CvGraphInvalidInputException {
        this.graphFormat.setConfiguration(string);
        this.setBorderFormat(this.graphFormat.getBorderFormat());
        this.makeSureXAxisNotScroll();
        this.update();
    }

    public void setBorderFormat(CvGraphBorderFormat cvGraphBorderFormat) {
        int n = cvGraphBorderFormat.getOutsideBorderWidth();
        String string = cvGraphBorderFormat.getOutsideBorderType();
        int n2 = cvGraphBorderFormat.getInsideBorderWidth();
        String string2 = cvGraphBorderFormat.getInsideBorderType();
        this.graphBorderType = CvGraphFormat.getBorderTypeNumber(string);
        this.chartAreaBorderType = CvGraphFormat.getBorderTypeNumber(string2);
        ((JComponent)((Object)this)).setBorder(this.getBorder(string));
        this.getChartArea().setBorder(this.getBorder(string2));
    }

    public void setConfiguration(CvGraphFormat cvGraphFormat) {
        if (cvGraphFormat != null) {
            this.graphFormat = cvGraphFormat;
            this.setGraphFromConfiguration();
        }
    }

    public void setConfiguration(String string) throws CvGraphInvalidInputException {
        this.graphFormat.setConfiguration(string);
        this.setGraphFromConfiguration();
    }

    public void setDirectionFormat(CvGraphDirectionFormat cvGraphDirectionFormat) {
        JCAxis jCAxis = this.getChartArea().getXAxis(0);
        JCAxis jCAxis2 = this.getChartArea().getYAxis(0);
        ChartDataView chartDataView = this.getDataView(0);
        String string = cvGraphDirectionFormat.getDirections();
        if (string.equals("nnn")) {
            chartDataView.setInverted(false);
            jCAxis.setReversed(false);
            jCAxis2.setReversed(false);
        } else if (string.equals("nnr")) {
            chartDataView.setInverted(false);
            jCAxis.setReversed(false);
            jCAxis2.setReversed(true);
        } else if (string.equals("inr")) {
            chartDataView.setInverted(true);
            jCAxis.setReversed(false);
            jCAxis2.setReversed(true);
        } else if (string.equals("inn")) {
            chartDataView.setInverted(true);
            jCAxis.setReversed(false);
            jCAxis2.setReversed(false);
        } else if (string.equals("nrn")) {
            chartDataView.setInverted(false);
            jCAxis.setReversed(true);
            jCAxis2.setReversed(false);
        } else if (string.equals("nrr")) {
            chartDataView.setInverted(false);
            jCAxis.setReversed(true);
            jCAxis2.setReversed(true);
        } else if (string.equals("irn")) {
            chartDataView.setInverted(true);
            jCAxis.setReversed(true);
            jCAxis2.setReversed(false);
        } else if (string.equals("irr")) {
            chartDataView.setInverted(true);
            jCAxis.setReversed(true);
            jCAxis2.setReversed(true);
        }
    }

    public void setFooterConfiguration(String string, String string2) throws CvGraphInvalidInputException {
        ((JLabel)this.getFooter()).setText(string);
        this.graphFormat.setConfiguration(string2);
        this.setFooterFormat(this.graphFormat.getFooterFormat());
        this.makeSureXAxisNotScroll();
        this.update();
    }

    public void setFooterFormat(CvGraphFooterFormat cvGraphFooterFormat) {
        JLabel jLabel = (JLabel)this.getFooter();
        jLabel.setHorizontalAlignment(0);
        jLabel.setFont(cvGraphFooterFormat.getTitleFont());
        jLabel.setBorder(this.getBorder(cvGraphFooterFormat.getBorderType()));
        jLabel.setVisible(cvGraphFooterFormat.getShowFooter());
    }

    public void setGraphDataSource(SMRawDataRequest sMRawDataRequest) {
        if (sMRawDataRequest != null) {
            this.origDataSource = sMRawDataRequest;
            this.graphDataSource = new SMGraphRequest(sMRawDataRequest);
        }
    }

    private void setGraphFromConfiguration() {
        if (this.graphFormat == null) {
            return;
        }
        this.configurationSpecified = true;
        this.setBatched(true);
        this.setDirectionFormat(this.graphFormat.getDirectionFormat());
        this.setStyleFormat(this.graphFormat.getStyleFormat());
        this.setHeaderFormat(this.graphFormat.getHeaderFormat());
        this.setFooterFormat(this.graphFormat.getFooterFormat());
        this.setLegendFormat(this.graphFormat.getLegendFormat());
        this.setBorderFormat(this.graphFormat.getBorderFormat());
        this.setTypeFormat(this.graphFormat.getStyleFormat());
        this.setupXAxis(this.graphFormat.getXAxisFormat(), this.getChartArea().getXAxis(0));
        this.setupYAxis(this.graphFormat.getYAxisFormat(), this.getChartArea().getYAxis(0));
        this.setXLabelFormat(this.graphFormat.getXLabelFormat());
        this.setYLabelFormat(this.graphFormat.getYLabelFormat());
        ChartDataView chartDataView = this.getDataView(0);
        chartDataView.setHoleValue(-123456.789);
        this.resetAllOtherFormats();
        this.setBatched(false);
    }

    public void setHeaderConfiguration(String string, String string2) throws CvGraphInvalidInputException {
        ((JLabel)this.getHeader()).setText(string);
        this.graphFormat.setConfiguration(string2);
        this.setHeaderFormat(this.graphFormat.getHeaderFormat());
        this.makeSureXAxisNotScroll();
        this.update();
    }

    public void setHeaderFormat(CvGraphHeaderFormat cvGraphHeaderFormat) {
        JLabel jLabel = (JLabel)this.getHeader();
        jLabel.setHorizontalAlignment(0);
        jLabel.setFont(cvGraphHeaderFormat.getTitleFont());
        jLabel.setBorder(this.getBorder(cvGraphHeaderFormat.getBorderType()));
        jLabel.setVisible(cvGraphHeaderFormat.getShowHeader());
    }

    public void setLegendConfiguration(int n, String string, String string2) throws CvGraphInvalidInputException {
        this.graphFormat.setConfiguration(string2);
        this.setLegendText(n, string);
        this.setLegendFormat(this.graphFormat.getLegendFormat());
        this.makeSureXAxisNotScroll();
        this.update();
    }

    public void setLegendText(int n, String string) {
        JCLegend jCLegend = this.getLegend();
        ChartDataViewSeries chartDataViewSeries = this.getDataView(0).getSeries(n);
        CvGraphLineFormat cvGraphLineFormat = this.graphFormat.getLineFormat(n);
        chartDataViewSeries.setLabel(string);
        cvGraphLineFormat.setLegendText(string);
        this.graphModel.setSeriesLabel(n, string);
    }

    public void setLegendFormat(CvGraphLegendFormat cvGraphLegendFormat) {
        JCLegend jCLegend = this.getLegend();
        jCLegend.setFont(cvGraphLegendFormat.getLegendFont());
        jCLegend.setBorder(this.getBorder(cvGraphLegendFormat.getBorderType()));
        jCLegend.setOrientation(cvGraphLegendFormat.getOrientationNumber());
        jCLegend.setAnchor(cvGraphLegendFormat.getPositionNumber());
        jCLegend.setVisible(cvGraphLegendFormat.getShowLegend());
        this.update();
    }

    public void setStyleConfiguration(String string) throws CvGraphInvalidInputException {
        this.graphFormat.setConfiguration(string);
        this.setStyleFormat(this.graphFormat.getStyleFormat());
        this.makeSureXAxisNotScroll();
        this.update();
    }

    public void setStyleFormat(CvGraphStyleFormat cvGraphStyleFormat) {
        int n = cvGraphStyleFormat.getGraphType();
        this.changeGraphType(n);
    }

    public void setTypeFormat(CvGraphStyleFormat cvGraphStyleFormat) {
        int n = cvGraphStyleFormat.getGraphType();
        int n2 = this.getDataView().size();
        int n3 = 0;
        while (n3 < n2) {
            this.getDataView(n3).setChartType(n);
            ++n3;
        }
    }

    public void setXLabelConfiguration(String string, String string2) throws CvGraphInvalidInputException {
        JCAxisTitle jCAxisTitle = this.getDataView(0).getXAxis().getTitle();
        jCAxisTitle.setText(string);
        this.graphFormat.setConfiguration(string2);
        this.setXLabelFormat(this.graphFormat.getXLabelFormat());
        this.makeSureXAxisNotScroll();
        this.update();
    }

    public void setXLabelFormat(CvGraphXLabelFormat cvGraphXLabelFormat) {
        JCAxisTitle jCAxisTitle = this.getDataView(0).getXAxis().getTitle();
        jCAxisTitle.setFont(cvGraphXLabelFormat.getTitleFont());
        jCAxisTitle.setRotation(cvGraphXLabelFormat.getOrientationNumber());
        jCAxisTitle.setPlacement(cvGraphXLabelFormat.getPlacement());
        jCAxisTitle.setVisible(cvGraphXLabelFormat.getShowXTitle());
        this.update();
    }

    public void setYLabelConfiguration(String string, String string2) throws CvGraphInvalidInputException {
        JCAxisTitle jCAxisTitle = this.getDataView(0).getYAxis().getTitle();
        jCAxisTitle.setText(string);
        this.graphFormat.setConfiguration(string2);
        this.setYLabelFormat(this.graphFormat.getYLabelFormat());
        this.makeSureXAxisNotScroll();
        this.update();
    }

    public void setYLabelFormat(CvGraphYLabelFormat cvGraphYLabelFormat) {
        JCAxisTitle jCAxisTitle = this.getDataView(0).getYAxis().getTitle();
        jCAxisTitle.setFont(cvGraphYLabelFormat.getTitleFont());
        jCAxisTitle.setRotation(cvGraphYLabelFormat.getOrientationNumber());
        jCAxisTitle.setPlacement(cvGraphYLabelFormat.getPlacement());
        jCAxisTitle.setVisible(cvGraphYLabelFormat.getShowYTitle());
        this.update();
    }

    private void setupXAxis(CvGraphXAxisFormat cvGraphXAxisFormat, JCAxis jCAxis) {
        this.setAxisFont(new Font("times", 0, 8));
        if (cvGraphXAxisFormat != null && jCAxis != null) {
            jCAxis.setGridSpacingIsDefault(false);
            jCAxis.setGridSpacing(cvGraphXAxisFormat.getGridSpacing() * 60.0);
            jCAxis.setTickSpacingIsDefault(false);
            jCAxis.setTickSpacing(cvGraphXAxisFormat.getTickSpacing() * 60.0);
            this.secsToDisplay = cvGraphXAxisFormat.getMinutesToDisplay() * 60;
            long l = this.secsToDisplay / 6;
            this.graphStartTime = this.currentTimeStamp / l * l - 300L;
            this.graphEndTime = this.graphStartTime + (long)this.secsToDisplay;
            jCAxis.setMin((double)this.graphStartTime);
            jCAxis.setMax((double)this.graphEndTime);
            jCAxis.setMaxIsDefault(false);
            jCAxis.setMinIsDefault(false);
        }
    }

    private void makeSureXAxisNotScroll() {
        JCAxis jCAxis = this.getChartArea().getXAxis(0);
        jCAxis.setMin((double)this.graphStartTime);
        jCAxis.setMax((double)this.graphEndTime);
    }

    private void setupYAxis(CvGraphYAxisFormat cvGraphYAxisFormat, JCAxis jCAxis) {
        if (cvGraphYAxisFormat != null && jCAxis != null) {
            jCAxis.setGridSpacing(cvGraphYAxisFormat.getGridSpacing());
            jCAxis.setGridSpacingIsDefault(cvGraphYAxisFormat.getAutoScale());
            if (!cvGraphYAxisFormat.getAutoScale()) {
                jCAxis.setMin(cvGraphYAxisFormat.getMinValue());
                jCAxis.setMax(cvGraphYAxisFormat.getMaxValue());
            }
            if (this.getDataView(0).getChartType() == 0) {
                jCAxis.setMinIsDefault(cvGraphYAxisFormat.getAutoScale());
                jCAxis.setMaxIsDefault(cvGraphYAxisFormat.getAutoScale());
            } else {
                jCAxis.setMinIsDefault(false);
                jCAxis.setMaxIsDefault(false);
            }
            jCAxis.setTickSpacing(cvGraphYAxisFormat.getTickSpacing());
            jCAxis.setTickSpacingIsDefault(cvGraphYAxisFormat.getAutoScale());
            jCAxis.setNumSpacing(cvGraphYAxisFormat.getNumSpacing());
            jCAxis.setNumSpacingIsDefault(cvGraphYAxisFormat.getAutoScale());
        }
    }

    public void showAxesLabels() {
        ChartDataView chartDataView = this.getDataView(0);
        this.setBatched(true);
        if (chartDataView.getXAxis().getTitle().isVisible()) {
            chartDataView.getXAxis().getTitle().setVisible(false);
            this.graphFormat.getXLabelFormat().setShowXTitle(false);
        } else {
            chartDataView.getXAxis().getTitle().setVisible(true);
            this.graphFormat.getXLabelFormat().setShowXTitle(true);
        }
        if (chartDataView.getYAxis().getTitle().isVisible()) {
            chartDataView.getYAxis().getTitle().setVisible(false);
            this.graphFormat.getYLabelFormat().setShowYTitle(false);
        } else {
            chartDataView.getYAxis().getTitle().setVisible(true);
            this.graphFormat.getYLabelFormat().setShowYTitle(true);
        }
        JCAxis jCAxis = this.getChartArea().getXAxis(0);
        JCAxis jCAxis2 = this.getChartArea().getYAxis(0);
        jCAxis.setMin((double)this.graphStartTime);
        jCAxis.setMax((double)this.graphEndTime);
        this.setupYAxis(this.graphFormat.getYAxisFormat(), jCAxis2);
        this.update();
        this.setBatched(false);
    }

    public void showGraphAxes() {
        if (this.getChartArea().getYAxis(0).isVisible()) {
            this.getChartArea().getYAxis(0).setVisible(false);
            this.getChartArea().getXAxis(0).setVisible(false);
            this.graphFormat.setShowGraphAxes(false);
        } else {
            this.getChartArea().getYAxis(0).setVisible(true);
            this.getChartArea().getXAxis(0).setVisible(true);
            this.graphFormat.setShowGraphAxes(true);
        }
        this.update();
    }

    public void showGraphFooter() {
        if (this.getFooter().isVisible()) {
            this.getFooter().setVisible(false);
            this.graphFormat.getFooterFormat().setShowFooter(false);
        } else {
            this.getFooter().setVisible(true);
            this.graphFormat.getFooterFormat().setShowFooter(true);
        }
        this.update();
    }

    public void showGraphGrids() {
        JCAxis jCAxis = this.getChartArea().getXAxis(0);
        JCAxis jCAxis2 = this.getChartArea().getYAxis(0);
        if (jCAxis2.isGridVisible()) {
            jCAxis2.setGridVisible(false);
            jCAxis.setGridVisible(false);
            this.graphFormat.setShowGraphGrids(false);
        } else {
            jCAxis2.setGridVisible(true);
            jCAxis.setGridVisible(true);
            this.graphFormat.setShowGraphGrids(true);
        }
        this.update();
    }

    public void showGraphHeader() {
        if (this.getHeader().isVisible()) {
            this.getHeader().setVisible(false);
            this.graphFormat.getHeaderFormat().setShowHeader(false);
        } else {
            this.getHeader().setVisible(true);
            this.graphFormat.getHeaderFormat().setShowHeader(true);
        }
        this.update();
    }

    public void showGraphLegend() {
        if (this.getLegend().isVisible()) {
            this.getLegend().setVisible(false);
            this.graphFormat.getLegendFormat().setShowLegend(false);
        } else {
            this.getLegend().setVisible(true);
            this.graphFormat.getLegendFormat().setShowLegend(true);
        }
        this.update();
    }

    public void shutdown() {
        UcDDL.logDebugMessage((String)"stopping all graph threads .... ");
        int n = 0;
        while (n < this.lineInfo.size()) {
            CvGraphLineInfo cvGraphLineInfo = (CvGraphLineInfo)this.lineInfo.elementAt(n);
            if (cvGraphLineInfo.getRequesterThread() != null) {
                cvGraphLineInfo.getRequesterThread().stop();
            }
            ++n;
        }
        this.lineInfo.removeAllElements();
        this.graphModel.removeAllData();
        this.graphModel.removeSeriesLabels();
        this.graphFormat.removeAllLines();
    }

    public void switchDataState() {
        if (this.liveData) {
            int n = 0;
            while (n < this.lineInfo.size()) {
                CvGraphLineInfo cvGraphLineInfo = (CvGraphLineInfo)this.lineInfo.elementAt(n);
                CvGraphThread cvGraphThread = cvGraphLineInfo.getRequesterThread();
                if (cvGraphThread != null) {
                    cvGraphThread.suspend();
                }
                ++n;
            }
            this.liveData = false;
        } else {
            int n = 0;
            while (n < this.lineInfo.size()) {
                CvGraphLineInfo cvGraphLineInfo = (CvGraphLineInfo)this.lineInfo.elementAt(n);
                CvGraphThread cvGraphThread = cvGraphLineInfo.getRequesterThread();
                if (cvGraphThread != null) {
                    cvGraphThread.resume();
                }
                ++n;
            }
            this.liveData = true;
        }
        this.graphFormat.setDataState(this.liveData);
    }

    private boolean zoomOrTranslated() {
        return (double)this.graphStartTime != this.getXMinValue() || (double)this.graphEndTime != this.getXMaxValue();
    }

    public void checkForTimeout(SMAPIException sMAPIException) {
        if (sMAPIException.getReasonCode() == 4) {
            this.origDataSource.launchTimeoutNotification("cfgserver");
        }
    }

    public int getBorderType() {
        return this.graphBorderType;
    }

    public int getChartAreaBorderType() {
        return this.chartAreaBorderType;
    }

    public Border getBorder(String string) {
        if (string.equals("none")) {
            return new EmptyBorder(0, 0, 0, 0);
        }
        if (string.equals("plain")) {
            return new LineBorder(Color.lightGray);
        }
        if (string.equals("etchedin")) {
            return new EtchedBorder(1);
        }
        if (string.equals("etchedout")) {
            return new EtchedBorder(0);
        }
        if (string.equals("in")) {
            return new BevelBorder(1);
        }
        if (string.equals("out")) {
            return new BevelBorder(0);
        }
        return new EmptyBorder(0, 0, 0, 0);
    }
}

