/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.tools.editor;

import com.sun.symon.base.console.tools.editor.CommonTimex;
import com.sun.symon.base.console.tools.editor.CtArrowsCombo;
import com.sun.symon.base.console.tools.editor.CtMarginPanel;
import com.sun.symon.base.console.tools.editor.CtTimexEditor;
import com.sun.symon.base.console.tools.editor.RootPanel;
import com.sun.symon.base.console.tools.editor.TimeAndDate;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class AbsoluteTimex
extends CommonTimex
implements PropertyChangeListener {
    private CtArrowsCombo timeCombo;
    private CtArrowsCombo dateCombo;
    private RootPanel center = new RootPanel(new Insets(5, 15, 5, 5));
    private CtMarginPanel bottom = new CtMarginPanel(new Insets(8, 5, 2, 5));
    private CtMarginPanel top = new CtMarginPanel(new Insets(5, 5, 5, 5));
    private JLabel text = new JLabel("");
    private TimeAndDate basic;

    public AbsoluteTimex(String[] stringArray) {
        this.basic = new TimeAndDate(stringArray);
        this.setLayout(new BorderLayout());
        this.add("North", this.top);
        this.add("Center", this.center);
        this.add("South", this.bottom);
        CtTimexEditor.addTimezoneInfo(this.top, stringArray);
        this.timeCombo = this.basic.getTimeCombo();
        this.dateCombo = this.basic.getDateCombo();
        this.timeCombo.addPropertyChangeListener(this);
        this.dateCombo.addPropertyChangeListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.center.setLayout(gridBagLayout);
        this.addAnother(this.center, gridBagLayout, gridBagConstraints, this.timeCombo, this.dateCombo);
        this.center.setBorder(BorderFactory.createTitledBorder(UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:absolutetitle")));
        this.text.setFont(new JTextField("").getFont());
        this.text.setForeground(Color.black);
        this.bottom.setLayout(new BorderLayout());
        this.bottom.add("West", new JLabel(UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:currentSE") + "   "));
        this.bottom.add("Center", this.text);
    }

    void addAnother(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, JComponent jComponent, JComponent jComponent2) {
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.center.add(jComponent);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
        this.center.add(jComponent2);
    }

    public int checkTimex() {
        if (!this.basic.isValidDate()) {
            return -2;
        }
        if (this.basic.oldTime()) {
            return -1;
        }
        return 1;
    }

    public void setErrorMesg(String string) {
        this.text.setText(string);
        this.text.invalidate();
        this.text.validate();
        this.text.repaint();
        this.validate();
        this.repaint();
    }

    public String getCurrentText() {
        return this.text.getText();
    }

    public String getCurrentTimex() {
        if (this.dateCombo != null && this.timeCombo != null) {
            return "Date = " + this.basic.getEnglishDate() + " " + this.timeCombo.getComboValue();
        }
        return "";
    }

    public Insets getInsets() {
        return new Insets(15, 15, 15, 15);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.text.setText(this.getCurrentTimex());
    }
}

