/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.modules;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMManagedEntityRequest;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.attribute.SMAttributeEntryData;
import com.sun.symon.base.client.console.SMUrlContext;
import com.sun.symon.base.client.module.SMModuleAlarmInfo;
import com.sun.symon.base.client.module.SMModuleRequest;
import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.utility.UcCommon;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class CmRuleDialog
extends JDialog
implements ListSelectionListener,
Runnable {
    static final String CLOSE = "close";
    static final String ATTRIBUTE_NAME = "attributeName";
    static final String RULE_NAME = "ruleName";
    static final String CRITICAL = "critical";
    static final String ALERT = "alert";
    static final String CAUTION = "caution";
    static final String DETAIL = "detail";
    static final String DESCRIPTION = "description";
    static final String THRESHOLDS = "thresholds";
    static final String HELP = "help";
    static final String TITLE = "title";
    static final String THRESHOLD_NAME = "thresholdName";
    static final String THRESHOLD_VALUE = "thresholdValue";
    static final String RULE = "Rule";
    static final String PARAM_DESC = "paramDesc";
    static final String NORULE = "noRule";
    static final String ALARMS = "Alarms";
    static final String RULE_DESC = "ruledesc";
    private SMRawDataRequest req;
    private String modUrl;
    private String moduleKey;
    private SMModuleAlarmInfo[] ruleInfo;
    private JLabel statusLabel;
    private JButton closeBtn;
    private JButton helpBtn;
    private JTable pageTable;
    private JTable thresTable;
    private int selectRule;
    private Vector ruleVector;
    private JTextArea descArea;
    private JTextArea pDescArea;

    private String translate(String string) {
        return UcInternationalizer.translateKey((String)("com.sun.symon.base.console.modules.ModuleBundle:" + string));
    }

    private String translate(String string, Object[] objectArray) {
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.applyPattern(this.translate(string));
        return messageFormat.format(objectArray);
    }

    public CmRuleDialog(SMRawDataRequest sMRawDataRequest, String string, String string2) {
        this(sMRawDataRequest, string, string2, null, null);
    }

    public CmRuleDialog(SMRawDataRequest sMRawDataRequest, String string, String string2, String string3, SMModuleAlarmInfo[] sMModuleAlarmInfoArray) {
        this.setTitle(this.translate(TITLE) + " " + string);
        this.getAccessibleContext().setAccessibleDescription(this.translate(TITLE) + string);
        this.req = sMRawDataRequest;
        this.modUrl = string2;
        this.ruleInfo = sMModuleAlarmInfoArray;
        this.moduleKey = new String(string3);
        int n = this.moduleKey.indexOf(":");
        if (n < 0) {
            n = this.moduleKey.length();
        }
        this.moduleKey = this.moduleKey.substring(0, n);
        this.start();
    }

    public void start() {
        new Thread((Runnable)this, "getRule").start();
    }

    public void run() {
        this.ruleVector = new Vector();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(new EmptyBorder(17, 17, 17, 17));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), BorderFactory.createTitledBorder(this.translate(RULE))));
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        Container container = this.getContentPane();
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setAlignmentY(0.0f);
        jPanel3.setBorder(new EmptyBorder(0, 8, 8, 6));
        this.pageTable = new JTable(new PageTableModel(this));
        this.pageTable.setSelectionMode(0);
        this.pageTable.getSelectionModel().addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.pageTable);
        jScrollPane.setPreferredSize(new Dimension(300, 200));
        jScrollPane.setAlignmentX(0.0f);
        jPanel3.add(jScrollPane);
        jPanel2.add(jPanel3);
        this.pageTable.setBackground(UcCommon.getLightGrayColor());
        TableColumnModel tableColumnModel = this.pageTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(120);
        tableColumnModel.getColumn(1).setPreferredWidth(20);
        tableColumnModel.getColumn(2).setPreferredWidth(5);
        tableColumnModel.getColumn(3).setPreferredWidth(5);
        tableColumnModel.getColumn(4).setPreferredWidth(5);
        jPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.setAlignmentY(0.0f);
        jPanel4.setBorder(new EmptyBorder(0, 8, 8, 6));
        JLabel jLabel = new JLabel(this.translate(DESCRIPTION));
        jLabel.setAlignmentX(0.0f);
        jPanel4.add(jLabel);
        this.descArea = new JTextArea(3, 60);
        this.descArea.setLineWrap(true);
        this.descArea.setWrapStyleWord(true);
        this.descArea.setEditable(false);
        JScrollPane jScrollPane2 = new JScrollPane(this.descArea);
        jScrollPane2.setVerticalScrollBarPolicy(20);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setAlignmentX(0.0f);
        jPanel4.add(jScrollPane2);
        jPanel2.add(jPanel4);
        this.descArea.setBackground(jPanel4.getBackground());
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), BorderFactory.createTitledBorder(this.translate(DETAIL))));
        jPanel5.setLayout(new GridLayout(1, 2));
        jPanel5.setAlignmentX(0.0f);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel6.setAlignmentY(0.0f);
        jPanel6.setBorder(new EmptyBorder(0, 6, 8, 8));
        JLabel jLabel2 = new JLabel(this.translate(THRESHOLDS));
        jLabel2.setAlignmentX(0.0f);
        jPanel6.add(jLabel2);
        this.thresTable = new JTable(new thresTableModel(this));
        this.thresTable.setRowSelectionAllowed(false);
        JScrollPane jScrollPane3 = new JScrollPane(this.thresTable);
        jScrollPane3.setPreferredSize(new Dimension(80, 40));
        jScrollPane3.setAlignmentX(0.0f);
        jPanel6.add(jScrollPane3);
        this.thresTable.setBackground(jPanel6.getBackground());
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 1));
        jPanel7.setAlignmentY(0.0f);
        jPanel7.setBorder(new EmptyBorder(0, 6, 8, 8));
        JLabel jLabel3 = new JLabel(this.translate(PARAM_DESC));
        jLabel3.setAlignmentX(0.0f);
        jPanel7.add(jLabel3);
        this.pDescArea = new JTextArea(5, 30);
        this.pDescArea.setLineWrap(true);
        this.pDescArea.setWrapStyleWord(true);
        this.pDescArea.setEditable(false);
        JScrollPane jScrollPane4 = new JScrollPane(this.pDescArea);
        jScrollPane4.setVerticalScrollBarPolicy(20);
        jScrollPane4.setHorizontalScrollBarPolicy(31);
        jScrollPane4.setAlignmentX(0.0f);
        jPanel7.add(jScrollPane4);
        this.pDescArea.setBackground(jPanel7.getBackground());
        jPanel5.add(jPanel6);
        jPanel5.add(jPanel7);
        jPanel.add(jPanel5);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 0));
        jPanel8.setAlignmentX(0.0f);
        jPanel8.setBorder(new EmptyBorder(17, 17, 17, 17));
        jPanel8.add(Box.createHorizontalGlue());
        this.closeBtn = new JButton(this.translate(CLOSE));
        jPanel8.add(this.closeBtn);
        this.closeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)CmRuleDialog.this).setVisible(false);
            }
        });
        jPanel8.add(Box.createRigidArea(new Dimension(10, 0)));
        this.helpBtn = new JButton(this.translate(HELP));
        this.helpBtn.setMnemonic(this.translate("help.mnemonic").charAt(0));
        jPanel8.add(this.helpBtn);
        this.helpBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = "details-module-rule-help";
                CmConsoleSession cmConsoleSession = CmConsoleSession.getInstance();
                cmConsoleSession.launchHelp(string);
            }
        });
        this.statusLabel = new JLabel("");
        this.statusLabel.setBorder(new EmptyBorder(0, 17, 17, 0));
        container.setLayout(new BoxLayout(container, 1));
        container.add(jPanel);
        container.add(new JSeparator());
        container.add(jPanel8);
        container.add(this.statusLabel);
        this.setContentPane(container);
        this.pack();
        ((Component)this).setVisible(true);
        this.getRootPane().setDefaultButton(this.closeBtn);
        if (this.pageTable.getModel().getRowCount() == 0) {
            Toolkit.getDefaultToolkit().beep();
            this.statusLabel.setText(this.translate(NORULE));
        }
    }

    private Object[][] getAttribute() {
        this.ruleVector.clear();
        if (this.ruleInfo == null) {
            return null;
        }
        int n = Array.getLength(this.ruleInfo);
        if (n == 0) {
            return null;
        }
        Object[][] objectArray = new Object[n][5];
        int n2 = 0;
        while (n2 < n) {
            String string = this.ruleInfo[n2].getTargetUrl();
            int n3 = string.indexOf(35);
            objectArray[n2][0] = n3 == -1 ? this.ruleInfo[n2].getDescription() : this.ruleInfo[n2].getDescription() + " (" + string.substring(n3 + 1, string.length()) + ")";
            objectArray[n2][1] = this.ruleInfo[n2].getRuleName();
            String string2 = this.ruleInfo[n2].getCritical();
            objectArray[n2][2] = string2 == null || string2.length() == 0 ? "-" : string2;
            string2 = this.ruleInfo[n2].getAlert();
            objectArray[n2][3] = string2 == null || string2.length() == 0 ? "-" : string2;
            string2 = this.ruleInfo[n2].getCaution();
            objectArray[n2][4] = string2 == null || string2.length() == 0 ? "-" : string2;
            RuleTableRow ruleTableRow = new RuleTableRow((String)objectArray[n2][0], (String)objectArray[n2][1], (String)objectArray[n2][2], (String)objectArray[n2][3], (String)objectArray[n2][4], this.ruleInfo[n2].getTargetUrl());
            this.ruleVector.add(ruleTableRow);
            ++n2;
        }
        return objectArray;
    }

    private Object[][] getThreshold() {
        Object[][] objectArray = null;
        if (this.ruleVector == null || this.ruleVector.size() == 0) {
            return objectArray;
        }
        RuleTableRow ruleTableRow = (RuleTableRow)this.ruleVector.elementAt(this.selectRule);
        if (ruleTableRow.ruleName.equals("rCompare")) {
            return objectArray;
        }
        SMModuleRequest sMModuleRequest = new SMModuleRequest(this.req);
        SMUrlContext sMUrlContext = new SMUrlContext(this.modUrl);
        String string = new String(this.moduleKey + ":editAtt." + ruleTableRow.ruleName + ".");
        try {
            String[][] stringArray = sMModuleRequest.getRuleParamsValue(ruleTableRow.targetUrl);
            objectArray = new Object[stringArray.length][2];
            int n = 0;
            while (n < stringArray.length) {
                objectArray[n][0] = UcInternationalizer.translateKey((String)(string + stringArray[n][0]));
                objectArray[n][1] = stringArray[n][1];
                ++n;
            }
        }
        catch (SMAPIException sMAPIException) {
            System.out.println(sMAPIException.getMessage());
            UcDDL.logErrorMessage((String)"Failed to get thresholds.");
        }
        return objectArray;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (listSelectionModel == this.pageTable.getSelectionModel()) {
            String string;
            Object object;
            this.selectRule = listSelectionModel.getMinSelectionIndex();
            RuleTableRow ruleTableRow = (RuleTableRow)this.ruleVector.elementAt(this.selectRule);
            SMUrlContext sMUrlContext = new SMUrlContext(this.modUrl);
            String string2 = null;
            if (ruleTableRow.ruleName.equals("rCompare")) {
                string2 = new String("base.console.ConsoleGeneric:editAtt.rCompare");
                this.pDescArea.setText("");
            } else {
                object = null;
                object = new String(this.moduleKey + ":editAtt." + ruleTableRow.ruleName);
                string = UcInternationalizer.translateKey((String)((String)object + ".desc"));
                if (string.startsWith((String)object)) {
                    SMManagedEntityRequest sMManagedEntityRequest = null;
                    sMManagedEntityRequest = new SMManagedEntityRequest(this.req);
                    try {
                        SMAttributeEntryData[] sMAttributeEntryDataArray = sMManagedEntityRequest.getAttributeEntries(this.ruleInfo[this.selectRule].getTargetUrl(), ALARMS);
                        int n = 0;
                        while (n < sMAttributeEntryDataArray.length) {
                            if (sMAttributeEntryDataArray[n].getKey().equals(RULE_DESC)) {
                                String string3 = new String(sMAttributeEntryDataArray[n].getValue());
                                int n2 = string3.lastIndexOf(".");
                                string2 = new String(string3.substring(0, n2));
                                break;
                            }
                            ++n;
                        }
                    }
                    catch (Exception exception) {
                        System.out.println(exception.getMessage());
                        UcDDL.logErrorMessage((String)"CmRuleDiag: Failed to get attribute.");
                    }
                }
                if (string2 == null) {
                    string2 = new String(this.moduleKey + ":editAtt." + ruleTableRow.ruleName);
                }
                if ((string = UcInternationalizer.translateKey((String)(string2 + ".paramsdesc"))).startsWith(string2)) {
                    this.pDescArea.setText("");
                } else {
                    this.pDescArea.setText(string);
                }
                this.pDescArea.setCaretPosition(0);
            }
            string = UcInternationalizer.translateKey((String)(string2 + ".desc"));
            if (string.startsWith(string2)) {
                this.descArea.setText("");
            } else {
                this.descArea.setText(string);
            }
            this.descArea.setCaretPosition(0);
            object = (thresTableModel)this.thresTable.getModel();
            ((thresTableModel)object).setNewData(this.getThreshold());
            ((AbstractTableModel)object).fireTableChanged(new TableModelEvent((TableModel)object));
        }
    }

    private class RuleTableRow {
        public String medDesc;
        public String ruleName;
        public String criticalValue;
        public String alertValue;
        public String cautionValue;
        public String targetUrl;

        public RuleTableRow(String string, String string2, String string3, String string4, String string5, String string6) {
            this.medDesc = string;
            this.ruleName = string2;
            this.criticalValue = string3;
            this.alertValue = string4;
            this.cautionValue = string5;
            this.targetUrl = string6;
        }
    }

    class thresTableModel
    extends AbstractTableModel {
        String[] columnNames;
        Object[][] data;

        public thresTableModel(CmRuleDialog cmRuleDialog2) {
            this.columnNames = new String[]{CmRuleDialog.this.translate(CmRuleDialog.THRESHOLD_NAME), CmRuleDialog.this.translate(CmRuleDialog.THRESHOLD_VALUE)};
            this.data = null;
            this.data = cmRuleDialog2.getThreshold();
        }

        void setNewData(Object[][] objectArray) {
            this.data = objectArray;
            this.fireTableChanged(new TableModelEvent(this));
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data == null ? 0 : this.data.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    class PageTableModel
    extends AbstractTableModel {
        String[] columnNames;
        Object[][] data;

        public PageTableModel(CmRuleDialog cmRuleDialog2) {
            this.columnNames = new String[]{CmRuleDialog.this.translate(CmRuleDialog.ATTRIBUTE_NAME), CmRuleDialog.this.translate(CmRuleDialog.RULE_NAME), CmRuleDialog.this.translate(CmRuleDialog.CRITICAL), CmRuleDialog.this.translate(CmRuleDialog.ALERT), CmRuleDialog.this.translate(CmRuleDialog.CAUTION)};
            this.data = null;
            this.data = cmRuleDialog2.getAttribute();
        }

        void setNewData(Object[][] objectArray) {
            this.data = objectArray;
            this.fireTableChanged(new TableModelEvent(this));
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data == null ? 0 : this.data.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

