/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.manager;

import com.sun.symon.apps.generic.help.SMHelpBrowser;
import com.sun.symon.base.bootstrap.BsRMIClassLoader;
import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMManagedEntityRequest;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRowStatusRequest;
import com.sun.symon.base.client.alarm.SMAlarmStatusRequest;
import com.sun.symon.base.client.console.SMConsoleContext;
import com.sun.symon.base.client.console.SMModApp;
import com.sun.symon.base.client.console.SMUrlContext;
import com.sun.symon.base.client.module.SMModuleRequest;
import com.sun.symon.base.client.service.SMHandleRegistry;
import com.sun.symon.base.client.topology.SMFamilyCommands;
import com.sun.symon.base.client.topology.SMUserDomainData;
import com.sun.symon.base.client.topology.SMUserDomainRequest;
import com.sun.symon.base.console.awx.AwxComponent;
import com.sun.symon.base.console.awx.AwxLayoutDialog;
import com.sun.symon.base.console.awx.AwxLayoutFrame;
import com.sun.symon.base.console.awx.AwxObject;
import com.sun.symon.base.console.manager.CmModuleController;
import com.sun.symon.base.console.manager.CmNavigatorConsole;
import com.sun.symon.base.console.manager.CmTableRowController;
import com.sun.symon.base.console.manager.CmTopologyPath;
import com.sun.symon.base.console.manager.CmWindowLoader;
import com.sun.symon.base.console.services.client.CsClientAPIStub;
import com.sun.symon.base.server.receptors.rmi.RMIClientLevel1;
import com.sun.symon.base.utility.UcAgentURL;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcListUtil;
import com.sun.symon.base.xobject.XObjectBase;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class CmConsoleSession
extends XObjectBase {
    private int ConsoleIndex = 1;
    private int FrameIndex = 1;
    private int DialogIndex = 1;
    private static int PathIndex = 1;
    private Hashtable UniqueWindows = new Hashtable();
    private static Hashtable PathTable = new Hashtable();
    private Object nullObj = new Object();
    private CsClientAPIStub ClientStub = null;
    private static CmConsoleSession session = null;
    private CmNavigatorConsole awxNavigatorFrame = null;

    public CmConsoleSession() {
        session = this;
    }

    public static CmConsoleSession getInstance() {
        return session;
    }

    public JFrame getMainWindowFrame() {
        JFrame jFrame = null;
        if (this.awxNavigatorFrame != null) {
            jFrame = (JFrame)this.awxNavigatorFrame.getBean();
        }
        return jFrame;
    }

    public void launchHelp(String string) {
        SMHelpBrowser sMHelpBrowser = (SMHelpBrowser)((AwxObject)session.locate("~helpmanager", true)).getBean();
        sMHelpBrowser.init(string);
    }

    public String getConsoleParameter(String string) {
        String string2 = null;
        if (this.awxNavigatorFrame != null) {
            string2 = this.awxNavigatorFrame.getConsoleParameter(string);
        }
        return string2;
    }

    public void setConsoleParameter(String string, String string2) {
        if (this.awxNavigatorFrame != null) {
            this.awxNavigatorFrame.setConsoleParameter(string, string2);
        }
    }

    public void navigateToPathByName(String string, String string2) {
        if (this.awxNavigatorFrame != null) {
            this.awxNavigatorFrame.navigateToPathByName(string, string2);
        }
    }

    public Frame getWindowFromId(String string) {
        if (string == null) {
            return null;
        }
        try {
            AwxComponent awxComponent = (AwxComponent)this.locate(string, true);
            if (awxComponent instanceof AwxLayoutFrame) {
                return (Frame)((AwxLayoutFrame)awxComponent).getBean();
            }
            if (awxComponent instanceof AwxLayoutDialog) {
                AwxComponent awxComponent2 = (AwxLayoutDialog)awxComponent;
                while (awxComponent2 instanceof AwxLayoutDialog) {
                    String string2 = awxComponent2.getConsoleParameter("parentWindowID");
                    awxComponent2 = (AwxComponent)awxComponent2.locate(string2, true);
                }
                return (Frame)((AwxLayoutFrame)awxComponent2).getBean();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void closeWindow(String string) {
        XObjectBase xObjectBase = this.locate(string, true);
        if (xObjectBase == null) {
            UcDDL.logErrorMessage((String)("Invalid window close request " + string));
            return;
        }
        String string2 = xObjectBase.name();
        if (string2.length() > 8 && string2.substring(0, 8).compareTo("console-") == 0) {
            int n = 0;
            int n2 = 0;
            while (n2 < this.inferiors().size()) {
                XObjectBase xObjectBase2 = (XObjectBase)this.inferiors().elementAt(n2);
                String string3 = xObjectBase2.name();
                if (string3.length() > 8 && string3.substring(0, 8).compareTo("console-") == 0) {
                    ++n;
                }
                ++n2;
            }
            if (n == 1) {
                this.queryExit(string);
                return;
            }
        }
        try {
            CmConsoleSession cmConsoleSession = this;
            synchronized (cmConsoleSession) {
                String string4 = xObjectBase.lookup("internal", "uniqueWindowKey", null);
                if (string4 != null) {
                    this.UniqueWindows.remove(string4);
                }
            }
            xObjectBase.recursiveDestruct();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            UcDDL.logErrorMessage((String)("Unexpected error closing " + string));
        }
    }

    public void closeWindow(String[] stringArray) {
        if (stringArray.length != 0) {
            this.closeWindow(stringArray[0]);
        }
    }

    public AwxLayoutDialog createDialogInstance(String string, boolean bl) {
        Object object;
        AwxComponent awxComponent = null;
        Frame frame = null;
        try {
            awxComponent = (AwxComponent)this.locate(string, true);
            object = awxComponent;
            while (object instanceof AwxLayoutDialog) {
                string = ((AwxObject)object).getConsoleParameter("parentWindowID");
                object = (AwxComponent)object.locate(string, true);
                if (!bl) continue;
                awxComponent = object;
                bl = false;
            }
            frame = (Frame)((AwxLayoutFrame)object).getBean();
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)("Invalid parent frame for dialog create " + string));
            return null;
        }
        if (frame == null) {
            UcDDL.logErrorMessage((String)("Unrealized parent frame for dialog create " + string));
            return null;
        }
        CmConsoleSession cmConsoleSession = this;
        synchronized (cmConsoleSession) {
            object = "dialog-" + this.DialogIndex++;
        }
        AwxLayoutDialog awxLayoutDialog = new AwxLayoutDialog((XObjectBase)awxComponent, (String)object, null, frame);
        awxLayoutDialog.setConsoleParameter("windowID", awxLayoutDialog.fullName());
        awxLayoutDialog.setConsoleParameter("parentWindowID", awxComponent.fullName());
        return awxLayoutDialog;
    }

    public AwxLayoutFrame createFrameInstance() {
        String string;
        CmConsoleSession cmConsoleSession = this;
        synchronized (cmConsoleSession) {
            string = "frame-" + this.FrameIndex++;
        }
        AwxLayoutFrame awxLayoutFrame = new AwxLayoutFrame(this, string, null);
        awxLayoutFrame.setConsoleParameter("windowID", awxLayoutFrame.fullName());
        return awxLayoutFrame;
    }

    public void createNavigationalConsole(String string, String string2, boolean bl) {
        String string3;
        CmConsoleSession cmConsoleSession = this;
        synchronized (cmConsoleSession) {
            string3 = "console-" + this.ConsoleIndex++;
        }
        this.awxNavigatorFrame = new CmNavigatorConsole(this, string3);
        this.awxNavigatorFrame.setConsoleParameter("windowID", this.awxNavigatorFrame.fullName());
        this.awxNavigatorFrame.setInitialDomainInfo(string, string2, bl);
        this.awxNavigatorFrame.initConsole();
    }

    public void domainDeleted(String string) {
        Vector vector = this.inferiors();
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (e instanceof CmNavigatorConsole) {
                ((CmNavigatorConsole)e).domainDeleted(string);
            }
            ++n;
        }
    }

    public void exitSession() {
        SMHandleRegistry.closeAll();
        this.ClientStub.getClientAPIInstance().disconnect();
        System.exit(0);
    }

    public void launchDialog(String[] stringArray) {
        this.launchDialog(stringArray, false);
    }

    public void launchDialogOnParent(String[] stringArray) {
        this.launchDialog(stringArray, true);
    }

    private void launchDialog(String[] stringArray, boolean bl) {
        if (stringArray.length < 2) {
            UcDDL.logErrorMessage((String)"Insufficient arguments for launchDialog.");
            return;
        }
        String string = stringArray[0];
        AwxLayoutDialog awxLayoutDialog = this.createDialogInstance(string, bl);
        if (awxLayoutDialog == null) {
            return;
        }
        CmWindowLoader cmWindowLoader = new CmWindowLoader(this, awxLayoutDialog, stringArray, null);
        Thread thread = new Thread((Runnable)cmWindowLoader, "window-loader");
        thread.start();
    }

    public void launchApp(String[] stringArray) {
        if (stringArray.length < 2) {
            UcDDL.logErrorMessage((String)"Insufficient arguments for launching application.");
            return;
        }
        String string = stringArray[0];
        AwxComponent awxComponent = (AwxComponent)this.locate(string, true);
        if (awxComponent == null) {
            UcDDL.logErrorMessage((String)"cannot resolve %_self for launchApp command");
            return;
        }
        String[] stringArray2 = null;
        stringArray2 = new String[stringArray.length - 2];
        int n = 2;
        while (n < stringArray.length) {
            stringArray2[n - 2] = stringArray[n];
            ++n;
        }
        try {
            Object object;
            Object object2;
            BsRMIClassLoader bsRMIClassLoader = BsRMIClassLoader.getClassLoader((RMIClientLevel1)SMConsoleContext.getInstance().getAPIHandle().getHandle());
            Class clazz = bsRMIClassLoader.loadClass(stringArray[1], true);
            boolean bl = false;
            try {
                object2 = clazz.newInstance();
                if (object2 instanceof SMModApp) {
                    object = (SMModApp)object2;
                    object.setRawDataRequestHandle(SMConsoleContext.getInstance().getAPIHandle());
                    object.setAgentPort(Integer.parseInt(awxComponent.getConsoleParameter("agentPort")));
                    object.setAgentHost(awxComponent.getConsoleParameter("agentHost"));
                    object.setAgentName(awxComponent.getConsoleParameter("nodeName"));
                    object.setUrlContext(new SMUrlContext(awxComponent.getConsoleParameter("targetUrl")));
                    object.setArguments(stringArray2);
                    object.init();
                } else {
                    bl = true;
                }
            }
            catch (Exception exception) {
                bl = true;
            }
            if (bl) {
                try {
                    object2 = new Class[]{stringArray2.getClass()};
                    object = clazz.getDeclaredMethod("main", (Class<?>)object2);
                    Object[] objectArray = new Object[]{stringArray2};
                    ((Method)object).invoke((Object)clazz, objectArray);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)("could not load class:" + exception.getMessage()));
        }
    }

    public void launchFrame(String[] stringArray) {
        if (stringArray.length < 2) {
            UcDDL.logErrorMessage((String)"Insufficient arguments for launchFrame.");
            return;
        }
        AwxLayoutFrame awxLayoutFrame = this.createFrameInstance();
        if (awxLayoutFrame == null) {
            return;
        }
        CmWindowLoader cmWindowLoader = new CmWindowLoader(this, awxLayoutFrame, stringArray, null);
        Thread thread = new Thread((Runnable)cmWindowLoader, "window-loader");
        thread.start();
    }

    public void launchUniqueDialog(String[] stringArray) {
        this.launchUniqueDialog(stringArray, false, null);
    }

    public void launchUniqueDialog(JFrame jFrame, String[] stringArray) {
        this.launchUniqueDialog(stringArray, false, jFrame);
    }

    public void launchUniqueDialogOnParent(String[] stringArray) {
        this.launchUniqueDialog(stringArray, true, null);
    }

    private void launchUniqueDialog(String[] stringArray, boolean bl, JFrame jFrame) {
        Object object;
        Object object2;
        if (stringArray.length < 2) {
            UcDDL.logErrorMessage((String)"Insufficient arguments for launchDialog.");
            return;
        }
        String string = stringArray[0];
        if (bl) {
            object2 = null;
            try {
                object2 = (AwxComponent)this.locate(string, true);
                if (object2 instanceof AwxLayoutDialog && (string = ((AwxObject)object2).getConsoleParameter("parentWindowID")) == null) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                UcDDL.logErrorMessage((String)("Invalid parent frame for dialog create " + string));
                return;
            }
        }
        object2 = new StringBuffer("dialog");
        ((StringBuffer)object2).append(":");
        ((StringBuffer)object2).append(string);
        int n = 1;
        while (n < stringArray.length) {
            if (stringArray[n].charAt(0) != '!') {
                ((StringBuffer)object2).append(":");
                ((StringBuffer)object2).append(stringArray[n]);
            }
            ++n;
        }
        UcDDL.logDebugMessage((String)("Unique dialog key " + object2));
        String string2 = ((StringBuffer)object2).toString();
        try {
            object = this;
            synchronized (object) {
                if (this.UniqueWindows.containsKey(string2)) {
                    Object v = this.UniqueWindows.get(string2);
                    if (v != this.nullObj) {
                        AwxComponent awxComponent = (AwxComponent)v;
                        ((Window)awxComponent.getBean()).show();
                        int n2 = 2;
                        while (n2 < stringArray.length) {
                            String string3 = stringArray[n2];
                            if (string3.charAt(0) == '!') {
                                int n3 = string3.indexOf(61);
                                if (n3 < 0) {
                                    UcDDL.logErrorMessage((String)("Invalid window parameter " + string3));
                                } else {
                                    String string4 = string3.substring(1, n3);
                                    String string5 = "";
                                    if (n3 < string3.length() - 1) {
                                        string5 = string3.substring(n3 + 1);
                                    }
                                    awxComponent.setConsoleParameter(string4, string5);
                                }
                            }
                            ++n2;
                        }
                        awxComponent.triggerService("reshow");
                    }
                    AwxObject.triggerService(this, stringArray[0], "launchComplete", null);
                    return;
                }
                this.UniqueWindows.put(string2, this.nullObj);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            UcDDL.logErrorMessage((String)"Error re-opening unique dialog instance.");
        }
        object = stringArray[0];
        AwxLayoutDialog awxLayoutDialog = this.createDialogInstance((String)object, bl);
        if (awxLayoutDialog == null) {
            this.UniqueWindows.remove(string2);
            return;
        }
        awxLayoutDialog.define("internal", "uniqueWindowKey", string2);
        CmWindowLoader cmWindowLoader = null;
        cmWindowLoader = jFrame == null ? new CmWindowLoader(this, awxLayoutDialog, stringArray, string2) : new CmWindowLoader(this, awxLayoutDialog, stringArray, string2, jFrame);
        Thread thread = new Thread((Runnable)cmWindowLoader, "window-loader");
        thread.start();
    }

    public void launchUniqueFrame(String[] stringArray) {
        Object object;
        if (stringArray.length < 2) {
            UcDDL.logErrorMessage((String)"Insufficient arguments for launchUniqueFrame.");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("frame");
        int n = 1;
        while (n < stringArray.length) {
            if (stringArray[n].charAt(0) != '!') {
                stringBuffer.append(":");
                stringBuffer.append(stringArray[n]);
            }
            ++n;
        }
        UcDDL.logDebugMessage((String)("Unique frame key " + stringBuffer));
        String string = stringBuffer.toString();
        try {
            object = this;
            synchronized (object) {
                if (this.UniqueWindows.containsKey(string)) {
                    AwxComponent awxComponent = (AwxComponent)this.UniqueWindows.get(string);
                    if (awxComponent != this.nullObj) {
                        if (awxComponent instanceof AwxLayoutFrame && ((AwxLayoutFrame)awxComponent).getIsIconic()) {
                            ((Frame)awxComponent.getBean()).setState(0);
                        }
                        ((Window)awxComponent.getBean()).show();
                        int n2 = 2;
                        while (n2 < stringArray.length) {
                            String string2 = stringArray[n2];
                            if (string2.charAt(0) == '!') {
                                int n3 = string2.indexOf(61);
                                if (n3 < 0) {
                                    UcDDL.logErrorMessage((String)("Invalid window parameter " + string2));
                                } else {
                                    String string3 = string2.substring(1, n3);
                                    String string4 = "";
                                    if (n3 < string2.length() - 1) {
                                        string4 = string2.substring(n3 + 1);
                                    }
                                    awxComponent.setConsoleParameter(string3, string4);
                                }
                            }
                            ++n2;
                        }
                        awxComponent.triggerService("reshow");
                    }
                    AwxObject.triggerService(this, stringArray[0], "launchComplete", null);
                    return;
                }
                this.UniqueWindows.put(string, this.nullObj);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            UcDDL.logErrorMessage((String)"Error re-opening unique frame instance.");
        }
        object = this.createFrameInstance();
        if (object == null) {
            this.UniqueWindows.remove(string);
            return;
        }
        object.define("internal", "uniqueWindowKey", string);
        CmWindowLoader cmWindowLoader = new CmWindowLoader(this, (AwxComponent)object, stringArray, string);
        Thread thread = new Thread((Runnable)cmWindowLoader, "window-loader");
        thread.start();
    }

    public static String pathRegister(String string, CmTopologyPath cmTopologyPath) {
        if (string == null) {
            string = "path-" + PathIndex++;
        }
        PathTable.put(string, cmTopologyPath);
        return string;
    }

    public static void pathRemove(String string) {
        PathTable.remove(string);
    }

    public static CmTopologyPath pathRetrieve(String string, boolean bl) {
        CmTopologyPath cmTopologyPath = (CmTopologyPath)PathTable.get(string);
        if (bl && cmTopologyPath != null) {
            PathTable.remove(string);
        }
        return cmTopologyPath;
    }

    public void postInitialize() {
        try {
            this.ClientStub = (CsClientAPIStub)this.locate(".services.client", false);
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"CmConsoleSession: Error obtaining client API stub.");
        }
        SMAlarmStatusRequest.initializeStatusDetails((SMRawDataRequest)this.ClientStub.getClientAPIInstance());
    }

    public void postActivate() {
        SMUserDomainData sMUserDomainData = null;
        SMUserDomainData[] sMUserDomainDataArray = null;
        this.postInitialize();
        SMUserDomainRequest sMUserDomainRequest = new SMUserDomainRequest(this.ClientStub.getClientAPIInstance());
        int n = 0;
        while (true) {
            try {
                sMUserDomainData = sMUserDomainRequest.getDefaultDomainInfo();
                sMUserDomainDataArray = sMUserDomainRequest.getAllConfiguredDomains();
            }
            catch (SMAPIException sMAPIException) {
                if (++n <= 2) continue;
                String string = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:standard.serverNotReady");
                if (UcDialog.showOkCancel((String)string) != 0) {
                    System.exit(1);
                }
                n = 0;
                continue;
            }
            break;
        }
        if (sMUserDomainDataArray == null || sMUserDomainDataArray.length == 0) {
            this.createNavigationalConsole(null, null, true);
        } else if (sMUserDomainData == null) {
            this.createNavigationalConsole(null, null, false);
        } else {
            this.createNavigationalConsole(sMUserDomainData.getDomainName(), sMUserDomainData.getDomainRootUrl(), false);
        }
    }

    public void printWindow(String string) {
        AwxLayoutFrame awxLayoutFrame = null;
        Frame frame = null;
        try {
            awxLayoutFrame = (AwxLayoutFrame)this.locate(string, true);
            frame = (Frame)awxLayoutFrame.getBean();
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)("Invalid frame for printing " + string));
            return;
        }
        if (frame == null) {
            UcDDL.logErrorMessage((String)("Unrealized frame for printing " + string));
            return;
        }
        String string2 = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:standard.print.title");
        PrintJob printJob = frame.getToolkit().getPrintJob(frame, string2, null);
        if (printJob != null) {
            Graphics graphics = printJob.getGraphics();
            if (graphics != null) {
                frame.printAll(graphics);
                graphics.dispose();
            }
            printJob.end();
        }
    }

    public void probeview(String[] stringArray) {
        if (stringArray.length < 2) {
            UcDDL.logErrorMessage((String)"No window/probe target URL specified.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray[1].substring(0, 7).equals("snmp://")) {
            int n = 2;
            while (n < stringArray.length) {
                UcListUtil.appendElement((StringBuffer)stringBuffer, (String)stringArray[n]);
                ++n;
            }
            String string = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:probe.title");
            String[] stringArray2 = new String[]{stringArray[0], ".templates.tools.probeView", "probeName=" + string, "probeUrl=" + stringArray[1], "probeArgs=" + stringBuffer.toString()};
            this.launchUniqueFrame(stringArray2);
        } else if (stringArray.length >= 3) {
            int n = 3;
            while (n < stringArray.length) {
                UcListUtil.appendElement((StringBuffer)stringBuffer, (String)stringArray[n]);
                ++n;
            }
            String string = UcInternationalizer.translateKey((String)stringArray[1]);
            String[] stringArray3 = new String[]{stringArray[0], ".templates.tools.probeView", "probeName=" + string, "probeUrl=" + stringArray[2], "probeArgs=" + stringBuffer.toString()};
            this.launchUniqueFrame(stringArray3);
        }
    }

    public static void processFamilyExclusions(AwxComponent awxComponent, SMFamilyCommands sMFamilyCommands) {
        Vector vector = awxComponent.inferiors();
        int n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n) instanceof AwxComponent) {
                Object object;
                AwxComponent awxComponent2 = (AwxComponent)vector.elementAt(n);
                CmConsoleSession.processFamilyExclusions(awxComponent2, sMFamilyCommands);
                String string = awxComponent2.lookup("exclusion", "type", "");
                if (string.equals("byFamily") && (object = awxComponent2.getBean()) != null) {
                    String string2 = null;
                    if (object instanceof AbstractButton) {
                        string2 = ((AbstractButton)object).getText();
                    }
                    if (string2 == null || sMFamilyCommands == null) {
                        if (object instanceof Component) {
                            ((Component)object).setEnabled(false);
                        }
                    } else {
                        String[] stringArray;
                        String string3 = null;
                        String[] stringArray2 = sMFamilyCommands.getLocalCommandLabels();
                        if (stringArray2 != null) {
                            int n2 = 0;
                            while (n2 < stringArray2.length) {
                                if (string2.equals(stringArray2[n2])) {
                                    string3 = sMFamilyCommands.getLocalCommandSpecs()[n2];
                                    break;
                                }
                                ++n2;
                            }
                        }
                        if ((stringArray = sMFamilyCommands.getGlobalCommandLabels()) != null && string3 == null) {
                            int n3 = 0;
                            while (n3 < stringArray.length) {
                                if (string2.equals(stringArray[n3])) {
                                    string3 = sMFamilyCommands.getGlobalCommandSpecs()[n3];
                                    break;
                                }
                                ++n3;
                            }
                        }
                        if (string3 == null) {
                            ((Component)object).setEnabled(false);
                        } else {
                            ((Component)object).setEnabled(true);
                            String string4 = awxComponent2.lookup("exclusion", "cmdInfo", null);
                            if (string4 != null) {
                                String string5 = "value";
                                String string6 = string4;
                                int n4 = string4.indexOf(":");
                                if (n4 >= 0) {
                                    string5 = string4.substring(0, n4);
                                    string6 = string4.substring(n4 + 1);
                                }
                                awxComponent2.define(string5, string6, string3);
                            }
                        }
                    }
                }
            }
            ++n;
        }
    }

    public static void processContextExclusions(AwxComponent awxComponent, String string) {
        Vector vector = awxComponent.inferiors();
        int n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n) instanceof AwxComponent) {
                String string2;
                Object object;
                AwxComponent awxComponent2 = (AwxComponent)vector.elementAt(n);
                CmConsoleSession.processContextExclusions(awxComponent2, string);
                String string3 = awxComponent2.lookup("exclusion", "type", "");
                if (string3.equals("byContext") && (object = awxComponent2.getBean()) != null && object instanceof Component && (string2 = awxComponent2.lookup("exclusion", "contextInfo", null)) != null) {
                    boolean bl = true;
                    if (string == null) {
                        string = "";
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    while (stringTokenizer.hasMoreTokens()) {
                        String string4 = stringTokenizer.nextToken();
                        if (string4.charAt(0) != '!') continue;
                        string4 = string4.substring(1);
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string2);
                        while (stringTokenizer2.hasMoreTokens()) {
                            if (!stringTokenizer2.nextToken().equals(string4)) continue;
                            bl = false;
                        }
                    }
                    ((Component)object).setEnabled(bl);
                }
            }
            ++n;
        }
    }

    public void queryExit(String string) {
        AwxComponent awxComponent = (AwxComponent)this.locate(string, true);
        if (awxComponent != null && awxComponent instanceof AwxLayoutFrame && ((AwxLayoutFrame)awxComponent).getIsIconic()) {
            ((Frame)awxComponent.getBean()).setState(0);
        }
        String[] stringArray = new String[]{string, ".templates.tools.exitsession"};
        this.launchUniqueDialog(stringArray);
    }

    private void recursiveUIUpdate(XObjectBase xObjectBase) {
        Object object;
        if (xObjectBase instanceof AwxComponent && (object = (AwxComponent)xObjectBase).getBean() != null && object.getBean() instanceof JComponent) {
            Component component = (Component)object.getBean();
            SwingUtilities.updateComponentTreeUI(component);
            component.validate();
        }
        object = xObjectBase.inferiors();
        int n = 0;
        while (n < ((Vector)object).size()) {
            this.recursiveUIUpdate((XObjectBase)((Vector)object).elementAt(n));
            ++n;
        }
    }

    public void refreshUrlValue(String string, String string2) {
        final SMManagedEntityRequest sMManagedEntityRequest = new SMManagedEntityRequest(this.ClientStub.getClientAPIInstance());
        final String string3 = string;
        final String string4 = string2;
        final CmConsoleSession cmConsoleSession = this;
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    AwxObject.triggerService(cmConsoleSession, string3, "busyStart", null);
                    sMManagedEntityRequest.sendRefreshRequest(string4);
                    AwxObject.triggerService(cmConsoleSession, string3, "busyEnd", null);
                    String[] stringArray = new String[]{"base.console.ConsoleMessages:refresh.success"};
                    AwxObject.triggerService(cmConsoleSession, string3, "message", stringArray);
                }
                catch (Exception exception) {
                    AwxObject.triggerService(cmConsoleSession, string3, "busyEnd", null);
                    UcDDL.logErrorMessage((String)("Unable to refresh value for " + string4));
                    String[] stringArray = new String[]{"base.console.ConsoleMessages:refresh.fail"};
                    AwxObject.triggerService(cmConsoleSession, string3, "messageBell", stringArray);
                }
            }
        };
        new Thread(runnable).start();
    }

    public synchronized void registerKeyedWindow(String string, AwxComponent awxComponent) {
        if (awxComponent != null) {
            if (this.UniqueWindows.containsKey(string)) {
                this.UniqueWindows.put(string, awxComponent);
            }
        } else {
            this.UniqueWindows.remove(string);
        }
    }

    public void requestModuleOperation(String string, String string2, String string3, String string4) {
        AwxComponent awxComponent = (AwxComponent)this.locate(string, true);
        if (awxComponent == null) {
            UcDDL.logErrorMessage((String)("Invalid parent window specification " + string));
            return;
        }
        int n = 0;
        if (string3.compareTo("enable") == 0) {
            n = 2;
        } else if (string3.compareTo("disable") == 0) {
            n = 1;
        } else if (string3.compareTo("unload") == 0) {
            n = 3;
        } else {
            UcDDL.logErrorMessage((String)("Invalid module operation " + string3));
            return;
        }
        SMModuleRequest sMModuleRequest = new SMModuleRequest(this.ClientStub.getClientAPIInstance());
        CmModuleController cmModuleController = new CmModuleController(awxComponent, string2, n, sMModuleRequest, string4);
        Thread thread = new Thread((Runnable)cmModuleController, "module-control");
        thread.start();
    }

    public void requestTableRowOperation(String string, String string2, String string3) {
        AwxComponent awxComponent = (AwxComponent)this.locate(string, true);
        if (awxComponent == null) {
            UcDDL.logErrorMessage((String)("Invalid parent window specification " + string));
            return;
        }
        int n = 0;
        if (string3.compareTo("enable") == 0) {
            n = 2;
        } else if (string3.compareTo("disable") == 0) {
            n = 1;
        } else if (string3.compareTo("unload") == 0) {
            n = 3;
        } else {
            UcDDL.logErrorMessage((String)("Invalid table row operation " + string3));
            return;
        }
        UcAgentURL ucAgentURL = new UcAgentURL(string2);
        String string4 = ucAgentURL.getFragmentValue();
        String string5 = ucAgentURL.getScheme() + "://" + ucAgentURL.getHost() + ":" + ucAgentURL.getPort() + "/" + ucAgentURL.getSubPath();
        int n2 = string5.lastIndexOf("#");
        if (n2 >= 0) {
            string5 = string5.substring(0, n2);
        }
        n2 = string5.lastIndexOf("/");
        String string6 = "";
        if (n2 >= 0) {
            string6 = string5.substring(n2);
            string5 = string5.substring(0, n2);
        }
        SMRowStatusRequest sMRowStatusRequest = new SMRowStatusRequest(this.ClientStub.getClientAPIInstance());
        CmTableRowController cmTableRowController = new CmTableRowController(awxComponent, string5, string6, string4, n, sMRowStatusRequest);
        Thread thread = new Thread((Runnable)cmTableRowController, "row-control");
        thread.start();
    }

    public void setLookAndFeel(String string) {
        try {
            UIManager.setLookAndFeel(string);
            this.recursiveUIUpdate(this);
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)("Error updating look and feel to " + string));
        }
    }

    public void soundBell(String[] stringArray) {
        Toolkit.getDefaultToolkit().beep();
    }

    public static boolean isInRemoteServerContext(String string, String string2) {
        SMRawDataRequest sMRawDataRequest = SMConsoleContext.getInstance().getAPIHandle();
        int n = Integer.parseInt(string2);
        try {
            if (sMRawDataRequest.isInServerContext(string, n)) {
                return false;
            }
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)("Error in isInRemoteServerContext: " + exception));
            return false;
        }
        return true;
    }
}

