/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.main;

import com.sun.symon.base.console.main.ConsoleLoginController;
import com.sun.symon.base.utility.UcInternationalizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.util.StringTokenizer;

class SymonConsoleAutomaticLogin
extends ConsoleLoginController {
    protected String configFilename;

    public SymonConsoleAutomaticLogin(String string, String string2, String string3) {
        this.publicKey = string2;
        this.baseXFile = string3;
        this.configFilename = string;
        ConsoleLoginController.isAutomatedLogin = true;
        this.initLoginParameters();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean initLoginParameters() {
        String string;
        Object object;
        File file = new File(this.configFilename);
        if (!file.exists()) {
            System.err.println(UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:no_such_file", (boolean)true));
            System.err.println(UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:aborting_automated_login", (boolean)true));
            System.exit(1);
        }
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
        }
        catch (Exception exception) {
            object = UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:ioerror_configfile", (boolean)true);
            object = (String)object + "\n" + UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:aborting_automated_login", (boolean)true);
            System.err.println((String)object);
            System.exit(1);
        }
        try {
            string = null;
            while ((string = bufferedReader.readLine()) != null) {
                object = new StringTokenizer(string, ":");
                if (((StringTokenizer)object).countTokens() <= 1 && ((StringTokenizer)(object = new StringTokenizer(string, "="))).countTokens() <= 1) continue;
                while (((StringTokenizer)object).hasMoreElements()) {
                    String string2 = ((StringTokenizer)object).nextToken().trim();
                    if (string2.equalsIgnoreCase("username")) {
                        this.loginID = ((StringTokenizer)object).nextToken().trim();
                        continue;
                    }
                    if (string2.equalsIgnoreCase("password")) {
                        this.password = ((StringTokenizer)object).nextToken().trim();
                        continue;
                    }
                    if (string2.equalsIgnoreCase("serverport")) {
                        try {
                            this.hostPort = Integer.parseInt(((StringTokenizer)object).nextToken().trim());
                        }
                        catch (Exception exception) {
                            this.hostPort = ConsoleLoginController.DEFAULT_PORT;
                        }
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("serverhost")) continue;
                    this.hostName = ((StringTokenizer)object).nextToken().trim();
                }
            }
        }
        catch (IOException iOException) {
            object = UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:ioerror_configfile", (boolean)true);
            object = (String)object + "\n" + UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:aborting_automated_login", (boolean)true);
            System.err.println((String)object);
            System.exit(1);
        }
        if (this.hostName == null) {
            string = UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:badhost", (boolean)true);
            string = string + "\n" + UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:aborting_automated_login", (boolean)true);
            System.err.println(string);
            System.exit(1);
        } else {
            try {
                InetAddress.getByName(this.hostName);
            }
            catch (Exception exception) {
                object = UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:badhost", (boolean)true);
                object = (String)object + "\n" + UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:aborting_automated_login", (boolean)true);
                System.err.println((String)object);
                System.exit(1);
            }
        }
        if (this.hostPort > 65535 || this.hostPort < 1024) {
            string = UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:badport", (boolean)true);
            string = string + "\n" + UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:using_default_port", (boolean)true);
            System.err.println(string);
            this.hostPort = ConsoleLoginController.DEFAULT_PORT;
        }
        if (this.password == null) {
            string = UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:needpw", (boolean)true);
            string = string + "\n" + UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:aborting_automated_login", (boolean)true);
            System.err.println(string);
            System.exit(1);
        }
        if (this.loginID == null) {
            string = UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:needid", (boolean)true);
            string = string + "\n" + UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:aborting_automated_login", (boolean)true);
            System.err.println(string);
            System.exit(1);
        }
        return true;
    }
}

