/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.main;

import com.sun.symon.base.bootstrap.BsRMIBootstrap;
import com.sun.symon.base.bootstrap.BsRMIBootstrapException;
import com.sun.symon.base.console.main.ConsoleLoginRunner;
import com.sun.symon.base.utility.UcInternationalizer;
import java.io.Serializable;
import javax.swing.JFrame;

public class ConsoleLoginController
implements Serializable {
    public static int DEFAULT_PORT = 2099;
    public static String DEFAULT_PORT_STRING = "" + DEFAULT_PORT;
    protected int hostPort = DEFAULT_PORT;
    protected String hostName;
    String password;
    String loginID;
    protected static boolean isAutomatedLogin = false;
    protected String publicKey;
    protected String baseXFile;
    protected String securityScheme = "medium";
    protected boolean wantEncryption = false;
    protected BootstrapThread bst;
    protected Exception e;
    protected JFrame frame;

    public ConsoleLoginController() {
    }

    public ConsoleLoginController(String string, String string2, String string3, int n) {
        this.loginID = string;
        this.password = string2;
        this.hostName = string3;
        this.hostPort = n > 0 ? n : DEFAULT_PORT;
    }

    public ConsoleLoginController(String string, String string2, String string3, String string4) {
        this.loginID = string;
        this.password = string2;
        this.hostName = string3;
        try {
            this.hostPort = Integer.parseInt(string4);
        }
        catch (Exception exception) {
            this.hostPort = DEFAULT_PORT;
        }
    }

    public ConsoleLoginController(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
        this.loginID = string;
        this.password = string2;
        this.hostName = string3;
        try {
            this.hostPort = Integer.parseInt(string4);
        }
        catch (Exception exception) {
            this.hostPort = DEFAULT_PORT;
        }
        this.publicKey = string6;
        this.securityScheme = string5;
        this.wantEncryption = bl;
    }

    public void setTopFrame(JFrame jFrame) {
        this.frame = jFrame;
    }

    protected boolean loginBootstrapOK() {
        this.bst = new BootstrapThread(this.hostName, this.hostPort);
        int n = 20;
        int n2 = 0;
        while (!this.bst.isDone() && n2 < n) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        if (!this.bst.isDone()) {
            this.e = this.bst.getException();
            return false;
        }
        this.e = this.bst.getException();
        return true;
    }

    protected void doLogin() {
        ConsoleLoginRunner consoleLoginRunner = new ConsoleLoginRunner(this);
        consoleLoginRunner.start();
    }

    protected Exception getLoginException() {
        return this.e;
    }

    protected String getLoginStatusMessage(Exception exception) {
        String string = null;
        switch (((BsRMIBootstrapException)((Object)exception)).getReason()) {
            case 1: {
                string = "remoteex";
                break;
            }
            case 2: {
                string = "registryex";
                break;
            }
            case 3: {
                string = "unboundex";
                break;
            }
            case 4: {
                string = "invalidurlex";
                break;
            }
            case 5: {
                string = "unexpectedex(" + exception.getMessage() + ")";
                break;
            }
            case 17: {
                string = "sessionlimitex";
                break;
            }
            case 6: {
                string = "rejectex";
                break;
            }
            case 7: {
                string = "unknownex";
                break;
            }
            case 8: {
                string = "logerrorex";
                break;
            }
            case 12: {
                string = "nosecurityex";
                break;
            }
            case 13: {
                string = "logtimeoutex";
                break;
            }
            case 14: {
                string = "loginvaliduser";
                break;
            }
            case 16: {
                string = "loginvalidpassword";
                break;
            }
            case 15: {
                string = "logunknownuser";
                break;
            }
            case 9: {
                string = "classex";
                break;
            }
            case 10: {
                string = "initex";
                break;
            }
            case 11: {
                string = "bootex";
            }
        }
        String string2 = ((BsRMIBootstrapException)((Object)exception)).getReason() == 2 ? UcInternationalizer.translateKey((String)("base.console.main.ConsoleLogin:" + string), (boolean)true) + " " + this.hostPort : UcInternationalizer.translateKey((String)("base.console.main.ConsoleLogin:" + string), (boolean)true);
        return string2;
    }

    protected boolean checkPort() {
        String string = String.valueOf(this.hostPort);
        if (string.length() == 0) {
            this.hostPort = DEFAULT_PORT;
        }
        try {
            this.hostPort = Integer.parseInt(string);
        }
        catch (Exception exception) {
            return false;
        }
        return this.hostPort >= 0 && this.hostPort <= 65535;
    }

    protected String getLoginID() {
        return this.loginID;
    }

    protected String getPassword() {
        return this.password;
    }

    protected String getServerHost() {
        return this.hostName;
    }

    protected String getBaseXFile() {
        return this.baseXFile;
    }

    protected String getSecurityScheme() {
        return this.securityScheme;
    }

    protected boolean getEncryption() {
        return this.wantEncryption;
    }

    protected String getPublicKey() {
        return this.publicKey;
    }

    protected BsRMIBootstrap getBootstrap() {
        return this.bst.getBootstrap();
    }

    public boolean isAutomaticLogin() {
        return isAutomatedLogin;
    }

    class BootstrapThread
    extends Thread {
        private BsRMIBootstrap boot_;
        private String host_;
        private int port_;
        private Exception exception_ = null;
        private boolean isDone_ = false;

        public BootstrapThread(String string, int n) {
            this.host_ = string;
            this.port_ = n;
            this.start();
        }

        public void run() {
            try {
                this.boot_ = new BsRMIBootstrap(this.host_, this.port_);
            }
            catch (Exception exception) {
                this.exception_ = exception;
            }
            this.isDone_ = true;
        }

        public boolean isDone() {
            return this.isDone_;
        }

        public Exception getException() {
            return this.exception_;
        }

        public BsRMIBootstrap getBootstrap() {
            return this.boot_;
        }
    }
}

