/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping.aggregate;

import com.sun.symon.base.client.SMManagedEntityRequest;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.service.SMLengthException;
import com.sun.symon.base.client.table.SMTableEntryData;
import com.sun.symon.base.client.task.SMTaskOperationData;
import com.sun.symon.base.console.didgets.CdPropValueEditorPane;
import com.sun.symon.base.console.grouping.CgUtility;
import com.sun.symon.base.console.grouping.aggregate.CgTblHeaderRenderer;
import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.utility.UcAgentURL;
import com.sun.symon.base.utility.UcDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class CgUpdateRowChooser
extends JDialog {
    private final String ADD_ROW_OPERATION = "add_row";
    private final String MODIFY_ROW_OPERATION = "modify_row";
    private final String DELETE_ROW_OPERATION = "delete_row";
    private SMTaskOperationData[] ops_;
    private SMManagedEntityRequest entReq_;
    private SMRawDataRequest req_;
    private JTable table_;
    private UpdateRowTableModel tableModel_;
    private JButton okBut_;
    private JButton cancelBut_;
    private JButton helpBut_;
    private JLabel moduleInstance_;
    private JLabel reqLabel_;
    private String action_ = "add_row";
    private boolean ok_ = false;

    public CgUpdateRowChooser(Frame frame, SMTaskOperationData[] sMTaskOperationDataArray, SMRawDataRequest sMRawDataRequest) {
        super(frame, true);
        this.ops_ = sMTaskOperationDataArray;
        this.req_ = sMRawDataRequest;
        if (this.ops_ == null || this.ops_.length == 0) {
            UcDialog.showError((Component)this, (Object)CgUtility.getI18nMsg("table.incompleteData"));
            this.dispose();
            return;
        }
        this.action_ = this.ops_[0].getOperation();
        this.createGUI();
        this.pack();
        ((Component)this).setSize(380, 300);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((int)(dimension.getWidth() - (double)this.getWidth()) / 2, (int)(dimension.getHeight() - (double)this.getHeight()) / 2);
        this.entReq_ = new SMManagedEntityRequest(this.req_);
        this.load();
        ((Component)this).setVisible(true);
    }

    private void load() {
        Thread thread = new Thread(){

            public void run() {
                CgUpdateRowChooser.this.tableModel_.populate();
            }
        };
        thread.start();
    }

    private String rowActionToKey(String string) {
        if (string.equals("add_row")) {
            return "table.addRow";
        }
        if (string.equals("modify_row")) {
            return "table.editRow";
        }
        if (string.equals("delete_row")) {
            return "table.deleteRow";
        }
        return string;
    }

    private void cancel() {
        this.dispose();
    }

    public void createGUI() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(new EmptyBorder(17, 17, 17, 17));
        jPanel.setAlignmentX(0.0f);
        this.tableModel_ = new UpdateRowTableModel(this.ops_);
        this.table_ = new JTable(this.tableModel_);
        this.tableModel_.setTable(this.table_);
        this.reqLabel_ = new JLabel("*  " + CgUtility.getI18nMsg("table.requireValue") + " ", 2);
        this.reqLabel_.setFont(this.reqLabel_.getFont().deriveFont(0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)new JScrollPane(this.table_), "Center");
        jPanel2.add((Component)this.reqLabel_, "South");
        jPanel.add(jPanel2);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel jPanel3 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel3.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(CgUtility.getI18nMsg("table.moduleInstance") + ":", 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel3.add(jLabel);
        this.moduleInstance_ = new JLabel();
        this.moduleInstance_.setForeground(Color.black);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 5.0;
        gridBagLayout.setConstraints(this.moduleInstance_, gridBagConstraints);
        jPanel3.add(this.moduleInstance_);
        jPanel.add(jPanel3);
        jPanel.add(Box.createRigidArea(new Dimension(0, 12)));
        JPanel jPanel4 = new JPanel();
        GridLayout gridLayout = new GridLayout();
        gridLayout.setRows(1);
        gridLayout.setColumns(5);
        gridLayout.setHgap(5);
        gridLayout.setVgap(5);
        jPanel4.setLayout(gridLayout);
        this.okBut_ = new JButton(CgUtility.getI18nMsg("message.ok"));
        this.getRootPane().setDefaultButton(this.okBut_);
        this.okBut_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgUpdateRowChooser.this.setCurrentEditingCell();
                boolean bl = CgUpdateRowChooser.this.tableModel_.isAllReqRowsHaveValues();
                boolean bl2 = true;
                if (!bl) {
                    UcDialog.showError((Component)CgUpdateRowChooser.this, (Object)CgUtility.getI18nMsg("table.noValueMsg"));
                    bl2 = false;
                }
                if (bl) {
                    CgUpdateRowChooser.this.tableModel_.createRowOperation();
                }
                CgUpdateRowChooser.this.ok_ = true;
                if (bl2) {
                    CgUpdateRowChooser.this.dispose();
                }
            }
        });
        this.cancelBut_ = new JButton(CgUtility.getI18nMsg("message.cancel"));
        this.cancelBut_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgUpdateRowChooser.this.cancel();
            }
        });
        this.cancelBut_.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgUpdateRowChooser.this.cancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.table_.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgUpdateRowChooser.this.cancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 0);
        this.helpBut_ = new JButton(CgUtility.getI18nMsg("standard.help"));
        this.helpBut_.setMnemonic(CgUtility.getMnemonic("standard.help"));
        this.helpBut_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CmConsoleSession.getInstance().launchHelp("grouping-table-row-chooser-help");
            }
        });
        jPanel4.add(new JLabel(""));
        jPanel4.add(this.okBut_);
        jPanel4.add(this.cancelBut_);
        jPanel4.add(this.helpBut_);
        jPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        jPanel.add(jPanel4);
        this.getContentPane().add(jPanel);
        this.setTitle(CgUtility.getI18nMsg(this.rowActionToKey(this.action_)));
        this.getAccessibleContext().setAccessibleDescription(CgUtility.getI18nMsg("updateChooser.window.description"));
    }

    private void setCurrentEditingCell() {
        TableCellEditor tableCellEditor = this.table_.getColumnModel().getColumn(1).getCellEditor();
        tableCellEditor.stopCellEditing();
        tableCellEditor.getCellEditorValue();
    }

    public boolean isOK() {
        return this.ok_;
    }

    public SMTaskOperationData[] getRowOperation() {
        if (this.tableModel_ == null) {
            return new SMTaskOperationData[0];
        }
        return this.tableModel_.getRowOperation();
    }

    public Object getCurrentValueAt(int n, int n2) {
        return this.table_.getValueAt(n, n2);
    }

    class UpdateRowTableModel
    extends DefaultTableModel {
        private String[] columnNames_ = new String[]{CgUtility.getI18nMsg("table.propertyName"), CgUtility.getI18nMsg("table.propertyValue")};
        private SMTaskOperationData[] data_ = null;
        private JTable table_;
        private JTextField textField_;
        private Hashtable hashKey_;
        private SMTableEntryData[] editEnts_;

        public UpdateRowTableModel(SMTaskOperationData[] sMTaskOperationDataArray) {
            this.data_ = sMTaskOperationDataArray;
            this.hashKey_ = new Hashtable();
        }

        public void setTable(JTable jTable) {
            this.table_ = jTable;
        }

        public int getColumnCount() {
            return this.columnNames_.length;
        }

        public String getColumnName(int n) {
            return this.columnNames_[n];
        }

        public boolean isCellEditable(int n, int n2) {
            if (this.editEnts_ == null) {
                return false;
            }
            if (n2 == 0) {
                return false;
            }
            return n2 == 1 && (this.editEnts_[n].getAccess() || this.editEnts_[n].getColumnType() == 1);
        }

        private void setRenderers() {
            ModRowRenderer modRowRenderer = new ModRowRenderer();
            CgTblHeaderRenderer cgTblHeaderRenderer = new CgTblHeaderRenderer();
            int n = 0;
            while (n < this.table_.getColumnCount()) {
                TableColumn tableColumn = this.table_.getColumnModel().getColumn(n);
                if (n == 0) {
                    tableColumn.setCellRenderer(modRowRenderer);
                }
                tableColumn.setHeaderRenderer(cgTblHeaderRenderer);
                ++n;
            }
        }

        public void setEditors() {
            JTextField jTextField = new JTextField("");
            DefaultCellEditor defaultCellEditor = new DefaultCellEditor(this, jTextField){
                int editingRow_;
                int editingColumn_;
                private final /* synthetic */ UpdateRowTableModel this$1;
                {
                    this.this$1 = updateRowTableModel;
                }

                public Object getCellEditorValue() {
                    if (this.editingColumn_ == 1) {
                        UpdateRowTableModel.access$400(this.this$1).setValueAt(((JTextField)this.editorComponent).getText(), this.editingRow_, this.editingColumn_);
                    }
                    return ((JTextField)this.editorComponent).getText();
                }

                public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                    this.editingRow_ = n;
                    this.editingColumn_ = n2;
                    ((JTextField)this.editorComponent).setText(object.toString());
                    return this.editorComponent;
                }
            };
            defaultCellEditor.setClickCountToStart(1);
            TableColumn tableColumn = this.table_.getColumnModel().getColumn(1);
            tableColumn.setCellEditor(defaultCellEditor);
        }

        public boolean isAllReqRowsHaveValues() {
            if (CgUpdateRowChooser.this.action_.equals("modify_row") || CgUpdateRowChooser.this.action_.equals("delete_row")) {
                int n = 0;
                while (n < this.editEnts_.length) {
                    String string;
                    if (this.editEnts_[n].getColumnType() == 1 && ((string = (String)CgUpdateRowChooser.this.getCurrentValueAt(n, 1)) == null || string.trim().equals(""))) {
                        return false;
                    }
                    ++n;
                }
            } else {
                int n = 0;
                while (n < this.editEnts_.length) {
                    String string = (String)CgUpdateRowChooser.this.getCurrentValueAt(n, 1);
                    if (string == null || string.trim().equals("")) {
                        return false;
                    }
                    ++n;
                }
            }
            return true;
        }

        private String translateURL(String string, boolean bl) {
            String string2 = this.data_[0].getOperand();
            String string3 = CgUpdateRowChooser.this.req_.getMDRBaseURL();
            UcAgentURL ucAgentURL = new UcAgentURL(string3 + "/" + string2);
            String string4 = ucAgentURL.getMetaDataURL();
            if (bl) {
                CgUpdateRowChooser.this.moduleInstance_.setText(ucAgentURL.getInstance());
                return string4;
            }
            return "mod/" + ucAgentURL.getModuleId() + "+" + string + "/" + ucAgentURL.getManagedObject() + "/" + ucAgentURL.getProperty();
        }

        public void populate() {
            SMTableEntryData[] sMTableEntryDataArray;
            block20: {
                String string = this.translateURL("meta", true);
                try {
                    String string2 = string;
                    sMTableEntryDataArray = CgUpdateRowChooser.this.entReq_.getTableEntries(string2);
                    Vector<SMTableEntryData> vector = new Vector<SMTableEntryData>();
                    int n = 1;
                    while (n < sMTableEntryDataArray.length) {
                        if (CgUpdateRowChooser.this.action_.equals("delete_row")) {
                            if (sMTableEntryDataArray[n].getColumnType() == 1) {
                                vector.addElement(sMTableEntryDataArray[n]);
                            }
                        } else if (sMTableEntryDataArray[n].getAccess() || sMTableEntryDataArray[n].getRequired() || sMTableEntryDataArray[n].getColumnType() == 1) {
                            vector.addElement(sMTableEntryDataArray[n]);
                        }
                        ++n;
                    }
                    String string3 = this.data_[0].getUserData();
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                    Vector<String> vector2 = new Vector<String>();
                    while (stringTokenizer.hasMoreTokens()) {
                        vector2.addElement(stringTokenizer.nextToken());
                    }
                    int n2 = vector.size();
                    this.editEnts_ = new SMTableEntryData[n2];
                    int n3 = 0;
                    while (n3 < n2) {
                        this.editEnts_[n3] = (SMTableEntryData)vector.elementAt(n3);
                        ++n3;
                    }
                    int n4 = 0;
                    if (this.editEnts_ == null) break block20;
                    int n5 = 0;
                    while (n5 < this.editEnts_.length) {
                        if (this.editEnts_[n5].getColumnType() == 1) {
                            SMTaskOperationData sMTaskOperationData = new SMTaskOperationData();
                            try {
                                sMTaskOperationData.setOperand(this.editEnts_[n5].getKey());
                                if (n4 < vector2.size()) {
                                    sMTaskOperationData.setValue((String)vector2.elementAt(n4));
                                } else {
                                    sMTaskOperationData.setValue("");
                                }
                                ++n4;
                            }
                            catch (SMLengthException sMLengthException) {
                                UcDialog.showError((Object)sMLengthException.getMessage());
                            }
                            this.hashKey_.put(this.editEnts_[n5], sMTaskOperationData);
                        } else {
                            int n6 = 1;
                            while (n6 < this.data_.length - 1) {
                                String string4 = this.data_[n6].getOperand();
                                if (string4.startsWith("/")) {
                                    string4 = string4.substring(1);
                                }
                                if (this.editEnts_[n5].getKey().equals(string4) && !this.hashKey_.containsKey(this.editEnts_[n5])) {
                                    this.hashKey_.put(this.editEnts_[n5], this.data_[n6]);
                                    break;
                                }
                                ++n6;
                            }
                        }
                        ++n5;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    UcDialog.showError((Object)exception.getMessage());
                }
            }
            int n = this.editEnts_.length;
            sMTableEntryDataArray = new String[n][2];
            int n7 = 0;
            while (n7 < this.editEnts_.length) {
                SMTaskOperationData sMTaskOperationData = (SMTaskOperationData)this.hashKey_.get(this.editEnts_[n7]);
                sMTableEntryDataArray[n7][0] = this.editEnts_[n7].getDescId();
                sMTableEntryDataArray[n7][1] = sMTaskOperationData != null ? sMTaskOperationData.getValue() : "";
                ++n7;
            }
            Runnable runnable = new Runnable(this, (String[][])sMTableEntryDataArray){
                private final /* synthetic */ String[][] val$vals;
                private final /* synthetic */ UpdateRowTableModel this$1;
                {
                    this.this$1 = updateRowTableModel;
                    this.val$vals = stringArray;
                }

                public void run() {
                    UpdateRowTableModel.access$900(this.this$1, this.val$vals);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        private void setData(String[][] stringArray) {
            try {
                if (stringArray == null || stringArray[0] == null || stringArray[0].length != this.getColumnCount()) {
                    return;
                }
                this.setDataVector(stringArray, this.columnNames_);
                this.setRenderers();
                this.setEditors();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                UcDialog.showError((Object)exception.getMessage());
            }
        }

        public SMTaskOperationData[] getRowOperation() {
            return this.data_;
        }

        public void createRowOperation() {
            Object object;
            Object object2;
            String string = CgUpdateRowChooser.this.moduleInstance_.getText();
            try {
                this.data_[0].setOperation(CgUpdateRowChooser.this.action_);
                this.data_[0].setOperand("/" + this.translateURL(string, false));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                UcDialog.showError((Object)exception.getMessage());
            }
            Vector<SMTaskOperationData> vector = new Vector<SMTaskOperationData>();
            String string2 = "";
            int n = 0;
            while (n < this.editEnts_.length) {
                block14: {
                    block15: {
                        block13: {
                            SMTaskOperationData sMTaskOperationData;
                            object2 = (SMTaskOperationData)this.hashKey_.get(this.editEnts_[n]);
                            if (object2 != null) break block13;
                            object = (String)CgUpdateRowChooser.this.getCurrentValueAt(n, 1);
                            if (object == null || object == "") break block14;
                            object2 = sMTaskOperationData = new SMTaskOperationData();
                            try {
                                sMTaskOperationData.setOperand(this.editEnts_[n].getKey());
                                sMTaskOperationData.setValue((String)object);
                                sMTaskOperationData.setValueType(CdPropValueEditorPane.mapType(this.editEnts_[n].getType()));
                            }
                            catch (SMLengthException sMLengthException) {
                                UcDialog.showError((Object)sMLengthException.getMessage());
                            }
                            this.hashKey_.put(this.editEnts_[n], sMTaskOperationData);
                            break block15;
                        }
                        try {
                            object2.setValue((String)CgUpdateRowChooser.this.getCurrentValueAt(n, 1));
                            object2.setValueType(CdPropValueEditorPane.mapType(this.editEnts_[n].getType()));
                        }
                        catch (SMLengthException sMLengthException) {
                            UcDialog.showError((Object)sMLengthException.getMessage());
                        }
                    }
                    if (this.editEnts_[n].getColumnType() == 1) {
                        string2 = string2 + object2.getValue() + ",";
                    } else {
                        vector.addElement((SMTaskOperationData)object2);
                    }
                }
                ++n;
            }
            if (!string2.equals("")) {
                object2 = string2.substring(0, string2.length() - 1);
                try {
                    this.data_[0].setUserData((String)object2);
                }
                catch (SMLengthException sMLengthException) {
                    UcDialog.showError((Object)sMLengthException.getMessage());
                }
            }
            int n2 = vector.size();
            object = new SMTaskOperationData[n2 + 2];
            object[0] = this.data_[0];
            int n3 = 0;
            while (n3 < n2) {
                object[n3 + 1] = (SMTaskOperationData)vector.elementAt(n3);
                ++n3;
            }
            object[n2 + 1] = SMTaskOperationData.getEndOperation();
            this.data_ = object;
        }

        static /* synthetic */ JTable access$400(UpdateRowTableModel updateRowTableModel) {
            return updateRowTableModel.table_;
        }

        static /* synthetic */ void access$900(UpdateRowTableModel updateRowTableModel, String[][] stringArray) {
            updateRowTableModel.setData(stringArray);
        }

        class ModRowRenderer
        extends JLabel
        implements TableCellRenderer {
            JLabel label = new JLabel("");
            private Border focusBorder;
            private Border noFocusBorder;

            public ModRowRenderer() {
                this.label.setOpaque(true);
                this.focusBorder = BorderFactory.createLineBorder(new Color(102, 102, 153), 1);
                this.noFocusBorder = new EmptyBorder(1, 2, 1, 2);
            }

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (object != null) {
                    this.label.setText(object.toString());
                } else {
                    this.label.setText("");
                }
                if (n2 == 0) {
                    if (CgUpdateRowChooser.this.action_.equals("modify_row") || CgUpdateRowChooser.this.action_.equals("delete_row")) {
                        if (UpdateRowTableModel.this.editEnts_[n].getColumnType() == 1) {
                            this.label.setText(this.label.getText() + "*");
                        }
                    } else {
                        this.label.setText(this.label.getText() + "*");
                    }
                }
                this.label.setBackground(Color.white);
                this.label.setFont(this.label.getFont().deriveFont(0));
                return this.label;
            }
        }
    }
}

