/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping.aggregate;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.console.SMConsoleContext;
import com.sun.symon.base.client.service.SMDBChangeEvent;
import com.sun.symon.base.client.service.SMDBChangeListener;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMHandle;
import com.sun.symon.base.client.service.SMHandleRegistry;
import com.sun.symon.base.client.task.SMTaskRequestInfo;
import com.sun.symon.base.client.task.SMTaskRequestLog;
import com.sun.symon.base.client.task.SMTaskRequestLogInfo;
import com.sun.symon.base.client.task.SMTaskRequestLogListener;
import com.sun.symon.base.client.task.SMTaskRequestLogManager;
import com.sun.symon.base.console.grouping.CgGlassPane;
import com.sun.symon.base.console.grouping.CgUtility;
import com.sun.symon.base.console.grouping.aggregate.CgLogParser;
import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.console.views.table.CvBaseTable;
import com.sun.symon.base.console.views.table.CvBaseTableModel;
import com.sun.symon.base.utility.UcCommon;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

public class CgLogManager
extends JFrame
implements SMDBChangeListener,
SMTaskRequestLogManager {
    private final int TIME_COLUMN = 0;
    private TimeZone timeZone_;
    private static boolean testing_ = false;
    private CgLogParser parser;
    private SMTaskRequestInfo request_;
    private Vector rowInfo_;
    private CvBaseTableModel model_;
    private String[] colNames_ = new String[]{"time", "status"};
    private SMTaskRequestLog handle_;
    private String taskRequestName_;
    private boolean registerListeners_ = true;
    private String handleName_;
    JPanel mainPanel_ = new JPanel();
    BorderLayout mainBorderLayout_ = new BorderLayout();
    GridBagLayout mainGridBagLayout_ = new GridBagLayout();
    JPanel taskPanel_ = new JPanel();
    JLabel taskNameLabel_ = new JLabel();
    GridBagLayout taskGridBagLayout_ = new GridBagLayout();
    JLabel taskTypeVLabel_ = new JLabel();
    JLabel domainVLabel_ = new JLabel();
    JLabel taskNameVLabel_ = new JLabel();
    JLabel domainLabel_ = new JLabel();
    JLabel taskTypeLabel_ = new JLabel();
    JPanel schedulePanel_ = new JPanel();
    GridBagLayout scheduleGridBagLayout_ = new GridBagLayout();
    JLabel scheduleLabel_ = new JLabel();
    JScrollPane scheduleScrollPane_ = new JScrollPane();
    CvBaseTable scheduleTable_ = new CvBaseTable();
    JButton deleteButton_ = new JButton();
    JPanel detailsPanel_ = new JPanel();
    GridBagLayout detailsGridBagLayout_ = new GridBagLayout();
    JLabel userVLabel_ = new JLabel();
    JLabel durationVLabel_ = new JLabel();
    JLabel durationLabel_ = new JLabel();
    JLabel userLabel_ = new JLabel();
    JLabel scheduleDetailsLabel_ = new JLabel();
    JLabel agentDetailsLabel_ = new JLabel();
    JPanel operationPanel_ = new JPanel();
    JLabel operationDetailsLabel_ = new JLabel();
    JScrollPane detailsScrollPane_ = new JScrollPane();
    BorderLayout operationBorderLayout_ = new BorderLayout();
    JScrollPane operationScrollPane_ = new JScrollPane();
    JScrollPane descriptionScrollPane_ = new JScrollPane();
    JTextArea descriptionTextArea_ = new JTextArea();
    JLabel descriptionLabel_ = new JLabel();
    JEditorPane detailsEditorPane_ = new JEditorPane();
    JPanel bottomPane_ = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel statusLabel_ = new JLabel();
    GridLayout gridLayout1 = new GridLayout();
    JButton helpButton_ = new JButton();
    JButton closeButton_ = new JButton();
    JPanel butonPanel_ = new JPanel();
    Border border1;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$util$Date;

    public CgLogManager() {
        this(new SMTaskRequestInfo(null), true, "LM_TASK_REQUEST_LOG_1");
    }

    public CgLogManager(SMTaskRequestInfo sMTaskRequestInfo, boolean bl, String string) {
        this.handleName_ = string;
        testing_ = bl;
        this.request_ = sMTaskRequestInfo;
        this.setGlassPane(new CgGlassPane());
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.request_ != null) {
            this.taskRequestName_ = this.request_.getName();
            this.taskNameVLabel_.setText(this.request_.getTaskName());
            this.domainVLabel_.setText(CgLogManager.localize(this.request_.getDomain()));
        }
        this.scheduleTable_.setBackground(UcCommon.getLightGrayColor());
        this.descriptionTextArea_.setBackground(UcCommon.getLightGrayColor());
        this.detailsScrollPane_.setBackground(UcCommon.getLightGrayColor());
        this.detailsEditorPane_.setBackground(UcCommon.getLightGrayColor());
        this.localize();
        this.scheduleTable_.setSortable(true);
        this.scheduleTable_.setDefaultRenderer(class$java$lang$Integer == null ? (class$java$lang$Integer = CgLogManager.class$("java.lang.Integer")) : class$java$lang$Integer, new StatusCellRenderer());
        this.scheduleTable_.setDefaultRenderer(class$java$util$Date == null ? (class$java$util$Date = CgLogManager.class$("java.util.Date")) : class$java$util$Date, new TimeCellRenderer());
        this.model_ = new CvBaseTableModel(this.colNames_, new Vector());
        this.scheduleTable_.setModel(this.model_);
        this.scheduleTable_.getColumnModel().getColumn(0).setPreferredWidth(320);
        ListSelectionModel listSelectionModel = this.scheduleTable_.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (!listSelectionModel.isSelectionEmpty()) {
                    int n = listSelectionModel.getMinSelectionIndex();
                    CgLogManager.this.removeLogViewer();
                    if (CgLogManager.this.parser != null) {
                        CgLogManager.this.parser.cleanup();
                        CgLogManager.this.parser = null;
                    }
                    CgLogManager.this.showLogViewer(CgLogManager.this.model_.convertRowIndexToModel(n));
                }
            }
        });
        this.model_.setSortableColumn(this.scheduleTable_, 0, false);
        this.pack();
        ((Component)this).setSize(550, 695);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((int)(dimension.getWidth() - (double)this.getWidth()) / 2, (int)(dimension.getHeight() - (double)this.getHeight()) / 2);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CgLogManager.this.dispose();
            }
        });
        ((Frame)this).setIconImage(CgUtility.getSunMCImage());
        ((Component)this).setVisible(true);
        this.getRootPane().setDefaultButton(this.closeButton_);
        this.loadData();
    }

    public void dispose() {
        if (this.handle_ != null) {
            try {
                this.handle_.removeDBChangeListener((SMDBChangeListener)this);
                this.handle_.removeLogChangeListener((SMTaskRequestLogListener)this.parser);
                this.parser = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose();
    }

    private void localize() {
        this.setTitle(CgUtility.getI18nMsg("log.title"));
        this.closeButton_.setText(CgUtility.getI18nMsg("message.close"));
        this.helpButton_.setText(CgUtility.getI18nMsg("standard.help"));
        this.helpButton_.setMnemonic(CgUtility.getMnemonic("standard.help"));
        this.deleteButton_.setText(CgUtility.getI18nMsg("standard.delete"));
        this.deleteButton_.setMnemonic(CgUtility.getMnemonic("standard.delete"));
        this.descriptionLabel_.setText(CgUtility.getI18nMsg("message.description") + ":");
        this.taskNameLabel_.setText(CgUtility.getI18nMsg("task.message.taskName") + ":");
        this.domainLabel_.setText(CgUtility.getI18nMsg("standard.domain") + ":");
        this.taskTypeLabel_.setText(CgUtility.getI18nMsg("task.taskType") + ":");
        this.scheduleLabel_.setText(CgUtility.getI18nMsg("standard.schedule"));
        this.durationLabel_.setText(CgUtility.getI18nMsg("log.duration") + ":");
        this.userLabel_.setText(CgUtility.getI18nMsg("standard.user") + ":");
        this.scheduleDetailsLabel_.setText(CgUtility.getI18nMsg("log.scheduleDetails"));
        this.agentDetailsLabel_.setText(CgUtility.getI18nMsg("log.domainObjectStatus"));
        this.operationDetailsLabel_.setText(CgUtility.getI18nMsg("log.domainObjectStatusDetails"));
        this.colNames_ = new String[]{CgUtility.getI18nMsg("standard.time"), CgUtility.getI18nMsg("standard.status")};
        this.taskTypeVLabel_.setText("");
        this.getAccessibleContext().setAccessibleDescription(CgUtility.getI18nMsg("logManager.window.description"));
    }

    private static String localize(String string) {
        String string2 = CgUtility.getI18nMsg(string);
        if (string2.startsWith("base.") && string2.endsWith(".defaultdomain")) {
            string2 = UcInternationalizer.translateKey((String)("com.sun.symon." + string), (boolean)false);
        }
        return string2;
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(10, 10, 5, 5);
        this.getContentPane().setLayout(this.mainBorderLayout_);
        this.mainPanel_.setLayout(this.mainGridBagLayout_);
        this.taskNameLabel_.setText("taskName");
        this.taskPanel_.setLayout(this.taskGridBagLayout_);
        this.taskTypeVLabel_.setForeground(Color.black);
        this.taskTypeVLabel_.setText("taskTypeV");
        this.domainVLabel_.setForeground(Color.black);
        this.domainVLabel_.setText("domainV");
        this.taskNameVLabel_.setForeground(Color.black);
        this.taskNameVLabel_.setText("taskNameV");
        this.domainLabel_.setText("domain");
        this.taskTypeLabel_.setText("taskType");
        this.schedulePanel_.setLayout(this.scheduleGridBagLayout_);
        this.scheduleLabel_.setText("schedule");
        this.deleteButton_.setEnabled(false);
        this.deleteButton_.setText("delete");
        this.deleteButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgLogManager.this.deleteButton__actionPerformed(actionEvent);
            }
        });
        this.scheduleScrollPane_.setMinimumSize(new Dimension(100, 100));
        this.scheduleScrollPane_.setPreferredSize(new Dimension(454, 100));
        this.detailsPanel_.setLayout(this.detailsGridBagLayout_);
        this.durationVLabel_.setForeground(Color.black);
        this.durationVLabel_.setText("");
        this.durationLabel_.setText("duration");
        this.userLabel_.setText("user");
        this.scheduleDetailsLabel_.setText("scheduleDetails");
        this.agentDetailsLabel_.setText("domainObjectStatus");
        this.operationDetailsLabel_.setText("operationDetails");
        this.detailsScrollPane_.setMinimumSize(new Dimension(100, 155));
        this.detailsScrollPane_.setPreferredSize(new Dimension(4, 155));
        this.detailsScrollPane_.setToolTipText("");
        this.operationPanel_.setLayout(this.operationBorderLayout_);
        this.userVLabel_.setForeground(Color.black);
        this.userVLabel_.setText("");
        this.operationScrollPane_.setMinimumSize(new Dimension(24, 75));
        this.operationScrollPane_.setPreferredSize(new Dimension(4, 75));
        this.descriptionScrollPane_.setHorizontalScrollBarPolicy(31);
        this.descriptionScrollPane_.setMinimumSize(new Dimension(24, 34));
        this.descriptionScrollPane_.setPreferredSize(new Dimension(74, 34));
        this.descriptionLabel_.setText("description");
        this.descriptionTextArea_.setWrapStyleWord(true);
        this.descriptionTextArea_.setLineWrap(true);
        this.descriptionTextArea_.setEditable(false);
        this.mainPanel_.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.detailsEditorPane_.setPreferredSize(new Dimension(7, 152));
        this.detailsEditorPane_.setContentType("text/html");
        this.detailsEditorPane_.setText("");
        this.detailsEditorPane_.setMinimumSize(new Dimension(6, 155));
        this.detailsEditorPane_.setEditable(false);
        this.bottomPane_.setLayout(this.gridBagLayout1);
        this.helpButton_.setToolTipText("");
        this.helpButton_.setText("help");
        this.helpButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgLogManager.this.helpButton__actionPerformed(actionEvent);
            }
        });
        this.closeButton_.setText("close");
        this.closeButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgLogManager.this.closeButton__actionPerformed(actionEvent);
            }
        });
        this.butonPanel_.setLayout(this.gridLayout1);
        this.butonPanel_.setBorder(this.border1);
        this.gridLayout1.setHgap(5);
        this.statusLabel_.setForeground(Color.black);
        this.operationPanel_.setMinimumSize(new Dimension(24, 100));
        this.operationPanel_.setPreferredSize(new Dimension(4, 100));
        this.bottomPane_.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 5));
        this.getContentPane().add((Component)this.mainPanel_, "Center");
        this.mainPanel_.add((Component)this.taskPanel_, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.taskPanel_.add((Component)this.taskNameVLabel_, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.taskPanel_.add((Component)this.taskNameLabel_, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.taskPanel_.add((Component)this.taskTypeLabel_, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.taskPanel_.add((Component)this.taskTypeVLabel_, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.taskPanel_.add((Component)this.domainVLabel_, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 10, 0), 0, 0));
        this.taskPanel_.add((Component)this.descriptionScrollPane_, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.descriptionScrollPane_.getViewport().add((Component)this.descriptionTextArea_, null);
        this.taskPanel_.add((Component)this.domainLabel_, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 0, 0));
        this.taskPanel_.add((Component)this.descriptionLabel_, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel_.add((Component)this.schedulePanel_, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.schedulePanel_.add((Component)this.scheduleScrollPane_, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.schedulePanel_.add((Component)this.deleteButton_, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.schedulePanel_.add((Component)this.scheduleLabel_, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel_.add((Component)this.detailsPanel_, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.detailsPanel_.add((Component)this.scheduleDetailsLabel_, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 5, 0), 0, 0));
        this.detailsPanel_.add((Component)this.durationLabel_, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.detailsPanel_.add((Component)this.userLabel_, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.detailsPanel_.add((Component)this.userVLabel_, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.detailsPanel_.add((Component)this.durationVLabel_, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.detailsPanel_.add((Component)this.agentDetailsLabel_, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.mainPanel_.add((Component)this.operationPanel_, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.operationPanel_.add((Component)this.operationScrollPane_, "Center");
        this.mainPanel_.add((Component)this.operationDetailsLabel_, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel_.add((Component)this.detailsScrollPane_, new GridBagConstraints(0, 5, 1, 1, 1.0, 2.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.bottomPane_, "South");
        this.bottomPane_.add((Component)this.statusLabel_, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 16, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.bottomPane_.add((Component)this.butonPanel_, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.butonPanel_.add((Component)this.closeButton_, null);
        this.butonPanel_.add((Component)this.helpButton_, null);
        this.detailsScrollPane_.getViewport().add((Component)this.detailsEditorPane_, null);
        this.scheduleScrollPane_.getViewport().add((Component)this.scheduleTable_, null);
    }

    void closeButton__actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private void loadData() {
        if (CgLogManager.isTesting()) {
            this.makeDemoData();
            return;
        }
        try {
            this.handle_ = (SMTaskRequestLog)SMHandleRegistry.getInstance((String)"CONSOLE").getHandle(this.handleName_);
            if (this.handle_ == null) {
                this.handle_ = new SMTaskRequestLog(SMConsoleContext.getInstance().getAPIHandle());
                SMHandleRegistry.getInstance((String)"CONSOLE").addHandle(this.handleName_, (SMHandle)this.handle_);
            }
        }
        catch (SMAPIException sMAPIException) {
            CgLogManager.showError("log.unableToGetService");
            return;
        }
        final CgLogManager cgLogManager = this;
        Thread thread = new Thread(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                CgLogManager.this.setBusy(true);
                CgLogManager.this.setStatusMessage(CgUtility.getI18nMsg("standard.loading"));
                try {
                    block4: {
                        try {
                            CgLogManager.this.setData(CgLogManager.this.handle_.getAll(CgLogManager.this.taskRequestName_));
                            if (!CgLogManager.this.registerListeners_) break block4;
                            CgLogManager.this.registerListeners_ = false;
                            CgLogManager.this.handle_.addDBChangeListener(cgLogManager);
                        }
                        catch (SMAPIException sMAPIException) {
                            CgLogManager.showError("log.unableToRetrieveListOfLogs");
                            Object var3_2 = null;
                            CgLogManager.this.setBusy(false);
                            CgLogManager.this.clearStatusMessage();
                            return;
                        }
                    }
                    Object var3_1 = null;
                    CgLogManager.this.setBusy(false);
                    CgLogManager.this.clearStatusMessage();
                    return;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    CgLogManager.this.setBusy(false);
                    CgLogManager.this.clearStatusMessage();
                    throw throwable;
                }
            }
        };
        thread.start();
    }

    private void makeDemoData() {
        SMTaskRequestLogInfo[] sMTaskRequestLogInfoArray = new SMTaskRequestLogInfo[]{new SMTaskRequestLogInfo(null, "My Group Operation 1", "B", "base.console.ConsoleTopology:domain.defaultdomain", "X", System.currentTimeMillis() / 1000L, TimeZone.getDefault(), 1), new SMTaskRequestLogInfo(null, "My Group Operation 1", "B", "base.console.ConsoleTopology:domain.defaultdomain", "X", System.currentTimeMillis() / 1000L - 60L, TimeZone.getDefault(), 2), new SMTaskRequestLogInfo(null, "My Group Operation 2", "A", "ada", "Y", System.currentTimeMillis() / 1000L - 120L, TimeZone.getDefault(), 2), new SMTaskRequestLogInfo(null, "My Group Operation 2", "A", "Test", "X", System.currentTimeMillis() / 1000L - 180L, TimeZone.getDefault(), 3)};
        this.setData(sMTaskRequestLogInfoArray);
    }

    private void setData(SMTaskRequestLogInfo[] sMTaskRequestLogInfoArray) {
        final SMTaskRequestLogInfo[] sMTaskRequestLogInfoArray2 = sMTaskRequestLogInfoArray;
        if (sMTaskRequestLogInfoArray2 == null) {
            return;
        }
        if (sMTaskRequestLogInfoArray2.length == 0) {
            this.model_.removeAllRows();
            this.deleteButton_.setEnabled(false);
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                CgLogManager.this.domainVLabel_.setText(CgLogManager.localize(sMTaskRequestLogInfoArray2[0].getDomain()));
                CgLogManager.this.descriptionTextArea_.append(sMTaskRequestLogInfoArray2[0].getDescription());
                CgLogManager.this.model_.removeAllRows();
                CgLogManager.this.rowInfo_ = new Vector();
                int n = 0;
                while (n < sMTaskRequestLogInfoArray2.length) {
                    CgLogManager.this.rowInfo_.addElement(sMTaskRequestLogInfoArray2[n]);
                    Vector<Comparable<Date>> vector = new Vector<Comparable<Date>>();
                    CgLogManager.this.timeZone_ = sMTaskRequestLogInfoArray2[n].getTimeZone();
                    vector.addElement(new Date(sMTaskRequestLogInfoArray2[n].getTime()));
                    vector.addElement(new Integer(sMTaskRequestLogInfoArray2[n].getStatus()));
                    CgLogManager.this.model_.addRow(vector);
                    ++n;
                }
                if (sMTaskRequestLogInfoArray2.length > 0) {
                    CgLogManager.this.scheduleTable_.setRowSelectionInterval(0, 0);
                    CgLogManager.this.deleteButton_.setEnabled(true);
                } else {
                    CgLogManager.this.deleteButton_.setEnabled(false);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static boolean isTesting() {
        return testing_;
    }

    static void showError(String string) {
        UcDialog.showError(null, (Object)CgLogManager.localize(string));
    }

    void deleteButton__actionPerformed(ActionEvent actionEvent) {
        if (!this.confirmDelete()) {
            return;
        }
        if (CgLogManager.isTesting()) {
            return;
        }
        int[] nArray = this.scheduleTable_.getSelectedRows();
        if (nArray.length == 0 || nArray == null) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray2[n] = this.model_.convertRowIndexToModel(nArray[n]);
            ++n;
        }
        final SMDBObjectID[] sMDBObjectIDArray = new SMDBObjectID[nArray.length];
        int n2 = 0;
        while (n2 < nArray2.length) {
            SMTaskRequestLogInfo sMTaskRequestLogInfo = (SMTaskRequestLogInfo)this.rowInfo_.elementAt(nArray2[n2]);
            sMDBObjectIDArray[n2] = sMTaskRequestLogInfo.getObjectID();
            ++n2;
        }
        this.removeLogViewer();
        if (this.parser != null) {
            this.parser.cleanup();
            this.parser = null;
        }
        Thread thread = new Thread(){

            public void run() {
                CgLogManager.this.setBusy(true);
                CgLogManager.this.setStatusMessage(CgUtility.getI18nMsg("standard.deleting"));
                try {
                    try {
                        CgLogManager.this.handle_.delete(sMDBObjectIDArray);
                    }
                    catch (SMAPIException sMAPIException) {
                        CgUtility.handleError(sMAPIException);
                        Object var3_2 = null;
                        CgLogManager.this.setBusy(false);
                        CgLogManager.this.clearStatusMessage();
                        return;
                    }
                    Object var3_1 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    CgLogManager.this.setBusy(false);
                    CgLogManager.this.clearStatusMessage();
                    throw throwable;
                }
                CgLogManager.this.setBusy(false);
                CgLogManager.this.clearStatusMessage();
            }
        };
        thread.start();
    }

    private boolean confirmDelete() {
        return CgUtility.confirmDelete(this, CgUtility.getI18nMsg("log.confirmDelete"));
    }

    public void changed(SMDBChangeEvent sMDBChangeEvent) {
        this.loadData();
    }

    private void setBusy(boolean bl) {
        CgUtility.setGlassPaneVisible(this, bl);
    }

    private void clearStatusMessage() {
        this.statusLabel_.setText("");
    }

    private void setStatusMessage(String string) {
        this.statusLabel_.setText(string);
    }

    private void showLogViewer(int n) {
        this.setBusy(true);
        this.setStatusMessage(CgUtility.getI18nMsg("standard.loading"));
        this.parser = new CgLogParser(this.handle_, (SMTaskRequestLogInfo)this.rowInfo_.elementAt(n), this);
        this.clearStatusMessage();
        this.setBusy(false);
    }

    private void removeLogViewer() {
        this.durationVLabel_.setText("");
        this.userVLabel_.setText("");
        this.detailsEditorPane_.setText("");
    }

    public void showSummary(String string, String string2, String string3) {
        if (!string.equals("")) {
            this.durationVLabel_.setText(string);
        } else {
            this.durationVLabel_.setText("");
        }
        this.userVLabel_.setText(string2);
        this.detailsEditorPane_.setText("");
    }

    public void showStatusComponent(Component component) {
        this.operationScrollPane_.getViewport().add(component);
    }

    public void showStatusDetail(String string) {
        this.detailsEditorPane_.setText(string);
    }

    public void showTaskInfo(String string, String string2) {
        this.taskTypeVLabel_.setText(string);
        this.descriptionTextArea_.setText(string2);
    }

    void helpButton__actionPerformed(ActionEvent actionEvent) {
        CmConsoleSession.getInstance().launchHelp("grouping-request-log-help");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class StatusCellRenderer
    extends DefaultTableCellRenderer {
        private ImageIcon okIcon_;
        private ImageIcon failIcon_;
        private ImageIcon suspendedIcon_;
        private String success_ = CgLogManager.access$1100("standard.succeeded");
        private String failure_ = CgLogManager.access$1100("standard.failed");
        private String suspended_ = CgLogManager.access$1100("standard.suspended");
        private String notarget_ = CgLogManager.access$1100("standard.notarget");

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof Integer) {
                int n3 = (Integer)object;
                switch (n3) {
                    case 1: {
                        this.setText(this.success_);
                        break;
                    }
                    case 2: {
                        this.setText(this.failure_);
                        break;
                    }
                    case 3: {
                        this.setText(this.suspended_);
                        break;
                    }
                    case 5: {
                        this.setText(this.notarget_);
                        break;
                    }
                    default: {
                        this.setText("");
                        break;
                    }
                }
            } else {
                this.setText(object.toString());
            }
            return this;
        }
    }

    class TimeCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setText(object == null ? "" : this.getFormatter().format(object));
            return this;
        }

        private DateFormat getFormatter() {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0);
            dateFormat.setTimeZone(CgLogManager.this.timeZone_);
            return dateFormat;
        }
    }
}

