/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.didgets;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.topology.SMUserDomainData;
import com.sun.symon.base.client.topology.SMUserDomainRequest;
import com.sun.symon.base.console.awx.AwxServiceManager;
import com.sun.symon.base.console.awx.AwxServiceProvider;
import com.sun.symon.base.utility.UcDDL;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CdDomainList
extends JList
implements ListSelectionListener,
Runnable,
AwxServiceManager {
    private SMUserDomainRequest RequestHandle = null;
    private Thread RequestThread = null;
    private SMUserDomainData[] CurrentData = null;
    private AwxServiceProvider SvcProvider = null;

    public CdDomainList() {
        this.addListSelectionListener(this);
    }

    public SMUserDomainData getSelectedDomain() {
        int n = this.getSelectedIndex();
        if (n < 0) {
            return null;
        }
        return this.CurrentData[n];
    }

    public void registerServiceProvider(AwxServiceProvider awxServiceProvider) {
        this.SvcProvider = awxServiceProvider;
    }

    public synchronized void reload() {
        if (this.RequestThread != null) {
            return;
        }
        this.RequestThread = new Thread((Runnable)this, "domain-load");
        this.RequestThread.start();
    }

    public void run() {
        int n;
        Object object;
        if (this.RequestHandle == null) {
            return;
        }
        SMUserDomainData[] sMUserDomainDataArray = null;
        try {
            sMUserDomainDataArray = this.RequestHandle.getUserConfiguredDomains();
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logErrorMessage((String)("Domain list retrieval exception " + (Object)((Object)sMAPIException)));
        }
        int n2 = -1;
        int n3 = this.getSelectedIndex();
        if (n3 >= 0 && this.CurrentData != null && sMUserDomainDataArray != null) {
            object = this.CurrentData[n3].getDomainRootUrl();
            n = 0;
            while (n < sMUserDomainDataArray.length) {
                if (sMUserDomainDataArray[n].getDomainRootUrl().compareTo((String)object) == 0) {
                    n2 = n;
                }
                ++n;
            }
        }
        if (sMUserDomainDataArray == null) {
            this.setListData(new Object[0]);
        } else {
            object = new String[sMUserDomainDataArray.length];
            n = 0;
            while (n < sMUserDomainDataArray.length) {
                object[n] = sMUserDomainDataArray[n].getDomainName();
                ++n;
            }
            this.setListData((E[])object);
            if (n2 >= 0) {
                this.setSelectedIndex(n2);
            }
        }
        this.CurrentData = sMUserDomainDataArray;
        this.revalidate();
        this.repaint();
        this.RequestThread = null;
    }

    public void setRequestHandle(SMRawDataRequest sMRawDataRequest) {
        this.RequestHandle = new SMUserDomainRequest(sMRawDataRequest);
        this.reload();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        int n = this.getSelectedIndex();
        if (n < 0) {
            if (this.SvcProvider != null) {
                this.SvcProvider.triggerService("domainDeselect");
            }
        } else if (this.SvcProvider != null) {
            this.SvcProvider.triggerService("domainSelect");
        }
    }
}

