/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.table;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.client.alarm.SMAlarmStatusData;
import com.sun.symon.base.client.console.SMTblSelectionInfo;
import com.sun.symon.base.client.table.SMTablePageRequest;
import com.sun.symon.base.client.table.SMTablePageResponse;
import com.sun.symon.base.client.table.SMTableRequest;
import com.sun.symon.base.console.views.table.CvTable;
import com.sun.symon.base.console.views.table.CvTblFilterEvent;
import com.sun.symon.base.console.views.table.CvTblFilterListener;
import com.sun.symon.base.console.views.table.CvTblId;
import com.sun.symon.base.console.views.table.CvTblTable;
import com.sun.symon.base.console.views.table.CvTblTableModel;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CvTblSlider
extends JPanel
implements ActionListener,
Runnable {
    private JLabel pageLabel;
    private JComboBox pageBox;
    private int currentPage = 1;
    private int previousPage = 1;
    private int currentRow;
    private int lastPage;
    private Hashtable buttons = new Hashtable();
    private static final String FIRST = "first";
    private static final String PREVIOUS = "previous";
    private static final String NEXT = "next";
    private static final String LAST = "last";
    private CvTblTable table = null;
    private CvTblTableModel model = null;
    private CvTable ownTable;
    public SMTableRequest tabObj = null;
    private SMTablePageRequest tabreq = null;
    private SMRawDataRequest origDataSource = null;
    private CvTblPageResponser responser = null;
    private static final int PAGE = 20;
    private boolean continueGet = true;
    private Vector filterListeners = new Vector();
    boolean firstTime = true;
    boolean pageUpdated = false;
    private Object pageRequest = null;
    private Object pageStatusRequest = null;
    String refInterval;
    private boolean initialized = false;
    private Object tableDepthRequest = null;
    String[] dataUrls = null;
    String[] statusUrls = null;
    String alarmFilter = null;
    DataLoader dataLoader;
    Thread requester;
    private int tableDepth = 0;

    public CvTblSlider(CvTable cvTable, CvTblTable cvTblTable, SMRawDataRequest sMRawDataRequest, SMTableRequest sMTableRequest, int n) {
        this.setLayout(new BoxLayout(this, 0));
        this.setAlignmentX(0.0f);
        this.ownTable = cvTable;
        this.tabObj = sMTableRequest;
        this.origDataSource = sMRawDataRequest;
        this.tableDepth = n;
        this.setBackground(Color.white);
        this.currentPage = 1;
        this.lastPage = this.depth2Page(n);
        this.table = cvTblTable;
        this.model = (CvTblTableModel)cvTblTable.getModel();
        this.dataUrls = CvTable.removeBlankURLs(this.model.getDataURLs());
        this.statusUrls = CvTable.removeBlankURLs(this.model.getStatusURLs());
        this.createUI();
        this.updateUIStatus();
    }

    public void createUI() {
        Accessible accessible;
        String[] stringArray = new String[]{"stdimages/First-16x16.gif", "stdimages/Previous-16x16.gif", "stdimages/Next-16x16.gif", "stdimages/Last-16x16.gif"};
        String[] stringArray2 = new String[]{FIRST, PREVIOUS, NEXT, LAST};
        String string = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:table.page") + ": ";
        JLabel jLabel = new JLabel(string);
        jLabel.setAlignmentY(0.0f);
        this.add(jLabel);
        SMResourceAccess sMResourceAccess = new SMResourceAccess(this.origDataSource);
        int n = 0;
        while (n < 4) {
            accessible = new ImageIcon(sMResourceAccess.getImage(stringArray[n]));
            string = UcInternationalizer.translateKey((String)("base.console.alarms.AlarmBundle:" + stringArray2[n]));
            JButton jButton = new JButton((Icon)((Object)accessible));
            jButton.setToolTipText(string);
            jButton.setActionCommand(stringArray2[n]);
            jButton.setPreferredSize(new Dimension(18, 20));
            jButton.setMaximumSize(new Dimension(20, 20));
            jButton.setAlignmentY(0.0f);
            jButton.addActionListener(this);
            this.buttons.put(stringArray2[n], jButton);
            this.add(jButton);
            this.add(new JLabel(" "));
            ++n;
        }
        this.add(new JLabel("  "));
        this.pageBox = new JComboBox();
        this.pageBox.setPreferredSize(new Dimension(55, 20));
        this.pageBox.setMaximumSize(new Dimension(70, 20));
        this.pageBox.setEditable(true);
        this.pageBox.addActionListener(this);
        this.pageBox.setAlignmentY(0.0f);
        this.add(this.pageBox);
        string = " " + UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:table.i18nOf") + " ";
        accessible = new JLabel(string);
        ((JComponent)((Object)accessible)).setAlignmentY(0.0f);
        this.add((Component)((Object)accessible));
        string = " " + this.tableDepth;
        this.pageLabel = new JLabel(string);
        this.pageLabel.setAlignmentY(0.0f);
        this.add(this.pageLabel);
        this.add(Box.createHorizontalGlue());
        this.updatePageUI();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.previousPage = this.currentPage;
        if (actionEvent.getSource() == this.pageBox) {
            if (this.pageBox.getItemCount() == 0) {
                return;
            }
            int n = this.pageBox.getSelectedIndex() + 1;
            if (n == 0 && this.pageBox.getItemCount() >= this.currentPage) {
                this.pageBox.setSelectedIndex(this.currentPage - 1);
                return;
            }
            if (n == this.currentPage) {
                return;
            }
            this.currentPage = n;
        } else {
            String string = actionEvent.getActionCommand();
            String string2 = UcInternationalizer.translateKey((String)"com.sun.symon.base.console.alarms.AlarmBundle:thisIsLast");
            String string3 = UcInternationalizer.translateKey((String)"com.sun.symon.base.console.alarms.AlarmBundle:thisIsFirst");
            if (string.compareTo(FIRST) == 0) {
                if (this.currentPage <= 1) {
                    this.currentPage = 1;
                    UcDialog.showOk((String)string3);
                    return;
                }
                this.currentPage = 1;
            } else if (string.compareTo(PREVIOUS) == 0) {
                if (this.currentPage <= 1) {
                    UcDialog.showOk((String)string3);
                    return;
                }
                --this.currentPage;
            } else if (string.compareTo(NEXT) == 0) {
                if (this.currentPage >= this.lastPage) {
                    UcDialog.showOk((String)string2);
                    return;
                }
                ++this.currentPage;
            } else if (string.compareTo(LAST) == 0) {
                if (this.currentPage >= this.lastPage) {
                    this.currentPage = this.lastPage;
                    UcDialog.showOk((String)string2);
                    return;
                }
                this.currentPage = this.lastPage;
            }
        }
        this.updateUIStatus();
        this.getPageData((this.currentPage - 1) * 20);
    }

    private void updateUIStatus() {
        if (this.pageBox != null) {
            this.pageBox.setSelectedIndex(this.currentPage - 1);
        }
        if (this.table != null) {
            SMTblSelectionInfo sMTblSelectionInfo = this.table.getContextSelection();
            if (sMTblSelectionInfo != null && sMTblSelectionInfo.getSelectionType() == 2) {
                this.table.clearSelection();
            }
            if (this.table.getCellEditor() != null) {
                this.table.getCellEditor().stopCellEditing();
            }
        }
    }

    public void setAlarmFilter(String string) {
        String string2;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (string == null || string.equals("")) {
            string2 = null;
        } else {
            if (string.indexOf("ERR") >= 0) {
                bl = true;
            }
            if (string.indexOf("WRN") >= 0) {
                bl2 = true;
            }
            if (string.indexOf("INF") >= 0) {
                bl3 = true;
            }
            if (string.indexOf("DWN") >= 0) {
                bl5 = true;
            }
            string2 = SMTableRequest.createFilter((boolean)bl, (boolean)bl2, (boolean)bl3, (boolean)bl4, (boolean)bl5, (boolean)bl6);
        }
        if (string2 != null && this.alarmFilter != null && string2.equals(this.alarmFilter)) {
            return;
        }
        if (string2 == null && this.alarmFilter == null) {
            return;
        }
        this.alarmFilter = string2;
        if (this.initialized) {
            this.requester = new Thread(this);
            this.requester.start();
        }
    }

    public void addFilterListener(CvTblFilterListener cvTblFilterListener) {
        this.filterListeners.add(cvTblFilterListener);
    }

    public void removeFilterListener(CvTblFilterListener cvTblFilterListener) {
        this.filterListeners.removeElement(cvTblFilterListener);
    }

    public void fireFilterChange(String[] stringArray) {
        CvTblFilterEvent cvTblFilterEvent = new CvTblFilterEvent(this, stringArray);
        int n = 0;
        while (n < this.filterListeners.size()) {
            ((CvTblFilterListener)this.filterListeners.get(n)).labelsChanged(cvTblFilterEvent);
            ++n;
        }
    }

    public void initTablePageRequest(String string) {
        this.refInterval = string;
        if (this.tabObj == null) {
            UcDDL.logErrorMessage((String)" data source is null");
            return;
        }
        if (this.dataUrls == null) {
            UcDDL.logErrorMessage((String)" CvTblSlider: Data Urls is null");
            return;
        }
        RowNumberUpdator rowNumberUpdator = new RowNumberUpdator(this, this.dataUrls[0], this.tabObj);
        rowNumberUpdator.start();
        this.requester = new Thread(this);
        this.requester.start();
        this.initialized = true;
    }

    public void run() {
        this.firstTime = true;
        this.ownTable.displayFootMessage();
        this.ownTable.busyStart();
        this.shutdownAllRequest();
        try {
            this.tabreq = this.alarmFilter == null ? this.tabObj.getTablePageRequest(this.dataUrls, this.statusUrls, 20) : this.tabObj.getTablePageRequest(this.dataUrls, this.statusUrls, 20, this.alarmFilter);
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logErrorMessage((String)("CvTblSlider:getTableRequest  received exception " + sMAPIException.getMessage()));
        }
        this.responser = new CvTblPageResponser(this, this.model);
        try {
            this.tableDepthRequest = this.alarmFilter == null ? this.tabreq.getTableDepth(this.dataUrls[0], this.refInterval, (SMTablePageResponse)this.responser, null) : this.tabreq.getTableDepth(this.dataUrls[0], this.alarmFilter, this.refInterval, (SMTablePageResponse)this.responser, null);
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logErrorMessage((String)" CvTblSlider: get table depth received exception", (Throwable)sMAPIException);
        }
        this.ownTable.busyStop();
    }

    public void getData() {
        this.getPageData((this.currentPage - 1) * 20);
    }

    public void shutdown() {
        this.continueGet = false;
        this.shutdownAllRequest();
    }

    private synchronized void setPageUpdated(boolean bl) {
        this.pageUpdated = false;
    }

    public synchronized void setCurrentPageRequest(Object object) {
        this.shutdownPageRequests();
        this.pageRequest = object;
    }

    public synchronized void setCurrentStatusRequest(Object object) {
        this.shutdownStatusRequests();
        this.pageStatusRequest = object;
    }

    public void shutdownAllRequest() {
        this.shutdownPageRequests();
        this.shutdownStatusRequests();
        CvTblSlider cvTblSlider = this;
        synchronized (cvTblSlider) {
            if (this.tableDepthRequest != null) {
                try {
                    this.origDataSource.removeURLRequest(this.tableDepthRequest);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.tableDepthRequest = null;
            }
        }
    }

    public synchronized void shutdownPageRequests() {
        try {
            if (this.pageRequest != null) {
                this.origDataSource.removeURLRequest(this.pageRequest);
                this.pageRequest = null;
            }
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logWarningMessage((String)("CvTblSlider: error to remove page request" + (Object)((Object)sMAPIException)));
        }
    }

    public synchronized void shutdownStatusRequests() {
        try {
            if (this.pageStatusRequest != null) {
                this.origDataSource.removeURLRequest(this.pageStatusRequest);
                this.pageStatusRequest = null;
            }
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logWarningMessage((String)("CvTblSlider: error to remove status request" + (Object)((Object)sMAPIException)));
        }
    }

    public void getPageData(int n) {
        this.currentRow = n;
        CvTblPageResponser cvTblPageResponser = this.responser;
        synchronized (cvTblPageResponser) {
            this.responser.notify();
        }
        if (this.pageBox.isEnabled()) {
            this.pageBox.disable();
            ((JButton)this.buttons.get(FIRST)).setEnabled(false);
            ((JButton)this.buttons.get(PREVIOUS)).setEnabled(false);
            ((JButton)this.buttons.get(NEXT)).setEnabled(false);
            ((JButton)this.buttons.get(LAST)).setEnabled(false);
        }
        this.dataLoader = new DataLoader(this.tableDepth, this.currentRow);
        this.dataLoader.start();
    }

    private void updatePageUI() {
        String string = " " + this.lastPage;
        this.pageLabel.setText(string);
        this.pageBox.removeAllItems();
        int n = 0;
        while (n < this.lastPage) {
            this.pageBox.addItem(new String(" " + (n + 1)));
            ++n;
        }
        this.pageBox.setSelectedIndex(this.currentPage - 1);
    }

    private int depth2Page(int n) {
        int n2 = n % 20 > 0 ? n / 20 + 1 : n / 20;
        if (n / 20 == 0) {
            n2 = 1;
        }
        return n2;
    }

    public void updateTableDepth(int n) {
        int n2 = this.tableDepth;
        int n3 = this.lastPage;
        this.tableDepth = n;
        if (this.tableDepth == n2 && this.pageUpdated && !this.firstTime) {
            return;
        }
        if (n <= 20) {
            ((JButton)this.buttons.get(FIRST)).setEnabled(false);
            ((JButton)this.buttons.get(PREVIOUS)).setEnabled(false);
            ((JButton)this.buttons.get(NEXT)).setEnabled(false);
            ((JButton)this.buttons.get(LAST)).setEnabled(false);
        } else {
            ((JButton)this.buttons.get(FIRST)).setEnabled(true);
            ((JButton)this.buttons.get(PREVIOUS)).setEnabled(true);
            ((JButton)this.buttons.get(NEXT)).setEnabled(true);
            ((JButton)this.buttons.get(LAST)).setEnabled(true);
        }
        this.lastPage = this.depth2Page(n);
        if (this.currentPage > this.lastPage) {
            this.currentPage = this.lastPage;
        }
        if (n3 != this.lastPage) {
            this.updatePageUI();
            this.updateUIStatus();
        }
        this.firstTime = false;
        this.getPageData((this.currentPage - 1) * 20);
    }

    class RowNumberUpdator
    extends Thread {
        CvTblSlider parent;
        SMTableRequest request;
        String[] filters = new String[4];
        String url;
        boolean isRefreshAllButtons;

        public RowNumberUpdator(CvTblSlider cvTblSlider2, String string, SMTableRequest sMTableRequest) {
            this(cvTblSlider2, string, sMTableRequest, true);
        }

        public RowNumberUpdator(CvTblSlider cvTblSlider2, String string, SMTableRequest sMTableRequest, boolean bl) {
            this.request = sMTableRequest;
            this.parent = cvTblSlider2;
            this.url = string;
            this.isRefreshAllButtons = bl;
            this.filters[0] = SMTableRequest.createFilter((boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
            this.filters[1] = SMTableRequest.createFilter((boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
            this.filters[2] = SMTableRequest.createFilter((boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false);
            this.filters[3] = SMTableRequest.createFilter((boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true, (boolean)false);
        }

        public void run() {
            String[] stringArray = new String[]{"", "", "", "", ""};
            if (this.isRefreshAllButtons) {
                stringArray[0] = "" + this.request.getTableDepth(this.url);
            }
            int n = 0;
            while (n < 4) {
                stringArray[n + 1] = "" + this.request.getTableDepth(this.url, this.filters[n]);
                ++n;
            }
            this.parent.fireFilterChange(stringArray);
        }
    }

    class CvTblPageResponser
    implements SMTablePageResponse {
        String[] rowindex = null;
        CvTblTableModel tmodel = null;
        CvTblSlider pageSource = null;

        public CvTblPageResponser(CvTblSlider cvTblSlider2, CvTblTableModel cvTblTableModel) {
            this.pageSource = cvTblSlider2;
            this.tmodel = cvTblTableModel;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void getTablePageFieldResponse(SMRequestStatus sMRequestStatus, String[][] stringArray, String[][] stringArray2, String[] stringArray3, Object object) {
            block15: {
                block14: {
                    try {
                        if (sMRequestStatus.getReturnCode() != 0) {
                            if (sMRequestStatus.getReturnCode() == 1) {
                                UcDDL.logErrorMessage((String)"Security Error receiving page field data for table ");
                            } else if (sMRequestStatus.getReturnCode() == 2) {
                                UcDDL.logErrorMessage((String)"Invalid Url Error receiving page field  data for table ");
                            } else {
                                UcDDL.logErrorMessage((String)"Data Request Error receiving page field data for table ");
                            }
                            CvTblSlider.this.ownTable.displayFootMessage("base.console.ConsoleMessages:console.tableLoadError");
                            Object var10_6 = null;
                            CvTblSlider.this.pageBox.enable();
                            ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.FIRST)).setEnabled(true);
                            ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.PREVIOUS)).setEnabled(true);
                            ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.NEXT)).setEnabled(true);
                            ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.LAST)).setEnabled(true);
                            return;
                        }
                        if (sMRequestStatus == null || stringArray == null || stringArray.length == 0) {
                            if (sMRequestStatus == null) {
                                UcDDL.logErrorMessage((String)"Null status received while retrieving page field data for table ");
                            }
                            if (stringArray == null || stringArray.length == 0) {
                                UcDDL.logErrorMessage((String)"Null data received while retrieving page field data for table ");
                            }
                            break block14;
                        }
                        CvTblPageResponser cvTblPageResponser = this;
                        synchronized (cvTblPageResponser) {
                            try {
                                this.rowindex = stringArray3;
                                this.notify();
                            }
                            catch (Exception exception) {
                                UcDDL.logErrorMessage((String)("CvTblSlider: notify exception :" + exception.getMessage()));
                            }
                        }
                        this.tmodel.setDataValues(stringArray, ((CvTblId)object).getId());
                        CvTblSlider.this.ownTable.cleanFootMessage();
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var10_9 = null;
                        CvTblSlider.this.pageBox.enable();
                        ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.FIRST)).setEnabled(true);
                        ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.PREVIOUS)).setEnabled(true);
                        ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.NEXT)).setEnabled(true);
                        ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.LAST)).setEnabled(true);
                        throw throwable;
                    }
                }
                Object var10_7 = null;
                CvTblSlider.this.pageBox.enable();
                ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.FIRST)).setEnabled(true);
                ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.PREVIOUS)).setEnabled(true);
                ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.NEXT)).setEnabled(true);
                ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.LAST)).setEnabled(true);
                return;
            }
            Object var10_8 = null;
            CvTblSlider.this.pageBox.enable();
            ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.FIRST)).setEnabled(true);
            ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.PREVIOUS)).setEnabled(true);
            ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.NEXT)).setEnabled(true);
            ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.LAST)).setEnabled(true);
        }

        public void getTablePageAlarmStatusResponse(SMRequestStatus sMRequestStatus, SMAlarmStatusData[][] sMAlarmStatusDataArray, Object object) {
            if (sMRequestStatus.getReturnCode() != 0) {
                if (sMRequestStatus.getReturnCode() == 1) {
                    UcDDL.logErrorMessage((String)"Security Error receiving page alarm status data for table ");
                } else if (sMRequestStatus.getReturnCode() == 2) {
                    UcDDL.logErrorMessage((String)"Invalid Url Error receiving page alarm status data for table ");
                } else {
                    UcDDL.logErrorMessage((String)"Data Request Error receiving page alarm status data for table ");
                }
                return;
            }
            if (sMRequestStatus == null || sMAlarmStatusDataArray == null || sMAlarmStatusDataArray.length == 0) {
                if (sMRequestStatus == null) {
                    UcDDL.logErrorMessage((String)"Null status received while retrieving page alarm status data for table ");
                }
                if (sMAlarmStatusDataArray == null || sMAlarmStatusDataArray.length == 0) {
                    UcDDL.logErrorMessage((String)"Null data received while retrieving page alarm status data for table ");
                }
                return;
            }
            this.tmodel.setStatusValues(sMAlarmStatusDataArray, ((CvTblId)object).getId());
        }

        public final void waitRowIndex() throws SMAPIException {
            CvTblPageResponser cvTblPageResponser = this;
            synchronized (cvTblPageResponser) {
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    throw new SMAPIException(exception.getMessage());
                }
            }
        }

        public String[] getRowIndex() {
            return this.rowindex;
        }

        public void getTableDepthResponse(SMRequestStatus sMRequestStatus, int n, Object object) {
            if (sMRequestStatus.getReturnCode() == 0) {
                this.pageSource.updateTableDepth(n);
                new RowNumberUpdator(this.pageSource, CvTblSlider.this.dataUrls[0], CvTblSlider.this.tabObj).start();
            } else {
                UcDDL.logDebugMessage((String)" get table depth error ");
            }
        }
    }

    class DataLoader
    extends Thread {
        int tableDepth;
        int currentRow;

        public DataLoader(int n, int n2) {
            this.tableDepth = n;
            this.currentRow = n2;
        }

        public void run() {
            try {
                String[] stringArray;
                CvTblSlider.this.shutdownPageRequests();
                CvTblSlider.this.shutdownStatusRequests();
                if (this.tableDepth == 0 || this.currentRow > this.tableDepth) {
                    if (this.tableDepth == 0) {
                        CvTblSlider.this.model.shrinkSize(0);
                    }
                    Object var10_1 = null;
                    CvTblSlider.this.pageBox.enable();
                    ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.FIRST)).setEnabled(true);
                    ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.PREVIOUS)).setEnabled(true);
                    ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.NEXT)).setEnabled(true);
                    ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.LAST)).setEnabled(true);
                    return;
                }
                CvTblSlider.this.ownTable.displayFootMessage();
                CvTblSlider.this.model.shrinkSize(0);
                CvTblId cvTblId = new CvTblId(CvTblSlider.this.model);
                int n = Math.min(this.tableDepth - this.currentRow, 20);
                Vector vector = new Vector(this.currentRow);
                DataLoader dataLoader = this;
                synchronized (dataLoader) {
                    if (CvTblSlider.this.dataUrls != null) {
                        try {
                            stringArray = CvTblSlider.this.tabreq.getTablePageFieldRequest(this.currentRow, n, CvTblSlider.this.refInterval, (SMTablePageResponse)CvTblSlider.this.responser, (Object)cvTblId);
                            CvTblSlider.this.setCurrentPageRequest(stringArray);
                            CvTblSlider.this.setPageUpdated(true);
                        }
                        catch (Exception exception) {
                            UcDDL.logWarningMessage((String)("CvTblSlider:getPageData - received exception getting table data " + exception.getMessage()));
                            CvTblSlider.this.setPageUpdated(false);
                            CvTblSlider.this.ownTable.cleanFootMessage();
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 6, 8, 15] lbl33 : MonitorExitStatement: MONITOREXIT : var4_8
                            Object var10_2 = null;
                            CvTblSlider.this.pageBox.enable();
                            ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.FIRST)).setEnabled(true);
                            ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.PREVIOUS)).setEnabled(true);
                            ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.NEXT)).setEnabled(true);
                            ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.LAST)).setEnabled(true);
                            return;
                        }
                    }
                }
                try {
                    CvTblSlider.this.responser.waitRowIndex();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stringArray = CvTblSlider.this.responser.getRowIndex();
                DataLoader dataLoader2 = this;
                synchronized (dataLoader2) {
                    if (CvTblSlider.this.statusUrls != null && stringArray != null) {
                        try {
                            Object object = CvTblSlider.this.tabreq.getTablePageAlarmStatusRequest(stringArray, CvTblSlider.this.refInterval, (SMTablePageResponse)CvTblSlider.this.responser, (Object)cvTblId);
                            CvTblSlider.this.setCurrentStatusRequest(object);
                        }
                        catch (Exception exception) {
                            UcDDL.logWarningMessage((String)"CvTblSlider:getPageData - received exception getting table data", (Throwable)exception);
                        }
                    }
                }
                CvTblSlider.this.ownTable.cleanFootMessage();
            }
            catch (Throwable throwable) {
                Object var10_4 = null;
                CvTblSlider.this.pageBox.enable();
                ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.FIRST)).setEnabled(true);
                ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.PREVIOUS)).setEnabled(true);
                ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.NEXT)).setEnabled(true);
                ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.LAST)).setEnabled(true);
                throw throwable;
            }
            Object var10_3 = null;
            CvTblSlider.this.pageBox.enable();
            ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.FIRST)).setEnabled(true);
            ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.PREVIOUS)).setEnabled(true);
            ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.NEXT)).setEnabled(true);
            ((JButton)CvTblSlider.this.buttons.get(CvTblSlider.LAST)).setEnabled(true);
        }
    }
}

